/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Registry;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import tschipp.carryon.Constants;
import tschipp.carryon.client.modeloverride.ModelOverride;
import tschipp.carryon.client.modeloverride.ModelOverrideHandler;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.scripting.CarryOnScript;

public class CarryRenderHelper {
    public static Vec3 getExactPos(Entity entity, float partialticks) {
        return new Vec3(entity.f_19790_ + (entity.m_20185_() - entity.f_19790_) * (double)partialticks, entity.f_19791_ + (entity.m_20186_() - entity.f_19791_) * (double)partialticks, entity.f_19792_ + (entity.m_20189_() - entity.f_19792_) * (double)partialticks);
    }

    public static float getExactBodyRotationDegrees(LivingEntity entity, float partialticks) {
        Entity entity2;
        if (entity.m_20202_() != null && (entity2 = entity.m_20202_()) instanceof LivingEntity) {
            LivingEntity vehicle = (LivingEntity)entity2;
            if (vehicle instanceof Player) {
                Player player = (Player)vehicle;
                return -(player.f_20884_ + (player.f_20883_ - player.f_20884_) * partialticks);
            }
            return -(entity.f_20886_ + (entity.f_20885_ - entity.f_20886_) * partialticks);
        }
        return -(entity.f_20884_ + (entity.f_20883_ - entity.f_20884_) * partialticks);
    }

    public static Quaternion getExactBodyRotation(LivingEntity entity, float partialticks) {
        return Vector3f.f_122225_.m_122240_(CarryRenderHelper.getExactBodyRotationDegrees(entity, partialticks));
    }

    public static void applyGeneralTransformations(Player player, float partialticks, PoseStack matrix) {
        int perspective = CarryRenderHelper.getPerspective();
        Quaternion playerrot = CarryRenderHelper.getExactBodyRotation((LivingEntity)player, partialticks);
        Vec3 playerpos = CarryRenderHelper.getExactPos((Entity)player, partialticks);
        Vec3 cameraPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        Vec3 offset = playerpos.m_82546_(cameraPos);
        Pose pose = player.m_20089_();
        matrix.m_85836_();
        matrix.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
        if (perspective == 2) {
            playerrot.m_80148_(Vector3f.f_122225_.m_122240_(180.0f));
        }
        matrix.m_85845_(playerrot);
        matrix.m_85836_();
        matrix.m_85841_(0.6f, 0.6f, 0.6f);
        if (perspective == 2) {
            matrix.m_85837_(0.0, 0.0, -1.35);
        }
        if (CarryRenderHelper.doSneakCheck(player)) {
            matrix.m_85837_(0.0, -0.4, 0.0);
        }
        if (pose == Pose.SWIMMING) {
            float f = player.m_20998_(partialticks);
            float f3 = player.m_20069_() ? -90.0f - player.f_19860_ : -90.0f;
            float f4 = Mth.m_14179_((float)f, (float)0.0f, (float)f3);
            if (perspective == 2) {
                matrix.m_85837_(0.0, 0.0, 1.35);
                matrix.m_85845_(Vector3f.f_122223_.m_122240_(f4));
            } else {
                matrix.m_85845_(Vector3f.f_122222_.m_122240_(f4));
            }
            matrix.m_85837_(0.0, -1.5, -1.848);
            if (perspective == 2) {
                matrix.m_85837_(0.0, 0.0, 2.38);
            }
        }
        if (pose == Pose.FALL_FLYING) {
            float f1 = (float)player.m_21256_() + partialticks;
            float f2 = Mth.m_14036_((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!player.m_21209_()) {
                if (perspective == 2) {
                    matrix.m_85837_(0.0, 0.0, 1.35);
                }
                if (perspective == 2) {
                    matrix.m_85845_(Vector3f.f_122223_.m_122240_(f2 * (-90.0f - player.f_19860_)));
                } else {
                    matrix.m_85845_(Vector3f.f_122222_.m_122240_(f2 * (-90.0f - player.f_19860_)));
                }
            }
            Vec3 viewVector = player.m_20252_(partialticks);
            Vec3 deltaMovement = player.m_20184_();
            double d0 = deltaMovement.m_165925_();
            double d1 = deltaMovement.m_165925_();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (deltaMovement.f_82479_ * viewVector.f_82479_ + deltaMovement.f_82481_ * viewVector.f_82481_) / (Math.sqrt(d0) * Math.sqrt(d1));
                double d3 = deltaMovement.f_82479_ * viewVector.f_82481_ - deltaMovement.f_82481_ * viewVector.f_82479_;
                matrix.m_85845_(Vector3f.f_122225_.m_122270_((float)(Math.signum(d3) * Math.acos(d2))));
            }
            if (perspective != 2) {
                matrix.m_85837_(0.0, 0.0, -1.35);
            }
            matrix.m_85837_(0.0, -0.2, 0.0);
        }
        matrix.m_85837_(0.0, 1.6, 0.65);
    }

    public static void applyBlockTransformations(Player player, float partialticks, PoseStack matrix, Block block) {
        int perspective = CarryRenderHelper.getPerspective();
        CarryRenderHelper.applyGeneralTransformations(player, partialticks, matrix);
        if (Constants.CLIENT_CONFIG.facePlayer != CarryRenderHelper.isChest(block)) {
            matrix.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        }
        float height = CarryRenderHelper.getRenderHeight(player);
        float offset = (height - 1.0f) / 1.2f;
        matrix.m_85837_(0.0, (double)(-offset), 0.0);
    }

    public static void applyEntityTransformations(Player player, float partialticks, PoseStack matrix, Entity entity) {
        int perspective = CarryRenderHelper.getPerspective();
        Pose pose = player.m_20089_();
        CarryRenderHelper.applyGeneralTransformations(player, partialticks, matrix);
        if (perspective == 2) {
            matrix.m_85837_(0.0, -1.6, 0.65);
        } else {
            matrix.m_85837_(0.0, -1.6, -0.65);
        }
        matrix.m_85841_(1.666f, 1.666f, 1.666f);
        float height = entity.m_20206_();
        float width = entity.m_20205_();
        float multiplier = height * width;
        entity.f_19855_ = 0.0;
        entity.f_19859_ = 0.0f;
        entity.m_5616_(0.0f);
        entity.f_19854_ = 0.0;
        entity.f_19860_ = 0.0f;
        if (perspective == 2) {
            matrix.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        }
        matrix.m_85841_((10.0f - multiplier) * 0.08f, (10.0f - multiplier) * 0.08f, (10.0f - multiplier) * 0.08f);
        matrix.m_85837_(0.0, (double)(height / 2.0f + -(height / 2.0f) + 1.0f), (double)width - 0.1 < 0.7 ? (double)width - 0.1 + (0.7 - ((double)width - 0.1)) : (double)width - 0.1);
        if (pose == Pose.SWIMMING || pose == Pose.FALL_FLYING) {
            matrix.m_85845_(Vector3f.f_122222_.m_122240_(90.0f));
            matrix.m_85837_(0.0, -0.2 * (double)height, 0.0);
            if (pose == Pose.FALL_FLYING) {
                matrix.m_85837_(0.0, 0.0, 0.2);
            }
        }
    }

    public static void performScriptTransformation(PoseStack matrix, CarryOnScript script) {
        int perspective = CarryRenderHelper.getPerspective();
        CarryOnScript.ScriptRender render = script.scriptRender();
        Vec3 translation = render.renderTranslation().getVec();
        Vec3 rotation = render.renderRotation().getVec();
        Vec3 scale = render.renderscale().getVec(1.0, 1.0, 1.0);
        Quaternion rot = Vector3f.f_122223_.m_122240_((float)rotation.f_82479_);
        rot.m_80148_(Vector3f.f_122225_.m_122240_((float)rotation.f_82480_));
        rot.m_80148_(Vector3f.f_122227_.m_122240_((float)rotation.f_82481_));
        matrix.m_85845_(rot);
        matrix.m_85837_(translation.f_82479_, translation.f_82480_, perspective == 1 && script.isBlock() ? -translation.f_82481_ : translation.f_82481_);
        matrix.m_85841_((float)scale.f_82479_, (float)scale.f_82480_, (float)scale.f_82481_);
    }

    public static void renderBakedModel(ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int light, BakedModel model) {
        try {
            ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
            renderer.m_115143_(stack, ItemTransforms.TransformType.NONE, false, matrix, buffer, light, OverlayTexture.f_118083_, model);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static BlockState getRenderState(Player player) {
        Either<ItemStack, BlockState> renderObj;
        Optional<ModelOverride> ov;
        CarryOnScript.ScriptRender render;
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        BlockState state = carry.getBlock().m_60734_().m_49966_();
        if (carry.getActiveScript().isPresent() && (render = carry.getActiveScript().get().scriptRender()).renderNameBlock().isPresent()) {
            state = ((Block)Registry.f_122824_.m_6246_(render.renderNameBlock().get())).m_49966_();
        }
        if ((ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt())).isPresent() && (renderObj = ov.get().getRenderObject()).right().isPresent()) {
            state = (BlockState)renderObj.right().get();
        }
        return state;
    }

    public static BakedModel getRenderBlock(Player player) {
        Either<ItemStack, BlockState> renderObj;
        Optional<ModelOverride> ov;
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
        BlockState state = CarryRenderHelper.getRenderState(player);
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state);
        if (state.m_60799_() != RenderShape.MODEL || model.m_7521_() || model.m_213637_(state, null, RandomSource.m_216327_()).size() <= 0) {
            ItemStack stack = new ItemStack((ItemLike)state.m_60734_());
            model = renderer.m_174264_(stack, player.f_19853_, (LivingEntity)player, 0);
        }
        if ((ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt())).isPresent() && (renderObj = ov.get().getRenderObject()).left().isPresent()) {
            model = renderer.m_174264_((ItemStack)renderObj.left().get(), player.f_19853_, (LivingEntity)player, 0);
        }
        return model;
    }

    public static Entity getRenderEntity(Player player) {
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        Entity entity = carry.getEntity(player.f_19853_);
        if (carry.getActiveScript().isPresent()) {
            CarryOnScript script = carry.getActiveScript().get();
            CarryOnScript.ScriptRender render = script.scriptRender();
            if (render.renderNameEntity().isPresent()) {
                entity = ((EntityType)Registry.f_122826_.m_6246_(render.renderNameEntity().get())).m_20615_(player.f_19853_);
            }
            if (render.renderNBT().isPresent()) {
                entity.m_20258_(render.renderNBT().get());
            }
        }
        return entity;
    }

    public static float getRenderWidth(Player player) {
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
            Either<ItemStack, BlockState> renderObj;
            BlockState state = CarryRenderHelper.getRenderState(player);
            VoxelShape shape = state.m_60808_((BlockGetter)player.f_19853_, player.m_20183_());
            if (shape == null || shape.m_83281_()) {
                return 1.0f;
            }
            Optional<ModelOverride> ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt());
            if (ov.isPresent() && (renderObj = ov.get().getRenderObject()).left().isPresent()) {
                return 0.8f;
            }
            float width = (float)Math.abs(shape.m_83215_().f_82291_ - shape.m_83215_().f_82288_);
            return width;
        }
        if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
            Entity entity = CarryRenderHelper.getRenderEntity(player);
            return entity.m_20205_();
        }
        return 1.0f;
    }

    public static float getRenderHeight(Player player) {
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
            Either<ItemStack, BlockState> renderObj;
            BlockState state = CarryRenderHelper.getRenderState(player);
            VoxelShape shape = state.m_60808_((BlockGetter)player.f_19853_, player.m_20183_());
            if (shape == null || shape.m_83281_()) {
                return 1.0f;
            }
            Optional<ModelOverride> ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt());
            if (ov.isPresent() && (renderObj = ov.get().getRenderObject()).left().isPresent()) {
                return 0.5f;
            }
            float height = (float)Math.abs(shape.m_83215_().f_82292_ - shape.m_83215_().f_82289_);
            return height;
        }
        if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
            Entity entity = CarryRenderHelper.getRenderEntity(player);
            return entity.m_20206_();
        }
        return 1.0f;
    }

    public static int getPerspective() {
        boolean isThirdPerson = !Minecraft.m_91087_().f_91066_.m_92176_().m_90612_();
        boolean isThirdPersonReverse = Minecraft.m_91087_().f_91066_.m_92176_().m_90613_();
        if (!isThirdPerson && !isThirdPersonReverse) {
            return 0;
        }
        if (isThirdPerson && !isThirdPersonReverse) {
            return 1;
        }
        return 2;
    }

    public static boolean doSneakCheck(Player player) {
        if (player.m_150110_().f_35935_) {
            return false;
        }
        return player.m_6144_() || player.m_6047_();
    }

    public static boolean isChest(Block block) {
        return block == Blocks.f_50087_ || block == Blocks.f_50265_ || block == Blocks.f_50325_;
    }
}

