/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.platform;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import tschipp.carryon.CarryOnCommonClient;
import tschipp.carryon.CarryOnForge;
import tschipp.carryon.config.BuiltConfig;
import tschipp.carryon.config.forge.ConfigLoaderImpl;
import tschipp.carryon.networking.PacketBase;
import tschipp.carryon.platform.services.IPlatformHelper;

public class ForgePlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Forge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public void registerConfig(BuiltConfig cfg) {
        ConfigLoaderImpl.registerConfig(cfg);
    }

    @Override
    public <T extends PacketBase> void registerServerboundPacket(ResourceLocation id, int numericalId, Class<T> clazz, BiConsumer<T, FriendlyByteBuf> writer, Function<FriendlyByteBuf, T> reader, BiConsumer<T, Player> handler) {
        BiConsumer<PacketBase, Supplier> serverHandler = (packet, ctx) -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer()) {
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
                ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> ForgePlatformHelper.lambda$registerServerboundPacket$0(handler, packet, (Supplier)ctx));
            }
        };
        CarryOnForge.network.registerMessage(numericalId, clazz, writer, reader, serverHandler, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    @Override
    public <T extends PacketBase> void registerClientboundPacket(ResourceLocation id, int numericalId, Class<T> clazz, BiConsumer<T, FriendlyByteBuf> writer, Function<FriendlyByteBuf, T> reader, BiConsumer<T, Player> handler) {
        BiConsumer<PacketBase, Supplier> clientHandler = (packet, ctx) -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
                ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> handler.accept(packet, CarryOnCommonClient.getPlayer()));
            }
        };
        CarryOnForge.network.registerMessage(numericalId, clazz, writer, reader, clientHandler, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    @Override
    public void sendPacketToServer(ResourceLocation id, PacketBase packet) {
        CarryOnForge.network.sendToServer((Object)packet);
    }

    @Override
    public void sendPacketToPlayer(ResourceLocation id, PacketBase packet, ServerPlayer player) {
        CarryOnForge.network.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    private static /* synthetic */ void lambda$registerServerboundPacket$0(BiConsumer handler, PacketBase packet, Supplier ctx) {
        handler.accept(packet, ((NetworkEvent.Context)ctx.get()).getSender());
    }
}

