/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.travelerstitles.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.yungnickyoung.minecraft.travelerstitles.TravelersTitlesCommon;
import net.minecraft.ResourceLocationException;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceOrTagLocationArgument;
import net.minecraft.core.Registry;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public class BiomeTitleCommand {
    public static final DynamicCommandExceptionType BIOME_NOT_FOUND_EXCEPTION = new DynamicCommandExceptionType(formatArgs -> Component.m_237110_((String)"travelerstitles.commands.biometitle.notfound", (Object[])new Object[]{formatArgs}));
    public static final DynamicCommandExceptionType INVALID_BIOME_EXCEPTION = new DynamicCommandExceptionType(formatArgs -> Component.m_237110_((String)"travelerstitles.commands.biometitle.invalid", (Object[])new Object[]{formatArgs}));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context, Commands.CommandSelection environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"biometitle").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"biome", (ArgumentType)ResourceOrTagLocationArgument.m_210968_((ResourceKey)Registry.f_122885_)).executes(ctx -> BiomeTitleCommand.displayTitle((CommandSourceStack)ctx.getSource(), (ResourceOrTagLocationArgument.Result<Biome>)ResourceOrTagLocationArgument.m_210955_((CommandContext)ctx, (String)"biome", (ResourceKey)Registry.f_122885_, (DynamicCommandExceptionType)INVALID_BIOME_EXCEPTION)))));
    }

    public static int displayTitle(CommandSourceStack commandSource, ResourceOrTagLocationArgument.Result<Biome> biomeResult) throws CommandSyntaxException {
        MutableComponent biomeTitle;
        ResourceLocation biomeBaseKey;
        try {
            biomeBaseKey = new ResourceLocation(biomeResult.m_207276_());
        }
        catch (ResourceLocationException e) {
            throw INVALID_BIOME_EXCEPTION.create((Object)biomeResult.m_207276_());
        }
        String overrideBiomeNameKey = Util.m_137492_((String)"travelerstitles.biome", (ResourceLocation)biomeBaseKey);
        String normalBiomeNameKey = Util.m_137492_((String)"biome", (ResourceLocation)biomeBaseKey);
        if (TravelersTitlesCommon.CONFIG.biomes.biomeBlacklist.contains(biomeBaseKey.toString())) {
            commandSource.m_81354_((Component)Component.m_237113_((String)"That biome is blacklisted, so its title won't normally show!"), false);
        }
        if (Language.m_128107_().m_6722_(overrideBiomeNameKey)) {
            biomeTitle = Component.m_237115_((String)overrideBiomeNameKey);
        } else if (Language.m_128107_().m_6722_(normalBiomeNameKey)) {
            biomeTitle = Component.m_237115_((String)normalBiomeNameKey);
        } else {
            throw BIOME_NOT_FOUND_EXCEPTION.create((Object)biomeResult.m_207276_());
        }
        String overrideBiomeColorKey = overrideBiomeNameKey + ".color";
        String normalBiomeColorKey = normalBiomeNameKey + ".color";
        String biomeColorStr = Language.m_128107_().m_6722_(overrideBiomeColorKey) ? Language.m_128107_().m_6834_(overrideBiomeColorKey) : (Language.m_128107_().m_6722_(normalBiomeColorKey) ? Language.m_128107_().m_6834_(normalBiomeColorKey) : TravelersTitlesCommon.titleManager.biomeTitleRenderer.titleDefaultTextColor);
        TravelersTitlesCommon.titleManager.biomeTitleRenderer.setColor(biomeColorStr);
        TravelersTitlesCommon.titleManager.biomeTitleRenderer.displayTitle((Component)biomeTitle, null);
        TravelersTitlesCommon.titleManager.biomeTitleRenderer.cooldownTimer = TravelersTitlesCommon.CONFIG.biomes.textCooldownTime;
        return 1;
    }
}

