/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.bracket;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotation.BracketDumper;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.natives.block.ExpandBlock;
import com.blamejared.crafttweaker.natives.block.material.ExpandMaterial;
import com.blamejared.crafttweaker.natives.entity.ExpandEntityType;
import com.blamejared.crafttweaker.natives.entity.attribute.ExpandAttribute;
import com.blamejared.crafttweaker.natives.entity.effect.ExpandMobEffect;
import com.blamejared.crafttweaker.natives.item.ExpandCreativeModeTab;
import com.blamejared.crafttweaker.natives.item.alchemy.ExpandPotion;
import com.blamejared.crafttweaker.natives.item.enchantment.ExpandEnchantment;
import com.blamejared.crafttweaker.natives.sound.ExpandSoundEvent;
import com.blamejared.crafttweaker.natives.villager.ExpandVillagerProfession;
import com.blamejared.crafttweaker.natives.world.damage.ExpandDamageSource;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.BracketDumpers")
@Document(value="vanilla/api/BracketDumpers")
public class BracketDumpers {
    @ZenCodeType.Method
    @BracketDumper(value="attribute")
    public static Collection<String> getAttributeDump() {
        return Registry.f_122866_.m_123024_().map(ExpandAttribute::getCommandString).collect(Collectors.toSet());
    }

    @ZenCodeType.Method
    @BracketDumper(value="block")
    public static Collection<String> getBlockDump() {
        return Registry.f_122824_.m_123024_().map(ExpandBlock::getCommandString).collect(Collectors.toSet());
    }

    @ZenCodeType.Method
    @BracketDumper(value="material")
    public static Collection<String> getMaterialDump() {
        return ExpandMaterial.VANILLA_MATERIALS.values().stream().map(ExpandMaterial::getCommandString).collect(Collectors.toSet());
    }

    @ZenCodeType.Method
    @BracketDumper(value="mobeffect")
    public static Collection<String> getEffectDump() {
        return Registry.f_122823_.m_123024_().map(ExpandMobEffect::getCommandString).collect(Collectors.toSet());
    }

    @ZenCodeType.Method
    @BracketDumper(value="enchantment")
    public static Collection<String> getEnchantmentDump() {
        return Registry.f_122825_.m_123024_().map(ExpandEnchantment::getCommandString).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    @BracketDumper(value="entitytype")
    public static Collection<String> getEntityTypeDump() {
        return Registry.f_122826_.m_123024_().map(ExpandEntityType::getCommandString).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    @BracketDumper(value="item")
    public static Collection<String> getItemBracketDump() {
        return Registry.f_122827_.m_123024_().map(Item::m_7968_).map(ItemStackUtil::getCommandString).collect(Collectors.toSet());
    }

    @ZenCodeType.Method
    @BracketDumper(value="potion")
    public static Collection<String> getPotionTypeDump() {
        return Registry.f_122828_.m_123024_().map(ExpandPotion::getCommandString).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    @BracketDumper(value="profession")
    public static Collection<String> getProfessionDump() {
        return Registry.f_122869_.m_123024_().map(ExpandVillagerProfession::getCommandString).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    @BracketDumper(value="damagesource")
    public static Collection<String> getDamageSourceDump() {
        return ExpandDamageSource.PRE_REGISTERED_DAMAGE_SOURCES.keySet().stream().map(arg_0 -> BracketDumpers.lambda$getDamageSourceDump$0("<damagesource:%s>", arg_0)).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    @BracketDumper(value="creativemodetab")
    public static Collection<String> getCreativeModeTabBracketDump() {
        return Arrays.stream(CreativeModeTab.f_40748_).map(ExpandCreativeModeTab::getCommandString).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    @BracketDumper(value="soundevent")
    public static Collection<String> getSoundEventDump() {
        return Registry.f_122821_.m_123024_().map(ExpandSoundEvent::getCommandString).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    @BracketDumper(value="targetingstrategy")
    public static Collection<String> getTargetingStrategyDump() {
        return CraftTweakerAPI.getRegistry().getReplacerRegistry().allStrategyNames().stream().map(arg_0 -> BracketDumpers.lambda$getTargetingStrategyDump$1("<targetingstrategy:%s>", arg_0)).collect(Collectors.toList());
    }

    private static /* synthetic */ String lambda$getTargetingStrategyDump$1(String rec$, Object xva$0) {
        return "<targetingstrategy:%s>".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$getDamageSourceDump$0(String rec$, Object xva$0) {
        return "<damagesource:%s>".formatted(xva$0);
    }
}

