/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient.serializer;

import com.blamejared.crafttweaker.CraftTweakerRegistries;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.transform.IIngredientTransformer;
import com.blamejared.crafttweaker.api.ingredient.transform.serializer.IIngredientTransformerSerializer;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientTransformed;
import com.blamejared.crafttweaker.api.ingredient.type.IngredientTransformed;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

@ParametersAreNonnullByDefault
public enum IngredientTransformedSerializer implements IIngredientSerializer<IngredientTransformed<?, ?>>
{
    INSTANCE;


    public JsonObject toJson(IngredientTransformed<?, ?> ingredientVanillaPlus) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", CraftingHelper.getID((IIngredientSerializer)INSTANCE).toString());
        jsonObject.add("base", ((IIngredientTransformed)ingredientVanillaPlus.getCrTIngredient()).getBaseIngredient().asVanillaIngredient().m_43942_());
        IIngredientTransformer<?> transformer = ingredientVanillaPlus.getTransformer();
        JsonObject value = transformer.toJson();
        if (!value.has("type")) {
            value.addProperty("type", transformer.getType().toString());
        }
        jsonObject.add("transformer", (JsonElement)value);
        return jsonObject;
    }

    public IngredientTransformed<?, ?> parse(FriendlyByteBuf buffer) {
        IIngredient base = IIngredient.fromIngredient(Ingredient.m_43940_((FriendlyByteBuf)buffer));
        ResourceLocation type = buffer.m_130281_();
        IIngredientTransformerSerializer value = (IIngredientTransformerSerializer)CraftTweakerRegistries.REGISTRY_TRANSFORMER_SERIALIZER.m_7745_(type);
        if (value == null) {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        return new IngredientTransformed(new IIngredientTransformed<IIngredient>(base, (IIngredientTransformer<IIngredient>)value.fromNetwork(buffer)));
    }

    public IngredientTransformed<?, ?> parse(JsonObject json) {
        JsonObject base = json.getAsJsonObject("base");
        IIngredient baseIngredient = IIngredient.fromIngredient(CraftingHelper.getIngredient((JsonElement)base));
        JsonObject transformer = json.getAsJsonObject("transformer");
        ResourceLocation type = new ResourceLocation(transformer.get("type").getAsString());
        IIngredientTransformerSerializer value = (IIngredientTransformerSerializer)CraftTweakerRegistries.REGISTRY_TRANSFORMER_SERIALIZER.m_7745_(type);
        if (value == null) {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        return new IngredientTransformed(new IIngredientTransformed<IIngredient>(baseIngredient, (IIngredientTransformer<IIngredient>)value.fromJson(transformer)));
    }

    public void write(FriendlyByteBuf buffer, IngredientTransformed<?, ?> ingredient) {
        Ingredient baseIngredient = ((IIngredientTransformed)ingredient.getCrTIngredient()).getBaseIngredient().asVanillaIngredient();
        baseIngredient.m_43923_(buffer);
        IIngredientTransformer<?> transformer = ingredient.getTransformer();
        IIngredientTransformerSerializer serializer = transformer.getSerializer();
        buffer.m_130085_(serializer.getType());
        transformer.toNetwork(buffer);
    }
}

