/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient.transform.serializer;

import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.ingredient.transform.serializer.IIngredientTransformerSerializer;
import com.blamejared.crafttweaker.api.ingredient.transform.type.TransformReplace;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public enum TransformReplaceSerializer implements IIngredientTransformerSerializer<TransformReplace<?>>
{
    INSTANCE;


    @Override
    public TransformReplace<?> fromNetwork(FriendlyByteBuf buffer) {
        ItemStack replaceWith = buffer.m_130267_();
        return new TransformReplace(IItemStack.of(replaceWith));
    }

    @Override
    public TransformReplace<?> fromJson(JsonObject json) {
        Ingredient.Value iItemList = Ingredient.m_43919_((JsonObject)json.getAsJsonObject("replaceWith"));
        ItemStack replaceWith = (ItemStack)iItemList.m_6223_().iterator().next();
        return new TransformReplace(IItemStack.of(replaceWith));
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer, TransformReplace<?> ingredient) {
        buffer.m_130055_(ingredient.getReplaceWith().getInternal());
    }

    @Override
    public JsonObject toJson(TransformReplace<?> transformer) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", this.getType().toString());
        jsonObject.add("replaceWith", transformer.getReplaceWith().asVanillaIngredient().m_43942_());
        return jsonObject;
    }

    @Override
    public ResourceLocation getType() {
        return CraftTweakerConstants.rl("transform_replace");
    }
}

