/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient.type;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.condition.IIngredientCondition;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import net.minecraft.world.item.crafting.Ingredient;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.ingredient.type.IngredientConditioned")
@Document(value="vanilla/api/ingredient/type/IngredientConditioned")
public class IIngredientConditioned<T extends IIngredient>
implements IIngredient {
    private final T base;
    private final IIngredientCondition<T> condition;

    public IIngredientConditioned(T base, IIngredientCondition<T> condition) {
        this.base = base;
        this.condition = condition;
    }

    @Override
    public Ingredient asVanillaIngredient() {
        return Services.REGISTRY.getIngredientConditioned(this);
    }

    @ZenCodeType.Getter(value="condition")
    public IIngredientCondition<T> getCondition() {
        return this.condition;
    }

    @Override
    public String getCommandString() {
        return this.condition.getCommandString(this.base);
    }

    @ZenCodeType.Getter(value="baseIngredient")
    public T getBaseIngredient() {
        return this.base;
    }

    @Override
    @ZenCodeType.Method
    public boolean matches(IItemStack stack, boolean ignoreDamage) {
        return this.base.matches(stack, this.condition.ignoresDamage()) && this.condition.matches(stack);
    }

    @Override
    @ZenCodeType.Getter(value="items")
    public IItemStack[] getItems() {
        return this.base.getItems();
    }

    @Override
    @ZenCodeType.Caster(implicit=true)
    public MapData asMapData() {
        return this.base.asMapData();
    }

    @Override
    @ZenCodeType.Caster(implicit=true)
    public IData asIData() {
        return this.base.asIData();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IIngredientConditioned that = (IIngredientConditioned)o;
        if (!this.base.equals(that.base)) {
            return false;
        }
        return this.condition.equals(that.condition);
    }

    public int hashCode() {
        int result = this.base.hashCode();
        result = 31 * result + this.condition.hashCode();
        return result;
    }
}

