/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.event;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.entity.NameTagResult;
import com.blamejared.crafttweaker.impl.script.RecipeManagerScriptLoader;
import com.blamejared.crafttweaker.natives.entity.ExpandEntityType;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker.platform.services.IClientHelper;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="crafttweaker")
public class CTClientEventHandler {
    @SubscribeEvent
    public static void onRecipesUpdated(RecipesUpdatedEvent event) {
        RecipeManagerScriptLoader.updateState(RecipeManagerScriptLoader.UpdatedState.RECIPES, () -> ((RecipesUpdatedEvent)event).getRecipeManager());
    }

    @SubscribeEvent
    public static void handleTooltips(ItemTooltipEvent e) {
        Services.CLIENT.applyTooltips(e.getItemStack(), e.getFlags(), e.getToolTip());
    }

    @SubscribeEvent
    public static void nameTag(RenderNameTagEvent e) {
        Entity entity = e.getEntity();
        Event.Result eventResult = e.getResult();
        Boolean result = eventResult == Event.Result.DEFAULT ? null : Boolean.valueOf(eventResult == Event.Result.ALLOW);
        Component content = e.getContent();
        Component originalContent = e.getOriginalContent();
        for (Predicate<Entity> predicate : IClientHelper.NAMETAGS.keySet()) {
            if (!predicate.test(entity)) continue;
            try {
                NameTagResult nameTagResult = new NameTagResult(result, content, originalContent);
                IClientHelper.NAMETAGS.get(predicate).apply(entity, nameTagResult);
                e.setResult(nameTagResult.getResult() == null ? Event.Result.DEFAULT : (nameTagResult.getResult() != false ? Event.Result.ALLOW : Event.Result.DENY));
                e.setContent(nameTagResult.getContent());
            }
            catch (Exception exception) {
                CraftTweakerAPI.LOGGER.error("Unable to run one of the name tag functions for {} due to an error (for experts, refer to {})", (Object)ExpandEntityType.getCommandString(entity.m_6095_()), (Object)IClientHelper.NAMETAGS.get(predicate).getClass().getName(), (Object)exception);
            }
        }
    }
}

