/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.platform.services;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.condition.serializer.IIngredientConditionSerializer;
import com.blamejared.crafttweaker.api.ingredient.transform.serializer.IIngredientTransformerSerializer;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientConditioned;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientTransformed;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.MirrorAxis;
import com.blamejared.crafttweaker.api.recipe.fun.RecipeFunction1D;
import com.blamejared.crafttweaker.api.recipe.fun.RecipeFunction2D;
import com.blamejared.crafttweaker.api.recipe.serializer.ICTShapedRecipeBaseSerializer;
import com.blamejared.crafttweaker.api.recipe.serializer.ICTShapelessRecipeBaseSerializer;
import com.blamejared.crafttweaker.api.recipe.type.CTShapedRecipeBase;
import com.blamejared.crafttweaker.api.recipe.type.CTShapelessRecipeBase;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Lifecycle;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public interface IRegistryHelper {
    default public Set<ResourceKey<?>> serverOnlyRegistries() {
        return StreamSupport.stream(RegistryAccess.m_194613_().spliterator(), false).filter(registryData -> !registryData.m_123111_()).map(RegistryAccess.RegistryData::f_123101_).collect(Collectors.toSet());
    }

    default public void registerSerializer(MappedRegistry<IIngredientTransformerSerializer<?>> registry, IIngredientTransformerSerializer<?> serializer) {
        registry.m_203505_(ResourceKey.m_135785_((ResourceKey)registry.m_123023_(), (ResourceLocation)serializer.getType()), serializer, Lifecycle.stable());
    }

    default public void registerSerializer(MappedRegistry<IIngredientConditionSerializer<?>> registry, IIngredientConditionSerializer<?> serializer) {
        registry.m_203505_(ResourceKey.m_135785_((ResourceKey)registry.m_123023_(), (ResourceLocation)serializer.getType()), serializer, Lifecycle.stable());
    }

    default public <T> MappedRegistry<T> registerVanillaRegistry(ResourceLocation location) {
        WritableRegistry registry = (WritableRegistry)Registry.f_122897_;
        ResourceKey regKey = ResourceKey.m_135788_((ResourceLocation)location);
        Lifecycle stable = Lifecycle.stable();
        MappedRegistry mappedReg = new MappedRegistry(regKey, stable, null);
        registry.m_203505_(regKey, (Object)mappedReg, stable);
        return mappedReg;
    }

    public void init();

    public ICTShapedRecipeBaseSerializer getCTShapedRecipeSerializer();

    public ICTShapelessRecipeBaseSerializer getCTShapelessRecipeSerializer();

    default public CTShapedRecipeBase createCTShapedRecipe(String name, IItemStack output, IIngredient[][] ingredients, MirrorAxis mirrorAxis, @Nullable RecipeFunction2D function) {
        return this.getCTShapedRecipeSerializer().makeRecipe(CraftTweakerConstants.rl(name), output, ingredients, mirrorAxis, function);
    }

    default public CTShapelessRecipeBase createCTShapelessRecipe(String name, IItemStack output, IIngredient[] ingredients, @Nullable RecipeFunction1D function) {
        return this.getCTShapelessRecipeSerializer().makeRecipe(CraftTweakerConstants.rl(name), output, ingredients, function);
    }

    public Ingredient getIngredientAny();

    public Ingredient getIngredientList(List<Ingredient> var1);

    public <T extends IIngredient> Ingredient getIngredientConditioned(IIngredientConditioned<T> var1);

    public <T extends IIngredient> Ingredient getIngredientTransformed(IIngredientTransformed<T> var1);

    public Ingredient getIngredientPartialTag(ItemStack var1);

    default public Optional<ResourceLocation> maybeGetRegistryKey(Object object) {
        if (object instanceof Item) {
            Item obj = (Item)object;
            return this.nonDefaultKey((Registry)Registry.f_122827_, (Object)obj);
        }
        if (object instanceof Potion) {
            Potion obj = (Potion)object;
            return this.nonDefaultKey((Registry)Registry.f_122828_, (Object)obj);
        }
        if (object instanceof EntityType) {
            EntityType obj = (EntityType)object;
            return this.nonDefaultKey((Registry)Registry.f_122826_, (Object)obj);
        }
        if (object instanceof RecipeType) {
            RecipeType obj = (RecipeType)object;
            return this.nonDefaultKey(Registry.f_122864_, obj);
        }
        if (object instanceof RecipeSerializer) {
            RecipeSerializer obj = (RecipeSerializer)object;
            return this.nonDefaultKey(Registry.f_122865_, obj);
        }
        if (object instanceof Attribute) {
            Attribute obj = (Attribute)object;
            return this.nonDefaultKey(Registry.f_122866_, obj);
        }
        if (object instanceof Fluid) {
            Fluid obj = (Fluid)object;
            return this.nonDefaultKey((Registry)Registry.f_122822_, (Object)obj);
        }
        if (object instanceof Enchantment) {
            Enchantment obj = (Enchantment)object;
            return this.nonDefaultKey(Registry.f_122825_, obj);
        }
        if (object instanceof Block) {
            Block obj = (Block)object;
            return this.nonDefaultKey((Registry)Registry.f_122824_, (Object)obj);
        }
        if (object instanceof MobEffect) {
            MobEffect obj = (MobEffect)object;
            return this.nonDefaultKey(Registry.f_122823_, obj);
        }
        if (object instanceof VillagerProfession) {
            VillagerProfession obj = (VillagerProfession)object;
            return this.nonDefaultKey((Registry)Registry.f_122869_, (Object)obj);
        }
        if (object instanceof Biome) {
            Biome obj = (Biome)object;
            return this.nonDefaultKey(CraftTweakerAPI.getAccessibleElementsProvider().registryAccess().m_175515_(Registry.f_122885_), obj);
        }
        if (object instanceof SoundEvent) {
            SoundEvent obj = (SoundEvent)object;
            return this.nonDefaultKey(Registry.f_122821_, obj);
        }
        return Optional.empty();
    }

    private <T> Optional<ResourceLocation> nonDefaultKey(Registry<T> registry, T obj) {
        DefaultedRegistry def;
        ResourceLocation key = registry.m_7981_(obj);
        if (registry instanceof DefaultedRegistry && (def = (DefaultedRegistry)registry).m_122315_().equals((Object)key) && !def.m_7745_(key).equals(obj)) {
            return Optional.empty();
        }
        return Optional.ofNullable(key);
    }

    default public Registry<Biome> biomes() {
        return CraftTweakerAPI.getAccessibleElementsProvider().registryAccess().m_175515_(Registry.f_122885_);
    }

    default public <T> Holder<T> makeHolder(ResourceKey<?> resourceKey, Either<T, ResourceLocation> objectOrKey) {
        return (Holder)objectOrKey.map(t -> this.makeHolder(resourceKey, t), key -> this.makeHolder(resourceKey, (ResourceLocation)key));
    }

    default public <T> Holder<T> makeHolder(ResourceKey<?> resourceKey, T object) {
        Registry registry = CraftTweakerAPI.getAccessibleElementsProvider().registryAccess().m_175515_((ResourceKey)GenericUtil.uncheck(resourceKey));
        return (Holder)registry.m_7854_(object).flatMap(arg_0 -> ((Registry)registry).m_203636_(arg_0)).orElseThrow(() -> new RuntimeException("Unable to make holder for registry: " + registry + " and object: " + object));
    }

    default public <T> Holder<T> makeHolder(ResourceKey<?> resourceKey, ResourceLocation key) {
        Registry registry = CraftTweakerAPI.getAccessibleElementsProvider().registryAccess().m_175515_((ResourceKey)GenericUtil.uncheck(resourceKey));
        if (!registry.m_7804_(key)) {
            throw new IllegalArgumentException("Registry does not contain key: '" + key + "'");
        }
        return (Holder)registry.m_203636_(ResourceKey.m_135785_((ResourceKey)registry.m_123023_(), (ResourceLocation)key)).orElseThrow(() -> new RuntimeException("Unable to make holder for registry: " + registry + " and id: " + key));
    }
}

