/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vectorwing.farmersdelight.common.block.entity.BasketBlockEntity;
import vectorwing.farmersdelight.common.registry.ModBlockEntityTypes;

public class BasketBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty ENABLED = BlockStateProperties.f_61431_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape OUT_SHAPE = Shapes.m_83144_();
    public static final VoxelShape RENDER_SHAPE = BasketBlock.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    public static final ImmutableMap<Direction, VoxelShape> COLLISION_SHAPE_FACING = Maps.immutableEnumMap((Map)ImmutableMap.builder().put((Object)Direction.DOWN, (Object)BasketBlock.makeHollowCubeShape(BasketBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0))).put((Object)Direction.UP, (Object)BasketBlock.makeHollowCubeShape(BasketBlock.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0))).put((Object)Direction.NORTH, (Object)BasketBlock.makeHollowCubeShape(BasketBlock.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)14.0))).put((Object)Direction.SOUTH, (Object)BasketBlock.makeHollowCubeShape(BasketBlock.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)16.0))).put((Object)Direction.WEST, (Object)BasketBlock.makeHollowCubeShape(BasketBlock.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0))).put((Object)Direction.EAST, (Object)BasketBlock.makeHollowCubeShape(BasketBlock.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0))).build());

    private static VoxelShape makeHollowCubeShape(VoxelShape cutout) {
        return Shapes.m_83148_((VoxelShape)OUT_SHAPE, (VoxelShape)cutout, (BooleanOp)BooleanOp.f_82685_).m_83296_();
    }

    public BasketBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (VoxelShape)COLLISION_SHAPE_FACING.get((Object)state.m_61143_((Property)FACING));
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return RENDER_SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, ENABLED, WATERLOGGED});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tileEntity;
        if (!level.f_46443_ && (tileEntity = level.m_7702_(pos)) instanceof BasketBlockEntity) {
            player.m_5893_((MenuProvider)((BasketBlockEntity)tileEntity));
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof Container) {
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)((Container)tileEntity));
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean isPowered;
        boolean bl = isPowered = !level.m_46753_(pos);
        if (isPowered != (Boolean)state.m_61143_((Property)ENABLED)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(isPowered)), 4);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(pos));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity tileEntity;
        if (stack.m_41788_() && (tileEntity = level.m_7702_(pos)) instanceof BasketBlockEntity) {
            ((BasketBlockEntity)tileEntity).m_58638_(stack.m_41786_());
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluid = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter level, BlockPos pos) {
        return OUT_SHAPE;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BasketBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : BasketBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntityTypes.BASKET.get()), BasketBlockEntity::pushItemsTick);
    }
}

