/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports;

import com.aizistral.nochatreports.NoChatReports;
import com.aizistral.nochatreports.config.NCRConfig;
import com.aizistral.nochatreports.core.ServerDataExtension;
import com.aizistral.nochatreports.core.ServerSafetyLevel;
import com.aizistral.nochatreports.core.ServerSafetyState;
import com.aizistral.nochatreports.gui.AwaitConnectionScreen;
import com.aizistral.nochatreports.gui.UnsafeServerScreen;
import com.aizistral.nochatreports.mixins.client.AccessorDisconnectedScreen;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="nochatreports", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class NoChatReportsClient {
    private static final List<String> KEY_DISCONNECT_REASONS = ImmutableList.of((Object)"multiplayer.disconnect.missing_public_key", (Object)"multiplayer.disconnect.invalid_public_key_signature", (Object)"multiplayer.disconnect.invalid_public_key");
    private static final List<String> STRING_DISCONNECT_REASONS = ImmutableList.of((Object)"A secure profile is required to join this server.", (Object)"Secure profile expired.", (Object)"Secure profile invalid.");
    private static final Component CONNECT_FAILED_NCR = Component.m_237115_((String)"connect.failed");
    private static boolean screenOverride = false;

    private NoChatReportsClient() {
        throw new IllegalStateException("Can't touch this");
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        Minecraft client = Minecraft.m_91087_();
        Screen screen = event.getScreen();
        if (!NCRConfig.getClient().enableMod()) {
            return;
        }
        if (screen instanceof AccessorDisconnectedScreen) {
            AccessorDisconnectedScreen dsc = (AccessorDisconnectedScreen)screen;
            if (screenOverride || ServerSafetyState.isOnServer() || screen.m_96636_() == CONNECT_FAILED_NCR) {
                return;
            }
            screenOverride = true;
            Component disconnectReason = dsc.getReason();
            if (disconnectReason != null) {
                TranslatableContents translatable;
                ComponentContents componentContents;
                if (NCRConfig.getCommon().enableDebugLog()) {
                    NoChatReports.LOGGER.info("Disconnected with reason {}, reconnect count: {}", (Object)Component.Serializer.m_237122_((Component)disconnectReason), (Object)ServerSafetyState.getReconnectCount());
                }
                if (ServerSafetyState.allowsUnsafeServer()) {
                    screen = new DisconnectedScreen((Screen)new JoinMultiplayerScreen((Screen)new TitleScreen()), CONNECT_FAILED_NCR, dsc.getReason());
                    client.m_91152_(screen);
                    screenOverride = false;
                    return;
                }
                if ((STRING_DISCONNECT_REASONS.contains(disconnectReason.getString()) || (componentContents = disconnectReason.m_214077_()) instanceof TranslatableContents && KEY_DISCONNECT_REASONS.contains((translatable = (TranslatableContents)componentContents).m_237508_())) && ServerSafetyState.getLastServerAddress() != null) {
                    if (!NCRConfig.getServerWhitelist().isWhitelisted(ServerSafetyState.getLastServerAddress())) {
                        if (NCRConfig.getCommon().enableDebugLog()) {
                            NoChatReports.LOGGER.info("Server {} evaluated as unsafe and is not whitelisted, displaying warning screen.", (Object)(ServerSafetyState.getLastServerAddress().m_171863_() + ":" + ServerSafetyState.getLastServerAddress().m_171866_()));
                        }
                        client.m_91152_((Screen)new UnsafeServerScreen());
                    } else {
                        NCRConfig.getClient().updateSigningCheck(ServerSafetyState.getLastServerAddress());
                        if (ServerSafetyState.getReconnectCount() <= 0) {
                            ServerSafetyState.setAllowsUnsafeServer(true);
                            client.m_91152_((Screen)new AwaitConnectionScreen((Screen)new JoinMultiplayerScreen((Screen)new TitleScreen())));
                            screenOverride = false;
                            return;
                        }
                        ServerSafetyState.setReconnectCount(0);
                        screenOverride = false;
                        return;
                    }
                }
            }
            screenOverride = false;
        } else if (screen instanceof JoinMultiplayerScreen) {
            if (NCRConfig.getCommon().enableDebugLog()) {
                NoChatReports.LOGGER.info("Initialized JoinMultiplayerScreen screen, resetting safety state!");
            }
            ServerSafetyState.reset();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onDisconnect(Minecraft client) {
        if (!NCRConfig.getClient().enableMod()) {
            return;
        }
        if (NCRConfig.getCommon().enableDebugLog()) {
            NoChatReports.LOGGER.info("Disconnected from server, resetting safety state!");
        }
        ServerSafetyState.reset();
        ServerSafetyState.setDisconnectMillis(Util.m_137550_());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onPlayReady(ClientPlayerNetworkEvent.LoggingIn event) {
        Minecraft client = Minecraft.m_91087_();
        if (!NCRConfig.getClient().enableMod()) {
            return;
        }
        client.execute(() -> {
            ServerSafetyState.setReconnectCount(0);
            ServerSafetyState.setOnServer(true);
            if (!client.m_91090_()) {
                boolean canSend = NoChatReports.isDetectedOnServer();
                if (ServerSafetyState.getCurrent() != ServerSafetyLevel.REALMS) {
                    if (canSend) {
                        ServerSafetyState.updateCurrent(ServerSafetyLevel.SECURE);
                    } else if (ServerSafetyState.forceSignedMessages()) {
                        ServerSafetyState.updateCurrent(ServerSafetyLevel.INSECURE);
                    } else {
                        ServerDataExtension ext;
                        ServerData patt6144$temp = ServerSafetyState.getLastServerData();
                        if (patt6144$temp instanceof ServerDataExtension && (ext = (ServerDataExtension)patt6144$temp).preventsChatReports()) {
                            ServerSafetyState.updateCurrent(ServerSafetyLevel.SECURE);
                        } else {
                            ServerSafetyState.updateCurrent(ServerSafetyLevel.UNINTRUSIVE);
                        }
                    }
                }
            }
            if (NCRConfig.getCommon().enableDebugLog()) {
                NoChatReports.LOGGER.info("Sucessfully connected to server, safety state: {}, reconnect count reset.", (Object)ServerSafetyState.getCurrent());
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void reconnectLastServer() {
        ServerSafetyState.setReconnectCount(ServerSafetyState.getReconnectCount() + 1);
        ConnectScreen.m_169267_((Screen)new JoinMultiplayerScreen((Screen)new TitleScreen()), (Minecraft)Minecraft.m_91087_(), (ServerAddress)ServerSafetyState.getLastServerAddress(), (ServerData)ServerSafetyState.getLastServerData());
    }
}

