/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.teamabnormals.blueprint.client.renderer.IBlueprintBoat;
import javax.annotation.Nonnull;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BlueprintBoatRenderer<E extends Boat>
extends EntityRenderer<E> {
    private final BoatModel model;

    private BlueprintBoatRenderer(EntityRendererProvider.Context context, BoatModel model) {
        super(context);
        this.model = model;
        this.f_114477_ = 0.8f;
    }

    @Nonnull
    public static <E extends Boat> BlueprintBoatRenderer<E> simple(EntityRendererProvider.Context context) {
        return new BlueprintBoatRenderer<E>(context, new BoatModel(BoatModel.m_233347_((boolean)false).m_171564_(), false));
    }

    @Nonnull
    public static <E extends Boat> BlueprintBoatRenderer<E> chest(EntityRendererProvider.Context context) {
        return new BlueprintBoatRenderer<E>(context, new BoatModel(BoatModel.m_233347_((boolean)true).m_171564_(), true));
    }

    public void render(E entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource source, int packedLightIn) {
        float f2;
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.375, 0.0);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - entityYaw));
        float f = (float)entity.m_38385_() - partialTicks;
        float f1 = entity.m_38384_() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)entity.m_38386_()));
        }
        if (!Mth.m_14033_((float)(f2 = entity.m_38352_(partialTicks)), (float)0.0f)) {
            poseStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 1.0f), entity.m_38352_(partialTicks), true));
        }
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        this.model.m_6973_(entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = source.m_6299_(this.model.m_103119_(this.getTextureLocation(entity)));
        this.model.m_7695_(poseStack, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        VertexConsumer vertexConsumer1 = source.m_6299_(RenderType.m_110478_());
        this.model.m_102282_().m_104301_(poseStack, vertexConsumer1, packedLightIn, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        super.m_7392_(entity, entityYaw, partialTicks, poseStack, source, packedLightIn);
    }

    public ResourceLocation getTextureLocation(E entity) {
        return ((IBlueprintBoat)entity).getTexture();
    }
}

