/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.client.screen.splash;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.blueprint.client.screen.splash.LiteralSplash;
import com.teamabnormals.blueprint.client.screen.splash.Splash;
import com.teamabnormals.blueprint.core.Blueprint;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.Optional;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;

public abstract class SplashProvider
implements DataProvider {
    private final String modId;
    private final DataGenerator dataGenerator;
    private final LinkedList<Splash> splashes = new LinkedList();

    protected SplashProvider(String modId, DataGenerator dataGenerator) {
        this.modId = modId;
        this.dataGenerator = dataGenerator;
    }

    protected void add(String splash) {
        this.add(new LiteralSplash(splash));
    }

    protected void add(Splash splash) {
        this.splashes.add(splash);
    }

    protected abstract void registerSplashes();

    public void m_213708_(CachedOutput cachedOutput) throws IOException {
        this.splashes.clear();
        this.registerSplashes();
        Path outputFolder = this.dataGenerator.m_123916_();
        Path resolvedPath = outputFolder.resolve("assets/" + this.modId + "/texts/blueprint/splashes.json");
        try {
            DataResult dataResult = Splash.LIST_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, this.splashes);
            Optional error = dataResult.error();
            if (error.isPresent()) {
                throw new JsonParseException(((DataResult.PartialResult)error.get()).message());
            }
            DataProvider.m_236072_((CachedOutput)cachedOutput, (JsonElement)((JsonElement)dataResult.result().get()), (Path)resolvedPath);
        }
        catch (JsonParseException | IOException e) {
            Blueprint.LOGGER.error("Couldn't save splashes {}", (Object)resolvedPath, (Object)e);
        }
    }

    public String m_6055_() {
        return "Blueprint Splashes: " + this.modId;
    }
}

