/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.api.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.SimpleUnbakedGeometry;

public class FullbrightModel
extends SimpleUnbakedGeometry<FullbrightModel> {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(FullbrightBlockPart.class, (Object)new FullbrightBlockPart.Deserializer()).registerTypeAdapter(FullbrightBlockPartFace.class, (Object)new FullbrightBlockPartFace.Deserializer()).registerTypeAdapter(BlockFaceUV.class, (Object)new BlockFaceUV.Deserializer()).create();
    private static final IQuadTransformer MAX_LIGHTMAP_TRANSFORMER = QuadTransformers.applyingLightmap((int)0xF000F0);
    private final List<FullbrightBlockPart> elements;

    private FullbrightModel(List<FullbrightBlockPart> list) {
        this.elements = list;
    }

    public void addQuads(IGeometryBakingContext owner, IModelBuilder<?> modelBuilder, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation) {
        for (FullbrightBlockPart part : this.elements) {
            for (Map.Entry entry : part.f_111310_.entrySet()) {
                FullbrightBlockPartFace face = (FullbrightBlockPartFace)((Object)entry.getValue());
                BakedQuad quad = BlockModel.m_111437_((BlockElement)part, (BlockElementFace)face, (TextureAtlasSprite)spriteGetter.apply(owner.getMaterial(face.f_111356_)), (Direction)((Direction)entry.getKey()), (ModelState)modelTransform, (ResourceLocation)modelLocation);
                if (!face.override && part.fullbright || face.override && face.fullbright) {
                    MAX_LIGHTMAP_TRANSFORMER.processInPlace(quad);
                }
                if (face.f_111354_ == null) {
                    modelBuilder.addUnculledFace(quad);
                    continue;
                }
                modelBuilder.addCulledFace(modelTransform.m_6189_().rotateTransform(face.f_111354_), quad);
            }
        }
    }

    public Collection<Material> getMaterials(IGeometryBakingContext owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet textures = Sets.newHashSet();
        for (FullbrightBlockPart part : this.elements) {
            for (BlockElementFace face : part.f_111310_.values()) {
                textures.add(owner.getMaterial(face.f_111356_));
            }
        }
        return textures;
    }

    private static class FullbrightBlockPart
    extends BlockElement {
        private final boolean fullbright;

        private FullbrightBlockPart(Vector3f positionFrom, Vector3f positionTo, Map<Direction, BlockElementFace> mapFaces, @Nullable BlockElementRotation partRotation, boolean shade, boolean fullbright) {
            super(positionFrom, positionTo, mapFaces, partRotation, shade);
            this.fullbright = fullbright;
        }

        private static class Deserializer
        implements JsonDeserializer<FullbrightBlockPart> {
            private Deserializer() {
            }

            public FullbrightBlockPart deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
                JsonObject object = element.getAsJsonObject();
                Vector3f from = this.validateVectorBounds(object, "from");
                Vector3f to = this.validateVectorBounds(object, "to");
                BlockElementRotation rotation = this.parseRotation(object);
                Map<Direction, BlockElementFace> faces = this.parseFacesCheck(object);
                if (object.has("shade") && !GsonHelper.m_13880_((JsonObject)object, (String)"shade")) {
                    throw new JsonParseException("Expected shade to be a Boolean");
                }
                if (object.has("fullbright") && !GsonHelper.m_13880_((JsonObject)object, (String)"fullbright")) {
                    throw new JsonParseException("Expected fullbright to be a Boolean");
                }
                return new FullbrightBlockPart(from, to, faces, rotation, GsonHelper.m_13855_((JsonObject)object, (String)"shade", (boolean)true), GsonHelper.m_13855_((JsonObject)object, (String)"fullbright", (boolean)false));
            }

            @Nullable
            private BlockElementRotation parseRotation(JsonObject object) {
                BlockElementRotation rotation = null;
                if (object.has("rotation")) {
                    JsonObject rotObject = GsonHelper.m_13930_((JsonObject)object, (String)"rotation");
                    Vector3f origin = this.deserializeVec3f(rotObject, "origin");
                    origin.m_122261_(0.0625f);
                    rotation = new BlockElementRotation(origin, this.parseAxis(rotObject), this.parseAngle(rotObject), GsonHelper.m_13855_((JsonObject)rotObject, (String)"rescale", (boolean)false));
                }
                return rotation;
            }

            private float parseAngle(JsonObject object) {
                float angle = GsonHelper.m_13915_((JsonObject)object, (String)"angle");
                if (angle != 0.0f && Mth.m_14154_((float)angle) != 22.5f && Mth.m_14154_((float)angle) != 45.0f) {
                    throw new JsonParseException("Invalid rotation " + angle + " found, only -45/-22.5/0/22.5/45 allowed");
                }
                return angle;
            }

            private Direction.Axis parseAxis(JsonObject object) {
                String axisName = GsonHelper.m_13906_((JsonObject)object, (String)"axis");
                Direction.Axis axis = Direction.Axis.m_122473_((String)axisName.toLowerCase(Locale.ROOT));
                if (axis == null) {
                    throw new JsonParseException("Invalid rotation axis: " + axisName);
                }
                return axis;
            }

            private Map<Direction, BlockElementFace> parseFacesCheck(JsonObject object) {
                Map<Direction, BlockElementFace> faces = this.parseFaces(object);
                if (faces.isEmpty()) {
                    throw new JsonParseException("Expected between 1 and 6 unique faces, got 0");
                }
                return faces;
            }

            private Map<Direction, BlockElementFace> parseFaces(JsonObject object) {
                EnumMap faces = Maps.newEnumMap(Direction.class);
                JsonObject facesObject = GsonHelper.m_13930_((JsonObject)object, (String)"faces");
                for (Map.Entry entry : facesObject.entrySet()) {
                    Direction direction = this.parseEnumFacing((String)entry.getKey());
                    faces.put(direction, (BlockElementFace)GSON.fromJson((JsonElement)entry.getValue(), FullbrightBlockPartFace.class));
                }
                return faces;
            }

            private Direction parseEnumFacing(String name) {
                Direction direction = Direction.m_122402_((String)name);
                if (direction == null) {
                    throw new JsonParseException("Unknown facing: " + name);
                }
                return direction;
            }

            private Vector3f validateVectorBounds(JsonObject object, String name) {
                Vector3f vector = this.deserializeVec3f(object, name);
                if (vector.m_122239_() >= -16.0f && vector.m_122260_() >= -16.0f && vector.m_122269_() >= -16.0f && vector.m_122239_() <= 32.0f && vector.m_122260_() <= 32.0f && vector.m_122269_() <= 32.0f) {
                    return vector;
                }
                throw new JsonParseException("'" + name + "' specifier exceeds the allowed boundaries: " + vector);
            }

            private Vector3f deserializeVec3f(JsonObject object, String name) {
                JsonArray vectorJson = GsonHelper.m_13933_((JsonObject)object, (String)name);
                if (vectorJson.size() != 3) {
                    throw new JsonParseException("Expected 3 " + name + " values, found: " + vectorJson.size());
                }
                float[] vector = new float[3];
                for (int i = 0; i < 3; ++i) {
                    vector[i] = GsonHelper.m_13888_((JsonElement)vectorJson.get(i), (String)(name + "[" + i + "]"));
                }
                return new Vector3f(vector[0], vector[1], vector[2]);
            }
        }
    }

    private static class FullbrightBlockPartFace
    extends BlockElementFace {
        private final boolean fullbright;
        private final boolean override;

        private FullbrightBlockPartFace(@Nullable Direction cullFaceIn, int tintIndexIn, String textureIn, BlockFaceUV blockFaceUVIn, boolean fullbright, boolean override) {
            super(cullFaceIn, tintIndexIn, textureIn, blockFaceUVIn);
            this.fullbright = fullbright;
            this.override = override;
        }

        private static class Deserializer
        extends BlockElementFace.Deserializer {
            private Deserializer() {
            }

            public BlockElementFace deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
                BlockElementFace face = super.deserialize(element, type, context);
                JsonObject object = element.getAsJsonObject();
                if (object.has("fullbright") && !GsonHelper.m_13880_((JsonObject)object, (String)"fullbright")) {
                    throw new JsonParseException("Expected fullbright to be a Boolean");
                }
                return new FullbrightBlockPartFace(face.f_111354_, face.f_111355_, face.f_111356_, face.f_111357_, GsonHelper.m_13855_((JsonObject)object, (String)"fullbright", (boolean)false), object.has("fullbright"));
            }
        }
    }

    public static enum Loader implements IGeometryLoader<FullbrightModel>
    {
        INSTANCE;


        public FullbrightModel read(JsonObject model, JsonDeserializationContext context) {
            ArrayList list = Lists.newArrayList();
            if (model.has("elements")) {
                for (JsonElement jsonelement : GsonHelper.m_13933_((JsonObject)model, (String)"elements")) {
                    list.add((FullbrightBlockPart)((Object)GSON.fromJson(jsonelement, FullbrightBlockPart.class)));
                }
            }
            return new FullbrightModel(list);
        }
    }
}

