/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.chunk;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class SafeBlockGetter
implements BlockGetter {
    private final ServerLevel wrapped;
    private final Thread mainThread;

    public SafeBlockGetter(ServerLevel wrapped) {
        this.wrapped = wrapped;
        this.mainThread = Thread.currentThread();
    }

    public boolean shouldUse() {
        return Thread.currentThread() != this.mainThread;
    }

    @Nullable
    private BlockGetter getChunkSafe(BlockPos pos) {
        BlockGetter access = this.wrapped.m_7726_().m_6196_(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
        if (!(access instanceof ChunkAccess)) {
            return null;
        }
        ChunkAccess chunk = (ChunkAccess)access;
        if (!chunk.m_6415_().m_62427_(ChunkStatus.f_62326_)) {
            return null;
        }
        return chunk;
    }

    public int m_151558_() {
        return this.wrapped.m_151558_();
    }

    public int m_7469_() {
        return this.wrapped.m_7469_();
    }

    public int m_141937_() {
        return this.wrapped.m_141937_();
    }

    public int m_141928_() {
        return this.wrapped.m_141928_();
    }

    @Nullable
    public BlockEntity m_7702_(BlockPos pos) {
        BlockGetter g = this.getChunkSafe(pos);
        return g == null ? null : g.m_7702_(pos);
    }

    public BlockState m_8055_(BlockPos pos) {
        BlockGetter g = this.getChunkSafe(pos);
        return g == null ? Blocks.f_50016_.m_49966_() : g.m_8055_(pos);
    }

    public FluidState m_6425_(BlockPos pos) {
        BlockGetter g = this.getChunkSafe(pos);
        return g == null ? Fluids.f_76191_.m_76145_() : g.m_6425_(pos);
    }
}

