/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.animation;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.util.resource.MinecraftResourceUtils;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourcePackAnimationRenderer
implements IAnimationRenderer {
    private static final Logger LOGGER = LogManager.getLogger();
    protected String resourceNamespace;
    protected List<String> frameNames;
    protected int fps;
    protected boolean loop;
    protected int width;
    protected int height;
    protected int x;
    protected int y;
    public List<ResourceLocation> resources = new ArrayList<ResourceLocation>();
    protected boolean stretch = false;
    protected boolean hide = false;
    protected volatile boolean done = false;
    private int frame = 0;
    public long prevTime = 0L;
    protected float opacity = 1.0f;
    protected boolean ready = false;
    protected boolean sizeSet = false;

    public ResourcePackAnimationRenderer(@Nullable String resourceNamespace, List<String> frameNames, int fps, boolean loop, int posX, int posY, int width, int height) {
        this.fps = fps;
        this.loop = loop;
        this.x = posX;
        this.y = posY;
        this.width = width;
        this.height = height;
        this.resourceNamespace = resourceNamespace;
        this.frameNames = frameNames;
        this.loadAnimationFrames();
    }

    private void loadAnimationFrames() {
        try {
            for (String s : this.frameNames) {
                ResourceLocation r = this.resourceNamespace == null ? new ResourceLocation(s) : new ResourceLocation(this.resourceNamespace, s);
                this.resources.add(r);
            }
            this.ready = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void render(PoseStack matrix) {
        if (this.resources == null || this.resources.isEmpty()) {
            return;
        }
        if (this.fps < 0) {
            this.fps = -1;
        }
        if (this.frame > this.resources.size() - 1) {
            if (this.loop) {
                this.resetAnimation();
            } else {
                this.done = true;
                if (!this.hide) {
                    this.frame = this.resources.size() - 1;
                } else {
                    return;
                }
            }
        }
        this.renderFrame(matrix);
        long time = System.currentTimeMillis();
        if (this.fps == -1) {
            this.updateFrame(time);
        } else if (this.prevTime + (long)(1000 / this.fps) <= time) {
            this.updateFrame(time);
        }
    }

    protected void renderFrame(PoseStack matrix) {
        int h = this.height;
        int w = this.width;
        int x2 = this.x;
        int y2 = this.y;
        if (this.stretch && Minecraft.m_91087_().f_91080_ != null) {
            h = Minecraft.m_91087_().f_91080_.f_96544_;
            w = Minecraft.m_91087_().f_91080_.f_96543_;
            x2 = 0;
            y2 = 0;
        }
        RenderUtils.bindTexture((ResourceLocation)this.resources.get(this.frame));
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
        GuiComponent.m_93133_((PoseStack)matrix, (int)x2, (int)y2, (float)0.0f, (float)0.0f, (int)w, (int)h, (int)w, (int)h);
        RenderSystem.m_69461_();
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    public void updateFrame(long time) {
        ++this.frame;
        this.prevTime = time;
    }

    public void resetAnimation() {
        this.frame = 0;
        this.prevTime = 0L;
        this.done = false;
    }

    public void setStretchImageToScreensize(boolean b) {
        this.stretch = b;
    }

    public void setHideAfterLastFrame(boolean b) {
        this.hide = b;
    }

    public boolean isFinished() {
        return this.done;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int currentFrame() {
        return this.frame;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setPosX(int x) {
        this.x = x;
    }

    public void setPosY(int y) {
        this.y = y;
    }

    public int animationFrames() {
        return this.resources.size();
    }

    public List<ResourceLocation> getAnimationFrames() {
        return this.resources;
    }

    public String getPath() {
        return this.resourceNamespace;
    }

    public void setFPS(int fps) {
        this.fps = fps;
    }

    public int getFPS() {
        return this.fps;
    }

    public void setLooped(boolean b) {
        this.loop = b;
    }

    public void prepareAnimation() {
    }

    public boolean isGettingLooped() {
        return this.loop;
    }

    public boolean isStretchedToStreensize() {
        return this.stretch;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPosX() {
        return this.x;
    }

    public int getPosY() {
        return this.y;
    }

    public boolean setupAnimationSize() {
        if (this.sizeSet) {
            return true;
        }
        try {
            ResourceLocation r;
            List<ResourceLocation> l = this.getAnimationFrames();
            if (!l.isEmpty() && (r = l.get(0)) != null) {
                NativeImage i = NativeImage.m_85058_((InputStream)MinecraftResourceUtils.open(r));
                this.width = i.m_84982_();
                this.height = i.m_85084_();
                this.sizeSet = true;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOGGER.error("[FANCYMENU] Failed to update width and height for resource pack animation: " + this.resourceNamespace);
        return false;
    }
}

