/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.background.backgrounds.image;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.customization.background.MenuBackground;
import de.keksuccino.fancymenu.customization.background.MenuBackgroundBuilder;
import de.keksuccino.fancymenu.util.rendering.AspectRatio;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.konkrete.rendering.RenderUtils;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ImageMenuBackground
extends MenuBackground {
    private static final DrawableColor BACKGROUND_COLOR = DrawableColor.BLACK;
    public ResourceSupplier<ITexture> textureSupplier;
    public ResourceSupplier<ITexture> fallbackTextureSupplier;
    public boolean slideLeftRight = false;
    public boolean repeat = false;
    protected double slidePos = 0.0;
    protected boolean slideMoveBack = false;
    protected boolean slideStop = false;
    protected int slideTick = 0;

    public ImageMenuBackground(MenuBackgroundBuilder<ImageMenuBackground> builder) {
        super(builder);
    }

    @Override
    public void m_6305_(@NotNull PoseStack pose, int mouseX, int mouseY, float partial) {
        ITexture fallback;
        ITexture background;
        RenderSystem.m_69478_();
        ImageMenuBackground.m_93172_((PoseStack)pose, (int)0, (int)0, (int)ImageMenuBackground.getScreenWidth(), (int)ImageMenuBackground.getScreenHeight(), (int)BACKGROUND_COLOR.getColorIntWithAlpha(this.opacity));
        RenderingUtils.resetShaderColor();
        ResourceLocation resourceLocation = null;
        ITexture tex = null;
        AspectRatio ratio = new AspectRatio(10, 10);
        if (this.textureSupplier != null && (background = this.textureSupplier.get()) != null) {
            tex = background;
            ratio = background.getAspectRatio();
            resourceLocation = background.getResourceLocation();
        }
        if (resourceLocation == null && this.fallbackTextureSupplier != null && (fallback = this.fallbackTextureSupplier.get()) != null) {
            tex = fallback;
            ratio = fallback.getAspectRatio();
            resourceLocation = fallback.getResourceLocation();
        }
        if (resourceLocation != null) {
            RenderSystem.m_69478_();
            RenderUtils.bindTexture(resourceLocation);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
            if (this.repeat) {
                RenderingUtils.blitRepeat(pose, 0, 0, ImageMenuBackground.getScreenWidth(), ImageMenuBackground.getScreenHeight(), tex.getWidth(), tex.getHeight());
            } else if (this.slideLeftRight) {
                int w = ratio.getAspectRatioWidth(ImageMenuBackground.getScreenHeight());
                if (this.slidePos + (double)(w - ImageMenuBackground.getScreenWidth()) <= 0.0) {
                    this.slideMoveBack = true;
                }
                if (this.slidePos >= 0.0) {
                    this.slideMoveBack = false;
                }
                if (this.slidePos + (double)(w - ImageMenuBackground.getScreenWidth()) < 0.0) {
                    this.slidePos = -(w - ImageMenuBackground.getScreenWidth());
                }
                if (this.slidePos > 0.0) {
                    this.slidePos = 0.0;
                }
                if (!this.slideStop) {
                    if (this.slideTick >= 1) {
                        this.slideTick = 0;
                        this.slidePos = this.slideMoveBack ? (this.slidePos += 0.5) : (this.slidePos -= 0.5);
                        if (this.slidePos + (double)(w - ImageMenuBackground.getScreenWidth()) == 0.0) {
                            this.slideStop = true;
                        }
                        if (this.slidePos == 0.0) {
                            this.slideStop = true;
                        }
                    } else {
                        ++this.slideTick;
                    }
                } else if (this.slideTick >= 300) {
                    this.slideStop = false;
                    this.slideTick = 0;
                } else {
                    ++this.slideTick;
                }
                if (w <= ImageMenuBackground.getScreenWidth()) {
                    if (this.keepBackgroundAspectRatio) {
                        this.renderKeepAspectRatio(pose, ratio, resourceLocation);
                    } else {
                        RenderingUtils.bindTexture(resourceLocation);
                        ImageMenuBackground.m_93133_((PoseStack)pose, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)ImageMenuBackground.getScreenWidth(), (int)ImageMenuBackground.getScreenHeight(), (int)ImageMenuBackground.getScreenWidth(), (int)ImageMenuBackground.getScreenHeight());
                    }
                } else {
                    RenderingUtils.bindTexture(resourceLocation);
                    RenderingUtils.blitF(pose, (float)this.slidePos, 0.0f, 0.0f, 0.0f, w, ImageMenuBackground.getScreenHeight(), w, ImageMenuBackground.getScreenHeight());
                }
            } else if (this.keepBackgroundAspectRatio) {
                this.renderKeepAspectRatio(pose, ratio, resourceLocation);
            } else {
                RenderingUtils.bindTexture(resourceLocation);
                ImageMenuBackground.m_93133_((PoseStack)pose, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)ImageMenuBackground.getScreenWidth(), (int)ImageMenuBackground.getScreenHeight(), (int)ImageMenuBackground.getScreenWidth(), (int)ImageMenuBackground.getScreenHeight());
            }
        }
        RenderingUtils.resetShaderColor();
    }

    protected void renderKeepAspectRatio(@NotNull PoseStack graphics, @NotNull AspectRatio ratio, @NotNull ResourceLocation resourceLocation) {
        int[] size = ratio.getAspectRatioSizeByMinimumSize(ImageMenuBackground.getScreenWidth(), ImageMenuBackground.getScreenHeight());
        int x = 0;
        if (size[0] > ImageMenuBackground.getScreenWidth()) {
            x = -((size[0] - ImageMenuBackground.getScreenWidth()) / 2);
        }
        int y = 0;
        if (size[1] > ImageMenuBackground.getScreenHeight()) {
            y = -((size[1] - ImageMenuBackground.getScreenHeight()) / 2);
        }
        RenderingUtils.bindTexture(resourceLocation);
        ImageMenuBackground.m_93133_((PoseStack)graphics, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)size[0], (int)size[1], (int)size[0], (int)size[1]);
    }
}

