/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.slider.v2;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.customization.action.blocks.GenericExecutableBlock;
import de.keksuccino.fancymenu.customization.animation.AdvancedAnimation;
import de.keksuccino.fancymenu.customization.animation.AnimationHandler;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.ExecutableElement;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinAbstractWidget;
import de.keksuccino.fancymenu.util.enums.LocalizedCycleEnum;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.TooltipHandler;
import de.keksuccino.fancymenu.util.rendering.ui.widget.CustomizableSlider;
import de.keksuccino.fancymenu.util.rendering.ui.widget.CustomizableWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.slider.v2.AbstractExtendedSlider;
import de.keksuccino.fancymenu.util.rendering.ui.widget.slider.v2.ListSlider;
import de.keksuccino.fancymenu.util.rendering.ui.widget.slider.v2.RangeSlider;
import de.keksuccino.fancymenu.util.resource.RenderableResource;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SliderElement
extends AbstractElement
implements ExecutableElement {
    public static final String VALUE_PLACEHOLDER = "$$value";
    public AbstractExtendedSlider slider;
    @NotNull
    public SliderType type = SliderType.INTEGER_RANGE;
    @Nullable
    public String preSelectedValue;
    @NotNull
    public List<String> listValues = new ArrayList<String>();
    public double minRangeValue = 1.0;
    public double maxRangeValue = 10.0;
    public int roundingDecimalPlace = 2;
    @Nullable
    public String label;
    public String tooltip;
    public ResourceSupplier<ITexture> handleTextureNormal;
    public ResourceSupplier<ITexture> handleTextureHover;
    public ResourceSupplier<ITexture> handleTextureInactive;
    public String handleAnimationNormal;
    public String handleAnimationHover;
    public String handleAnimationInactive;
    public ResourceSupplier<ITexture> sliderBackgroundTextureNormal;
    public ResourceSupplier<ITexture> sliderBackgroundTextureHighlighted;
    public String sliderBackgroundAnimationNormal;
    public String sliderBackgroundAnimationHighlighted;
    public boolean loopBackgroundAnimations = true;
    public boolean restartBackgroundAnimationsOnHover = true;
    public boolean nineSliceCustomBackground = false;
    public int nineSliceBorderX = 5;
    public int nineSliceBorderY = 5;
    public boolean nineSliceSliderHandle = false;
    public int nineSliceSliderHandleBorderX = 5;
    public int nineSliceSliderHandleBorderY = 5;
    public boolean navigatable = true;
    @NotNull
    public GenericExecutableBlock executableBlock = new GenericExecutableBlock();

    public SliderElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
        this.buildSlider();
        this.prepareExecutableBlock();
    }

    public void prepareExecutableBlock() {
        this.executableBlock.addValuePlaceholder("value", () -> this.slider != null ? this.slider.getValueDisplayText() : "");
    }

    public void prepareLoadingRequirementContainer() {
        this.loadingRequirementContainer.addValuePlaceholder("value", () -> this.slider != null ? this.slider.getValueDisplayText() : "");
    }

    public void buildSlider() {
        String preSelectedString;
        String string = preSelectedString = this.preSelectedValue != null ? PlaceholderParser.replacePlaceholders(this.preSelectedValue) : null;
        if (this.type == SliderType.INTEGER_RANGE) {
            int min = (int)this.minRangeValue;
            int max = (int)this.maxRangeValue;
            int preSelected = min;
            if (preSelectedString != null && MathUtils.isDouble((String)preSelectedString)) {
                preSelected = (int)Double.parseDouble(preSelectedString);
            }
            this.slider = new RangeSlider(this.getAbsoluteX(), this.getAbsoluteY(), this.getAbsoluteWidth(), this.getAbsoluteHeight(), (Component)Component.m_237119_(), min, max, preSelected);
            ((RangeSlider)this.slider).setShowAsInteger(true);
        }
        if (this.type == SliderType.DECIMAL_RANGE) {
            double preSelected = this.minRangeValue;
            if (preSelectedString != null && MathUtils.isDouble((String)preSelectedString)) {
                preSelected = Double.parseDouble(preSelectedString);
            }
            this.slider = new RangeSlider(this.getAbsoluteX(), this.getAbsoluteY(), this.getAbsoluteWidth(), this.getAbsoluteHeight(), (Component)Component.m_237119_(), this.minRangeValue, this.maxRangeValue, preSelected);
            ((RangeSlider)this.slider).setRoundingDecimalPlace(this.roundingDecimalPlace);
        }
        if (this.type == SliderType.LIST) {
            int preSelectedIndex;
            if (this.listValues.isEmpty()) {
                this.listValues.addAll(List.of("placeholder_1", "placeholder_2"));
            }
            if (this.listValues.size() < 2) {
                this.listValues.add("placeholder_1");
            }
            int n = preSelectedIndex = preSelectedString != null ? this.listValues.indexOf(preSelectedString) : 0;
            if (preSelectedIndex < 0) {
                preSelectedIndex = 0;
            }
            this.slider = new ListSlider<String>(this.getAbsoluteX(), this.getAbsoluteY(), this.getAbsoluteWidth(), this.getAbsoluteHeight(), (Component)Component.m_237119_(), this.listValues, preSelectedIndex);
        }
        if (this.slider != null) {
            this.slider.setLabelSupplier(this::getSliderLabel);
            this.slider.setSliderValueUpdateListener((slider1, valueDisplayText, value) -> this.onChangeSliderValue());
        }
    }

    @NotNull
    protected Component getSliderLabel(@NotNull AbstractExtendedSlider slider) {
        String labelValueReplaced = this.label != null ? this.label.replace(VALUE_PLACEHOLDER, slider.getValueDisplayText()) : "";
        return SliderElement.buildComponent(labelValueReplaced);
    }

    protected void onChangeSliderValue() {
        this.executableBlock.execute();
    }

    @Override
    @Nullable
    public List<GuiEventListener> getWidgetsToRegister() {
        return !SliderElement.isEditor() ? List.of(this.slider) : null;
    }

    @Override
    public void m_6305_(@NotNull PoseStack graphics, int mouseX, int mouseY, float partial) {
        if (this.slider == null) {
            return;
        }
        this.slider.setNavigatable(this.navigatable);
        this.slider.f_93624_ = this.shouldRender();
        this.slider.m_93650_(this.opacity);
        if (!this.shouldRender()) {
            return;
        }
        this.slider.f_93620_ = this.getAbsoluteX();
        this.slider.f_93621_ = this.getAbsoluteY();
        this.slider.m_93674_(this.getAbsoluteWidth());
        ((IMixinAbstractWidget)((Object)this.slider)).setHeightFancyMenu(this.getAbsoluteHeight());
        this.updateWidget();
        this.slider.m_6305_(graphics, mouseX, mouseY, partial);
    }

    public void updateWidget() {
        if (this.slider == null) {
            return;
        }
        this.updateWidgetTooltip();
        this.updateWidgetTexture();
        this.slider.m_5695_();
    }

    public void updateWidgetTooltip() {
        if (this.tooltip != null && this.slider != null && ((IMixinAbstractWidget)((Object)this.slider)).getIsHoveredFancyMenu() && this.slider.f_93624_ && this.shouldRender() && !SliderElement.isEditor()) {
            String tooltip = this.tooltip.replace("%n%", "\n");
            TooltipHandler.INSTANCE.addWidgetTooltip((AbstractWidget)this.slider, Tooltip.of(StringUtils.splitLines((String)PlaceholderParser.replacePlaceholders(tooltip), (String)"\n")), false, true);
        }
    }

    public void updateWidgetTexture() {
        Object a;
        IAnimationRenderer r;
        Object a2;
        IAnimationRenderer r2;
        Object sliderBackNormal = null;
        Object sliderBackHighlighted = null;
        if (this.sliderBackgroundAnimationNormal != null && AnimationHandler.animationExists(this.sliderBackgroundAnimationNormal) && (r2 = AnimationHandler.getAnimation(this.sliderBackgroundAnimationNormal)) instanceof AdvancedAnimation) {
            a2 = (AdvancedAnimation)r2;
            ((AdvancedAnimation)a2).setLooped(this.loopBackgroundAnimations);
            sliderBackNormal = a2;
        }
        if (sliderBackNormal == null && this.sliderBackgroundTextureNormal != null) {
            sliderBackNormal = this.sliderBackgroundTextureNormal.get();
        }
        if (this.sliderBackgroundAnimationHighlighted != null && AnimationHandler.animationExists(this.sliderBackgroundAnimationHighlighted) && (r2 = AnimationHandler.getAnimation(this.sliderBackgroundAnimationHighlighted)) instanceof AdvancedAnimation) {
            a2 = (AdvancedAnimation)r2;
            ((AdvancedAnimation)a2).setLooped(this.loopBackgroundAnimations);
            sliderBackHighlighted = a2;
        }
        if (sliderBackHighlighted == null && this.sliderBackgroundTextureHighlighted != null) {
            sliderBackHighlighted = this.sliderBackgroundTextureHighlighted.get();
        }
        if ((a2 = this.slider) instanceof CustomizableSlider) {
            CustomizableSlider w = (CustomizableSlider)a2;
            w.setCustomSliderBackgroundNormalFancyMenu((RenderableResource)sliderBackNormal);
            w.setCustomSliderBackgroundHighlightedFancyMenu((RenderableResource)sliderBackHighlighted);
        }
        Object handleTextureNormal = null;
        Object handleTextureHover = null;
        Object handleTextureInactive = null;
        if (this.handleAnimationNormal != null && AnimationHandler.animationExists(this.handleAnimationNormal) && (r = AnimationHandler.getAnimation(this.handleAnimationNormal)) instanceof AdvancedAnimation) {
            a = (AdvancedAnimation)r;
            ((AdvancedAnimation)a).setLooped(this.loopBackgroundAnimations);
            handleTextureNormal = a;
        }
        if (handleTextureNormal == null && this.handleTextureNormal != null) {
            handleTextureNormal = this.handleTextureNormal.get();
        }
        if (this.handleAnimationHover != null && AnimationHandler.animationExists(this.handleAnimationHover) && (r = AnimationHandler.getAnimation(this.handleAnimationHover)) instanceof AdvancedAnimation) {
            a = (AdvancedAnimation)r;
            ((AdvancedAnimation)a).setLooped(this.loopBackgroundAnimations);
            handleTextureHover = a;
        }
        if (handleTextureHover == null && this.handleTextureHover != null) {
            handleTextureHover = this.handleTextureHover.get();
        }
        if (this.handleAnimationInactive != null && AnimationHandler.animationExists(this.handleAnimationInactive) && (r = AnimationHandler.getAnimation(this.handleAnimationInactive)) instanceof AdvancedAnimation) {
            a = (AdvancedAnimation)r;
            ((AdvancedAnimation)a).setLooped(this.loopBackgroundAnimations);
            handleTextureInactive = a;
        }
        if (handleTextureInactive == null && this.handleTextureInactive != null) {
            handleTextureInactive = this.handleTextureInactive.get();
        }
        if ((a = this.slider) instanceof CustomizableWidget) {
            CustomizableWidget w = (CustomizableWidget)a;
            AbstractExtendedSlider abstractExtendedSlider = this.slider;
            if (abstractExtendedSlider instanceof CustomizableSlider) {
                CustomizableSlider s = (CustomizableSlider)((Object)abstractExtendedSlider);
                s.setNineSliceCustomSliderBackground_FancyMenu(this.nineSliceCustomBackground);
                s.setNineSliceSliderBackgroundBorderX_FancyMenu(this.nineSliceBorderX);
                s.setNineSliceSliderBackgroundBorderY_FancyMenu(this.nineSliceBorderY);
                s.setNineSliceCustomSliderHandle_FancyMenu(this.nineSliceSliderHandle);
                s.setNineSliceSliderHandleBorderX_FancyMenu(this.nineSliceSliderHandleBorderX);
                s.setNineSliceSliderHandleBorderY_FancyMenu(this.nineSliceSliderHandleBorderY);
            }
            w.setCustomBackgroundNormalFancyMenu((RenderableResource)handleTextureNormal);
            w.setCustomBackgroundHoverFancyMenu((RenderableResource)handleTextureHover);
            w.setCustomBackgroundInactiveFancyMenu((RenderableResource)handleTextureInactive);
            w.setCustomBackgroundResetBehaviorFancyMenu(this.restartBackgroundAnimationsOnHover ? CustomizableWidget.CustomBackgroundResetBehavior.RESET_ON_HOVER : CustomizableWidget.CustomBackgroundResetBehavior.RESET_NEVER);
        }
    }

    @Override
    @NotNull
    public GenericExecutableBlock getExecutableBlock() {
        return this.executableBlock;
    }

    public static enum SliderType implements LocalizedCycleEnum<SliderType>
    {
        LIST("list"),
        INTEGER_RANGE("integer_range"),
        DECIMAL_RANGE("decimal_range");

        final String name;

        private SliderType(String name) {
            this.name = name;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public SliderType[] getValues() {
            return SliderType.values();
        }

        @Override
        @Nullable
        public SliderType getByNameInternal(@NotNull String name) {
            return SliderType.getByName(name);
        }

        @Nullable
        public static SliderType getByName(@NotNull String name) {
            for (SliderType i : SliderType.values()) {
                if (!i.getName().equals(name)) continue;
                return i;
            }
            return null;
        }

        @Override
        @NotNull
        public String getLocalizationKeyBase() {
            return "fancymenu.elements.slider.v2.type";
        }
    }
}

