/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.customization.layout.Layout;
import de.keksuccino.fancymenu.customization.layout.LayoutHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.cycle.ValueCycle;
import de.keksuccino.fancymenu.util.enums.LocalizedCycleEnum;
import de.keksuccino.fancymenu.util.file.FileUtils;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManageLayoutsScreen
extends Screen {
    protected Consumer<List<Layout>> callback;
    protected List<Layout> layouts;
    @Nullable
    protected Screen layoutTargetScreen;
    protected ValueCycle<Sorting> sortBy = ValueCycle.fromArray(Sorting.LAST_EDITED, Sorting.NAME, Sorting.STATUS);
    protected ScrollArea layoutListScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ExtendedButton sortingButton;
    protected ExtendedButton doneButton;
    protected ExtendedButton editButton;
    protected ExtendedButton deleteButton;
    protected ExtendedButton openInTextEditorButton;
    protected ExtendedButton toggleStatusButton;

    public ManageLayoutsScreen(@NotNull List<Layout> layouts, @Nullable Screen layoutTargetScreen, @NotNull Consumer<List<Layout>> callback) {
        super((Component)Components.translatable("fancymenu.layout.manage", new Object[0]));
        this.layouts = layouts;
        this.layoutTargetScreen = layoutTargetScreen;
        this.callback = callback;
        this.updateLayoutScrollArea();
    }

    protected void m_7856_() {
        super.m_7856_();
        Objects.requireNonNull(this.f_96547_);
        this.sortingButton = new ExtendedButton(0, 0, 150, 9 + 4, (Component)Components.literal(""), button -> {
            this.sortBy.next();
            this.updateLayoutScrollArea();
        }).setLabelSupplier(consumes -> this.sortBy.current().getCycleComponent());
        this.m_7787_((GuiEventListener)this.sortingButton);
        UIBase.applyDefaultWidgetSkinTo(this.sortingButton);
        this.doneButton = new ExtendedButton(0, 0, 150, 20, (Component)Components.translatable("fancymenu.guicomponents.done", new Object[0]), button -> this.callback.accept(this.layouts));
        this.m_7787_((GuiEventListener)this.doneButton);
        UIBase.applyDefaultWidgetSkinTo(this.doneButton);
        this.editButton = new ExtendedButton(0, 0, 150, 20, (Component)Components.translatable("fancymenu.layout.manage.edit", new Object[0]), button -> {
            LayoutScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                LayoutHandler.openLayoutEditor(e.layout, e.layout.isUniversalLayout() ? null : this.layoutTargetScreen);
            }
        }).setIsActiveSupplier(consumes -> this.getSelectedEntry() != null);
        this.m_7787_((GuiEventListener)this.editButton);
        UIBase.applyDefaultWidgetSkinTo(this.editButton);
        this.deleteButton = new ExtendedButton(0, 0, 150, 20, (Component)Components.translatable("fancymenu.layout.manage.delete", new Object[0]), button -> {
            LayoutScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                Minecraft.m_91087_().m_91152_((Screen)ConfirmationScreen.ofStrings(call -> {
                    if (call.booleanValue()) {
                        e.layout.delete(false);
                        this.layouts.remove(e.layout);
                        this.updateLayoutScrollArea();
                    }
                    Minecraft.m_91087_().m_91152_((Screen)this);
                }, LocalizationUtils.splitLocalizedStringLines("fancymenu.layout.manage.delete.confirm", new String[0])));
            }
        }).setIsActiveSupplier(consumes -> this.getSelectedEntry() != null);
        this.m_7787_((GuiEventListener)this.deleteButton);
        UIBase.applyDefaultWidgetSkinTo(this.deleteButton);
        this.openInTextEditorButton = new ExtendedButton(0, 0, 150, 20, (Component)Components.translatable("fancymenu.layout.manage.open_in_text_editor", new Object[0]), button -> {
            LayoutScrollEntry e = this.getSelectedEntry();
            if (e != null && e.layout.layoutFile != null) {
                FileUtils.openFile(e.layout.layoutFile);
            }
        }).setIsActiveSupplier(consumes -> this.getSelectedEntry() != null);
        this.m_7787_((GuiEventListener)this.openInTextEditorButton);
        UIBase.applyDefaultWidgetSkinTo(this.openInTextEditorButton);
        this.toggleStatusButton = new ExtendedButton(0, 0, 150, 20, (Component)Components.literal(""), button -> {
            LayoutScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                e.layout.setEnabled(!e.layout.isEnabled(), false);
                e.updateName();
            }
        }).setIsActiveSupplier(consumes -> this.getSelectedEntry() != null).setLabelSupplier(consumes -> {
            LayoutScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                return e.layout.getStatus().getCycleComponent();
            }
            return Layout.LayoutStatus.DISABLED.getCycleComponent();
        });
        this.m_7787_((GuiEventListener)this.toggleStatusButton);
        UIBase.applyDefaultWidgetSkinTo(this.toggleStatusButton);
    }

    public void m_7379_() {
        this.callback.accept(this.layouts);
    }

    public void m_6305_(@NotNull PoseStack pose, int mouseX, int mouseY, float partial) {
        RenderSystem.m_69478_();
        ManageLayoutsScreen.m_93172_((PoseStack)pose, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (int)UIBase.getUIColorTheme().screen_background_color.getColorInt());
        MutableComponent titleComp = this.f_96539_.m_6881_().m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        this.f_96547_.m_92889_(pose, (Component)titleComp, 20.0f, 20.0f, UIBase.getUIColorTheme().generic_text_base_color.getColorInt());
        this.f_96547_.m_92889_(pose, (Component)Components.translatable("fancymenu.layout.manage.layouts", new Object[0]), 20.0f, 50.0f, UIBase.getUIColorTheme().generic_text_base_color.getColorInt());
        this.layoutListScrollArea.setWidth(this.f_96543_ / 2 - 40, true);
        this.layoutListScrollArea.setHeight(this.f_96544_ - 85, true);
        this.layoutListScrollArea.setX(20, true);
        this.layoutListScrollArea.setY(65, true);
        this.layoutListScrollArea.render(pose, mouseX, mouseY, partial);
        this.sortingButton.m_93674_(this.f_96547_.m_92852_((FormattedText)this.sortingButton.m_6035_()) + 10);
        this.sortingButton.f_93620_ = this.layoutListScrollArea.getXWithBorder() + this.layoutListScrollArea.getWidthWithBorder() - this.sortingButton.m_5711_();
        this.sortingButton.f_93621_ = this.layoutListScrollArea.getYWithBorder() - 5 - this.sortingButton.m_93694_();
        this.sortingButton.m_6305_(pose, mouseX, mouseY, partial);
        this.doneButton.f_93620_ = this.f_96543_ - 20 - this.doneButton.m_5711_();
        this.doneButton.f_93621_ = this.f_96544_ - 20 - 20;
        this.doneButton.m_6305_(pose, mouseX, mouseY, partial);
        this.openInTextEditorButton.f_93620_ = this.f_96543_ - 20 - this.openInTextEditorButton.m_5711_();
        this.openInTextEditorButton.f_93621_ = this.doneButton.f_93621_ - 15 - 20;
        this.openInTextEditorButton.m_6305_(pose, mouseX, mouseY, partial);
        this.deleteButton.f_93620_ = this.f_96543_ - 20 - this.deleteButton.m_5711_();
        this.deleteButton.f_93621_ = this.openInTextEditorButton.f_93621_ - 5 - 20;
        this.deleteButton.m_6305_(pose, mouseX, mouseY, partial);
        this.editButton.f_93620_ = this.f_96543_ - 20 - this.editButton.m_5711_();
        this.editButton.f_93621_ = this.deleteButton.f_93621_ - 5 - 20;
        this.editButton.m_6305_(pose, mouseX, mouseY, partial);
        this.toggleStatusButton.f_93620_ = this.f_96543_ - 20 - this.toggleStatusButton.m_5711_();
        this.toggleStatusButton.f_93621_ = this.editButton.f_93621_ - 5 - 20;
        this.toggleStatusButton.m_6305_(pose, mouseX, mouseY, partial);
        super.m_6305_(pose, mouseX, mouseY, partial);
    }

    @Nullable
    protected LayoutScrollEntry getSelectedEntry() {
        for (ScrollAreaEntry e : this.layoutListScrollArea.getEntries()) {
            LayoutScrollEntry s;
            if (!(e instanceof LayoutScrollEntry) || !(s = (LayoutScrollEntry)e).isSelected()) continue;
            return s;
        }
        return null;
    }

    protected void updateLayoutScrollArea() {
        this.layoutListScrollArea.clearEntries();
        if (this.sortBy.current() == Sorting.STATUS) {
            LayoutHandler.sortLayoutListByStatus(this.layouts, false);
        } else if (this.sortBy.current() == Sorting.NAME) {
            LayoutHandler.sortLayoutListByName(this.layouts);
        } else if (this.sortBy.current() == Sorting.LAST_EDITED) {
            LayoutHandler.sortLayoutListByLastEdited(this.layouts, false);
        }
        for (Layout l : this.layouts) {
            LayoutScrollEntry e = new LayoutScrollEntry(this.layoutListScrollArea, l, entry -> {});
            this.layoutListScrollArea.addEntry(e);
        }
        if (this.layoutListScrollArea.getEntries().isEmpty()) {
            this.layoutListScrollArea.addEntry(new TextScrollAreaEntry(this.layoutListScrollArea, (Component)Components.translatable("fancymenu.layout.manage.no_layouts_found", new Object[0]).m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().error_text_color.getColorInt())), entry -> {}));
        }
    }

    protected static enum Sorting implements LocalizedCycleEnum<Sorting>
    {
        NAME("name"),
        LAST_EDITED("last_edited"),
        STATUS("status");

        final String name;

        private Sorting(String name) {
            this.name = name;
        }

        @Override
        @NotNull
        public String getLocalizationKeyBase() {
            return "fancymenu.layout.manage.layouts.sort_by";
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public Sorting[] getValues() {
            return Sorting.values();
        }

        @Override
        @Nullable
        public Sorting getByNameInternal(@NotNull String name) {
            return Sorting.getByName(name);
        }

        @Nullable
        public static Sorting getByName(@NotNull String name) {
            for (Sorting e : Sorting.values()) {
                if (!e.getName().equals(name)) continue;
                return e;
            }
            return null;
        }
    }

    public static class LayoutScrollEntry
    extends TextListScrollAreaEntry {
        public Layout layout;

        public LayoutScrollEntry(ScrollArea parent, @NotNull Layout layout, @NotNull Consumer<TextListScrollAreaEntry> onClick) {
            super(parent, (Component)Components.literal(""), UIBase.getUIColorTheme().listing_dot_color_1.getColor(), onClick);
            this.layout = layout;
            this.updateName();
        }

        protected void updateName() {
            Style style = this.layout.getStatus().getValueComponentStyle();
            MutableComponent c = Components.literal(this.layout.getLayoutName()).m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().description_area_text_color.getColorInt()));
            c.m_7220_((Component)Components.literal(" (").m_6270_(style));
            c.m_7220_((Component)this.layout.getStatus().getValueComponent());
            c.m_7220_((Component)Components.literal(")").m_6270_(style));
            this.setText((Component)c);
        }
    }
}

