/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.customization.animation.AdvancedAnimation;
import de.keksuccino.fancymenu.customization.animation.AnimationHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.AspectRatio;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.TooltipHandler;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseAnimationScreen
extends Screen {
    protected Consumer<String> callback;
    protected String selectedAnimationName = null;
    protected IAnimationRenderer selectedAnimation = null;
    protected ScrollArea animationListScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ExtendedButton doneButton;
    protected ExtendedButton cancelButton;

    public ChooseAnimationScreen(@Nullable String preSelectedAnimation, @NotNull Consumer<String> callback) {
        super((Component)Components.translatable("fancymenu.animation.choose", new Object[0]));
        this.callback = callback;
        this.updateAnimationScrollAreaContent();
        if (preSelectedAnimation != null) {
            for (ScrollAreaEntry e : this.animationListScrollArea.getEntries()) {
                if (!(e instanceof AnimationScrollEntry)) continue;
                AnimationScrollEntry a = (AnimationScrollEntry)e;
                if (!a.animation.equals(preSelectedAnimation)) continue;
                a.setSelected(true);
                this.setSelectedAnimation(a);
                break;
            }
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.doneButton = new ExtendedButton(0, 0, 150, 20, (Component)Components.translatable("fancymenu.guicomponents.done", new Object[0]), button -> this.callback.accept(this.selectedAnimationName)){

            @Override
            public void m_6303_(@NotNull PoseStack pose, int mouseX, int mouseY, float partial) {
                if (ChooseAnimationScreen.this.selectedAnimationName == null) {
                    TooltipHandler.INSTANCE.addWidgetTooltip((AbstractWidget)this, Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.animation.choose.no_animation_selected", new String[0])).setDefaultStyle(), false, true);
                    this.f_93623_ = false;
                } else {
                    this.f_93623_ = true;
                }
                super.m_6303_(pose, mouseX, mouseY, partial);
            }
        };
        this.m_7787_((GuiEventListener)this.doneButton);
        UIBase.applyDefaultWidgetSkinTo(this.doneButton);
        this.cancelButton = new ExtendedButton(0, 0, 150, 20, (Component)Components.translatable("fancymenu.guicomponents.cancel", new Object[0]), button -> this.callback.accept(null));
        this.m_7787_((GuiEventListener)this.cancelButton);
        UIBase.applyDefaultWidgetSkinTo(this.cancelButton);
    }

    public void m_7379_() {
        this.callback.accept(null);
    }

    public void m_6305_(@NotNull PoseStack pose, int mouseX, int mouseY, float partial) {
        RenderSystem.m_69478_();
        ChooseAnimationScreen.m_93172_((PoseStack)pose, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (int)UIBase.getUIColorTheme().screen_background_color.getColorInt());
        MutableComponent titleComp = this.f_96539_.m_6881_().m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        this.f_96547_.m_92889_(pose, (Component)titleComp, 20.0f, 20.0f, UIBase.getUIColorTheme().generic_text_base_color.getColorInt());
        this.f_96547_.m_92889_(pose, (Component)Components.translatable("fancymenu.animation.choose.available_animations", new Object[0]), 20.0f, 50.0f, UIBase.getUIColorTheme().generic_text_base_color.getColorInt());
        this.animationListScrollArea.setWidth(this.f_96543_ / 2 - 40, true);
        this.animationListScrollArea.setHeight(this.f_96544_ - 85, true);
        this.animationListScrollArea.setX(20, true);
        this.animationListScrollArea.setY(65, true);
        this.animationListScrollArea.render(pose, mouseX, mouseY, partial);
        MutableComponent previewLabel = Components.translatable("fancymenu.animation.choose.preview", new Object[0]);
        int previewLabelWidth = this.f_96547_.m_92852_((FormattedText)previewLabel);
        this.f_96547_.m_92889_(pose, (Component)previewLabel, (float)(this.f_96543_ - 20 - previewLabelWidth), 50.0f, UIBase.getUIColorTheme().generic_text_base_color.getColorInt());
        if (this.selectedAnimation != null) {
            int aniW = this.f_96543_ / 2 - 40;
            int aniH = this.f_96544_ / 2;
            AspectRatio ratio = new AspectRatio(this.selectedAnimation.getWidth(), this.selectedAnimation.getHeight());
            int[] size = ratio.getAspectRatioSizeByMaximumSize(aniW, aniH);
            aniW = size[0];
            aniH = size[1];
            int aniX = this.f_96543_ - 20 - aniW;
            int aniY = 65;
            boolean cachedLooped = this.selectedAnimation.isGettingLooped();
            ChooseAnimationScreen.m_93172_((PoseStack)pose, (int)aniX, (int)aniY, (int)(aniX + aniW), (int)(aniY + aniH), (int)UIBase.getUIColorTheme().area_background_color.getColorInt());
            this.selectedAnimation.setLooped(false);
            this.selectedAnimation.setPosX(aniX);
            this.selectedAnimation.setPosY(aniY);
            this.selectedAnimation.setWidth(aniW);
            this.selectedAnimation.setHeight(aniH);
            this.selectedAnimation.render(pose);
            this.selectedAnimation.setLooped(cachedLooped);
            UIBase.renderBorder(pose, aniX, aniY, aniX + aniW, aniY + aniH, 1, UIBase.getUIColorTheme().element_border_color_normal.getColor(), true, true, true, true);
        }
        this.doneButton.f_93620_ = this.f_96543_ - 20 - this.doneButton.m_5711_();
        this.doneButton.f_93621_ = this.f_96544_ - 20 - 20;
        this.doneButton.m_6305_(pose, mouseX, mouseY, partial);
        this.cancelButton.f_93620_ = this.f_96543_ - 20 - this.cancelButton.m_5711_();
        this.cancelButton.f_93621_ = this.doneButton.f_93621_ - 5 - 20;
        this.cancelButton.m_6305_(pose, mouseX, mouseY, partial);
        super.m_6305_(pose, mouseX, mouseY, partial);
    }

    protected void setSelectedAnimation(@Nullable AnimationScrollEntry entry) {
        if (this.selectedAnimation != null) {
            this.selectedAnimation.resetAnimation();
            if (this.selectedAnimation instanceof AdvancedAnimation) {
                ((AdvancedAnimation)this.selectedAnimation).stopAudio();
                ((AdvancedAnimation)this.selectedAnimation).resetAudio();
            }
        }
        if (entry == null) {
            this.selectedAnimation = null;
            this.selectedAnimationName = null;
            return;
        }
        this.selectedAnimationName = entry.animation;
        this.selectedAnimation = AnimationHandler.getAnimation(entry.animation);
        if (this.selectedAnimation != null) {
            this.selectedAnimation.resetAnimation();
            if (this.selectedAnimation instanceof AdvancedAnimation) {
                ((AdvancedAnimation)this.selectedAnimation).stopAudio();
                ((AdvancedAnimation)this.selectedAnimation).resetAudio();
            }
        }
    }

    protected void updateAnimationScrollAreaContent() {
        this.animationListScrollArea.clearEntries();
        for (String s : AnimationHandler.getExternalAnimationNames()) {
            ScrollAreaEntry e = new AnimationScrollEntry(this.animationListScrollArea, s, entry -> this.setSelectedAnimation((AnimationScrollEntry)((Object)entry)));
            this.animationListScrollArea.addEntry(e);
        }
        if (this.animationListScrollArea.getEntries().isEmpty()) {
            this.animationListScrollArea.addEntry(new TextScrollAreaEntry(this.animationListScrollArea, (Component)Components.translatable("fancymenu.animation.choose.no_animations", new Object[0]), entry -> {}));
        }
        int totalWidth = this.animationListScrollArea.getTotalEntryWidth();
        for (ScrollAreaEntry e : this.animationListScrollArea.getEntries()) {
            e.setWidth(totalWidth);
        }
    }

    public boolean m_7933_(int button, int $$1, int $$2) {
        if (button == 257 && this.selectedAnimationName != null) {
            this.callback.accept(this.selectedAnimationName);
            return true;
        }
        return super.m_7933_(button, $$1, $$2);
    }

    public static class AnimationScrollEntry
    extends TextListScrollAreaEntry {
        public String animation;

        public AnimationScrollEntry(ScrollArea parent, @NotNull String animation, @NotNull Consumer<TextListScrollAreaEntry> onClick) {
            super(parent, (Component)Components.literal(animation).m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().description_area_text_color.getColorInt())), UIBase.getUIColorTheme().listing_dot_color_1.getColor(), onClick);
            this.animation = animation;
        }
    }
}

