/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Lifecycle;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.customization.screen.identifier.UniversalScreenIdentifierRegistry;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinCreateWorldScreen;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.client.gui.screens.worldselection.WorldGenSettingsComponent;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenInstanceFactory {
    private static final Map<Class<?>, Object> DEFAULT_PARAMETERS = new HashMap();
    private static final Map<String, Supplier<? extends Screen>> SCREEN_INSTANCE_PROVIDERS = new HashMap<String, Supplier<? extends Screen>>();

    public static void registerScreenProvider(@NotNull String screenClassPath, @NotNull Supplier<? extends Screen> provider) {
        SCREEN_INSTANCE_PROVIDERS.put(screenClassPath, provider);
    }

    @Nullable
    public static Supplier<? extends Screen> getScreenProvider(@NotNull String screenClassPath) {
        return SCREEN_INSTANCE_PROVIDERS.get(screenClassPath);
    }

    @Nullable
    public static Screen tryConstruct(@NotNull String screenClassPathOrIdentifier) {
        try {
            Constructor<?>[] constructors;
            Supplier<? extends Screen> screenProvider;
            String nonUniversal;
            if (UniversalScreenIdentifierRegistry.universalIdentifierExists(screenClassPathOrIdentifier) && (nonUniversal = UniversalScreenIdentifierRegistry.getScreenForUniversalIdentifier(screenClassPathOrIdentifier)) != null) {
                screenClassPathOrIdentifier = nonUniversal;
            }
            if (ScreenCustomization.isScreenBlacklisted(screenClassPathOrIdentifier = ScreenIdentifierHandler.tryFixInvalidIdentifierWithNonUniversal(screenClassPathOrIdentifier))) {
                return null;
            }
            DEFAULT_PARAMETERS.put(Screen.class, Minecraft.m_91087_().f_91080_);
            DEFAULT_PARAMETERS.put(Player.class, Minecraft.m_91087_().f_91074_);
            if (Minecraft.m_91087_().f_91074_ != null) {
                DEFAULT_PARAMETERS.put(ClientAdvancements.class, Minecraft.m_91087_().f_91074_.f_108617_.m_105145_());
            }
            if ((screenProvider = ScreenInstanceFactory.getScreenProvider(screenClassPathOrIdentifier)) != null) {
                return screenProvider.get();
            }
            Class<?> screenClass = Class.forName(screenClassPathOrIdentifier, false, ScreenInstanceFactory.class.getClassLoader());
            if (Screen.class.isAssignableFrom(screenClass) && (constructors = screenClass.getConstructors()).length > 0) {
                Constructor<?> constructor = null;
                for (Constructor<?> c : constructors) {
                    if (c.getParameterTypes().length != 0) continue;
                    constructor = c;
                    break;
                }
                if (constructor == null) {
                    for (Constructor<?> c : constructors) {
                        if (!ScreenInstanceFactory.allParametersSupported(c.getParameterTypes())) continue;
                        constructor = c;
                        break;
                    }
                }
                if (constructor != null) {
                    Class<?>[] parameters = constructor.getParameterTypes();
                    ArrayList<Object> parameterInstances = new ArrayList<Object>();
                    for (Class<?> p : parameters) {
                        parameterInstances.add(DEFAULT_PARAMETERS.get(p));
                    }
                    return ScreenInstanceFactory.createInstance(constructor, parameterInstances);
                }
                return null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private static boolean allParametersSupported(Class<?>[] parameters) {
        for (Class<?> par : parameters) {
            if (DEFAULT_PARAMETERS.containsKey(par)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static Screen createInstance(@NotNull Constructor<?> constructor, @Nullable List<Object> parameters) {
        try {
            if (parameters == null || parameters.isEmpty()) {
                return (Screen)constructor.newInstance(new Object[0]);
            }
            return (Screen)constructor.newInstance(parameters.toArray(new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        DEFAULT_PARAMETERS.put(Minecraft.class, Minecraft.m_91087_());
        DEFAULT_PARAMETERS.put(Screen.class, null);
        DEFAULT_PARAMETERS.put(Options.class, Minecraft.m_91087_().f_91066_);
        DEFAULT_PARAMETERS.put(LanguageManager.class, Minecraft.m_91087_().m_91102_());
        DEFAULT_PARAMETERS.put(Player.class, null);
        DEFAULT_PARAMETERS.put(String.class, "");
        DEFAULT_PARAMETERS.put(ClientAdvancements.class, null);
        DEFAULT_PARAMETERS.put(Component.class, Components.empty());
        DEFAULT_PARAMETERS.put(Boolean.TYPE, true);
        DEFAULT_PARAMETERS.put(Integer.TYPE, 0);
        DEFAULT_PARAMETERS.put(Long.TYPE, 0L);
        DEFAULT_PARAMETERS.put(Double.TYPE, 0.0);
        DEFAULT_PARAMETERS.put(Float.TYPE, Float.valueOf(0.0f));
        DEFAULT_PARAMETERS.put(Boolean.class, true);
        DEFAULT_PARAMETERS.put(Integer.class, 0);
        DEFAULT_PARAMETERS.put(Long.class, 0L);
        DEFAULT_PARAMETERS.put(Double.class, 0.0);
        DEFAULT_PARAMETERS.put(Float.class, Float.valueOf(0.0f));
        ScreenInstanceFactory.registerScreenProvider(CreateWorldScreen.class.getName(), () -> {
            Minecraft $$0 = Minecraft.m_91087_();
            Screen $$1 = Minecraft.m_91087_().f_91080_;
            PackRepository $$2 = new PackRepository(PackType.SERVER_DATA, new RepositorySource[]{new ServerPacksSource()});
            WorldLoader.InitConfig $$3 = IMixinCreateWorldScreen.invokeCreateDefaultLoadConfigFancyMenu($$2, DataPackConfig.f_45842_);
            CompletableFuture $$4 = WorldLoader.m_214362_((WorldLoader.InitConfig)$$3, ($$0x, $$1x) -> {
                RegistryAccess.Frozen $$2x = RegistryAccess.m_206197_().m_203557_();
                WorldGenSettings $$3x = WorldPresets.m_226449_((RegistryAccess)$$2x);
                return Pair.of((Object)$$3x, (Object)$$2x);
            }, ($$0x, $$1x, $$2x, $$3x) -> {
                $$0x.close();
                return new WorldCreationContext($$3x, Lifecycle.stable(), $$2x, $$1x);
            }, (Executor)Util.m_183991_(), (Executor)$$0);
            Objects.requireNonNull($$4);
            $$0.m_18701_($$4::isDone);
            return IMixinCreateWorldScreen.invokeConstructFancyMenu($$1, DataPackConfig.f_45842_, new WorldGenSettingsComponent((WorldCreationContext)$$4.join(), Optional.of(WorldPresets.f_226437_), OptionalLong.empty()));
        });
        ScreenInstanceFactory.registerScreenProvider(PackSelectionScreen.class.getName(), () -> new PackSelectionScreen((Screen)(Minecraft.m_91087_().f_91080_ != null ? Minecraft.m_91087_().f_91080_ : new TitleScreen()), Minecraft.m_91087_().m_91099_(), repository -> {
            Options options = Minecraft.m_91087_().f_91066_;
            ImmutableList $$1 = ImmutableList.copyOf((Collection)options.f_92117_);
            options.f_92117_.clear();
            options.f_92118_.clear();
            for (Pack $$2 : repository.m_10524_()) {
                if ($$2.m_10450_()) continue;
                options.f_92117_.add($$2.m_10446_());
                if ($$2.m_10443_().m_10489_()) continue;
                options.f_92118_.add($$2.m_10446_());
            }
            options.m_92169_();
            ImmutableList $$3 = ImmutableList.copyOf((Collection)options.f_92117_);
            if (!$$3.equals($$1)) {
                Minecraft.m_91087_().m_91391_();
            }
        }, Minecraft.m_91087_().m_91101_(), (Component)Component.m_237115_((String)"resourcePack.title")));
    }
}

