/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.capability;

import com.oblivioussp.spartanweaponry.api.OilEffects;
import com.oblivioussp.spartanweaponry.api.oil.OilEffect;
import com.oblivioussp.spartanweaponry.capability.IOilHandler;
import com.oblivioussp.spartanweaponry.util.OilHelper;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryManager;

public class OilHandler
implements IOilHandler {
    public static final String NBT_OIL = "Oil";
    public static final String NBT_OIL_EFFECT = "Effect";
    public static final String NBT_USES_LEFT = "UsesLeft";
    private final ItemStack stack;
    private Optional<OilEffect> effect;
    private Optional<Potion> potion;
    private int usesLeft;

    public OilHandler(ItemStack stackIn) {
        this.stack = stackIn;
        this.effect = Optional.empty();
        this.potion = Optional.empty();
        this.usesLeft = 0;
        if (this.stack.m_41784_().m_128441_(NBT_OIL)) {
            this.deserializeNBT(this.stack.m_41783_().m_128469_(NBT_OIL));
        }
    }

    @Override
    public Optional<OilEffect> getEffect() {
        return this.effect;
    }

    @Override
    public Optional<Potion> getPotion() {
        return this.potion;
    }

    @Override
    public void setEffect(OilEffect effectIn, ItemStack oilStackIn) {
        this.effect = Optional.of(effectIn);
        this.usesLeft = effectIn.getMaxUses();
        this.potion = effectIn == OilEffects.POTION.get() ? Optional.of(PotionUtils.m_43579_((ItemStack)oilStackIn)) : Optional.empty();
        this.stack.m_41784_().m_128365_(NBT_OIL, (Tag)this.serializeNBT());
    }

    @Override
    public void setPotion(Potion potionIn, ItemStack oilStackIn) {
        this.effect = Optional.of((OilEffect)OilEffects.POTION.get());
        this.usesLeft = ((OilEffect)OilEffects.POTION.get()).getMaxUses();
        this.potion = Optional.of(potionIn);
        this.stack.m_41784_().m_128365_(NBT_OIL, (Tag)this.serializeNBT());
    }

    @Override
    public void clearEffect() {
        this.effect = Optional.empty();
        this.usesLeft = 0;
        this.stack.m_41784_().m_128473_(NBT_OIL);
    }

    @Override
    public float useEffect(float baseDamageIn, Level levelIn, LivingEntity targetIn, LivingEntity userIn, ItemStack userWeaponIn) {
        OilEffect oilEffect = this.effect.get();
        ItemStack oilStack = oilEffect == OilEffects.POTION.get() ? OilHelper.makePotionOilStack(this.potion.get()) : OilHelper.makeOilStack(oilEffect);
        float resultDamage = oilEffect.onUse(baseDamageIn, levelIn, targetIn, userIn, oilStack);
        --this.usesLeft;
        this.stack.m_41784_().m_128365_(NBT_OIL, (Tag)this.serializeNBT());
        if (this.usesLeft <= 0) {
            if (userIn instanceof Player) {
                ((Player)userIn).m_5661_((Component)Component.m_237110_((String)"message.spartanweaponry.oil_depleted", (Object[])new Object[]{oilStack.m_41786_(), userWeaponIn.m_41786_()}), true);
            }
            this.clearEffect();
        }
        return resultDamage;
    }

    @Override
    public boolean isOiled() {
        return this.effect.isPresent() && this.effect.get() != OilEffects.NONE.get();
    }

    @Override
    public int getUsesLeft() {
        return this.usesLeft;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(OilEffects.REGISTRY_KEY);
        if (registry != null && this.effect.isPresent()) {
            if (this.potion.isPresent()) {
                ResourceLocation potionLoc = ForgeRegistries.POTIONS.getKey((Object)this.potion.get());
                nbt.m_128359_("Potion", potionLoc.toString());
            }
            ResourceLocation loc = registry.getKey((Object)this.effect.get());
            nbt.m_128359_(NBT_OIL_EFFECT, loc.toString());
            nbt.m_128405_(NBT_USES_LEFT, this.usesLeft);
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        String oilEffectReg = nbt.m_128461_(NBT_OIL_EFFECT);
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(OilEffects.REGISTRY_KEY);
        if (registry != null) {
            Optional<Object> optional = this.effect = !oilEffectReg.isEmpty() ? Optional.of((OilEffect)registry.getValue(new ResourceLocation(oilEffectReg))) : Optional.empty();
            if (nbt.m_128441_("Potion")) {
                String potionReg = nbt.m_128461_("Potion");
                this.potion = !potionReg.isEmpty() ? Optional.of((Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(potionReg))) : Optional.empty();
            }
        }
        this.usesLeft = nbt.m_128451_(NBT_USES_LEFT);
    }
}

