/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.oblivioussp.spartanweaponry.client.model.LargeArrowQuiverModel;
import com.oblivioussp.spartanweaponry.client.model.LargeBoltQuiverModel;
import com.oblivioussp.spartanweaponry.client.model.MediumArrowQuiverModel;
import com.oblivioussp.spartanweaponry.client.model.MediumBoltQuiverModel;
import com.oblivioussp.spartanweaponry.client.model.QuiverModelBase;
import com.oblivioussp.spartanweaponry.client.model.SmallArrowQuiverModel;
import com.oblivioussp.spartanweaponry.client.model.SmallBoltQuiverModel;
import com.oblivioussp.spartanweaponry.client.renderer.entity.ModelLayers;
import com.oblivioussp.spartanweaponry.init.ModItems;
import com.oblivioussp.spartanweaponry.item.QuiverBaseItem;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class CurioRenderer
implements ResourceManagerReloadListener {
    public static final CurioRenderer INSTANCE = new CurioRenderer();
    public static SmallArrowQuiverModel smallArrowQuiverModel;
    protected static final ResourceLocation smallArrowQuiverTexture;
    public static MediumArrowQuiverModel mediumArrowQuiverModel;
    protected static final ResourceLocation mediumArrowQuiverTexture;
    public static LargeArrowQuiverModel largeArrowQuiverModel;
    protected static final ResourceLocation largeArrowQuiverTexture;
    protected static final ResourceLocation hugeArrowQuiverTexture;
    public static SmallBoltQuiverModel smallBoltQuiverModel;
    protected static final ResourceLocation smallBoltQuiverTexture;
    public static MediumBoltQuiverModel mediumBoltQuiverModel;
    protected static final ResourceLocation mediumBoltQuiverTexture;
    public static LargeBoltQuiverModel largeBoltQuiverModel;
    protected static final ResourceLocation largeBoltQuiverTexture;
    protected static final ResourceLocation hugeBoltQuiverTexture;
    public static final Renderer QUIVER_ARROW_SMALL_RENDERER;
    public static final Renderer QUIVER_ARROW_MEDIUM_RENDERER;
    public static final Renderer QUIVER_ARROW_LARGE_RENDERER;
    public static final Renderer QUIVER_ARROW_HUGE_RENDERER;
    public static final Renderer QUIVER_BOLT_SMALL_RENDERER;
    public static final Renderer QUIVER_BOLT_MEDIUM_RENDERER;
    public static final Renderer QUIVER_BOLT_LARGE_RENDERER;
    public static final Renderer QUIVER_BOLT_HUGE_RENDERER;

    private CurioRenderer() {
    }

    public static void register() {
        CuriosRendererRegistry.register((Item)((Item)ModItems.SMALL_ARROW_QUIVER.get()), () -> QUIVER_ARROW_SMALL_RENDERER);
        CuriosRendererRegistry.register((Item)((Item)ModItems.MEDIUM_ARROW_QUIVER.get()), () -> QUIVER_ARROW_MEDIUM_RENDERER);
        CuriosRendererRegistry.register((Item)((Item)ModItems.LARGE_ARROW_QUIVER.get()), () -> QUIVER_ARROW_LARGE_RENDERER);
        CuriosRendererRegistry.register((Item)((Item)ModItems.HUGE_ARROW_QUIVER.get()), () -> QUIVER_ARROW_HUGE_RENDERER);
        CuriosRendererRegistry.register((Item)((Item)ModItems.SMALL_BOLT_QUIVER.get()), () -> QUIVER_BOLT_SMALL_RENDERER);
        CuriosRendererRegistry.register((Item)((Item)ModItems.MEDIUM_BOLT_QUIVER.get()), () -> QUIVER_BOLT_MEDIUM_RENDERER);
        CuriosRendererRegistry.register((Item)((Item)ModItems.LARGE_BOLT_QUIVER.get()), () -> QUIVER_BOLT_LARGE_RENDERER);
        CuriosRendererRegistry.register((Item)((Item)ModItems.HUGE_BOLT_QUIVER.get()), () -> QUIVER_BOLT_HUGE_RENDERER);
    }

    public void m_6213_(ResourceManager p_10758_) {
        Minecraft mc = Minecraft.m_91087_();
        smallArrowQuiverModel = new SmallArrowQuiverModel(mc.m_167973_().m_171103_(ModelLayers.SMALL_ARROW_QUIVER));
        mediumArrowQuiverModel = new MediumArrowQuiverModel(mc.m_167973_().m_171103_(ModelLayers.MEDIUM_ARROW_QUIVER));
        largeArrowQuiverModel = new LargeArrowQuiverModel(mc.m_167973_().m_171103_(ModelLayers.LARGE_ARROW_QUIVER));
        QUIVER_ARROW_SMALL_RENDERER.setModel(smallArrowQuiverModel);
        QUIVER_ARROW_MEDIUM_RENDERER.setModel(mediumArrowQuiverModel);
        QUIVER_ARROW_LARGE_RENDERER.setModel(largeArrowQuiverModel);
        QUIVER_ARROW_HUGE_RENDERER.setModel(largeArrowQuiverModel);
        smallBoltQuiverModel = new SmallBoltQuiverModel(mc.m_167973_().m_171103_(ModelLayers.SMALL_BOLT_QUIVER));
        mediumBoltQuiverModel = new MediumBoltQuiverModel(mc.m_167973_().m_171103_(ModelLayers.MEDIUM_BOLT_QUIVER));
        largeBoltQuiverModel = new LargeBoltQuiverModel(mc.m_167973_().m_171103_(ModelLayers.LARGE_BOLT_QUIVER));
        QUIVER_BOLT_SMALL_RENDERER.setModel(smallBoltQuiverModel);
        QUIVER_BOLT_MEDIUM_RENDERER.setModel(mediumBoltQuiverModel);
        QUIVER_BOLT_LARGE_RENDERER.setModel(largeBoltQuiverModel);
        QUIVER_BOLT_HUGE_RENDERER.setModel(largeBoltQuiverModel);
    }

    static {
        smallArrowQuiverTexture = new ResourceLocation("spartanweaponry", "textures/model/quiver_arrow_small.png");
        mediumArrowQuiverTexture = new ResourceLocation("spartanweaponry", "textures/model/quiver_arrow_medium.png");
        largeArrowQuiverTexture = new ResourceLocation("spartanweaponry", "textures/model/quiver_arrow_large.png");
        hugeArrowQuiverTexture = new ResourceLocation("spartanweaponry", "textures/model/quiver_arrow_huge.png");
        smallBoltQuiverTexture = new ResourceLocation("spartanweaponry", "textures/model/quiver_bolt_small.png");
        mediumBoltQuiverTexture = new ResourceLocation("spartanweaponry", "textures/model/quiver_bolt_medium.png");
        largeBoltQuiverTexture = new ResourceLocation("spartanweaponry", "textures/model/quiver_bolt_large.png");
        hugeBoltQuiverTexture = new ResourceLocation("spartanweaponry", "textures/model/quiver_bolt_huge.png");
        CurioRenderer curioRenderer = INSTANCE;
        Objects.requireNonNull(curioRenderer);
        QUIVER_ARROW_SMALL_RENDERER = curioRenderer.new Renderer(smallArrowQuiverTexture);
        CurioRenderer curioRenderer2 = INSTANCE;
        Objects.requireNonNull(curioRenderer2);
        QUIVER_ARROW_MEDIUM_RENDERER = curioRenderer2.new Renderer(mediumArrowQuiverTexture);
        CurioRenderer curioRenderer3 = INSTANCE;
        Objects.requireNonNull(curioRenderer3);
        QUIVER_ARROW_LARGE_RENDERER = curioRenderer3.new Renderer(largeArrowQuiverTexture);
        CurioRenderer curioRenderer4 = INSTANCE;
        Objects.requireNonNull(curioRenderer4);
        QUIVER_ARROW_HUGE_RENDERER = curioRenderer4.new Renderer(hugeArrowQuiverTexture);
        CurioRenderer curioRenderer5 = INSTANCE;
        Objects.requireNonNull(curioRenderer5);
        QUIVER_BOLT_SMALL_RENDERER = curioRenderer5.new Renderer(smallBoltQuiverTexture);
        CurioRenderer curioRenderer6 = INSTANCE;
        Objects.requireNonNull(curioRenderer6);
        QUIVER_BOLT_MEDIUM_RENDERER = curioRenderer6.new Renderer(mediumBoltQuiverTexture);
        CurioRenderer curioRenderer7 = INSTANCE;
        Objects.requireNonNull(curioRenderer7);
        QUIVER_BOLT_LARGE_RENDERER = curioRenderer7.new Renderer(largeBoltQuiverTexture);
        CurioRenderer curioRenderer8 = INSTANCE;
        Objects.requireNonNull(curioRenderer8);
        QUIVER_BOLT_HUGE_RENDERER = curioRenderer8.new Renderer(hugeBoltQuiverTexture);
    }

    private class Renderer
    implements ICurioRenderer {
        private QuiverModelBase model;
        private ResourceLocation texture;

        public Renderer(ResourceLocation texture) {
            this.texture = texture;
        }

        public void setModel(QuiverModelBase model) {
            this.model = model;
        }

        public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            int arrowsToRender = 0;
            if (stack.m_41720_() instanceof QuiverBaseItem) {
                arrowsToRender = ((QuiverBaseItem)stack.m_41720_()).getAmmoCount(stack);
            }
            if (this.model != null) {
                this.renderQuiverModel(this.model, this.texture, arrowsToRender, slotContext, matrixStack, renderTypeBuffer, light);
            }
        }

        private void renderQuiverModel(QuiverModelBase model, ResourceLocation texture, int arrowsToRender, SlotContext slotContext, PoseStack mStack, MultiBufferSource renderTypeBuffer, int packedLight) {
            VertexConsumer buffer = renderTypeBuffer.m_6299_(model.m_103119_(texture));
            ICurioRenderer.translateIfSneaking((PoseStack)mStack, (LivingEntity)slotContext.entity());
            ICurioRenderer.rotateIfSneaking((PoseStack)mStack, (LivingEntity)slotContext.entity());
            model.m_7695_(mStack, buffer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            model.renderArrows(arrowsToRender, mStack, buffer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

