/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.client.model;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import com.oblivioussp.spartanweaponry.client.model.OilCoatingItemBakedModel;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import org.jetbrains.annotations.Nullable;

public class OilCoatedItemModel
implements IUnbakedGeometry<OilCoatedItemModel> {
    protected ImmutableList<Material> textures;
    protected Material coatingTexture;
    protected final IntSet emissiveLayers;
    protected final Int2ObjectMap<ResourceLocation> renderTypeNames;

    public OilCoatedItemModel(@Nullable ImmutableList<Material> texturesIn, @Nullable Material coatingTextureIn, IntSet emissiveLayersIn, Int2ObjectMap<ResourceLocation> renderTypeNamesIn) {
        this.textures = texturesIn;
        this.coatingTexture = coatingTextureIn;
        this.emissiveLayers = emissiveLayersIn;
        this.renderTypeNames = renderTypeNamesIn;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        if (this.textures == null) {
            throw new IllegalStateException("Textures aren't initialized! Pass into constructor or call getMaterials(...) first!");
        }
        TextureAtlasSprite particleSprite = spriteGetter.apply(context.hasMaterial("particle") ? context.getMaterial("particle") : (Material)this.textures.get(0));
        Transformation transform = context.getRootTransform();
        if (!transform.isIdentity()) {
            modelState = UnbakedGeometryHelper.composeRootTransformIntoModelState((ModelState)modelState, (Transformation)transform);
        }
        RenderTypeGroup normalRenderTypes = new RenderTypeGroup(RenderType.m_110466_(), ForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get());
        OilCoatingItemBakedModel.Builder builder = OilCoatingItemBakedModel.makeBuilder(context, particleSprite, overrides, context.getTransforms());
        for (int i = 0; i < this.textures.size(); ++i) {
            ResourceLocation renderTypeName;
            Material material = (Material)this.textures.get(i);
            if (material == this.coatingTexture) continue;
            TextureAtlasSprite sprite = spriteGetter.apply((Material)this.textures.get(i));
            List unbakedElements = UnbakedGeometryHelper.createUnbakedItemElements((int)i, (TextureAtlasSprite)sprite);
            List bakedQuads = UnbakedGeometryHelper.bakeElements((List)unbakedElements, mat -> sprite, (ModelState)modelState, (ResourceLocation)modelLocation);
            if (this.emissiveLayers.contains(i)) {
                QuadTransformers.settingMaxEmissivity().processInPlace(bakedQuads);
            }
            RenderTypeGroup renderTypes = (renderTypeName = (ResourceLocation)this.renderTypeNames.get(i)) != null ? context.getRenderType(renderTypeName) : normalRenderTypes;
            builder.addQuads(renderTypes, bakedQuads);
        }
        if (this.coatingTexture != null) {
            ResourceLocation renderTypeName;
            int coatingLayer = 100;
            TextureAtlasSprite sprite = spriteGetter.apply(this.coatingTexture);
            List unbakedElements = UnbakedGeometryHelper.createUnbakedItemElements((int)100, (TextureAtlasSprite)sprite);
            List bakedQuads = UnbakedGeometryHelper.bakeElements((List)unbakedElements, mat -> sprite, (ModelState)modelState, (ResourceLocation)modelLocation);
            if (this.emissiveLayers.contains(100)) {
                QuadTransformers.settingMaxEmissivity().processInPlace(bakedQuads);
            }
            RenderTypeGroup renderTypes = (renderTypeName = (ResourceLocation)this.renderTypeNames.get(100)) != null ? context.getRenderType(renderTypeName) : normalRenderTypes;
            builder.addCoatedQuads(renderTypes, bakedQuads);
        }
        return builder.build();
    }

    public Collection<Material> getMaterials(IGeometryBakingContext context, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        if (this.textures != null) {
            return this.textures;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        if (context.hasMaterial("particle")) {
            builder.add((Object)context.getMaterial("particle"));
        }
        int i = 0;
        while (context.hasMaterial("layer" + i)) {
            builder.add((Object)context.getMaterial("layer" + i));
            ++i;
        }
        if (context.hasMaterial("coating")) {
            this.coatingTexture = context.getMaterial("coating");
            builder.add((Object)this.coatingTexture);
        }
        this.textures = builder.build();
        return this.textures;
    }

    public static class Loader
    implements IGeometryLoader<OilCoatedItemModel> {
        public static final Loader INSTANCE = new Loader();

        public OilCoatedItemModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
            Int2ObjectOpenHashMap renderTypeNames = new Int2ObjectOpenHashMap();
            if (jsonObject.has("render_types")) {
                JsonObject renderTypes = jsonObject.getAsJsonObject("render_types");
                for (Map.Entry entry : renderTypes.entrySet()) {
                    ResourceLocation renderType = new ResourceLocation((String)entry.getKey());
                    for (JsonElement layer : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                        if (renderTypeNames.put(layer.getAsInt(), (Object)renderType) == null) continue;
                        throw new JsonParseException("Duplicate render type for layer " + layer);
                    }
                }
            }
            IntOpenHashSet emissiveLayers = new IntOpenHashSet();
            JsonArray emissiveLayersJson = jsonObject.has("emissive_layers") ? jsonObject.getAsJsonArray("emissive_layers") : new JsonArray();
            ResourceLocation renderType = new ResourceLocation("forge", "item_unlit");
            for (JsonElement emissiveLayer : emissiveLayersJson) {
                int layerIdx = emissiveLayer.getAsInt();
                emissiveLayers.add(layerIdx);
                renderTypeNames.putIfAbsent(layerIdx, (Object)renderType);
            }
            return new OilCoatedItemModel(null, null, (IntSet)emissiveLayers, (Int2ObjectMap<ResourceLocation>)renderTypeNames);
        }
    }
}

