/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.compat.jei;

import com.google.common.collect.ImmutableList;
import com.oblivioussp.spartanweaponry.compat.jei.JeiOilBrewingRecipe;
import com.oblivioussp.spartanweaponry.init.ModItems;
import com.oblivioussp.spartanweaponry.init.ModOilRecipes;
import com.oblivioussp.spartanweaponry.item.crafting.OilBrewingRecipe;
import com.oblivioussp.spartanweaponry.util.OilHelper;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class OilBrewingRecipeMaker {
    public static List<IJeiBrewingRecipe> getRecipes(IVanillaRecipeFactory vanillaRecipeFactoryIn) {
        ArrayList<IJeiBrewingRecipe> recipes = new ArrayList<IJeiBrewingRecipe>();
        if (ModOilRecipes.oilRecipes != null) {
            List<OilBrewingRecipe.OilMix> mixes = OilBrewingRecipe.getValidMixes();
            for (OilBrewingRecipe.OilMix mix : mixes) {
                ItemStack fromStack = OilHelper.makeOilStack(mix.from);
                ItemStack toStack = OilHelper.makeOilStack(mix.to);
                recipes.add(new JeiOilBrewingRecipe((List<ItemStack>)ImmutableList.of((Object)fromStack), (List<ItemStack>)ImmutableList.copyOf((Object[])mix.brewingIngredient.m_43908_()), toStack));
            }
        }
        if (ModOilRecipes.potionToOilRecipes != null) {
            for (Potion potion : ForgeRegistries.POTIONS) {
                if (!OilHelper.isValidPotion(potion)) continue;
                ItemStack potionStack = new ItemStack((ItemLike)Items.f_42589_);
                PotionUtils.m_43549_((ItemStack)potionStack, (Potion)potion);
                ItemStack oilStack = OilHelper.makePotionOilStack(potion);
                recipes.add(vanillaRecipeFactoryIn.createBrewingRecipe((List)ImmutableList.of((Object)new ItemStack((ItemLike)ModItems.GREASE_BALL.get())), (List)ImmutableList.of((Object)potionStack), oilStack));
            }
        }
        return recipes;
    }
}

