/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.data;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.oblivioussp.spartanweaponry.api.OilEffects;
import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.crafting.condition.TypeDisabledCondition;
import com.oblivioussp.spartanweaponry.api.data.recipe.ConditionalShapedRecipeBuilder;
import com.oblivioussp.spartanweaponry.api.data.recipe.ConditionalShapelessRecipeBuilder;
import com.oblivioussp.spartanweaponry.api.oil.OilEffect;
import com.oblivioussp.spartanweaponry.api.tags.ModItemTags;
import com.oblivioussp.spartanweaponry.data.recipe.TippedProjectileRecipeBuilder;
import com.oblivioussp.spartanweaponry.init.ModItems;
import com.oblivioussp.spartanweaponry.init.ModRecipeSerializers;
import com.oblivioussp.spartanweaponry.item.SwordBaseItem;
import com.oblivioussp.spartanweaponry.item.ThrowingWeaponItem;
import com.oblivioussp.spartanweaponry.util.OilHelper;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.UpgradeRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.registries.ForgeRegistries;

public class ModRecipeProvider
extends RecipeProvider {
    public ModRecipeProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    protected void m_176531_(Consumer<FinishedRecipe> recipeFunc) {
        TagKey woodLog = ItemTags.create((ResourceLocation)new ResourceLocation("minecraft:logs"));
        TagKey planks = ItemTags.create((ResourceLocation)new ResourceLocation("minecraft:planks"));
        TagKey arrows = ItemTags.create((ResourceLocation)new ResourceLocation("minecraft:arrows"));
        TagKey stick = ItemTags.create((ResourceLocation)new ResourceLocation("forge:rods/wooden"));
        TagKey string = ItemTags.create((ResourceLocation)new ResourceLocation("forge:string"));
        TagKey leather = ItemTags.create((ResourceLocation)new ResourceLocation("forge:leather"));
        TagKey gunpowder = ItemTags.create((ResourceLocation)new ResourceLocation("forge:gunpowder"));
        TagKey ironNugget = ItemTags.create((ResourceLocation)new ResourceLocation("forge:nuggets/iron"));
        TagKey feathers = ItemTags.create((ResourceLocation)new ResourceLocation("forge:feathers"));
        TagKey slimeballs = ItemTags.create((ResourceLocation)new ResourceLocation("forge:slimeballs"));
        TagKey bolts = ItemTags.create((ResourceLocation)new ResourceLocation("spartanweaponry:bolts"));
        TagKey stone = ItemTags.create((ResourceLocation)new ResourceLocation(WeaponMaterial.STONE.getRepairTagName()));
        TagKey copper = ItemTags.create((ResourceLocation)new ResourceLocation(WeaponMaterial.COPPER.getRepairTagName()));
        TagKey iron = ItemTags.create((ResourceLocation)new ResourceLocation(WeaponMaterial.IRON.getRepairTagName()));
        TagKey gold = ItemTags.create((ResourceLocation)new ResourceLocation(WeaponMaterial.GOLD.getRepairTagName()));
        TagKey diamond = ItemTags.create((ResourceLocation)new ResourceLocation(WeaponMaterial.DIAMOND.getRepairTagName()));
        TagKey netherite = ItemTags.create((ResourceLocation)new ResourceLocation(WeaponMaterial.NETHERITE.getRepairTagName()));
        TagKey tin = ItemTags.create((ResourceLocation)new ResourceLocation(WeaponMaterial.TIN.getRepairTagName()));
        TagKey bronze = ItemTags.create((ResourceLocation)new ResourceLocation(WeaponMaterial.BRONZE.getRepairTagName()));
        TagKey steel = ItemTags.create((ResourceLocation)new ResourceLocation(WeaponMaterial.STEEL.getRepairTagName()));
        TagKey silver = ItemTags.create((ResourceLocation)new ResourceLocation(WeaponMaterial.SILVER.getRepairTagName()));
        TagKey electrum = ItemTags.create((ResourceLocation)new ResourceLocation(WeaponMaterial.ELECTRUM.getRepairTagName()));
        TagKey lead = ItemTags.create((ResourceLocation)new ResourceLocation(WeaponMaterial.LEAD.getRepairTagName()));
        TagKey nickel = ItemTags.create((ResourceLocation)new ResourceLocation(WeaponMaterial.NICKEL.getRepairTagName()));
        TagKey invar = ItemTags.create((ResourceLocation)new ResourceLocation(WeaponMaterial.INVAR.getRepairTagName()));
        TagKey constantan = ItemTags.create((ResourceLocation)new ResourceLocation(WeaponMaterial.CONSTANTAN.getRepairTagName()));
        TagKey platinum = ItemTags.create((ResourceLocation)new ResourceLocation(WeaponMaterial.PLATINUM.getRepairTagName()));
        TagKey aluminum = ItemTags.create((ResourceLocation)new ResourceLocation(WeaponMaterial.ALUMINUM.getRepairTagName()));
        ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)ModItems.SIMPLE_HANDLE.get())).m_206419_(stick).m_206419_(ModItemTags.GRASS).m_126132_("has_stick", (CriterionTriggerInstance)this.hasItem((TagKey<Item>)stick)).m_176498_(recipeFunc);
        ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)ModItems.HANDLE.get())).m_206419_(stick).m_206419_(string).m_126145_("spartanweaponry:handle").m_126132_("has_string", (CriterionTriggerInstance)this.hasItem((TagKey<Item>)string)).m_176500_(recipeFunc, "spartanweaponry:handle_from_string");
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)ModItems.HANDLE.get()), (int)4).m_206419_(stick).m_206419_(stick).m_206419_(stick).m_206419_(stick).m_206419_(ItemTags.f_13167_).m_126145_("spartanweaponry:handle").m_126132_("has_stick", (CriterionTriggerInstance)this.hasItem((TagKey<Item>)stick)).m_176500_(recipeFunc, "spartanweaponry:handle_from_wool");
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)ModItems.HANDLE.get()), (int)4).m_206419_(stick).m_206419_(stick).m_206419_(stick).m_206419_(stick).m_206419_(leather).m_126145_("spartanweaponry:handle").m_126132_("has_stick", (CriterionTriggerInstance)this.hasItem((TagKey<Item>)stick)).m_176500_(recipeFunc, "spartanweaponry:handle_from_leather");
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ModItems.SIMPLE_POLE.get())).m_126127_(Character.valueOf('#'), (ItemLike)ModItems.SIMPLE_HANDLE.get()).m_206416_(Character.valueOf('/'), stick).m_126130_("/").m_126130_("#").m_126130_("/").m_126132_("has_handle", (CriterionTriggerInstance)this.hasItem((ItemLike)ModItems.SIMPLE_HANDLE.get())).m_176498_(recipeFunc);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ModItems.POLE.get())).m_206416_(Character.valueOf('|'), stick).m_206416_(Character.valueOf('#'), string).m_126130_("| ").m_126130_("|#").m_126130_("| ").m_126145_("spartanweaponry:pole").m_126132_("has_stick", (CriterionTriggerInstance)this.hasItem((TagKey<Item>)stick)).m_176500_(recipeFunc, "spartanweaponry:pole_from_string");
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ModItems.POLE.get()), (int)4).m_206416_(Character.valueOf('|'), stick).m_206416_(Character.valueOf('#'), ItemTags.f_13167_).m_126130_("|||").m_126130_("|||").m_126130_("||#").m_126145_("spartanweaponry:pole").m_126132_("has_stick", (CriterionTriggerInstance)this.hasItem((TagKey<Item>)stick)).m_176500_(recipeFunc, "spartanweaponry:pole_from_wool");
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ModItems.POLE.get()), (int)4).m_206416_(Character.valueOf('|'), stick).m_206416_(Character.valueOf('#'), leather).m_126130_("|||").m_126130_("|||").m_126130_("||#").m_126145_("spartanweaponry:pole").m_126132_("has_stick", (CriterionTriggerInstance)this.hasItem((TagKey<Item>)stick)).m_176500_(recipeFunc, "spartanweaponry:pole_from_leather");
        ConditionalShapedRecipeBuilder.shaped((ItemLike)ModItems.EXPLOSIVE_CHARGE.get(), 4).define(Character.valueOf('#'), (TagKey<Item>)gunpowder).define(Character.valueOf('-'), (TagKey<Item>)ironNugget).pattern("###").pattern("---").pattern("###").group("spartanweaponry:explosive").unlockedBy("has_gunpowder", (CriterionTriggerInstance)this.hasItem((TagKey<Item>)gunpowder)).condition(new TypeDisabledCondition(Collections.singletonList("explosives"))).save(recipeFunc);
        ConditionalShapedRecipeBuilder.shaped((ItemLike)ModItems.GREASE_BALL.get()).define(Character.valueOf('#'), ModItemTags.RAW_MEAT).define(Character.valueOf('O'), (TagKey<Item>)slimeballs).pattern(" # ").pattern("#O#").pattern(" # ").group("spartanweaponry:grease_ball").unlockedBy("has_meat", (CriterionTriggerInstance)this.hasItem(ModItemTags.RAW_MEAT)).unlockedBy("has_slimeball", (CriterionTriggerInstance)this.hasItem((TagKey<Item>)slimeballs)).condition(new TypeDisabledCondition(Collections.singletonList("oil"))).save(recipeFunc);
        RecipeData dataWood = new RecipeData((TagKey<Item>)ItemTags.f_13168_, "has_wood");
        RecipeData dataStone = new RecipeData((TagKey<Item>)stone, "has_cobblestone");
        RecipeData dataLeather = new RecipeData((TagKey<Item>)leather, "has_leather");
        RecipeData dataIron = new RecipeData((TagKey<Item>)iron, "has_iron_ingot");
        RecipeData dataGold = new RecipeData((TagKey<Item>)gold, "has_gold_ingot");
        RecipeData dataDiamond = new RecipeData((TagKey<Item>)diamond, "has_diamond");
        RecipeData dataNetherite = new RecipeData((TagKey<Item>)netherite, "has_netherite_ingot");
        RecipeData dataCopper = new RecipeData((TagKey<Item>)copper, "has_copper_ingot", "copper");
        RecipeData dataTin = new RecipeData((TagKey<Item>)tin, "has_tin_ingot", "tin");
        RecipeData dataBronze = new RecipeData((TagKey<Item>)bronze, "has_bronze_ingot", "bronze");
        RecipeData dataSteel = new RecipeData((TagKey<Item>)steel, "has_steel_ingot", "steel");
        RecipeData dataSilver = new RecipeData((TagKey<Item>)silver, "has_silver_ingot", "silver");
        RecipeData dataElectrum = new RecipeData((TagKey<Item>)electrum, "has_electrum_ingot", "electrum");
        RecipeData dataLead = new RecipeData((TagKey<Item>)lead, "has_lead_ingot", "lead");
        RecipeData dataNickel = new RecipeData((TagKey<Item>)nickel, "has_nickel_ingot", "nickel");
        RecipeData dataInvar = new RecipeData((TagKey<Item>)invar, "has_invar_ingot", "invar");
        RecipeData dataConstantan = new RecipeData((TagKey<Item>)constantan, "has_constantan_ingot", "constantan");
        RecipeData dataPlatinum = new RecipeData((TagKey<Item>)platinum, "has_platinum_ingot", "platinum");
        RecipeData dataAluminum = new RecipeData((TagKey<Item>)aluminum, "has_aluminum_ingot", "aluminum");
        ImmutableList<SwordBaseItem> daggers = ModItems.DAGGERS.getAsList();
        ImmutableList<SwordBaseItem> parryingDaggers = ModItems.PARRYING_DAGGERS.getAsList();
        ImmutableList<SwordBaseItem> longswords = ModItems.LONGSWORDS.getAsList();
        ImmutableList<SwordBaseItem> katanas = ModItems.KATANAS.getAsList();
        ImmutableList<SwordBaseItem> sabers = ModItems.SABERS.getAsList();
        ImmutableList<SwordBaseItem> rapiers = ModItems.RAPIERS.getAsList();
        ImmutableList<SwordBaseItem> greatswords = ModItems.GREATSWORDS.getAsList();
        ImmutableList<SwordBaseItem> battleHammers = ModItems.BATTLE_HAMMERS.getAsList();
        ImmutableList<SwordBaseItem> warhammers = ModItems.WARHAMMERS.getAsList();
        ImmutableList<SwordBaseItem> spears = ModItems.SPEARS.getAsList();
        ImmutableList<SwordBaseItem> halberds = ModItems.HALBERDS.getAsList();
        ImmutableList<SwordBaseItem> pikes = ModItems.PIKES.getAsList();
        ImmutableList<SwordBaseItem> lances = ModItems.LANCES.getAsList();
        ImmutableList<Item> longbows = ModItems.LONGBOWS.getAsList();
        ImmutableList<Item> heavyCrossbows = ModItems.HEAVY_CROSSBOWS.getAsList();
        ImmutableList<ThrowingWeaponItem> throwingKnives = ModItems.THROWING_KNIVES.getAsList();
        ImmutableList<ThrowingWeaponItem> tomahawks = ModItems.TOMAHAWKS.getAsList();
        ImmutableList<ThrowingWeaponItem> javelins = ModItems.JAVELINS.getAsList();
        ImmutableList<ThrowingWeaponItem> boomerangs = ModItems.BOOMERANGS.getAsList();
        ImmutableList<SwordBaseItem> battleaxes = ModItems.BATTLEAXES.getAsList();
        ImmutableList<SwordBaseItem> flangedMaces = ModItems.FLANGED_MACES.getAsList();
        ImmutableList<SwordBaseItem> glaives = ModItems.GLAIVES.getAsList();
        ImmutableList<SwordBaseItem> quarterstaves = ModItems.QUARTERSTAVES.getAsList();
        ImmutableList<SwordBaseItem> scythes = ModItems.SCYTHES.getAsList();
        ImmutableList dataList = ImmutableList.of((Object)dataWood, (Object)dataStone, (Object)dataCopper, (Object)dataIron, (Object)dataGold, (Object)dataDiamond, (Object)dataNetherite, (Object)dataTin, (Object)dataBronze, (Object)dataSteel, (Object)dataSilver, (Object)dataElectrum, (Object[])new RecipeData[]{dataLead, dataNickel, dataInvar, dataConstantan, dataPlatinum, dataAluminum});
        for (int i = 0; i < dataList.size(); ++i) {
            RecipeData data = (RecipeData)dataList.get(i);
            if (data.getMaterialTag() == netherite) {
                this.smithingRecipe(recipeFunc, (ItemLike)ModItems.DAGGERS.diamond.get(), (ItemLike)daggers.get(i), data);
                this.smithingRecipe(recipeFunc, (ItemLike)ModItems.PARRYING_DAGGERS.diamond.get(), (ItemLike)parryingDaggers.get(i), data);
                this.smithingRecipe(recipeFunc, (ItemLike)ModItems.LONGSWORDS.diamond.get(), (ItemLike)longswords.get(i), data);
                this.smithingRecipe(recipeFunc, (ItemLike)ModItems.KATANAS.diamond.get(), (ItemLike)katanas.get(i), data);
                this.smithingRecipe(recipeFunc, (ItemLike)ModItems.SABERS.diamond.get(), (ItemLike)sabers.get(i), data);
                this.smithingRecipe(recipeFunc, (ItemLike)ModItems.RAPIERS.diamond.get(), (ItemLike)rapiers.get(i), data);
                this.smithingRecipe(recipeFunc, (ItemLike)ModItems.GREATSWORDS.diamond.get(), (ItemLike)greatswords.get(i), data);
                this.smithingRecipe(recipeFunc, (ItemLike)ModItems.BATTLE_HAMMERS.diamond.get(), (ItemLike)battleHammers.get(i), data);
                this.smithingRecipe(recipeFunc, (ItemLike)ModItems.WARHAMMERS.diamond.get(), (ItemLike)warhammers.get(i), data);
                this.smithingRecipe(recipeFunc, (ItemLike)ModItems.SPEARS.diamond.get(), (ItemLike)spears.get(i), data);
                this.smithingRecipe(recipeFunc, (ItemLike)ModItems.HALBERDS.diamond.get(), (ItemLike)halberds.get(i), data);
                this.smithingRecipe(recipeFunc, (ItemLike)ModItems.PIKES.diamond.get(), (ItemLike)pikes.get(i), data);
                this.smithingRecipe(recipeFunc, (ItemLike)ModItems.LANCES.diamond.get(), (ItemLike)lances.get(i), data);
                this.smithingRecipe(recipeFunc, (ItemLike)ModItems.LONGBOWS.diamond.get(), (ItemLike)longbows.get(i), data);
                this.smithingRecipe(recipeFunc, (ItemLike)ModItems.HEAVY_CROSSBOWS.diamond.get(), (ItemLike)heavyCrossbows.get(i), data);
                this.smithingRecipe(recipeFunc, (ItemLike)ModItems.THROWING_KNIVES.diamond.get(), (ItemLike)throwingKnives.get(i), data);
                this.smithingRecipe(recipeFunc, (ItemLike)ModItems.TOMAHAWKS.diamond.get(), (ItemLike)tomahawks.get(i), data);
                this.smithingRecipe(recipeFunc, (ItemLike)ModItems.JAVELINS.diamond.get(), (ItemLike)javelins.get(i), data);
                this.smithingRecipe(recipeFunc, (ItemLike)ModItems.BOOMERANGS.diamond.get(), (ItemLike)boomerangs.get(i), data);
                this.smithingRecipe(recipeFunc, (ItemLike)ModItems.BATTLEAXES.diamond.get(), (ItemLike)battleaxes.get(i), data);
                this.smithingRecipe(recipeFunc, (ItemLike)ModItems.FLANGED_MACES.diamond.get(), (ItemLike)flangedMaces.get(i), data);
                this.smithingRecipe(recipeFunc, (ItemLike)ModItems.GLAIVES.diamond.get(), (ItemLike)glaives.get(i), data);
                this.smithingRecipe(recipeFunc, (ItemLike)ModItems.QUARTERSTAVES.diamond.get(), (ItemLike)quarterstaves.get(i), data);
                this.smithingRecipe(recipeFunc, (ItemLike)ModItems.SCYTHES.diamond.get(), (ItemLike)scythes.get(i), data);
                continue;
            }
            this.recipeDagger(recipeFunc, (ItemLike)daggers.get(i), data);
            this.recipeParryingDagger(recipeFunc, (ItemLike)parryingDaggers.get(i), data);
            this.recipeLongsword(recipeFunc, (ItemLike)longswords.get(i), data);
            this.recipeKatana(recipeFunc, (ItemLike)katanas.get(i), data);
            this.recipeSaber(recipeFunc, (ItemLike)sabers.get(i), data);
            this.recipeRapier(recipeFunc, (ItemLike)rapiers.get(i), data);
            this.recipeGreatsword(recipeFunc, (ItemLike)greatswords.get(i), data);
            this.recipeBattleHammer(recipeFunc, (ItemLike)battleHammers.get(i), data);
            this.recipeWarhammer(recipeFunc, (ItemLike)warhammers.get(i), data);
            this.recipeSpear(recipeFunc, (ItemLike)spears.get(i), data);
            this.recipeHalberd(recipeFunc, (ItemLike)halberds.get(i), data);
            this.recipePike(recipeFunc, (ItemLike)pikes.get(i), data);
            this.recipeLance(recipeFunc, (ItemLike)lances.get(i), data);
            if (data.getMaterialTag() == stone) {
                this.recipeLongbow(recipeFunc, (TagKey<Item>)stick, (TagKey<Item>)string, (ItemLike)longbows.get(i), dataLeather);
                this.recipeHeavyCrossbow(recipeFunc, (TagKey<Item>)planks, (ItemLike)heavyCrossbows.get(i), dataLeather);
            } else {
                this.recipeLongbow(recipeFunc, (TagKey<Item>)stick, (TagKey<Item>)string, (ItemLike)longbows.get(i), data);
                this.recipeHeavyCrossbow(recipeFunc, (TagKey<Item>)planks, (ItemLike)heavyCrossbows.get(i), data);
            }
            this.recipeThrowingKnife(recipeFunc, (ItemLike)throwingKnives.get(i), data);
            this.recipeTomahawk(recipeFunc, (ItemLike)tomahawks.get(i), data);
            this.recipeJavelin(recipeFunc, (ItemLike)javelins.get(i), data);
            this.recipeBoomerang(recipeFunc, (TagKey<Item>)planks, (ItemLike)boomerangs.get(i), data);
            this.recipeBattleaxe(recipeFunc, (TagKey<Item>)stick, (ItemLike)battleaxes.get(i), data);
            this.recipeFlangedMace(recipeFunc, (TagKey<Item>)stick, (ItemLike)flangedMaces.get(i), data);
            this.recipeGlaive(recipeFunc, (ItemLike)glaives.get(i), data);
            this.recipeQuarterstaff(recipeFunc, (ItemLike)quarterstaves.get(i), data);
            this.recipeScythe(recipeFunc, (ItemLike)scythes.get(i), data);
        }
        ConditionalShapedRecipeBuilder.shaped((ItemLike)ModItems.WOODEN_CLUB.get()).define(Character.valueOf('#'), (TagKey<Item>)woodLog).pattern(" #").pattern("# ").group("spartanweaponry:club").unlockedBy("has_wood_log", (CriterionTriggerInstance)this.hasItem((TagKey<Item>)woodLog)).condition(new TypeDisabledCondition(Collections.singletonList("club"))).save(recipeFunc);
        ConditionalShapedRecipeBuilder.shaped((ItemLike)ModItems.STUDDED_CLUB.get()).define(Character.valueOf('#'), (TagKey<Item>)iron).define(Character.valueOf('C'), (ItemLike)ModItems.WOODEN_CLUB.get()).pattern("C#").group("spartanweaponry:club").unlockedBy("has_club", (CriterionTriggerInstance)this.hasItem((ItemLike)ModItems.WOODEN_CLUB.get())).condition(new TypeDisabledCondition(Collections.singletonList("club"))).save(recipeFunc);
        ConditionalShapedRecipeBuilder.shaped((ItemLike)ModItems.CESTUS.get()).define(Character.valueOf('l'), (TagKey<Item>)leather).define(Character.valueOf('o'), (TagKey<Item>)ItemTags.f_13167_).pattern("lo").group("spartanweaponry:cestus").unlockedBy("has_leather", (CriterionTriggerInstance)this.hasItem((TagKey<Item>)leather)).unlockedBy("has_wool", (CriterionTriggerInstance)this.hasItem((TagKey<Item>)ItemTags.f_13167_)).condition(new TypeDisabledCondition(Collections.singletonList("cestus"))).save(recipeFunc);
        ConditionalShapedRecipeBuilder.shaped((ItemLike)ModItems.STUDDED_CESTUS.get()).define(Character.valueOf('#'), (TagKey<Item>)iron).define(Character.valueOf('C'), (ItemLike)ModItems.CESTUS.get()).pattern("C#").group("spartanweaponry:cestus").unlockedBy("has_cestus", (CriterionTriggerInstance)this.hasItem((ItemLike)ModItems.CESTUS.get())).condition(new TypeDisabledCondition(Collections.singletonList("cestus"))).save(recipeFunc);
        this.recipeArrow(recipeFunc, (TagKey<Item>)planks, (TagKey<Item>)stick, (TagKey<Item>)feathers, (ItemLike)ModItems.WOODEN_ARROW.get());
        TippedProjectileRecipeBuilder.tipped((ItemLike)ModItems.TIPPED_WOODEN_ARROW.get()).input((ItemLike)ModItems.WOODEN_ARROW.get()).save(recipeFunc);
        this.recipeArrow(recipeFunc, (TagKey<Item>)copper, (TagKey<Item>)stick, (TagKey<Item>)feathers, (ItemLike)ModItems.COPPER_ARROW.get(), "copper_ammo");
        TippedProjectileRecipeBuilder.tipped((ItemLike)ModItems.TIPPED_COPPER_ARROW.get()).input((ItemLike)ModItems.COPPER_ARROW.get()).save(recipeFunc);
        this.recipeArrow(recipeFunc, (TagKey<Item>)iron, (TagKey<Item>)stick, (TagKey<Item>)feathers, (ItemLike)ModItems.IRON_ARROW.get());
        TippedProjectileRecipeBuilder.tipped((ItemLike)ModItems.TIPPED_IRON_ARROW.get()).input((ItemLike)ModItems.IRON_ARROW.get()).save(recipeFunc);
        this.recipeArrow(recipeFunc, (TagKey<Item>)diamond, (TagKey<Item>)stick, (TagKey<Item>)feathers, (ItemLike)ModItems.DIAMOND_ARROW.get(), "diamond_ammo");
        TippedProjectileRecipeBuilder.tipped((ItemLike)ModItems.TIPPED_DIAMOND_ARROW.get()).input((ItemLike)ModItems.DIAMOND_ARROW.get()).save(recipeFunc);
        ConditionalShapelessRecipeBuilder.shapeless((ItemLike)ModItems.NETHERITE_ARROW.get(), 8).requires((TagKey<Item>)netherite).requires((ItemLike)ModItems.DIAMOND_ARROW.get(), 8).unlockedBy("has_netherite_ingot", (CriterionTriggerInstance)this.hasItem((TagKey<Item>)netherite)).unlockedBy("has_bow", (CriterionTriggerInstance)this.hasItem((ItemLike)Items.f_42411_)).condition(new TypeDisabledCondition((List<String>)ImmutableList.of((Object)"arrows", (Object)"netherite_ammo"))).save(recipeFunc);
        TippedProjectileRecipeBuilder.tipped((ItemLike)ModItems.TIPPED_NETHERITE_ARROW.get()).input((ItemLike)ModItems.NETHERITE_ARROW.get()).save(recipeFunc);
        ConditionalShapelessRecipeBuilder.shapeless((ItemLike)ModItems.EXPLOSIVE_ARROW.get()).requires((ItemLike)Items.f_42412_).requires((ItemLike)ModItems.EXPLOSIVE_CHARGE.get()).unlockedBy("has_explosive_charge", (CriterionTriggerInstance)this.hasItem((ItemLike)ModItems.EXPLOSIVE_CHARGE.get())).condition(new TypeDisabledCondition((List<String>)ImmutableList.of((Object)"arrows", (Object)"explosives"))).save(recipeFunc);
        this.recipeBolt(recipeFunc, (TagKey<Item>)iron, (TagKey<Item>)ironNugget, (TagKey<Item>)feathers, (ItemLike)ModItems.BOLT.get(), ModItemTags.HEAVY_CROSSBOWS);
        TippedProjectileRecipeBuilder.tipped((ItemLike)ModItems.TIPPED_BOLT.get()).input((ItemLike)ModItems.BOLT.get()).save(recipeFunc);
        ConditionalShapelessRecipeBuilder.shapeless((ItemLike)ModItems.SPECTRAL_BOLT.get()).requires((ItemLike)ModItems.BOLT.get()).requires((ItemLike)Items.f_42525_, 2).unlockedBy("has_glowstone_dust", (CriterionTriggerInstance)this.hasItem((ItemLike)Items.f_42525_)).condition(new TypeDisabledCondition(Collections.singletonList("bolts"))).save(recipeFunc);
        this.recipeBolt(recipeFunc, (TagKey<Item>)copper, (TagKey<Item>)ironNugget, (TagKey<Item>)feathers, (ItemLike)ModItems.COPPER_BOLT.get(), ModItemTags.HEAVY_CROSSBOWS);
        TippedProjectileRecipeBuilder.tipped((ItemLike)ModItems.TIPPED_COPPER_BOLT.get()).input((ItemLike)ModItems.COPPER_BOLT.get()).save(recipeFunc);
        this.recipeBolt(recipeFunc, (TagKey<Item>)diamond, (TagKey<Item>)ironNugget, (TagKey<Item>)feathers, (ItemLike)ModItems.DIAMOND_BOLT.get(), ModItemTags.HEAVY_CROSSBOWS, "diamond_ammo");
        TippedProjectileRecipeBuilder.tipped((ItemLike)ModItems.TIPPED_DIAMOND_BOLT.get()).input((ItemLike)ModItems.DIAMOND_BOLT.get()).save(recipeFunc);
        ConditionalShapelessRecipeBuilder.shapeless((ItemLike)ModItems.NETHERITE_BOLT.get(), 8).requires((TagKey<Item>)netherite).requires((ItemLike)ModItems.DIAMOND_BOLT.get(), 8).unlockedBy("has_netherite_ingot", (CriterionTriggerInstance)this.hasItem((TagKey<Item>)netherite)).unlockedBy("has_heavy_crossbow", (CriterionTriggerInstance)this.hasItem(ModItemTags.HEAVY_CROSSBOWS)).condition(new TypeDisabledCondition((List<String>)ImmutableList.of((Object)"bolts", (Object)"netherite_ammo"))).save(recipeFunc);
        TippedProjectileRecipeBuilder.tipped((ItemLike)ModItems.TIPPED_NETHERITE_BOLT.get()).input((ItemLike)ModItems.NETHERITE_BOLT.get()).save(recipeFunc);
        ConditionalShapedRecipeBuilder.shaped((ItemLike)ModItems.SMALL_ARROW_QUIVER.get()).define(Character.valueOf('L'), (TagKey<Item>)leather).define(Character.valueOf('~'), (TagKey<Item>)string).define(Character.valueOf('^'), (TagKey<Item>)arrows).define(Character.valueOf('#'), (TagKey<Item>)iron).pattern("L~L").pattern("L^L").pattern("###").unlockedBy("has_arrow", (CriterionTriggerInstance)this.hasItem((TagKey<Item>)arrows)).condition(new TypeDisabledCondition(Collections.singletonList("quiver"))).save(recipeFunc);
        this.quiverSmithingRecipe(recipeFunc, (ItemLike)ModItems.SMALL_ARROW_QUIVER.get(), (ItemLike)ModItems.MEDIUM_QUIVER_UPGRADE_KIT.get(), (ItemLike)ModItems.MEDIUM_ARROW_QUIVER.get(), "has_medium_quiver_upgrade_kit");
        this.quiverSmithingRecipe(recipeFunc, (ItemLike)ModItems.MEDIUM_ARROW_QUIVER.get(), (ItemLike)ModItems.LARGE_QUIVER_UPGRADE_KIT.get(), (ItemLike)ModItems.LARGE_ARROW_QUIVER.get(), "has_large_quiver_upgrade_kit");
        this.quiverSmithingRecipe(recipeFunc, (ItemLike)ModItems.LARGE_ARROW_QUIVER.get(), (ItemLike)ModItems.HUGE_QUIVER_UPGRADE_KIT.get(), (ItemLike)ModItems.HUGE_ARROW_QUIVER.get(), "has_huge_quiver_upgrade_kit");
        ConditionalShapedRecipeBuilder.shaped((ItemLike)ModItems.SMALL_BOLT_QUIVER.get()).define(Character.valueOf('L'), (TagKey<Item>)leather).define(Character.valueOf('~'), (TagKey<Item>)string).define(Character.valueOf('^'), (TagKey<Item>)bolts).define(Character.valueOf('#'), (TagKey<Item>)iron).pattern("L~L").pattern("L^L").pattern("###").unlockedBy("has_bolt", (CriterionTriggerInstance)this.hasItem((TagKey<Item>)bolts)).condition(new TypeDisabledCondition((List<String>)ImmutableList.of((Object)"quiver", (Object)"bolts"))).save(recipeFunc);
        this.quiverSmithingRecipe(recipeFunc, (ItemLike)ModItems.SMALL_BOLT_QUIVER.get(), (ItemLike)ModItems.MEDIUM_QUIVER_UPGRADE_KIT.get(), (ItemLike)ModItems.MEDIUM_BOLT_QUIVER.get(), "has_medium_quiver_upgrade_kit");
        this.quiverSmithingRecipe(recipeFunc, (ItemLike)ModItems.MEDIUM_BOLT_QUIVER.get(), (ItemLike)ModItems.LARGE_QUIVER_UPGRADE_KIT.get(), (ItemLike)ModItems.LARGE_BOLT_QUIVER.get(), "has_large_quiver_upgrade_kit");
        this.quiverSmithingRecipe(recipeFunc, (ItemLike)ModItems.LARGE_BOLT_QUIVER.get(), (ItemLike)ModItems.HUGE_QUIVER_UPGRADE_KIT.get(), (ItemLike)ModItems.HUGE_BOLT_QUIVER.get(), "has_huge_quiver_upgrade_kit");
        ConditionalShapedRecipeBuilder.shaped((ItemLike)ModItems.MEDIUM_QUIVER_UPGRADE_KIT.get()).define(Character.valueOf('L'), (TagKey<Item>)leather).define(Character.valueOf('#'), (TagKey<Item>)gold).pattern("L L").pattern("###").unlockedBy("has_gold_ingot", (CriterionTriggerInstance)this.hasItem((TagKey<Item>)gold)).condition(new TypeDisabledCondition(Collections.singletonList("quiver"))).save(recipeFunc);
        ConditionalShapedRecipeBuilder.shaped((ItemLike)ModItems.LARGE_QUIVER_UPGRADE_KIT.get()).define(Character.valueOf('L'), (TagKey<Item>)leather).define(Character.valueOf('#'), (TagKey<Item>)diamond).pattern("L L").pattern("###").unlockedBy("has_diamond", (CriterionTriggerInstance)this.hasItem((TagKey<Item>)diamond)).condition(new TypeDisabledCondition(Collections.singletonList("quiver"))).save(recipeFunc);
        ConditionalShapedRecipeBuilder.shaped((ItemLike)ModItems.HUGE_QUIVER_UPGRADE_KIT.get()).define(Character.valueOf('L'), (TagKey<Item>)leather).define(Character.valueOf('#'), (TagKey<Item>)netherite).pattern("L L").pattern(" # ").unlockedBy("has_netherite_ingot", (CriterionTriggerInstance)this.hasItem((TagKey<Item>)netherite)).condition(new TypeDisabledCondition(Collections.singletonList("quiver"))).save(recipeFunc);
        ConditionalShapedRecipeBuilder.shaped((ItemLike)ModItems.DYNAMITE.get(), 2).define(Character.valueOf('~'), (TagKey<Item>)string).define(Character.valueOf('#'), (ItemLike)ModItems.EXPLOSIVE_CHARGE.get()).pattern("  ~").pattern(" # ").pattern("#  ").unlockedBy("has_explosive_charge", (CriterionTriggerInstance)this.hasItem((ItemLike)ModItems.EXPLOSIVE_CHARGE.get())).condition(new TypeDisabledCondition(Collections.singletonList("explosives"))).save(recipeFunc);
        ItemStack weaponOilBase = OilHelper.makeOilStack((OilEffect)OilEffects.NONE.get());
        ConditionalShapelessRecipeBuilder.shapeless(weaponOilBase, 3).requires((ItemLike)ModItems.GREASE_BALL.get()).requires((ItemLike)Items.f_42590_, 3).unlockedBy("has_greaseball", (CriterionTriggerInstance)this.hasItem((ItemLike)ModItems.GREASE_BALL.get())).condition(new TypeDisabledCondition(Collections.singletonList("oil"))).save(recipeFunc, ForgeRegistries.ITEMS.getKey((Object)weaponOilBase.m_41720_()) + "_base");
        recipeFunc.accept(new FinishedRecipe(){
            private final ResourceLocation ID = new ResourceLocation("spartanweaponry", "apply_oil");

            public void m_7917_(JsonObject p_125967_) {
            }

            public ResourceLocation m_6445_() {
                return this.ID;
            }

            public RecipeSerializer<?> m_6637_() {
                return (RecipeSerializer)ModRecipeSerializers.APPLY_OIL.get();
            }

            public JsonObject m_5860_() {
                return null;
            }

            public ResourceLocation m_6448_() {
                return new ResourceLocation("");
            }
        });
    }

    private void smithingRecipe(Consumer<FinishedRecipe> consumer, ItemLike base, ItemLike result, RecipeData data) {
        UpgradeRecipeBuilder.m_126385_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{base}), (Ingredient)Ingredient.m_204132_(data.getMaterialTag()), (Item)result.m_5456_()).m_126389_(data.getCriterion(), (CriterionTriggerInstance)this.hasItem(data.getMaterialTag())).m_126392_(consumer, ForgeRegistries.ITEMS.getKey((Object)result.m_5456_()) + "_smithing");
    }

    private void recipeDagger(Consumer<FinishedRecipe> consumer, ItemLike result, RecipeData data) {
        String itemDisabledType = data.getDisableType();
        ImmutableList typesDisabled = itemDisabledType == null || itemDisabledType.isEmpty() ? Collections.singletonList("dagger") : ImmutableList.of((Object)"dagger", (Object)itemDisabledType);
        ConditionalShapedRecipeBuilder builder = ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('#'), data.getMaterialTag()).define(Character.valueOf('|'), ModItemTags.HANDLES).pattern("#").pattern("|").group("spartanweaponry:dagger").condition(new TypeDisabledCondition((List<String>)typesDisabled)).unlockedBy(data.getCriterion(), (CriterionTriggerInstance)this.hasItem(data.getMaterialTag()));
        if (data.isModdedMaterial()) {
            builder.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(data.getMaterialTag().f_203868_().toString())));
        }
        builder.save(consumer);
    }

    private void recipeParryingDagger(Consumer<FinishedRecipe> consumer, ItemLike result, RecipeData data) {
        String itemDisabledType = data.getDisableType();
        ImmutableList typesDisabled = itemDisabledType == null || itemDisabledType.isEmpty() ? Collections.singletonList("parrying_dagger") : ImmutableList.of((Object)"parrying_dagger", (Object)itemDisabledType);
        ConditionalShapedRecipeBuilder builder = ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('#'), data.getMaterialTag()).define(Character.valueOf('|'), (ItemLike)ModItems.HANDLE.get()).pattern(" #").pattern("#|").group("spartanweaponry:parrying_dagger").condition(new TypeDisabledCondition((List<String>)typesDisabled)).unlockedBy(data.getCriterion(), (CriterionTriggerInstance)this.hasItem(data.getMaterialTag()));
        if (data.isModdedMaterial()) {
            builder.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(data.getMaterialTag().f_203868_().toString())));
        }
        builder.save(consumer);
    }

    private void recipeLongsword(Consumer<FinishedRecipe> consumer, ItemLike result, RecipeData data) {
        String itemDisabledType = data.getDisableType();
        ImmutableList typesDisabled = itemDisabledType == null || itemDisabledType.isEmpty() ? Collections.singletonList("longsword") : ImmutableList.of((Object)"longsword", (Object)itemDisabledType);
        ConditionalShapedRecipeBuilder builder = ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('#'), data.getMaterialTag()).define(Character.valueOf('|'), (ItemLike)ModItems.HANDLE.get()).pattern(" # ").pattern(" # ").pattern("#|#").group("spartanweaponry:longsword").condition(new TypeDisabledCondition((List<String>)typesDisabled)).unlockedBy(data.getCriterion(), (CriterionTriggerInstance)this.hasItem(data.getMaterialTag()));
        if (data.isModdedMaterial()) {
            builder.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(data.getMaterialTag().f_203868_().toString())));
        }
        builder.save(consumer);
    }

    private void recipeKatana(Consumer<FinishedRecipe> consumer, ItemLike result, RecipeData data) {
        String itemDisabledType = data.getDisableType();
        ImmutableList typesDisabled = itemDisabledType == null || itemDisabledType.isEmpty() ? Collections.singletonList("katana") : ImmutableList.of((Object)"katana", (Object)itemDisabledType);
        ConditionalShapedRecipeBuilder builder = ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('#'), data.getMaterialTag()).define(Character.valueOf('|'), (ItemLike)ModItems.HANDLE.get()).pattern("  #").pattern(" # ").pattern("|  ").group("spartanweaponry:katana").condition(new TypeDisabledCondition((List<String>)typesDisabled)).unlockedBy(data.getCriterion(), (CriterionTriggerInstance)this.hasItem(data.getMaterialTag()));
        if (data.isModdedMaterial()) {
            builder.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(data.getMaterialTag().f_203868_().toString())));
        }
        builder.save(consumer);
    }

    private void recipeSaber(Consumer<FinishedRecipe> consumer, ItemLike result, RecipeData data) {
        String itemDisabledType = data.getDisableType();
        ImmutableList typesDisabled = itemDisabledType == null || itemDisabledType.isEmpty() ? Collections.singletonList("saber") : ImmutableList.of((Object)"saber", (Object)itemDisabledType);
        ConditionalShapedRecipeBuilder builder = ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('#'), data.getMaterialTag()).define(Character.valueOf('|'), (ItemLike)ModItems.HANDLE.get()).pattern(" #").pattern(" #").pattern("#|").group("spartanweaponry:saber").condition(new TypeDisabledCondition((List<String>)typesDisabled)).unlockedBy(data.getCriterion(), (CriterionTriggerInstance)this.hasItem(data.getMaterialTag()));
        if (data.isModdedMaterial()) {
            builder.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(data.getMaterialTag().f_203868_().toString())));
        }
        builder.save(consumer);
    }

    private void recipeRapier(Consumer<FinishedRecipe> consumer, ItemLike result, RecipeData data) {
        String itemDisabledType = data.getDisableType();
        ImmutableList typesDisabled = itemDisabledType == null || itemDisabledType.isEmpty() ? Collections.singletonList("rapier") : ImmutableList.of((Object)"rapier", (Object)itemDisabledType);
        ConditionalShapedRecipeBuilder builder = ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('#'), data.getMaterialTag()).define(Character.valueOf('|'), (ItemLike)ModItems.HANDLE.get()).pattern("  #").pattern("## ").pattern("|# ").group("spartanweaponry:rapier").condition(new TypeDisabledCondition((List<String>)typesDisabled)).unlockedBy(data.getCriterion(), (CriterionTriggerInstance)this.hasItem(data.getMaterialTag()));
        if (data.isModdedMaterial()) {
            builder.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(data.getMaterialTag().f_203868_().toString())));
        }
        builder.save(consumer);
    }

    private void recipeGreatsword(Consumer<FinishedRecipe> consumer, ItemLike result, RecipeData data) {
        String itemDisabledType = data.getDisableType();
        ImmutableList typesDisabled = itemDisabledType == null || itemDisabledType.isEmpty() ? Collections.singletonList("greatsword") : ImmutableList.of((Object)"greatsword", (Object)itemDisabledType);
        ConditionalShapedRecipeBuilder builder = ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('#'), data.getMaterialTag()).define(Character.valueOf('|'), (ItemLike)ModItems.HANDLE.get()).pattern(" # ").pattern("###").pattern("#|#").group("spartanweaponry:greatsword").condition(new TypeDisabledCondition((List<String>)typesDisabled)).unlockedBy(data.getCriterion(), (CriterionTriggerInstance)this.hasItem(data.getMaterialTag()));
        if (data.isModdedMaterial()) {
            builder.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(data.getMaterialTag().f_203868_().toString())));
        }
        builder.save(consumer);
    }

    private void recipeBattleHammer(Consumer<FinishedRecipe> consumer, ItemLike result, RecipeData data) {
        String itemDisabledType = data.getDisableType();
        ImmutableList typesDisabled = itemDisabledType == null || itemDisabledType.isEmpty() ? Collections.singletonList("battle_hammer") : ImmutableList.of((Object)"battle_hammer", (Object)itemDisabledType);
        ConditionalShapedRecipeBuilder builder = ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('#'), data.getMaterialTag()).define(Character.valueOf('|'), (ItemLike)ModItems.HANDLE.get()).pattern("###").pattern("###").pattern(" | ").group("spartanweaponry:battle_hammer").condition(new TypeDisabledCondition((List<String>)typesDisabled)).unlockedBy(data.getCriterion(), (CriterionTriggerInstance)this.hasItem(data.getMaterialTag()));
        if (data.isModdedMaterial()) {
            builder.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(data.getMaterialTag().f_203868_().toString())));
        }
        builder.save(consumer);
    }

    private void recipeWarhammer(Consumer<FinishedRecipe> consumer, ItemLike result, RecipeData data) {
        String itemDisabledType = data.getDisableType();
        ImmutableList typesDisabled = itemDisabledType == null || itemDisabledType.isEmpty() ? Collections.singletonList("warhammer") : ImmutableList.of((Object)"warhammer", (Object)itemDisabledType);
        ConditionalShapedRecipeBuilder builder = ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('#'), data.getMaterialTag()).define(Character.valueOf('|'), (ItemLike)ModItems.HANDLE.get()).pattern(" #").pattern("##").pattern(" |").group("spartanweaponry:warhammer").condition(new TypeDisabledCondition((List<String>)typesDisabled)).unlockedBy(data.getCriterion(), (CriterionTriggerInstance)this.hasItem(data.getMaterialTag()));
        if (data.isModdedMaterial()) {
            builder.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(data.getMaterialTag().f_203868_().toString())));
        }
        builder.save(consumer);
    }

    private void recipeSpear(Consumer<FinishedRecipe> consumer, ItemLike result, RecipeData data) {
        String itemDisabledType = data.getDisableType();
        ImmutableList typesDisabled = itemDisabledType == null || itemDisabledType.isEmpty() ? Collections.singletonList("spear") : ImmutableList.of((Object)"spear", (Object)itemDisabledType);
        ConditionalShapedRecipeBuilder builder = ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('#'), data.getMaterialTag()).define(Character.valueOf('/'), ModItemTags.POLES).pattern("#").pattern("/").group("spartanweaponry:spear").condition(new TypeDisabledCondition((List<String>)typesDisabled)).unlockedBy(data.getCriterion(), (CriterionTriggerInstance)this.hasItem(data.getMaterialTag()));
        if (data.isModdedMaterial()) {
            builder.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(data.getMaterialTag().f_203868_().toString())));
        }
        builder.save(consumer);
    }

    private void recipeHalberd(Consumer<FinishedRecipe> consumer, ItemLike result, RecipeData data) {
        String itemDisabledType = data.getDisableType();
        ImmutableList typesDisabled = itemDisabledType == null || itemDisabledType.isEmpty() ? Collections.singletonList("halberd") : ImmutableList.of((Object)"halberd", (Object)itemDisabledType);
        ConditionalShapedRecipeBuilder builder = ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('#'), data.getMaterialTag()).define(Character.valueOf('/'), (ItemLike)ModItems.POLE.get()).pattern(" #").pattern("##").pattern("#/").group("spartanweaponry:halberd").condition(new TypeDisabledCondition((List<String>)typesDisabled)).unlockedBy(data.getCriterion(), (CriterionTriggerInstance)this.hasItem(data.getMaterialTag()));
        if (data.isModdedMaterial()) {
            builder.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(data.getMaterialTag().f_203868_().toString())));
        }
        builder.save(consumer);
    }

    private void recipePike(Consumer<FinishedRecipe> consumer, ItemLike result, RecipeData data) {
        String itemDisabledType = data.getDisableType();
        ImmutableList typesDisabled = itemDisabledType == null || itemDisabledType.isEmpty() ? Collections.singletonList("pike") : ImmutableList.of((Object)"pike", (Object)itemDisabledType);
        ConditionalShapedRecipeBuilder builder = ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('#'), data.getMaterialTag()).define(Character.valueOf('/'), (ItemLike)ModItems.POLE.get()).pattern("#").pattern("/").pattern("/").group("spartanweaponry:pike").condition(new TypeDisabledCondition((List<String>)typesDisabled)).unlockedBy(data.getCriterion(), (CriterionTriggerInstance)this.hasItem(data.getMaterialTag()));
        if (data.isModdedMaterial()) {
            builder.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(data.getMaterialTag().f_203868_().toString())));
        }
        builder.save(consumer);
    }

    private void recipeLance(Consumer<FinishedRecipe> consumer, ItemLike result, RecipeData data) {
        String itemDisabledType = data.getDisableType();
        ImmutableList typesDisabled = itemDisabledType == null || itemDisabledType.isEmpty() ? Collections.singletonList("lance") : ImmutableList.of((Object)"lance", (Object)itemDisabledType);
        ConditionalShapedRecipeBuilder builder = ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('#'), data.getMaterialTag()).define(Character.valueOf('|'), (ItemLike)ModItems.HANDLE.get()).define(Character.valueOf('/'), (ItemLike)ModItems.POLE.get()).pattern("  #").pattern("#/ ").pattern("|# ").group("spartanweaponry:lance").condition(new TypeDisabledCondition((List<String>)typesDisabled)).unlockedBy(data.getCriterion(), (CriterionTriggerInstance)this.hasItem(data.getMaterialTag()));
        if (data.isModdedMaterial()) {
            builder.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(data.getMaterialTag().f_203868_().toString())));
        }
        builder.save(consumer);
    }

    private void recipeLongbow(Consumer<FinishedRecipe> consumer, TagKey<Item> stick, TagKey<Item> string, ItemLike result, RecipeData data) {
        String itemDisabledType = data.getDisableType();
        ImmutableList typesDisabled = itemDisabledType == null || itemDisabledType.isEmpty() ? Collections.singletonList("longbow") : ImmutableList.of((Object)"longbow", (Object)itemDisabledType);
        ConditionalShapedRecipeBuilder builder = ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('#'), data.getMaterialTag()).define(Character.valueOf('|'), (ItemLike)ModItems.HANDLE.get()).define(Character.valueOf('/'), stick).define(Character.valueOf('~'), string).pattern("|/#").pattern("/ ~").pattern("#~~").group("spartanweaponry:longbow").condition(new TypeDisabledCondition((List<String>)typesDisabled)).unlockedBy(data.getCriterion(), (CriterionTriggerInstance)this.hasItem(data.getMaterialTag()));
        if (data.isModdedMaterial()) {
            builder.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(data.getMaterialTag().f_203868_().toString())));
        }
        builder.save(consumer);
    }

    private void recipeHeavyCrossbow(Consumer<FinishedRecipe> consumer, TagKey<Item> planks, ItemLike result, RecipeData data) {
        String itemDisabledType = data.getDisableType();
        ImmutableList typesDisabled = itemDisabledType == null || itemDisabledType.isEmpty() ? Collections.singletonList("heavy_crossbow") : ImmutableList.of((Object)"heavy_crossbow", (Object)itemDisabledType);
        ConditionalShapedRecipeBuilder builder = ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('#'), data.getMaterialTag()).define(Character.valueOf('|'), (ItemLike)ModItems.HANDLE.get()).define(Character.valueOf('P'), planks).define(Character.valueOf('D'), (ItemLike)Items.f_42411_).define(Character.valueOf('H'), (ItemLike)Items.f_42109_).pattern("#D#").pattern("PHP").pattern(" | ").group("spartanweaponry:heavy_crossbow").condition(new TypeDisabledCondition((List<String>)typesDisabled)).unlockedBy(data.getCriterion(), (CriterionTriggerInstance)this.hasItem(data.getMaterialTag()));
        if (data.isModdedMaterial()) {
            builder.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(data.getMaterialTag().f_203868_().toString())));
        }
        builder.save(consumer);
    }

    private void recipeThrowingKnife(Consumer<FinishedRecipe> consumer, ItemLike result, RecipeData data) {
        String itemDisabledType = data.getDisableType();
        ImmutableList typesDisabled = itemDisabledType == null || itemDisabledType.isEmpty() ? Collections.singletonList("throwing_knife") : ImmutableList.of((Object)"throwing_knife", (Object)itemDisabledType);
        ConditionalShapedRecipeBuilder builder = ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('#'), data.getMaterialTag()).define(Character.valueOf('|'), ModItemTags.HANDLES).pattern("|#").group("spartanweaponry:throwing_knife").condition(new TypeDisabledCondition((List<String>)typesDisabled)).unlockedBy(data.getCriterion(), (CriterionTriggerInstance)this.hasItem(data.getMaterialTag()));
        if (data.isModdedMaterial()) {
            builder.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(data.getMaterialTag().f_203868_().toString())));
        }
        builder.save(consumer);
    }

    private void recipeTomahawk(Consumer<FinishedRecipe> consumer, ItemLike result, RecipeData data) {
        String itemDisabledType = data.getDisableType();
        ImmutableList typesDisabled = itemDisabledType == null || itemDisabledType.isEmpty() ? Collections.singletonList("tomahawk") : ImmutableList.of((Object)"tomahawk", (Object)itemDisabledType);
        ConditionalShapedRecipeBuilder builder = ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('#'), data.getMaterialTag()).define(Character.valueOf('|'), (ItemLike)ModItems.HANDLE.get()).pattern("|#").pattern(" #").group("spartanweaponry:tomahawk").condition(new TypeDisabledCondition((List<String>)typesDisabled)).unlockedBy(data.getCriterion(), (CriterionTriggerInstance)this.hasItem(data.getMaterialTag()));
        if (data.isModdedMaterial()) {
            builder.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(data.getMaterialTag().f_203868_().toString())));
        }
        builder.save(consumer);
    }

    private void recipeJavelin(Consumer<FinishedRecipe> consumer, ItemLike result, RecipeData data) {
        String itemDisabledType = data.getDisableType();
        ImmutableList typesDisabled = itemDisabledType == null || itemDisabledType.isEmpty() ? Collections.singletonList("javelin") : ImmutableList.of((Object)"javelin", (Object)itemDisabledType);
        ConditionalShapedRecipeBuilder builder = ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('#'), data.getMaterialTag()).define(Character.valueOf('/'), (ItemLike)ModItems.POLE.get()).pattern("/#").group("spartanweaponry:javelin").condition(new TypeDisabledCondition((List<String>)typesDisabled)).unlockedBy(data.getCriterion(), (CriterionTriggerInstance)this.hasItem(data.getMaterialTag()));
        if (data.isModdedMaterial()) {
            builder.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(data.getMaterialTag().f_203868_().toString())));
        }
        builder.save(consumer);
    }

    private void recipeBoomerang(Consumer<FinishedRecipe> consumer, TagKey<Item> planks, ItemLike result, RecipeData data) {
        String itemDisabledType = data.getDisableType();
        ImmutableList typesDisabled = itemDisabledType == null || itemDisabledType.isEmpty() ? Collections.singletonList("boomerang") : ImmutableList.of((Object)"boomerang", (Object)itemDisabledType);
        ConditionalShapedRecipeBuilder builder = ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('#'), data.getMaterialTag()).define(Character.valueOf('P'), planks).pattern("#PP").pattern("P  ").pattern("P  ").group("spartanweaponry:boomerang").condition(new TypeDisabledCondition((List<String>)typesDisabled)).unlockedBy(data.getCriterion(), (CriterionTriggerInstance)this.hasItem(data.getMaterialTag()));
        if (data.isModdedMaterial()) {
            builder.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(data.getMaterialTag().f_203868_().toString())));
        }
        builder.save(consumer);
    }

    private void recipeBattleaxe(Consumer<FinishedRecipe> consumer, TagKey<Item> stick, ItemLike result, RecipeData data) {
        String itemDisabledType = data.getDisableType();
        ImmutableList typesDisabled = itemDisabledType == null || itemDisabledType.isEmpty() ? Collections.singletonList("battleaxe") : ImmutableList.of((Object)"battleaxe", (Object)itemDisabledType);
        ConditionalShapedRecipeBuilder builder = ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('#'), data.getMaterialTag()).define(Character.valueOf('|'), (ItemLike)ModItems.HANDLE.get()).define(Character.valueOf('/'), stick).pattern("###").pattern("#/#").pattern(" | ").group("spartanweaponry:battleaxe").condition(new TypeDisabledCondition((List<String>)typesDisabled)).unlockedBy(data.getCriterion(), (CriterionTriggerInstance)this.hasItem(data.getMaterialTag()));
        if (data.isModdedMaterial()) {
            builder.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(data.getMaterialTag().f_203868_().toString())));
        }
        builder.save(consumer);
    }

    private void recipeFlangedMace(Consumer<FinishedRecipe> consumer, TagKey<Item> stick, ItemLike result, RecipeData data) {
        String itemDisabledType = data.getDisableType();
        ImmutableList typesDisabled = itemDisabledType == null || itemDisabledType.isEmpty() ? Collections.singletonList("flanged_mace") : ImmutableList.of((Object)"flanged_mace", (Object)itemDisabledType);
        ConditionalShapedRecipeBuilder builder = ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('#'), data.getMaterialTag()).define(Character.valueOf('|'), (ItemLike)ModItems.HANDLE.get()).define(Character.valueOf('/'), stick).pattern(" ##").pattern(" /#").pattern("|  ").group("spartanweaponry:flanged_mace").condition(new TypeDisabledCondition((List<String>)typesDisabled)).unlockedBy(data.getCriterion(), (CriterionTriggerInstance)this.hasItem(data.getMaterialTag()));
        if (data.isModdedMaterial()) {
            builder.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(data.getMaterialTag().f_203868_().toString())));
        }
        builder.save(consumer);
    }

    private void recipeGlaive(Consumer<FinishedRecipe> consumer, ItemLike result, RecipeData data) {
        String itemDisabledType = data.getDisableType();
        ImmutableList typesDisabled = itemDisabledType == null || itemDisabledType.isEmpty() ? Collections.singletonList("glaive") : ImmutableList.of((Object)"glaive", (Object)itemDisabledType);
        ConditionalShapedRecipeBuilder builder = ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('#'), data.getMaterialTag()).define(Character.valueOf('/'), (ItemLike)ModItems.POLE.get()).pattern(" #").pattern(" #").pattern(" /").group("spartanweaponry:glaive").condition(new TypeDisabledCondition((List<String>)typesDisabled)).unlockedBy(data.getCriterion(), (CriterionTriggerInstance)this.hasItem(data.getMaterialTag()));
        if (data.isModdedMaterial()) {
            builder.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(data.getMaterialTag().f_203868_().toString())));
        }
        builder.save(consumer);
    }

    private void recipeQuarterstaff(Consumer<FinishedRecipe> consumer, ItemLike result, RecipeData data) {
        String itemDisabledType = data.getDisableType();
        ImmutableList typesDisabled = itemDisabledType == null || itemDisabledType.isEmpty() ? Collections.singletonList("quarterstaff") : ImmutableList.of((Object)"quarterstaff", (Object)itemDisabledType);
        ConditionalShapedRecipeBuilder builder = ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('#'), data.getMaterialTag()).define(Character.valueOf('/'), (ItemLike)ModItems.POLE.get()).pattern("  #").pattern(" / ").pattern("#  ").group("spartanweaponry:quarterstaff").condition(new TypeDisabledCondition((List<String>)typesDisabled)).unlockedBy(data.getCriterion(), (CriterionTriggerInstance)this.hasItem(data.getMaterialTag()));
        if (data.isModdedMaterial()) {
            builder.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(data.getMaterialTag().f_203868_().toString())));
        }
        builder.save(consumer);
    }

    private void recipeScythe(Consumer<FinishedRecipe> consumer, ItemLike result, RecipeData data) {
        String itemDisabledType = data.getDisableType();
        ImmutableList typesDisabled = itemDisabledType == null || itemDisabledType.isEmpty() ? Collections.singletonList("scythe") : ImmutableList.of((Object)"scythe", (Object)itemDisabledType);
        ConditionalShapedRecipeBuilder builder = ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('#'), data.getMaterialTag()).define(Character.valueOf('/'), (ItemLike)ModItems.POLE.get()).pattern("## ").pattern("  #").pattern(" / ").group("spartanweaponry:scythe").condition(new TypeDisabledCondition((List<String>)typesDisabled)).unlockedBy(data.getCriterion(), (CriterionTriggerInstance)this.hasItem(data.getMaterialTag()));
        if (data.isModdedMaterial()) {
            builder.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(data.getMaterialTag().f_203868_().toString())));
        }
        builder.save(consumer);
    }

    private void recipeArrow(Consumer<FinishedRecipe> consumer, TagKey<Item> arrowHead, TagKey<Item> stick, TagKey<Item> feather, ItemLike result, String extraDisableType) {
        ConditionalShapedRecipeBuilder.shaped(result, 4).define(Character.valueOf('#'), arrowHead).define(Character.valueOf('|'), stick).define(Character.valueOf('F'), feather).pattern("#").pattern("|").pattern("F").unlockedBy("has_feather", (CriterionTriggerInstance)this.hasItem(feather)).unlockedBy("has_bow", (CriterionTriggerInstance)this.hasItem((ItemLike)Items.f_42411_)).condition(new TypeDisabledCondition((List<String>)ImmutableList.of((Object)"arrows", (Object)extraDisableType))).save(consumer);
    }

    private void recipeArrow(Consumer<FinishedRecipe> consumer, TagKey<Item> arrowHead, TagKey<Item> stick, TagKey<Item> feather, ItemLike result) {
        ConditionalShapedRecipeBuilder.shaped(result, 4).define(Character.valueOf('#'), arrowHead).define(Character.valueOf('|'), stick).define(Character.valueOf('F'), feather).pattern("#").pattern("|").pattern("F").unlockedBy("has_feather", (CriterionTriggerInstance)this.hasItem(feather)).unlockedBy("has_bow", (CriterionTriggerInstance)this.hasItem((ItemLike)Items.f_42411_)).condition(new TypeDisabledCondition(Collections.singletonList("arrows"))).save(consumer);
    }

    private void recipeBolt(Consumer<FinishedRecipe> consumer, TagKey<Item> boltHead, TagKey<Item> stick, TagKey<Item> feather, ItemLike result, TagKey<Item> heavyCrossbows, String extraDisableType) {
        ConditionalShapedRecipeBuilder.shaped(result, 4).define(Character.valueOf('#'), boltHead).define(Character.valueOf('|'), stick).define(Character.valueOf('F'), feather).pattern("  #").pattern(" | ").pattern("F  ").unlockedBy("has_feather", (CriterionTriggerInstance)this.hasItem(feather)).unlockedBy("has_heavy_crossbow", (CriterionTriggerInstance)this.hasItem(heavyCrossbows)).condition(new TypeDisabledCondition((List<String>)ImmutableList.of((Object)"bolts", (Object)extraDisableType))).save(consumer);
    }

    private void recipeBolt(Consumer<FinishedRecipe> consumer, TagKey<Item> boltHead, TagKey<Item> stick, TagKey<Item> feather, ItemLike result, TagKey<Item> heavyCrossbows) {
        ConditionalShapedRecipeBuilder.shaped(result, 4).define(Character.valueOf('#'), boltHead).define(Character.valueOf('|'), stick).define(Character.valueOf('F'), feather).pattern("  #").pattern(" | ").pattern("F  ").unlockedBy("has_feather", (CriterionTriggerInstance)this.hasItem(feather)).unlockedBy("has_heavy_crossbow", (CriterionTriggerInstance)this.hasItem(heavyCrossbows)).condition(new TypeDisabledCondition(Collections.singletonList("bolts"))).save(consumer);
    }

    private void quiverSmithingRecipe(Consumer<FinishedRecipe> consumer, ItemLike base, ItemLike addition, ItemLike result, String criterionName) {
        UpgradeRecipeBuilder recipe = new UpgradeRecipeBuilder((RecipeSerializer)ModRecipeSerializers.QUIVER_UPGRADE_SMITHING.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{base}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{addition}), result.m_5456_());
        recipe.m_126389_(criterionName, (CriterionTriggerInstance)this.hasItem(addition)).m_126392_(consumer, ForgeRegistries.ITEMS.getKey((Object)result.m_5456_()) + "_smithing");
    }

    private InventoryChangeTrigger.TriggerInstance hasItem(TagKey<Item> tag) {
        return this.makeInventoryTrigger(ItemPredicate.Builder.m_45068_().m_204145_(tag).m_45077_());
    }

    private InventoryChangeTrigger.TriggerInstance hasItem(ItemLike item) {
        return this.makeInventoryTrigger(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_());
    }

    private InventoryChangeTrigger.TriggerInstance makeInventoryTrigger(ItemPredicate ... predicates) {
        return new InventoryChangeTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, predicates);
    }

    public String m_6055_() {
        return "Spartan Weaponry Recipes";
    }

    public static class RecipeData {
        private final TagKey<Item> materialTag;
        private final String criterion;
        private final String disableType;
        private final boolean isModdedMaterial;

        public RecipeData(TagKey<Item> materialTagIn, String criterionIn, String disableTypeIn) {
            this.materialTag = materialTagIn;
            this.criterion = criterionIn;
            this.disableType = disableTypeIn;
            this.isModdedMaterial = !disableTypeIn.isEmpty();
        }

        public RecipeData(TagKey<Item> materialTagIn, String criterionIn) {
            this(materialTagIn, criterionIn, "");
        }

        public TagKey<Item> getMaterialTag() {
            return this.materialTag;
        }

        public String getCriterion() {
            return this.criterion;
        }

        public String getDisableType() {
            return this.disableType;
        }

        public boolean isModdedMaterial() {
            return this.isModdedMaterial;
        }
    }
}

