/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.event;

import com.google.common.collect.ImmutableMap;
import com.oblivioussp.spartanweaponry.api.IWeaponTraitContainer;
import com.oblivioussp.spartanweaponry.api.OilEffects;
import com.oblivioussp.spartanweaponry.api.WeaponTraits;
import com.oblivioussp.spartanweaponry.api.oil.OilEffect;
import com.oblivioussp.spartanweaponry.api.tags.ModItemTags;
import com.oblivioussp.spartanweaponry.api.trait.IMeleeTraitCallback;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.capability.IOilHandler;
import com.oblivioussp.spartanweaponry.entity.projectile.ThrowingWeaponEntity;
import com.oblivioussp.spartanweaponry.init.ModCapabilities;
import com.oblivioussp.spartanweaponry.init.ModCriteriaTriggers;
import com.oblivioussp.spartanweaponry.init.ModEnchantments;
import com.oblivioussp.spartanweaponry.init.ModItems;
import com.oblivioussp.spartanweaponry.init.ModMobEffects;
import com.oblivioussp.spartanweaponry.init.ModParticles;
import com.oblivioussp.spartanweaponry.item.QuiverBaseItem;
import com.oblivioussp.spartanweaponry.item.SwordBaseItem;
import com.oblivioussp.spartanweaponry.item.ThrowingWeaponItem;
import com.oblivioussp.spartanweaponry.loot.ModLootTables;
import com.oblivioussp.spartanweaponry.merchant.villager.FletcherTrades;
import com.oblivioussp.spartanweaponry.merchant.villager.WeaponsmithTrades;
import com.oblivioussp.spartanweaponry.util.Config;
import com.oblivioussp.spartanweaponry.util.Log;
import com.oblivioussp.spartanweaponry.util.OilHelper;
import com.oblivioussp.spartanweaponry.util.QuiverHelper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.brewing.PlayerBrewedPotionEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonEventHandler {
    public static Random rand = new Random();
    private static ImmutableMap<Block, Block> conversionMap = ImmutableMap.of((Object)Blocks.f_50034_, (Object)Blocks.f_50016_, (Object)Blocks.f_50359_, (Object)Blocks.f_50034_, (Object)Blocks.f_50037_, (Object)Blocks.f_49990_, (Object)Blocks.f_50038_, (Object)Blocks.f_50037_, (Object)Blocks.f_50035_, (Object)Blocks.f_50016_, (Object)Blocks.f_50360_, (Object)Blocks.f_50035_);

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent ev) {
        DamageSource src = ev.getSource();
        float dmgDealt = ev.getAmount();
        LivingEntity target = ev.getEntity();
        if (dmgDealt == 0.0f || src.m_19360_() || src.m_19384_() || src.m_19372_() || src.m_19387_() || !src.m_19385_().equals("player") && !src.m_19385_().equals("mob")) {
            return;
        }
        if (src.m_7640_() == src.m_7639_() && src.m_7639_() instanceof LivingEntity && target != null) {
            IOilHandler oilHandler;
            IWeaponTraitContainer container;
            Object object;
            LivingEntity attacker = (LivingEntity)src.m_7639_();
            ItemStack attackerStack = attacker.m_21205_();
            ItemStack targetStack = target.m_21205_();
            boolean doTraitDamageParticles = false;
            boolean doOilDamageParticles = false;
            if (!attackerStack.m_41619_() && (object = attackerStack.m_41720_()) instanceof IWeaponTraitContainer) {
                container = (IWeaponTraitContainer)object;
                float dmgUnmodified = dmgDealt;
                for (WeaponTrait trait : container.getAllWeaponTraits()) {
                    Optional<IMeleeTraitCallback> opt = trait.getMeleeCallback();
                    if (!opt.isPresent()) continue;
                    dmgDealt = opt.get().modifyDamageDealt(container.getMaterial(), dmgDealt, src, attacker, target);
                }
                if (dmgDealt > dmgUnmodified) {
                    doTraitDamageParticles = true;
                }
            }
            if (attackerStack.m_41720_() instanceof ThrowingWeaponItem && attackerStack.m_41782_() && attackerStack.m_41783_().m_128451_("AmmoUsed") >= ((ThrowingWeaponItem)attackerStack.m_41720_()).getMaxAmmo(attackerStack)) {
                dmgDealt = 1.0f;
            }
            if (attackerStack.m_204117_(ModItemTags.OILABLE_WEAPONS) && (oilHandler = (IOilHandler)attackerStack.getCapability(ModCapabilities.OIL_CAPABILITY).resolve().get()).isOiled()) {
                float dmgUnmodified = dmgDealt;
                if ((dmgDealt = oilHandler.useEffect(dmgDealt, attacker.f_19853_, target, attacker, attackerStack)) != dmgUnmodified) {
                    doOilDamageParticles = true;
                }
            }
            if (!targetStack.m_41619_() && (object = targetStack.m_41720_()) instanceof IWeaponTraitContainer) {
                container = (IWeaponTraitContainer)object;
                for (WeaponTrait trait : container.getAllWeaponTraits()) {
                    Optional<IMeleeTraitCallback> opt = trait.getMeleeCallback();
                    if (!opt.isPresent()) continue;
                    dmgDealt = opt.get().modifyDamageTaken(container.getMaterial(), dmgDealt, src, attacker, target);
                }
            }
            if (dmgDealt != ev.getAmount()) {
                if (!attacker.f_19853_.f_46443_) {
                    if (doTraitDamageParticles && dmgDealt > ev.getAmount()) {
                        ((ServerLevel)attacker.f_19853_).m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.DAMAGE_BOOSTED.get()), target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_(), 8, 0.2, 0.2, 0.2, 0.5);
                    } else if (dmgDealt < ev.getAmount()) {
                        ((ServerLevel)attacker.f_19853_).m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.DAMAGE_REDUCED.get()), target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_(), 8, 0.2, 0.2, 0.2, 0.5);
                    }
                    if (doOilDamageParticles) {
                        ((ServerLevel)attacker.f_19853_).m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.OIL_DAMAGE_BOOSTED.get()), target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_(), 8, 0.2, 0.2, 0.2, 0.5);
                    }
                }
                ev.setAmount(dmgDealt);
            }
        }
    }

    @SubscribeEvent
    public static void attackEvent(LivingAttackEvent ev) {
        SwordBaseItem weapon;
        ItemStack activeStack;
        Item item;
        Player player;
        LivingEntity livingEntity = ev.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_6117_() && !player.m_21211_().m_41619_() && (item = (activeStack = player.m_21211_()).m_41720_()) instanceof SwordBaseItem && (weapon = (SwordBaseItem)item).hasWeaponTrait((WeaponTrait)WeaponTraits.BLOCK_MELEE.get())) {
            DamageSource source = ev.getSource();
            boolean damageItem = false;
            if (!(source.m_19372_() || source.m_19384_() || source.m_19387_() || source.m_19360_() || source.m_19376_())) {
                Entity trueSourceEntity = source.m_7639_();
                if (trueSourceEntity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)source.m_7639_();
                    living.m_147240_((double)0.3f, player.m_20185_() - living.m_20185_(), player.m_20189_() - living.m_20189_());
                }
                damageItem = true;
            }
            if (damageItem) {
                int itemDamage = 1 + Mth.m_14143_((float)ev.getAmount());
                activeStack.m_41622_(itemDamage, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(playerEntity.m_7655_()));
                player.f_19853_.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12314_, SoundSource.PLAYERS, 0.8f, 0.8f);
                ev.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void modifyLootLevel(LootingLevelEvent ev) {
        if (ev.getDamageSource() == null) {
            return;
        }
        Entity e = ev.getDamageSource().m_7640_();
        if (e != null && e instanceof ThrowingWeaponEntity) {
            ThrowingWeaponEntity throwingWeapon = (ThrowingWeaponEntity)e;
            int luckLevel = throwingWeapon.getWeaponItem().getEnchantmentLevel((Enchantment)ModEnchantments.LUCKY_THROW.get());
            ev.setLootingLevel(luckLevel);
        }
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent ev) {
        LivingEntity livingEntity;
        if ((ev.getSlot() == EquipmentSlot.MAINHAND || ev.getSlot() == EquipmentSlot.OFFHAND) && (livingEntity = ev.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack fromStack = ev.getFrom();
            ItemStack toStack = ev.getTo();
            EquipmentSlot oppositeHand = ev.getSlot() == EquipmentSlot.OFFHAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            ItemStack oppositeStack = player.m_6844_(oppositeHand);
            if (!ItemStack.m_41746_((ItemStack)fromStack, (ItemStack)toStack) && !oppositeStack.m_41619_()) {
                boolean toStackBlacklisted = false;
                String toName = ForgeRegistries.ITEMS.getKey((Object)toStack.m_41720_()).toString();
                if (((List)Config.INSTANCE.quiverBowBlacklist.get()).contains(toName)) {
                    toStackBlacklisted = true;
                }
                for (QuiverHelper.IQuiverInfo quiverInfo : QuiverHelper.info) {
                    if (!quiverInfo.isWeapon(fromStack) || quiverInfo.isWeapon(toStack) && !toStackBlacklisted || !quiverInfo.isAmmo(oppositeStack)) continue;
                    ItemStack quiver = QuiverHelper.findFirstOfType(player, quiverInfo);
                    CommonEventHandler.placeAmmoIntoQuiver(player, quiver, oppositeHand);
                    oppositeStack = player.m_6844_(oppositeHand);
                    if (!oppositeStack.m_41619_()) continue;
                    CompoundTag nbt = quiver.m_41737_("OffhandMoved");
                    if (nbt == null) break;
                    String itemId = nbt.m_128461_("Id");
                    int itemSlot = nbt.m_128451_("Slot");
                    ItemStack offhandStack = player.m_150109_().m_8020_(itemSlot);
                    if (ForgeRegistries.ITEMS.getKey((Object)offhandStack.m_41720_()).toString().equals(itemId)) {
                        player.m_8061_(oppositeHand, offhandStack);
                        player.m_150109_().m_6836_(itemSlot, ItemStack.f_41583_);
                    }
                    quiver.m_41783_().m_128473_("OffhandMoved");
                    break;
                }
            }
            if (!ItemStack.m_41746_((ItemStack)toStack, (ItemStack)fromStack)) {
                String regName = ForgeRegistries.ITEMS.getKey((Object)toStack.m_41720_()).toString();
                if (((List)Config.INSTANCE.quiverBowBlacklist.get()).contains(regName)) {
                    return;
                }
                for (QuiverHelper.IQuiverInfo quiverInfo : QuiverHelper.info) {
                    ItemStack quiver;
                    if (!quiverInfo.isWeapon(toStack) || (quiver = QuiverHelper.findFirstOfType(player, quiverInfo)).m_41619_()) continue;
                    IItemHandler quiverHandler = (IItemHandler)quiver.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().orElseThrow();
                    boolean isQuiverEmpty = true;
                    for (int i = 0; i < quiverHandler.getSlots(); ++i) {
                        ItemStack arrowStack = quiverHandler.getStackInSlot(i);
                        if (arrowStack.m_41619_()) continue;
                        isQuiverEmpty = false;
                        break;
                    }
                    if (!(isQuiverEmpty || oppositeStack.m_41619_() || quiverInfo.isAmmo(oppositeStack))) {
                        int emptySlot = -1;
                        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                            ItemStack playerStack = (ItemStack)player.m_150109_().f_35974_.get(i);
                            if (!playerStack.m_41619_()) continue;
                            emptySlot = i;
                            break;
                        }
                        if (emptySlot != -1) {
                            String itemId = ForgeRegistries.ITEMS.getKey((Object)oppositeStack.m_41720_()).toString();
                            CompoundTag nbt = quiver.m_41698_("OffhandMoved");
                            nbt.m_128359_("Id", itemId);
                            nbt.m_128405_("Slot", emptySlot);
                            player.m_150109_().m_6836_(emptySlot, oppositeStack);
                            player.m_8061_(oppositeHand, ItemStack.f_41583_);
                        }
                    }
                    if (player.m_6844_(oppositeHand).m_41619_()) {
                        CommonEventHandler.takeAmmoFromQuiver(player, quiver, oppositeHand);
                    }
                    if ((oppositeStack = player.m_6844_(oppositeHand)).m_41619_()) continue;
                    break;
                }
            }
        }
    }

    protected static void placeAmmoIntoQuiver(Player player, ItemStack quiver, EquipmentSlot oppositeHandSlot) {
        if (!quiver.m_41619_()) {
            IItemHandler quiverHandler = (IItemHandler)quiver.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().orElseThrow();
            ItemStack arrowStack = player.m_6844_(oppositeHandSlot);
            int prioritySlot = quiver.m_41784_().m_128451_("PrioritySlot");
            arrowStack = quiverHandler.insertItem(prioritySlot, arrowStack, false);
            if (!arrowStack.m_41619_()) {
                for (int j = 0; !(j >= quiverHandler.getSlots() || j != prioritySlot && (arrowStack = quiverHandler.insertItem(j, arrowStack, false)).m_41619_()); ++j) {
                }
            }
            player.m_8061_(oppositeHandSlot, arrowStack);
        }
    }

    protected static void takeAmmoFromQuiver(Player player, ItemStack quiver, EquipmentSlot oppositeHandSlot) {
        if (!quiver.m_41619_()) {
            IItemHandler quiverHandler = (IItemHandler)quiver.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().orElseThrow();
            ItemStack arrowStack = ItemStack.f_41583_;
            int prioritySlot = quiver.m_41784_().m_128451_("PrioritySlot");
            arrowStack = quiverHandler.extractItem(prioritySlot, 64, false);
            if (!arrowStack.m_41619_()) {
                player.m_8061_(oppositeHandSlot, arrowStack);
                return;
            }
            for (int j = 0; j < quiverHandler.getSlots(); ++j) {
                if (j == prioritySlot || (arrowStack = quiverHandler.extractItem(j, 64, false)).m_41619_()) continue;
                player.m_8061_(oppositeHandSlot, arrowStack);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerPickup(EntityItemPickupEvent ev) {
        Item item;
        int i;
        int beforeCount;
        ItemStack pickedUpStack = ev.getItem().m_32055_().m_41777_();
        int afterCount = beforeCount = pickedUpStack.m_41613_();
        Player player = ev.getEntity();
        List<ItemStack> quivers = QuiverHelper.findValidQuivers(player);
        if (!quivers.isEmpty()) {
            for (ItemStack itemStack : quivers) {
                if (!pickedUpStack.m_41619_() && !itemStack.m_41619_() && ((QuiverBaseItem)itemStack.m_41720_()).isAmmoValid(pickedUpStack, itemStack) && itemStack.m_41784_().m_128471_("AmmoCollect")) {
                    IItemHandler quiverHandler = (IItemHandler)itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().orElseThrow();
                    for (i = 0; i < quiverHandler.getSlots(); ++i) {
                        pickedUpStack = quiverHandler.insertItem(i, pickedUpStack, false);
                    }
                }
                if (!pickedUpStack.m_41619_()) continue;
                break;
            }
            if ((afterCount = pickedUpStack.m_41613_()) < beforeCount) {
                player.m_7938_((Entity)ev.getItem(), beforeCount - afterCount);
                ev.getItem().m_32055_().m_41764_(afterCount);
                player.f_19853_.m_6263_((Player)null, ev.getItem().m_20185_(), ev.getItem().m_20186_(), ev.getItem().m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, (rand.nextFloat() - rand.nextFloat()) * 0.7f + 0.0f);
            }
        }
        if ((item = pickedUpStack.m_41720_()) instanceof ThrowingWeaponItem) {
            boolean bl;
            ThrowingWeaponItem throwingWeapon = (ThrowingWeaponItem)item;
            boolean bl2 = true;
            boolean removeItems = false;
            for (i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack slotStack = player.m_150109_().m_8020_(i);
                if (!ItemStack.m_41758_((ItemStack)slotStack, (ItemStack)pickedUpStack) || !pickedUpStack.m_41782_() || !slotStack.m_41782_() || !slotStack.m_41783_().m_128403_("UUID") || !pickedUpStack.m_41783_().m_128403_("UUID") || !pickedUpStack.m_41783_().m_128342_("UUID").equals(slotStack.m_41783_().m_128342_("UUID"))) continue;
                int maxAmmo = throwingWeapon.getMaxAmmo(slotStack);
                int currentAmmo = maxAmmo - slotStack.m_41783_().m_128451_("AmmoUsed");
                boolean currentNotOriginalStack = !slotStack.m_41783_().m_128471_("Original");
                boolean pickedUpOriginalStack = pickedUpStack.m_41783_().m_128471_("Original");
                if (currentAmmo >= maxAmmo && (!currentNotOriginalStack || !pickedUpOriginalStack)) continue;
                int itemDamage = slotStack.m_41773_() + pickedUpStack.m_41773_();
                if (itemDamage > slotStack.m_41776_()) {
                    itemDamage -= slotStack.m_41776_() + 1;
                } else {
                    currentAmmo += maxAmmo - pickedUpStack.m_41783_().m_128451_("AmmoUsed");
                    currentAmmo = Mth.m_14045_((int)currentAmmo, (int)0, (int)maxAmmo);
                    slotStack.m_41783_().m_128405_("AmmoUsed", maxAmmo - currentAmmo);
                    if (currentNotOriginalStack && pickedUpOriginalStack) {
                        slotStack.m_41783_().m_128379_("Original", pickedUpOriginalStack);
                        if (pickedUpStack.m_41793_()) {
                            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)pickedUpStack);
                            EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)slotStack);
                        }
                    }
                }
                slotStack.m_41721_(itemDamage);
                bl = false;
                removeItems = true;
                break;
            }
            if (bl) {
                removeItems = player.m_150109_().m_36054_(pickedUpStack);
            }
            if (removeItems) {
                player.m_7938_((Entity)player, 1);
                player.f_19853_.m_6263_((Player)null, ev.getItem().m_20185_(), ev.getItem().m_20186_(), ev.getItem().m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, (rand.nextFloat() - rand.nextFloat()) * 0.7f + 0.0f);
                ev.getItem().m_32055_().m_41764_(0);
            }
        }
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent ev) {
        if (((Boolean)Config.INSTANCE.addIronWeaponsToVillageWeaponsmith.get()).booleanValue() && ev.getName().equals((Object)BuiltInLootTables.f_78743_)) {
            Log.info("Adding Iron Weapons to the Village Weaponsmith Loot Table!");
            ev.getTable().addPool(CommonEventHandler.generateLootPool(ModLootTables.INJECT_VILLAGE_WEAPONSMITH));
        } else if (((Boolean)Config.INSTANCE.addBowAndCrossbowLootToVillageFletcher.get()).booleanValue() && ev.getName().equals((Object)BuiltInLootTables.f_78750_)) {
            Log.info("Adding Longbow and Heavy Crossbow related loot to the Village Fletcher Loot Table!");
            ev.getTable().addPool(CommonEventHandler.generateLootPool(ModLootTables.INJECT_VILLAGE_FLETCHER));
        } else if (((Boolean)Config.INSTANCE.addDiamondWeaponsToEndCity.get()).booleanValue() && ev.getName().equals((Object)BuiltInLootTables.f_78741_)) {
            Log.info("Adding Diamond Weapons to the End City Treasure Loot Table!");
            ev.getTable().addPool(CommonEventHandler.generateLootPool(ModLootTables.INJECT_END_CITY_TREASURE));
        }
    }

    private static LootPool generateLootPool(ResourceLocation lootName) {
        return LootPool.m_79043_().m_79076_(CommonEventHandler.generateLootEntry(lootName)).m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).name("spartanweaponry_inject").m_79082_();
    }

    private static LootPoolEntryContainer.Builder<?> generateLootEntry(ResourceLocation lootName) {
        return LootTableReference.m_79776_((ResourceLocation)lootName).m_79707_(1);
    }

    @SubscribeEvent
    public static void addVillagerTrades(VillagerTradesEvent ev) {
        if (((Boolean)Config.INSTANCE.disableVillagerTrading.get()).booleanValue()) {
            return;
        }
        if (ev.getType() == VillagerProfession.f_35599_) {
            List tradesLv1 = (List)ev.getTrades().get(1);
            List tradesLv2 = (List)ev.getTrades().get(2);
            List tradesLv3 = (List)ev.getTrades().get(3);
            List tradesLv4 = (List)ev.getTrades().get(4);
            List tradesLv5 = (List)ev.getTrades().get(5);
            if (!WeaponsmithTrades.LVL1_ITEMS.isEmpty()) {
                tradesLv1.add(WeaponsmithTrades.LVL1_TRADE);
            }
            if (!WeaponsmithTrades.LVL2_ITEMS.isEmpty()) {
                tradesLv2.add(WeaponsmithTrades.LVL2_TRADE);
            }
            if (!WeaponsmithTrades.LVL3_ITEMS.isEmpty()) {
                tradesLv3.add(WeaponsmithTrades.LVL3_TRADE);
            }
            if (!WeaponsmithTrades.LVL4_ITEMS.isEmpty()) {
                tradesLv4.add(WeaponsmithTrades.LVL4_TRADE);
            }
            if (!WeaponsmithTrades.LVL5_ITEMS.isEmpty()) {
                tradesLv5.add(WeaponsmithTrades.LVL5_TRADE);
            }
        } else if (ev.getType() == VillagerProfession.f_35592_) {
            List tradesLv1 = (List)ev.getTrades().get(1);
            List tradesLv3 = (List)ev.getTrades().get(3);
            List tradesLv5 = (List)ev.getTrades().get(5);
            if (!((Boolean)Config.INSTANCE.longbows.disableRecipes.get()).booleanValue()) {
                tradesLv1.add(FletcherTrades.LONGBOW_WOOD_TRADE);
            }
            if (!((Boolean)Config.INSTANCE.longbows.disableRecipes.get()).booleanValue()) {
                tradesLv3.add(FletcherTrades.LONGBOW_IRON_TRADE);
            }
            if (!((Boolean)Config.INSTANCE.heavyCrossbows.disableRecipes.get()).booleanValue()) {
                tradesLv3.add(FletcherTrades.HEAVY_CROSSBOW_TRADE);
            }
            if (!((Boolean)Config.INSTANCE.heavyCrossbows.disableRecipes.get()).booleanValue()) {
                tradesLv3.add(FletcherTrades.BOLT_TRADE);
            }
            if (!((Boolean)Config.INSTANCE.longbows.disableRecipes.get()).booleanValue()) {
                tradesLv5.add(FletcherTrades.ENCHANTED_DIAMOND_LONGBOW_TRADE);
            }
            if (!((Boolean)Config.INSTANCE.heavyCrossbows.disableRecipes.get()).booleanValue()) {
                tradesLv5.add(FletcherTrades.ENCHANTED_DIAMOND_HEAVY_CROSSBOW_TRADE);
            }
        }
    }

    @SubscribeEvent
    public static void onEnderTeleport(EntityTeleportEvent.EnderEntity ev) {
        ev.setCanceled(CommonEventHandler.checkToCancelTeleport(ev.getEntityLiving()));
    }

    @SubscribeEvent
    public static void onEnderTeleport(EntityTeleportEvent.EnderPearl ev) {
        ev.setCanceled(CommonEventHandler.checkToCancelTeleport((LivingEntity)ev.getPlayer()));
    }

    @SubscribeEvent
    public static void onEnderTeleport(EntityTeleportEvent.ChorusFruit ev) {
        ev.setCanceled(CommonEventHandler.checkToCancelTeleport(ev.getEntityLiving()));
    }

    public static boolean checkToCancelTeleport(LivingEntity teleportingEntity) {
        return teleportingEntity.m_21023_((MobEffect)ModMobEffects.ENDER_DISRPUTION.get());
    }

    @SubscribeEvent
    public static void handleAnvilUpdate(AnvilUpdateEvent ev) {
        ItemStack left = ev.getLeft();
        ItemStack right = ev.getRight();
        if (left.m_41720_() instanceof ThrowingWeaponItem && left.m_41782_() && left.m_41783_().m_128471_("Original") && ItemStack.m_41758_((ItemStack)left, (ItemStack)right)) {
            ThrowingWeaponItem throwingWeapon = (ThrowingWeaponItem)left.m_41720_();
            int leftAmmo = left.m_41783_().m_128451_("AmmoUsed");
            int rightAmmo = right.m_41783_().m_128451_("AmmoUsed");
            if (leftAmmo == 0) {
                return;
            }
            int maxAmmo = ((ThrowingWeaponItem)left.m_41720_()).getMaxAmmo(left);
            int durability = left.m_41773_() + right.m_41773_();
            int combinedAmmo = Mth.m_14045_((int)(maxAmmo - leftAmmo + (maxAmmo - rightAmmo)), (int)0, (int)throwingWeapon.getMaxAmmo(left));
            if (durability > left.m_41776_()) {
                combinedAmmo = Math.max(combinedAmmo - 1, 0);
                durability -= left.m_41776_();
            }
            ItemStack resultStack = ev.getLeft().m_41777_();
            resultStack.m_41783_().m_128405_("AmmoUsed", maxAmmo - combinedAmmo);
            resultStack.m_41721_(durability);
            Map enchantmentMap = EnchantmentHelper.m_44831_((ItemStack)left);
            int cost = 1;
            for (Map.Entry enchantment : enchantmentMap.entrySet()) {
                cost += ((Integer)enchantment.getValue()).intValue();
            }
            ev.setCost(cost);
            ev.setOutput(resultStack);
        }
    }

    @SubscribeEvent
    public static void onBrewPotion(PlayerBrewedPotionEvent ev) {
        ItemStack stack = ev.getStack();
        OilEffect oil = (OilEffect)OilEffects.NONE.get();
        if (stack.m_150930_((Item)ModItems.WEAPON_OIL.get()) && (oil = OilHelper.getOilFromStack(stack)) != OilEffects.NONE.get()) {
            ModCriteriaTriggers.BREW_OIL.trigger((ServerPlayer)ev.getEntity(), oil);
        }
    }

    @SubscribeEvent
    public static void onItemRightClick(PlayerInteractEvent.RightClickBlock ev) {
        BlockPos pos;
        InteractionHand hand;
        Player player = ev.getEntity();
        ItemStack stack = player.m_21120_(hand = ev.getHand());
        if (!stack.m_204117_(Tags.Items.RODS_WOODEN) || player.m_36335_().m_41519_(stack.m_41720_())) {
            return;
        }
        Level level = ev.getLevel();
        BlockState state = level.m_8055_(pos = ev.getPos());
        Block block = state.m_60734_();
        Block blockTo = (Block)conversionMap.get((Object)block);
        if (blockTo != null) {
            if ((block == Blocks.f_50359_ || block == Blocks.f_50038_ || block == Blocks.f_50360_) && state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.UPPER) {
                pos = pos.m_7495_();
                state = level.m_8055_(pos);
            }
            player.m_36335_().m_41524_(stack.m_41720_(), 5);
            stack.m_41774_(1);
            if (stack.m_41613_() <= 0) {
                stack = ItemStack.f_41583_;
                player.m_21008_(hand, stack);
            }
            stack = new ItemStack((ItemLike)ModItems.SIMPLE_HANDLE.get());
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack);
            level.m_7731_(pos, blockTo.m_49966_(), 35);
            level.m_5898_(player, 2001, pos, Block.m_49956_((BlockState)state));
            ev.setCancellationResult(InteractionResult.CONSUME);
        }
    }
}

