/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.init;

import com.google.common.collect.ImmutableList;
import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.enchantment.EnchantmentSW;
import com.oblivioussp.spartanweaponry.init.ModBlocks;
import com.oblivioussp.spartanweaponry.item.ArrowBaseItem;
import com.oblivioussp.spartanweaponry.item.ArrowBaseTippedItem;
import com.oblivioussp.spartanweaponry.item.ArrowExplosiveItem;
import com.oblivioussp.spartanweaponry.item.BasicItem;
import com.oblivioussp.spartanweaponry.item.BoltItem;
import com.oblivioussp.spartanweaponry.item.BoltSpectralItem;
import com.oblivioussp.spartanweaponry.item.BoltTippedItem;
import com.oblivioussp.spartanweaponry.item.DynamiteItem;
import com.oblivioussp.spartanweaponry.item.ExtendedSkullItem;
import com.oblivioussp.spartanweaponry.item.QuiverArrowItem;
import com.oblivioussp.spartanweaponry.item.QuiverBoltItem;
import com.oblivioussp.spartanweaponry.item.SwordBaseItem;
import com.oblivioussp.spartanweaponry.item.ThrowingWeaponItem;
import com.oblivioussp.spartanweaponry.item.WeaponOilItem;
import com.oblivioussp.spartanweaponry.util.WeaponArchetype;
import com.oblivioussp.spartanweaponry.util.WeaponFactory;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ModItems {
    public static final DeferredRegister<Item> REGISTRY = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.ITEMS, (String)"spartanweaponry");
    public static final CreativeModeTab TAB_SW = new CreativeModeTab("spartanweaponry.basic"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ModItems.LONGSWORDS.diamond.get());
        }
    }.m_40781_(new EnchantmentCategory[]{EnchantmentSW.TYPE_THROWING_WEAPON, EnchantmentSW.TYPE_HEAVY_CROSSBOW, EnchantmentSW.TYPE_BOOMERANG});
    public static final CreativeModeTab TAB_SW_MODDED = new CreativeModeTab("spartanweaponry.modded"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ModItems.GREATSWORDS.bronze.get());
        }
    };
    public static final CreativeModeTab TAB_SW_ARROWS_BOLTS = new CreativeModeTab("spartanweaponry.arrows_bolts"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)DIAMOND_ARROW.get());
        }
    };
    public static final RegistryObject<Item> SIMPLE_HANDLE = REGISTRY.register("simple_handle", () -> new BasicItem(new Item.Properties().m_41491_(TAB_SW)));
    public static final RegistryObject<Item> HANDLE = REGISTRY.register("handle", () -> new BasicItem(new Item.Properties().m_41491_(TAB_SW)));
    public static final RegistryObject<Item> SIMPLE_POLE = REGISTRY.register("simple_pole", () -> new BasicItem(new Item.Properties().m_41491_(TAB_SW)));
    public static final RegistryObject<Item> POLE = REGISTRY.register("pole", () -> new BasicItem(new Item.Properties().m_41491_(TAB_SW)));
    public static final RegistryObject<Item> EXPLOSIVE_CHARGE = REGISTRY.register("explosive_charge", () -> new BasicItem(new Item.Properties().m_41491_(TAB_SW)));
    public static final RegistryObject<Item> GREASE_BALL = REGISTRY.register("grease_ball", () -> new BasicItem(new Item.Properties().m_41491_(TAB_SW)));
    public static final WeaponItemsMelee DAGGERS = new WeaponItemsMelee(REGISTRY, "dagger", WeaponFactory.DAGGER);
    public static final WeaponItemsMelee PARRYING_DAGGERS = new WeaponItemsMelee(REGISTRY, "parrying_dagger", WeaponFactory.PARRYING_DAGGER);
    public static final WeaponItemsMelee LONGSWORDS = new WeaponItemsMelee(REGISTRY, "longsword", WeaponFactory.LONGSWORD);
    public static final WeaponItemsMelee KATANAS = new WeaponItemsMelee(REGISTRY, "katana", WeaponFactory.KATANA);
    public static final WeaponItemsMelee SABERS = new WeaponItemsMelee(REGISTRY, "saber", WeaponFactory.SABER);
    public static final WeaponItemsMelee RAPIERS = new WeaponItemsMelee(REGISTRY, "rapier", WeaponFactory.RAPIER);
    public static final WeaponItemsMelee GREATSWORDS = new WeaponItemsMelee(REGISTRY, "greatsword", WeaponFactory.GREATSWORD);
    public static final RegistryObject<Item> WOODEN_CLUB = REGISTRY.register("wooden_club", () -> new SwordBaseItem(new Item.Properties().m_41491_(TAB_SW), WeaponMaterial.WOOD, WeaponArchetype.CLUB, 4.0f, 1.0f, 1.3f));
    public static final RegistryObject<Item> STUDDED_CLUB = REGISTRY.register("studded_club", () -> new SwordBaseItem(new Item.Properties().m_41491_(TAB_SW), WeaponMaterial.IRON, WeaponArchetype.CLUB, 4.0f, 1.0f, 1.3f));
    public static final RegistryObject<Item> CESTUS = REGISTRY.register("cestus", () -> new SwordBaseItem(new Item.Properties().m_41491_(TAB_SW), WeaponMaterial.LEATHER, WeaponArchetype.CESTUS, 2.0f, 0.5f, 3.5));
    public static final RegistryObject<Item> STUDDED_CESTUS = REGISTRY.register("studded_cestus", () -> new SwordBaseItem(new Item.Properties().m_41491_(TAB_SW), WeaponMaterial.IRON, WeaponArchetype.CESTUS, 2.0f, 0.5f, 3.5));
    public static final WeaponItemsMelee BATTLE_HAMMERS = new WeaponItemsMelee(REGISTRY, "battle_hammer", WeaponFactory.BATTLE_HAMMER);
    public static final WeaponItemsMelee WARHAMMERS = new WeaponItemsMelee(REGISTRY, "warhammer", WeaponFactory.WARHAMMER);
    public static final WeaponItemsMelee SPEARS = new WeaponItemsMelee(REGISTRY, "spear", WeaponFactory.SPEAR);
    public static final WeaponItemsMelee HALBERDS = new WeaponItemsMelee(REGISTRY, "halberd", WeaponFactory.HALBERD);
    public static final WeaponItemsMelee PIKES = new WeaponItemsMelee(REGISTRY, "pike", WeaponFactory.PIKE);
    public static final WeaponItemsMelee LANCES = new WeaponItemsMelee(REGISTRY, "lance", WeaponFactory.LANCE);
    public static final WeaponItemsRanged LONGBOWS = new WeaponItemsRanged(REGISTRY, "longbow", WeaponFactory.LONGBOW);
    public static final WeaponItemsRanged HEAVY_CROSSBOWS = new WeaponItemsRanged(REGISTRY, "heavy_crossbow", WeaponFactory.HEAVY_CROSSBOW);
    public static final WeaponItemsThrowing THROWING_KNIVES = new WeaponItemsThrowing(REGISTRY, "throwing_knife", WeaponFactory.THROWING_KNIFE);
    public static final WeaponItemsThrowing TOMAHAWKS = new WeaponItemsThrowing(REGISTRY, "tomahawk", WeaponFactory.TOMAHAWK);
    public static final WeaponItemsThrowing JAVELINS = new WeaponItemsThrowing(REGISTRY, "javelin", WeaponFactory.JAVELIN);
    public static final WeaponItemsThrowing BOOMERANGS = new WeaponItemsThrowing(REGISTRY, "boomerang", WeaponFactory.BOOMERANG);
    public static final WeaponItemsMelee BATTLEAXES = new WeaponItemsMelee(REGISTRY, "battleaxe", WeaponFactory.BATTLEAXE);
    public static final WeaponItemsMelee FLANGED_MACES = new WeaponItemsMelee(REGISTRY, "flanged_mace", WeaponFactory.FLANGED_MACE);
    public static final WeaponItemsMelee GLAIVES = new WeaponItemsMelee(REGISTRY, "glaive", WeaponFactory.GLAIVE);
    public static final WeaponItemsMelee QUARTERSTAVES = new WeaponItemsMelee(REGISTRY, "quarterstaff", WeaponFactory.QUARTERSTAFF);
    public static final WeaponItemsMelee SCYTHES = new WeaponItemsMelee(REGISTRY, "scythe", WeaponFactory.SCYTHE);
    public static final RegistryObject<ArrowBaseItem> WOODEN_ARROW = REGISTRY.register("wooden_arrow", () -> new ArrowBaseItem(0.2f, 1.5f));
    public static final RegistryObject<ArrowBaseItem> TIPPED_WOODEN_ARROW = REGISTRY.register("tipped_wooden_arrow", () -> new ArrowBaseTippedItem("wooden_arrow", 0.2f, 1.5f));
    public static final RegistryObject<ArrowBaseItem> COPPER_ARROW = REGISTRY.register("copper_arrow", () -> new ArrowBaseItem(2.5f, 0.85f));
    public static final RegistryObject<ArrowBaseItem> TIPPED_COPPER_ARROW = REGISTRY.register("tipped_copper_arrow", () -> new ArrowBaseTippedItem("copper_arrow", 2.5f, 0.85f));
    public static final RegistryObject<ArrowBaseItem> IRON_ARROW = REGISTRY.register("iron_arrow", () -> new ArrowBaseItem(3.0f, 0.75f));
    public static final RegistryObject<ArrowBaseItem> TIPPED_IRON_ARROW = REGISTRY.register("tipped_iron_arrow", () -> new ArrowBaseTippedItem("iron_arrow", 3.0f, 0.75f));
    public static final RegistryObject<ArrowBaseItem> DIAMOND_ARROW = REGISTRY.register("diamond_arrow", () -> new ArrowBaseItem(3.5f, 1.25f));
    public static final RegistryObject<ArrowBaseItem> TIPPED_DIAMOND_ARROW = REGISTRY.register("tipped_diamond_arrow", () -> new ArrowBaseTippedItem("diamond_arrow", 3.5f, 1.25f));
    public static final RegistryObject<ArrowBaseItem> NETHERITE_ARROW = REGISTRY.register("netherite_arrow", () -> new ArrowBaseItem(4.0f, 1.25f));
    public static final RegistryObject<ArrowBaseItem> TIPPED_NETHERITE_ARROW = REGISTRY.register("tipped_netherite_arrow", () -> new ArrowBaseTippedItem("netherite_arrow", 4.0f, 1.25f));
    public static final RegistryObject<Item> EXPLOSIVE_ARROW = REGISTRY.register("explosive_arrow", () -> new ArrowExplosiveItem(1.0f));
    public static final RegistryObject<BoltItem> BOLT = REGISTRY.register("bolt", () -> new BoltItem(4.0f, 1.0f, 0.25f));
    public static final RegistryObject<BoltItem> TIPPED_BOLT = REGISTRY.register("tipped_bolt", () -> new BoltTippedItem("bolt", 4.0f, 1.0f, 0.25f));
    public static final RegistryObject<BoltItem> SPECTRAL_BOLT = REGISTRY.register("spectral_bolt", () -> new BoltSpectralItem(4.0f, 1.0f, 0.25f));
    public static final RegistryObject<BoltItem> COPPER_BOLT = REGISTRY.register("copper_bolt", () -> new BoltItem(3.5f, 1.0f, 0.125f));
    public static final RegistryObject<BoltItem> TIPPED_COPPER_BOLT = REGISTRY.register("tipped_copper_bolt", () -> new BoltTippedItem("copper_bolt", 3.5f, 1.0f, 0.125f));
    public static final RegistryObject<BoltItem> DIAMOND_BOLT = REGISTRY.register("diamond_bolt", () -> new BoltItem(5.0f, 1.0f, 0.5f));
    public static final RegistryObject<BoltItem> TIPPED_DIAMOND_BOLT = REGISTRY.register("tipped_diamond_bolt", () -> new BoltTippedItem("diamond_bolt", 5.0f, 1.0f, 0.5f));
    public static final RegistryObject<BoltItem> NETHERITE_BOLT = REGISTRY.register("netherite_bolt", () -> new BoltItem(5.5f, 1.0f, 0.5f));
    public static final RegistryObject<BoltItem> TIPPED_NETHERITE_BOLT = REGISTRY.register("tipped_netherite_bolt", () -> new BoltTippedItem("netherite_bolt", 5.5f, 1.0f, 0.5f));
    public static final RegistryObject<Item> SMALL_ARROW_QUIVER = REGISTRY.register("small_arrow_quiver", () -> new QuiverArrowItem(4));
    public static final RegistryObject<Item> MEDIUM_ARROW_QUIVER = REGISTRY.register("medium_arrow_quiver", () -> new QuiverArrowItem(6));
    public static final RegistryObject<Item> LARGE_ARROW_QUIVER = REGISTRY.register("large_arrow_quiver", () -> new QuiverArrowItem(9));
    public static final RegistryObject<Item> HUGE_ARROW_QUIVER = REGISTRY.register("huge_arrow_quiver", () -> new QuiverArrowItem(12));
    public static final RegistryObject<Item> SMALL_BOLT_QUIVER = REGISTRY.register("small_bolt_quiver", () -> new QuiverBoltItem(4));
    public static final RegistryObject<Item> MEDIUM_BOLT_QUIVER = REGISTRY.register("medium_bolt_quiver", () -> new QuiverBoltItem(6));
    public static final RegistryObject<Item> LARGE_BOLT_QUIVER = REGISTRY.register("large_bolt_quiver", () -> new QuiverBoltItem(9));
    public static final RegistryObject<Item> HUGE_BOLT_QUIVER = REGISTRY.register("huge_bolt_quiver", () -> new QuiverBoltItem(12));
    public static final RegistryObject<Item> MEDIUM_QUIVER_UPGRADE_KIT = REGISTRY.register("medium_quiver_upgrade_kit", () -> new BasicItem(new Item.Properties().m_41491_(TAB_SW)));
    public static final RegistryObject<Item> LARGE_QUIVER_UPGRADE_KIT = REGISTRY.register("large_quiver_upgrade_kit", () -> new BasicItem(new Item.Properties().m_41491_(TAB_SW)));
    public static final RegistryObject<Item> HUGE_QUIVER_UPGRADE_KIT = REGISTRY.register("huge_quiver_upgrade_kit", () -> new BasicItem(new Item.Properties().m_41491_(TAB_SW)));
    public static final RegistryObject<Item> DYNAMITE = REGISTRY.register("dynamite", () -> new DynamiteItem(new Item.Properties().m_41491_(TAB_SW)));
    public static final RegistryObject<WeaponOilItem> WEAPON_OIL = REGISTRY.register("weapon_oil", () -> new WeaponOilItem());
    public static final RegistryObject<Item> BLAZE_HEAD = REGISTRY.register("blaze_head", () -> new ExtendedSkullItem((Block)ModBlocks.BLAZE_HEAD.get(), (Block)ModBlocks.BLAZE_WALL_HEAD.get(), new Item.Properties().m_41491_(TAB_SW).m_41497_(Rarity.UNCOMMON)));
    public static final RegistryObject<Item> ENDERMAN_HEAD = REGISTRY.register("enderman_head", () -> new ExtendedSkullItem((Block)ModBlocks.ENDERMAN_HEAD.get(), (Block)ModBlocks.ENDERMAN_WALL_HEAD.get(), new Item.Properties().m_41491_(TAB_SW).m_41497_(Rarity.UNCOMMON)));
    public static final RegistryObject<Item> SPIDER_HEAD = REGISTRY.register("spider_head", () -> new ExtendedSkullItem((Block)ModBlocks.SPIDER_HEAD.get(), (Block)ModBlocks.SPIDER_WALL_HEAD.get(), new Item.Properties().m_41491_(TAB_SW).m_41497_(Rarity.UNCOMMON)));
    public static final RegistryObject<Item> CAVE_SPIDER_HEAD = REGISTRY.register("cave_spider_head", () -> new ExtendedSkullItem((Block)ModBlocks.CAVE_SPIDER_HEAD.get(), (Block)ModBlocks.CAVE_SPIDER_WALL_HEAD.get(), new Item.Properties().m_41491_(TAB_SW).m_41497_(Rarity.UNCOMMON)));
    public static final RegistryObject<Item> PIGLIN_HEAD = REGISTRY.register("piglin_head", () -> new ExtendedSkullItem((Block)ModBlocks.PIGLIN_HEAD.get(), (Block)ModBlocks.PIGLIN_WALL_HEAD.get(), new Item.Properties().m_41491_(TAB_SW).m_41497_(Rarity.UNCOMMON)));
    public static final RegistryObject<Item> ZOMBIFIED_PIGLIN_HEAD = REGISTRY.register("zombified_piglin_head", () -> new ExtendedSkullItem((Block)ModBlocks.ZOMBIFIED_PIGLIN_HEAD.get(), (Block)ModBlocks.ZOMBIFIED_PIGLIN_WALL_HEAD.get(), new Item.Properties().m_41491_(TAB_SW).m_41497_(Rarity.UNCOMMON)));
    public static final RegistryObject<Item> HUSK_HEAD = REGISTRY.register("husk_head", () -> new ExtendedSkullItem((Block)ModBlocks.HUSK_HEAD.get(), (Block)ModBlocks.HUSK_WALL_HEAD.get(), new Item.Properties().m_41491_(TAB_SW).m_41497_(Rarity.UNCOMMON)));
    public static final RegistryObject<Item> STRAY_SKULL = REGISTRY.register("stray_skull", () -> new ExtendedSkullItem((Block)ModBlocks.STRAY_SKULL.get(), (Block)ModBlocks.STRAY_WALL_SKULL.get(), new Item.Properties().m_41491_(TAB_SW).m_41497_(Rarity.UNCOMMON)));
    public static final RegistryObject<Item> DROWNED_HEAD = REGISTRY.register("drowned_head", () -> new ExtendedSkullItem((Block)ModBlocks.DROWNED_HEAD.get(), (Block)ModBlocks.DROWNED_WALL_HEAD.get(), new Item.Properties().m_41491_(TAB_SW).m_41497_(Rarity.UNCOMMON)));
    public static final RegistryObject<Item> ILLAGER_HEAD = REGISTRY.register("illager_head", () -> new ExtendedSkullItem((Block)ModBlocks.ILLAGER_HEAD.get(), (Block)ModBlocks.ILLAGER_WALL_HEAD.get(), new Item.Properties().m_41491_(TAB_SW).m_41497_(Rarity.UNCOMMON)));
    public static final RegistryObject<Item> WITCH_HEAD = REGISTRY.register("witch_head", () -> new ExtendedSkullItem((Block)ModBlocks.WITCH_HEAD.get(), (Block)ModBlocks.WITCH_WALL_HEAD.get(), new Item.Properties().m_41491_(TAB_SW).m_41497_(Rarity.UNCOMMON)));

    public static class WeaponItemsMelee {
        public final RegistryObject<SwordBaseItem> wood;
        public final RegistryObject<SwordBaseItem> stone;
        public final RegistryObject<SwordBaseItem> copper;
        public final RegistryObject<SwordBaseItem> iron;
        public final RegistryObject<SwordBaseItem> gold;
        public final RegistryObject<SwordBaseItem> diamond;
        public final RegistryObject<SwordBaseItem> netherite;
        public final RegistryObject<SwordBaseItem> tin;
        public final RegistryObject<SwordBaseItem> bronze;
        public final RegistryObject<SwordBaseItem> steel;
        public final RegistryObject<SwordBaseItem> silver;
        public final RegistryObject<SwordBaseItem> lead;
        public final RegistryObject<SwordBaseItem> nickel;
        public final RegistryObject<SwordBaseItem> invar;
        public final RegistryObject<SwordBaseItem> constantan;
        public final RegistryObject<SwordBaseItem> platinum;
        public final RegistryObject<SwordBaseItem> electrum;
        public final RegistryObject<SwordBaseItem> aluminum;

        public WeaponItemsMelee(DeferredRegister<Item> register, String weaponName, WeaponFactory.WeaponFunction<SwordBaseItem> factory) {
            Item.Properties propVanilla = new Item.Properties().m_41491_(TAB_SW);
            Item.Properties propModded = new Item.Properties().m_41491_(TAB_SW_MODDED);
            this.wood = register.register("wooden_" + weaponName, () -> (SwordBaseItem)factory.create(WeaponMaterial.WOOD, propVanilla));
            this.stone = register.register("stone_" + weaponName, () -> (SwordBaseItem)factory.create(WeaponMaterial.STONE, propVanilla));
            this.copper = register.register("copper_" + weaponName, () -> (SwordBaseItem)factory.create(WeaponMaterial.COPPER, propVanilla));
            this.iron = register.register("iron_" + weaponName, () -> (SwordBaseItem)factory.create(WeaponMaterial.IRON, propVanilla));
            this.gold = register.register("golden_" + weaponName, () -> (SwordBaseItem)factory.create(WeaponMaterial.GOLD, propVanilla));
            this.diamond = register.register("diamond_" + weaponName, () -> (SwordBaseItem)factory.create(WeaponMaterial.DIAMOND, propVanilla));
            this.netherite = register.register("netherite_" + weaponName, () -> (SwordBaseItem)factory.create(WeaponMaterial.NETHERITE, new Item.Properties().m_41491_(TAB_SW).m_41486_()));
            this.tin = register.register("tin_" + weaponName, () -> (SwordBaseItem)factory.create(WeaponMaterial.TIN, propModded));
            this.bronze = register.register("bronze_" + weaponName, () -> (SwordBaseItem)factory.create(WeaponMaterial.BRONZE, propModded));
            this.steel = register.register("steel_" + weaponName, () -> (SwordBaseItem)factory.create(WeaponMaterial.STEEL, propModded));
            this.silver = register.register("silver_" + weaponName, () -> (SwordBaseItem)factory.create(WeaponMaterial.SILVER, propModded));
            this.electrum = register.register("electrum_" + weaponName, () -> (SwordBaseItem)factory.create(WeaponMaterial.ELECTRUM, propModded));
            this.lead = register.register("lead_" + weaponName, () -> (SwordBaseItem)factory.create(WeaponMaterial.LEAD, propModded));
            this.nickel = register.register("nickel_" + weaponName, () -> (SwordBaseItem)factory.create(WeaponMaterial.NICKEL, propModded));
            this.invar = register.register("invar_" + weaponName, () -> (SwordBaseItem)factory.create(WeaponMaterial.INVAR, propModded));
            this.constantan = register.register("constantan_" + weaponName, () -> (SwordBaseItem)factory.create(WeaponMaterial.CONSTANTAN, propModded));
            this.platinum = register.register("platinum_" + weaponName, () -> (SwordBaseItem)factory.create(WeaponMaterial.PLATINUM, propModded));
            this.aluminum = register.register("aluminum_" + weaponName, () -> (SwordBaseItem)factory.create(WeaponMaterial.ALUMINUM, propModded));
        }

        public void updateSettingsFromConfig(float baseDamage, float damageMultiplier, double speed) {
            this.getAsList().forEach(weapon -> weapon.setAttackDamageAndSpeed(baseDamage, damageMultiplier, speed));
        }

        public ImmutableList<SwordBaseItem> getAsList() {
            return ImmutableList.of((Object)((SwordBaseItem)this.wood.get()), (Object)((SwordBaseItem)this.stone.get()), (Object)((SwordBaseItem)this.copper.get()), (Object)((SwordBaseItem)this.iron.get()), (Object)((SwordBaseItem)this.gold.get()), (Object)((SwordBaseItem)this.diamond.get()), (Object)((SwordBaseItem)this.netherite.get()), (Object)((SwordBaseItem)this.tin.get()), (Object)((SwordBaseItem)this.bronze.get()), (Object)((SwordBaseItem)this.steel.get()), (Object)((SwordBaseItem)this.silver.get()), (Object)((SwordBaseItem)this.electrum.get()), (Object[])new SwordBaseItem[]{(SwordBaseItem)this.lead.get(), (SwordBaseItem)this.nickel.get(), (SwordBaseItem)this.invar.get(), (SwordBaseItem)this.constantan.get(), (SwordBaseItem)this.platinum.get(), (SwordBaseItem)this.aluminum.get()});
        }
    }

    public static class WeaponItemsRanged {
        public final RegistryObject<Item> wood;
        public final RegistryObject<Item> leather;
        public final RegistryObject<Item> copper;
        public final RegistryObject<Item> iron;
        public final RegistryObject<Item> gold;
        public final RegistryObject<Item> diamond;
        public final RegistryObject<Item> netherite;
        public final RegistryObject<Item> tin;
        public final RegistryObject<Item> bronze;
        public final RegistryObject<Item> steel;
        public final RegistryObject<Item> silver;
        public final RegistryObject<Item> electrum;
        public final RegistryObject<Item> lead;
        public final RegistryObject<Item> nickel;
        public final RegistryObject<Item> invar;
        public final RegistryObject<Item> constantan;
        public final RegistryObject<Item> platinum;
        public final RegistryObject<Item> aluminum;

        public WeaponItemsRanged(DeferredRegister<Item> register, String weaponName, WeaponFactory.WeaponFunction<? extends Item> factory) {
            Item.Properties propVanilla = new Item.Properties().m_41491_(TAB_SW);
            Item.Properties propModded = new Item.Properties().m_41491_(TAB_SW_MODDED);
            this.wood = register.register("wooden_" + weaponName, () -> factory.create(WeaponMaterial.WOOD, propVanilla));
            this.leather = register.register("leather_" + weaponName, () -> factory.create(WeaponMaterial.LEATHER, propVanilla));
            this.copper = register.register("copper_" + weaponName, () -> factory.create(WeaponMaterial.COPPER, propVanilla));
            this.iron = register.register("iron_" + weaponName, () -> factory.create(WeaponMaterial.IRON, propVanilla));
            this.gold = register.register("golden_" + weaponName, () -> factory.create(WeaponMaterial.GOLD, propVanilla));
            this.diamond = register.register("diamond_" + weaponName, () -> factory.create(WeaponMaterial.DIAMOND, propVanilla));
            this.netherite = register.register("netherite_" + weaponName, () -> factory.create(WeaponMaterial.NETHERITE, new Item.Properties().m_41491_(TAB_SW).m_41486_()));
            this.tin = register.register("tin_" + weaponName, () -> factory.create(WeaponMaterial.TIN, propModded));
            this.bronze = register.register("bronze_" + weaponName, () -> factory.create(WeaponMaterial.BRONZE, propModded));
            this.steel = register.register("steel_" + weaponName, () -> factory.create(WeaponMaterial.STEEL, propModded));
            this.silver = register.register("silver_" + weaponName, () -> factory.create(WeaponMaterial.SILVER, propModded));
            this.electrum = register.register("electrum_" + weaponName, () -> factory.create(WeaponMaterial.ELECTRUM, propModded));
            this.lead = register.register("lead_" + weaponName, () -> factory.create(WeaponMaterial.LEAD, propModded));
            this.nickel = register.register("nickel_" + weaponName, () -> factory.create(WeaponMaterial.NICKEL, propModded));
            this.invar = register.register("invar_" + weaponName, () -> factory.create(WeaponMaterial.INVAR, propModded));
            this.constantan = register.register("constantan_" + weaponName, () -> factory.create(WeaponMaterial.CONSTANTAN, propModded));
            this.platinum = register.register("platinum_" + weaponName, () -> factory.create(WeaponMaterial.PLATINUM, propModded));
            this.aluminum = register.register("aluminum_" + weaponName, () -> factory.create(WeaponMaterial.ALUMINUM, propModded));
        }

        public ImmutableList<Item> getAsList() {
            return ImmutableList.of((Object)((Item)this.wood.get()), (Object)((Item)this.leather.get()), (Object)((Item)this.copper.get()), (Object)((Item)this.iron.get()), (Object)((Item)this.gold.get()), (Object)((Item)this.diamond.get()), (Object)((Item)this.netherite.get()), (Object)((Item)this.tin.get()), (Object)((Item)this.bronze.get()), (Object)((Item)this.steel.get()), (Object)((Item)this.silver.get()), (Object)((Item)this.electrum.get()), (Object[])new Item[]{(Item)this.lead.get(), (Item)this.nickel.get(), (Item)this.invar.get(), (Item)this.constantan.get(), (Item)this.platinum.get(), (Item)this.aluminum.get()});
        }
    }

    public static class WeaponItemsThrowing {
        public RegistryObject<ThrowingWeaponItem> wood;
        public RegistryObject<ThrowingWeaponItem> stone;
        public RegistryObject<ThrowingWeaponItem> copper;
        public RegistryObject<ThrowingWeaponItem> iron;
        public RegistryObject<ThrowingWeaponItem> gold;
        public RegistryObject<ThrowingWeaponItem> diamond;
        public RegistryObject<ThrowingWeaponItem> netherite;
        public RegistryObject<ThrowingWeaponItem> tin;
        public RegistryObject<ThrowingWeaponItem> bronze;
        public RegistryObject<ThrowingWeaponItem> steel;
        public RegistryObject<ThrowingWeaponItem> silver;
        public RegistryObject<ThrowingWeaponItem> electrum;
        public RegistryObject<ThrowingWeaponItem> lead;
        public RegistryObject<ThrowingWeaponItem> nickel;
        public RegistryObject<ThrowingWeaponItem> invar;
        public RegistryObject<ThrowingWeaponItem> constantan;
        public RegistryObject<ThrowingWeaponItem> platinum;
        public RegistryObject<ThrowingWeaponItem> aluminum;

        public WeaponItemsThrowing(DeferredRegister<Item> register, String weaponName, WeaponFactory.WeaponFunction<ThrowingWeaponItem> factory) {
            Item.Properties propVanilla = new Item.Properties().m_41491_(TAB_SW);
            Item.Properties propModded = new Item.Properties().m_41491_(TAB_SW_MODDED);
            this.wood = register.register("wooden_" + weaponName, () -> (ThrowingWeaponItem)factory.create(WeaponMaterial.WOOD, propVanilla));
            this.stone = register.register("stone_" + weaponName, () -> (ThrowingWeaponItem)factory.create(WeaponMaterial.STONE, propVanilla));
            this.copper = register.register("copper_" + weaponName, () -> (ThrowingWeaponItem)factory.create(WeaponMaterial.COPPER, propVanilla));
            this.iron = register.register("iron_" + weaponName, () -> (ThrowingWeaponItem)factory.create(WeaponMaterial.IRON, propVanilla));
            this.gold = register.register("golden_" + weaponName, () -> (ThrowingWeaponItem)factory.create(WeaponMaterial.GOLD, propVanilla));
            this.diamond = register.register("diamond_" + weaponName, () -> (ThrowingWeaponItem)factory.create(WeaponMaterial.DIAMOND, propVanilla));
            this.netherite = register.register("netherite_" + weaponName, () -> (ThrowingWeaponItem)factory.create(WeaponMaterial.NETHERITE, new Item.Properties().m_41491_(TAB_SW).m_41486_()));
            this.tin = register.register("tin_" + weaponName, () -> (ThrowingWeaponItem)factory.create(WeaponMaterial.TIN, propModded));
            this.bronze = register.register("bronze_" + weaponName, () -> (ThrowingWeaponItem)factory.create(WeaponMaterial.BRONZE, propModded));
            this.steel = register.register("steel_" + weaponName, () -> (ThrowingWeaponItem)factory.create(WeaponMaterial.STEEL, propModded));
            this.silver = register.register("silver_" + weaponName, () -> (ThrowingWeaponItem)factory.create(WeaponMaterial.SILVER, propModded));
            this.electrum = register.register("electrum_" + weaponName, () -> (ThrowingWeaponItem)factory.create(WeaponMaterial.ELECTRUM, propModded));
            this.lead = register.register("lead_" + weaponName, () -> (ThrowingWeaponItem)factory.create(WeaponMaterial.LEAD, propModded));
            this.nickel = register.register("nickel_" + weaponName, () -> (ThrowingWeaponItem)factory.create(WeaponMaterial.NICKEL, propModded));
            this.invar = register.register("invar_" + weaponName, () -> (ThrowingWeaponItem)factory.create(WeaponMaterial.INVAR, propModded));
            this.constantan = register.register("constantan_" + weaponName, () -> (ThrowingWeaponItem)factory.create(WeaponMaterial.CONSTANTAN, propModded));
            this.platinum = register.register("platinum_" + weaponName, () -> (ThrowingWeaponItem)factory.create(WeaponMaterial.PLATINUM, propModded));
            this.aluminum = register.register("aluminum_" + weaponName, () -> (ThrowingWeaponItem)factory.create(WeaponMaterial.ALUMINUM, propModded));
        }

        public void updateSettingsFromConfig(float baseDamage, float damageMultiplier, double speed, int chargeTicks) {
            this.getAsList().forEach(weapon -> weapon.updateFromConfig(baseDamage, damageMultiplier, speed, chargeTicks));
        }

        public ImmutableList<ThrowingWeaponItem> getAsList() {
            return ImmutableList.of((Object)((ThrowingWeaponItem)this.wood.get()), (Object)((ThrowingWeaponItem)this.stone.get()), (Object)((ThrowingWeaponItem)this.copper.get()), (Object)((ThrowingWeaponItem)this.iron.get()), (Object)((ThrowingWeaponItem)this.gold.get()), (Object)((ThrowingWeaponItem)this.diamond.get()), (Object)((ThrowingWeaponItem)this.netherite.get()), (Object)((ThrowingWeaponItem)this.tin.get()), (Object)((ThrowingWeaponItem)this.bronze.get()), (Object)((ThrowingWeaponItem)this.steel.get()), (Object)((ThrowingWeaponItem)this.silver.get()), (Object)((ThrowingWeaponItem)this.electrum.get()), (Object[])new ThrowingWeaponItem[]{(ThrowingWeaponItem)this.lead.get(), (ThrowingWeaponItem)this.nickel.get(), (ThrowingWeaponItem)this.invar.get(), (ThrowingWeaponItem)this.constantan.get(), (ThrowingWeaponItem)this.platinum.get(), (ThrowingWeaponItem)this.aluminum.get()});
        }
    }
}

