/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item.crafting;

import com.oblivioussp.spartanweaponry.api.OilEffects;
import com.oblivioussp.spartanweaponry.api.oil.OilEffect;
import com.oblivioussp.spartanweaponry.api.tags.ModItemTags;
import com.oblivioussp.spartanweaponry.capability.IOilHandler;
import com.oblivioussp.spartanweaponry.init.ModCapabilities;
import com.oblivioussp.spartanweaponry.init.ModItems;
import com.oblivioussp.spartanweaponry.init.ModRecipeSerializers;
import com.oblivioussp.spartanweaponry.util.OilHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;

public class ApplyOilRecipe
extends CustomRecipe {
    public ApplyOilRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingContainer containerIn, Level levelIn) {
        boolean foundOil = false;
        boolean foundWeapon = false;
        for (int i = 0; i < containerIn.m_39347_(); ++i) {
            for (int j = 0; j < containerIn.m_39346_(); ++j) {
                ItemStack stack = containerIn.m_8020_(j * containerIn.m_39347_() + i);
                if (stack.m_150930_((Item)ModItems.WEAPON_OIL.get())) {
                    if (foundOil) {
                        return false;
                    }
                    foundOil = true;
                    continue;
                }
                if (stack.m_204117_(ModItemTags.OILABLE_WEAPONS)) {
                    if (foundWeapon) {
                        return false;
                    }
                    foundWeapon = true;
                    continue;
                }
                if (stack.m_41619_()) continue;
                return false;
            }
        }
        return foundOil && foundWeapon;
    }

    public ItemStack assemble(CraftingContainer containerIn) {
        ItemStack oilStack = ItemStack.f_41583_;
        ItemStack weaponStack = ItemStack.f_41583_;
        for (int i = 0; i < containerIn.m_39347_(); ++i) {
            for (int j = 0; j < containerIn.m_39346_(); ++j) {
                ItemStack stack = containerIn.m_8020_(j * containerIn.m_39347_() + i);
                if (stack.m_150930_((Item)ModItems.WEAPON_OIL.get())) {
                    if (!oilStack.m_41619_()) {
                        return ItemStack.f_41583_;
                    }
                    oilStack = stack;
                    continue;
                }
                if (stack.m_204117_(ModItemTags.OILABLE_WEAPONS)) {
                    if (!weaponStack.m_41619_()) {
                        return ItemStack.f_41583_;
                    }
                    weaponStack = stack;
                    continue;
                }
                if (stack.m_41619_()) continue;
                return ItemStack.f_41583_;
            }
        }
        if (!oilStack.m_41619_() && !weaponStack.m_41619_()) {
            ItemStack resultStack = weaponStack.m_41777_();
            OilEffect effect = OilHelper.getOilFromStack(oilStack);
            LazyOptional handler = resultStack.getCapability(ModCapabilities.OIL_CAPABILITY);
            if (effect != OilEffects.NONE.get() && handler.isPresent()) {
                IOilHandler oilHandler = (IOilHandler)handler.resolve().get();
                if (effect == OilEffects.POTION.get()) {
                    Potion potion = OilHelper.getPotionFromStack(oilStack);
                    oilHandler.setPotion(potion, oilStack);
                } else {
                    oilHandler.setEffect(effect, oilStack);
                }
                return resultStack.m_41777_();
            }
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 1;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.APPLY_OIL.get();
    }
}

