/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.oblivioussp.spartanweaponry.api.IWeaponTraitContainer;
import com.oblivioussp.spartanweaponry.api.WeaponTraits;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class DecapitateLootModifier
extends LootModifier {
    public static final Supplier<Codec<DecapitateLootModifier>> DECAPITATE_CODEC = () -> RecordCodecBuilder.create(instance -> DecapitateLootModifier.codecStart((RecordCodecBuilder.Instance)instance).and(instance.group((App)ForgeRegistries.ITEMS.getCodec().fieldOf("skull").forGetter(modifier -> modifier.skull)).t1()).apply((Applicative)instance, DecapitateLootModifier::new));
    private Item skull;

    public DecapitateLootModifier(LootItemCondition[] conditionsIn, Item skullItem) {
        super(conditionsIn);
        this.skull = skullItem;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (!context.m_78936_(LootContextParams.f_81458_)) {
            return generatedLoot;
        }
        Entity killer = (Entity)context.m_165124_(LootContextParams.f_81458_);
        if (killer instanceof LivingEntity) {
            IWeaponTraitContainer container;
            LivingEntity living = (LivingEntity)killer;
            ItemStack weapon = living.m_21205_();
            if (context.m_230907_().m_188500_() < (double)(((WeaponTrait)WeaponTraits.DECAPITATE.get()).getMagnitude() / 100.0f) && weapon.m_41720_() instanceof IWeaponTraitContainer && (container = (IWeaponTraitContainer)weapon.m_41720_()).hasWeaponTraitWithType("decapitate")) {
                ItemStack skullStack = new ItemStack((ItemLike)this.skull);
                Entity thisEntity = (Entity)context.m_165124_(LootContextParams.f_81455_);
                if (thisEntity instanceof Player) {
                    Player player = (Player)thisEntity;
                    skullStack.m_41784_().m_128359_("SkullOwner", player.m_36316_().getName());
                }
                generatedLoot.add((Object)skullStack);
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return DECAPITATE_CODEC.get();
    }
}

