/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.util;

import com.google.common.collect.ImmutableList;
import com.oblivioussp.spartanweaponry.api.tags.ModItemTags;
import com.oblivioussp.spartanweaponry.item.HeavyCrossbowItem;
import com.oblivioussp.spartanweaponry.item.QuiverBaseItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraftforge.fml.ModList;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class QuiverHelper {
    public static final Predicate<ItemStack> ARROW_QUIVER = stack -> stack.m_204117_(ModItemTags.ARROW_QUIVERS);
    public static final Predicate<ItemStack> BOLT_QUIVER = stack -> stack.m_204117_(ModItemTags.BOLT_QUIVERS);
    public static final Predicate<ItemStack> HEAVY_CROSSBOW = stack -> stack.m_204117_(ModItemTags.HEAVY_CROSSBOWS);
    public static List<IQuiverInfo> info = ImmutableList.of((Object)new IQuiverInfo(){

        @Override
        public boolean isQuiver(ItemStack stack) {
            return stack.m_41619_() ? false : BOLT_QUIVER.test(stack);
        }

        @Override
        public boolean isWeapon(ItemStack stack) {
            return stack.m_41619_() ? false : HEAVY_CROSSBOW.test(stack);
        }

        @Override
        public boolean isAmmo(ItemStack stack) {
            return stack.m_41619_() ? false : HeavyCrossbowItem.BOLT.test(stack);
        }
    }, (Object)new IQuiverInfo(){

        @Override
        public boolean isQuiver(ItemStack stack) {
            return stack.m_41619_() ? false : ARROW_QUIVER.test(stack);
        }

        @Override
        public boolean isWeapon(ItemStack stack) {
            return stack.m_41619_() ? false : stack.m_41720_() instanceof ProjectileWeaponItem && !(stack.m_41720_() instanceof HeavyCrossbowItem);
        }

        @Override
        public boolean isAmmo(ItemStack stack) {
            return stack.m_41619_() ? false : ProjectileWeaponItem.f_43005_.test(stack);
        }
    });

    public static ItemStack findFirstOfType(Player player, IQuiverInfo info) {
        Optional opt;
        if (ModList.get().isLoaded("curios") && (opt = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, stack -> stack.m_41720_() instanceof QuiverBaseItem)).isPresent() && info.isQuiver(((SlotResult)opt.get()).stack())) {
            return ((SlotResult)opt.get()).stack();
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack stack2 = player.m_150109_().m_8020_(i);
            if (stack2.m_41619_() || !info.isQuiver(stack2)) continue;
            return stack2;
        }
        return ItemStack.f_41583_;
    }

    public static List<ItemStack> findValidQuivers(Player player) {
        Optional opt;
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (ModList.get().isLoaded("curios") && (opt = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, stack -> stack.m_41720_() instanceof QuiverBaseItem)).isPresent()) {
            result.add(((SlotResult)opt.get()).stack());
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack stack2 = player.m_150109_().m_8020_(i);
            if (stack2.m_41619_() || !(stack2.m_41720_() instanceof QuiverBaseItem)) continue;
            result.add(stack2);
        }
        return result;
    }

    public static ItemStack findFirstQuiver(Player player) {
        Optional opt;
        if (ModList.get().isLoaded("curios") && (opt = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, stack -> stack.m_41720_() instanceof QuiverBaseItem)).isPresent()) {
            return ((SlotResult)opt.get()).stack();
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack stack2 = player.m_150109_().m_8020_(i);
            if (stack2.m_41619_() || !(stack2.m_41720_() instanceof QuiverBaseItem)) continue;
            return stack2;
        }
        return ItemStack.f_41583_;
    }

    public static interface IQuiverInfo {
        public boolean isQuiver(ItemStack var1);

        public boolean isWeapon(ItemStack var1);

        public boolean isAmmo(ItemStack var1);
    }
}

