/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.util;

import com.google.common.collect.ImmutableSet;
import com.oblivioussp.spartanweaponry.api.IReloadable;
import com.oblivioussp.spartanweaponry.api.ReloadableHandler;
import com.oblivioussp.spartanweaponry.api.WeaponTraits;
import com.oblivioussp.spartanweaponry.api.tags.ModWeaponTraitTags;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;
import org.apache.commons.lang3.tuple.Pair;

public class WeaponArchetype
implements IReloadable {
    public static final Predicate<WeaponTrait> IS_MELEE = trait -> trait.isMeleeTrait();
    public static final Predicate<WeaponTrait> IS_RANGED = trait -> trait.isRangedTrait();
    public static final Predicate<WeaponTrait> IS_THROWING = trait -> trait.isThrowingTrait();
    public static final WeaponArchetype DAGGER = new WeaponArchetype("Dagger", true, ModWeaponTraitTags.DAGGER, IS_MELEE, new ToolAction[0]);
    public static final WeaponArchetype PARRYING_DAGGER = new WeaponArchetype("Parrying Dagger", true, ModWeaponTraitTags.PARRYING_DAGGER, IS_MELEE, new ToolAction[0]);
    public static final WeaponArchetype LONGSWORD = new WeaponArchetype("Longsword", true, ModWeaponTraitTags.LONGSWORD, IS_MELEE, ToolActions.SWORD_DIG);
    public static final WeaponArchetype KATANA = new WeaponArchetype("Katana", true, ModWeaponTraitTags.KATANA, IS_MELEE, ToolActions.SWORD_DIG);
    public static final WeaponArchetype SABER = new WeaponArchetype("Saber", true, ModWeaponTraitTags.SABER, IS_MELEE, ToolActions.SWORD_DIG);
    public static final WeaponArchetype RAPIER = new WeaponArchetype("Rapier", true, ModWeaponTraitTags.RAPIER, IS_MELEE, new ToolAction[0]);
    public static final WeaponArchetype GREATSWORD = new WeaponArchetype("Greatsword", true, ModWeaponTraitTags.GREATSWORD, IS_MELEE, ToolActions.SWORD_DIG);
    public static final WeaponArchetype CLUB = new WeaponArchetype("Club", false, ModWeaponTraitTags.CLUB, IS_MELEE, new ToolAction[0]);
    public static final WeaponArchetype CESTUS = new WeaponArchetype("Cestus", false, ModWeaponTraitTags.CESTUS, IS_MELEE, new ToolAction[0]);
    public static final WeaponArchetype BATTLE_HAMMER = new WeaponArchetype("Battle Hammer", false, ModWeaponTraitTags.BATTLE_HAMMER, IS_MELEE, new ToolAction[0]);
    public static final WeaponArchetype WARHAMMER = new WeaponArchetype("Warhammer", false, ModWeaponTraitTags.WARHAMMER, IS_MELEE, new ToolAction[0]);
    public static final WeaponArchetype SPEAR = new WeaponArchetype("Spear", false, ModWeaponTraitTags.SPEAR, IS_MELEE, new ToolAction[0]);
    public static final WeaponArchetype HALBERD = new WeaponArchetype("Halberd", false, ModWeaponTraitTags.HALBERD, IS_MELEE, new ToolAction[0]);
    public static final WeaponArchetype PIKE = new WeaponArchetype("Pike", false, ModWeaponTraitTags.PIKE, IS_MELEE, new ToolAction[0]);
    public static final WeaponArchetype LANCE = new WeaponArchetype("Lance", false, ModWeaponTraitTags.LANCE, IS_MELEE, new ToolAction[0]);
    public static final WeaponArchetype THROWING_KNIFE = new WeaponArchetype("Throwing Knife", true, ModWeaponTraitTags.THROWING_KNIFE, IS_THROWING, new ToolAction[0]);
    public static final WeaponArchetype TOMAHAWK = new WeaponArchetype("Tomahawk", false, ModWeaponTraitTags.TOMAHAWK, IS_THROWING, new ToolAction[0]);
    public static final WeaponArchetype JAVELIN = new WeaponArchetype("Javelin", false, ModWeaponTraitTags.JAVELIN, IS_THROWING, new ToolAction[0]);
    public static final WeaponArchetype BOOMERANG = new WeaponArchetype("Boomerang", false, ModWeaponTraitTags.BOOMERANG, IS_THROWING, new ToolAction[0]);
    public static final WeaponArchetype BATTLEAXE = new WeaponArchetype("Battleaxe", false, ModWeaponTraitTags.BATTLEAXE, IS_MELEE, ToolActions.DEFAULT_AXE_ACTIONS);
    public static final WeaponArchetype FLANGED_MACE = new WeaponArchetype("Flanged Mace", false, ModWeaponTraitTags.FLANGED_MACE, IS_MELEE, new ToolAction[0]);
    public static final WeaponArchetype GLAIVE = new WeaponArchetype("Glaive", true, ModWeaponTraitTags.GLAIVE, IS_MELEE, new ToolAction[0]);
    public static final WeaponArchetype QUARTERSTAFF = new WeaponArchetype("Quarterstaff", false, ModWeaponTraitTags.QUARTERSTAFF, IS_MELEE, new ToolAction[0]);
    public static final WeaponArchetype SCYTHE = new WeaponArchetype("Scythe", false, ModWeaponTraitTags.SCYTHE, IS_MELEE, new ToolAction[0]);
    protected final String name;
    protected final TagKey<WeaponTrait> traitsTag;
    protected boolean isValidTag = true;
    protected List<WeaponTrait> traits;
    protected Optional<WeaponTrait> actionTrait = Optional.empty();
    protected Optional<List<Pair<WeaponTrait, WeaponTrait.InvalidReason>>> invalidTraits = Optional.empty();
    protected final Predicate<WeaponTrait> traitFilter;
    protected final boolean isBladed;
    protected final Set<ToolAction> toolActions;

    public WeaponArchetype(String nameIn, boolean isBladedIn, TagKey<WeaponTrait> traitsTagIn, Predicate<WeaponTrait> traitFilterIn, Set<ToolAction> toolActionsIn) {
        this.name = nameIn;
        this.traitsTag = traitsTagIn;
        this.traitFilter = traitFilterIn;
        this.isBladed = isBladedIn;
        this.toolActions = toolActionsIn;
        ReloadableHandler.addToReloadList(this);
    }

    public WeaponArchetype(String nameIn, boolean isBladedIn, TagKey<WeaponTrait> traitsTagIn, Predicate<WeaponTrait> traitFilterIn, ToolAction ... toolActionsIn) {
        this(nameIn, isBladedIn, traitsTagIn, traitFilterIn, (Set<ToolAction>)ImmutableSet.copyOf((Object[])toolActionsIn));
    }

    @Override
    public void reload() {
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(WeaponTraits.REGISTRY_KEY);
        ITagManager tagManager = registry.tags();
        this.isValidTag = tagManager.isKnownTagName(this.traitsTag);
        if (!this.isValidTag) {
            Log.error("Weapon Trait tag \"" + this.traitsTag.f_203868_() + "\" couldn't be found for weapon archetype \"" + this.name + "\"!");
        }
        ITag tag = tagManager.getTag(this.traitsTag);
        this.invalidTraits = Optional.empty();
        ArrayList invalidTraitList = new ArrayList();
        ArrayList invalidTraitValues = new ArrayList();
        AtomicReference<Object> actionTraitRef = new AtomicReference<Object>(null);
        this.traits = tag.stream().filter(trait -> {
            boolean isValid = this.traitFilter.test((WeaponTrait)trait);
            if (isValid && trait.isActionTrait()) {
                if (actionTraitRef.get() == null) {
                    actionTraitRef.set(trait);
                    return isValid;
                }
                invalidTraitList.add(Pair.of((Object)trait, (Object)((Object)WeaponTrait.InvalidReason.MULTIPLE_ACTION_TRAITS)));
                invalidTraitValues.add(registry.getKey(trait).toString());
                return false;
            }
            if (isValid) return isValid;
            WeaponTrait.InvalidReason reason = trait.isMeleeTrait() ? WeaponTrait.InvalidReason.WEAPON_NOT_MELEE : (trait.isRangedTrait() ? WeaponTrait.InvalidReason.WEAPON_NOT_RANGED : (trait.isThrowingTrait() ? WeaponTrait.InvalidReason.WEAPON_NOT_THROWING : WeaponTrait.InvalidReason.WEAPON_NOT_SUPPORTED));
            invalidTraitList.add(Pair.of((Object)trait, (Object)((Object)reason)));
            invalidTraitValues.add(registry.getKey(trait).toString());
            return isValid;
        }).collect(Collectors.toUnmodifiableList());
        WeaponTrait trait2 = actionTraitRef.get();
        Optional<Object> optional = this.actionTrait = trait2 != null ? Optional.of(actionTraitRef.get()) : Optional.empty();
        if (!invalidTraitList.isEmpty()) {
            Log.warn("Found invalid Weapon Traits for weapon archetype \"" + this.name + "\" which have not been added: " + String.join((CharSequence)", ", invalidTraitValues));
            this.invalidTraits = Optional.of(invalidTraitList);
        }
    }

    public boolean isBladed() {
        return this.isBladed;
    }

    public boolean canPerformToolAction(ToolAction toolAction) {
        return this.toolActions.contains(toolAction);
    }

    public List<WeaponTrait> getTraits() {
        return this.traits;
    }

    public Optional<List<Pair<WeaponTrait, WeaponTrait.InvalidReason>>> getInvalidTraits() {
        return this.invalidTraits;
    }

    public Optional<WeaponTrait> getActionTrait() {
        return this.actionTrait;
    }

    public void addTagErrorTooltip(ItemStack stack, List<Component> tooltip) {
        if (!this.isValidTag) {
            tooltip.add((Component)Component.m_237110_((String)String.format("tooltip.%s.trait.invalid.archetype_tag", "spartanweaponry"), (Object[])new Object[]{this.name, this.traitsTag.f_203868_()}).m_130940_(ChatFormatting.DARK_RED));
        }
    }

    public void addTraitsToTooltip(ItemStack stack, List<Component> tooltip, boolean isShiftPressed) {
        this.traits.forEach(trait -> trait.addTooltip(stack, tooltip, isShiftPressed, WeaponTrait.InvalidReason.NONE));
        if (this.invalidTraits.isPresent()) {
            this.invalidTraits.get().forEach(traitPair -> ((WeaponTrait)traitPair.getLeft()).addTooltip(stack, tooltip, isShiftPressed, (WeaponTrait.InvalidReason)((Object)((Object)traitPair.getRight()))));
        }
    }
}

