/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyseq.damageindicator.client.overlays;

import com.jeremyseq.damageindicator.client.DamageIndicatorClientConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class IndicatorOverlay {
    private static final ResourceLocation INDICATOR = new ResourceLocation("damageindicator", "textures/overlays/damage_indicator.png");
    public static Vec3 damageVec;
    public static Double finalAngle;
    public static boolean show;
    public static float counter;
    public static final IGuiOverlay DAMAGE_INDICATOR;

    private static double calculateFinalAngle(Vec3 playerForward, Vec3 playerPosition, Vec3 damagePosition) {
        double playerAngle = Math.atan2(playerForward.f_82479_, playerForward.f_82481_) * 180.0 / Math.PI;
        Vec2 enemyVec = new Vec2((float)damagePosition.f_82479_, (float)damagePosition.f_82481_).m_165910_(new Vec2((float)playerPosition.f_82479_, (float)playerPosition.f_82481_).m_165913_());
        double enemyAngle = Math.atan2(enemyVec.f_82470_, enemyVec.f_82471_) * 180.0 / Math.PI;
        double finalAngle = enemyAngle - playerAngle;
        return -finalAngle;
    }

    public static Quaternion inverse(Quaternion quaternion) {
        float magnitudeSquared = quaternion.m_80156_() * quaternion.m_80156_() + quaternion.m_80140_() * quaternion.m_80140_() + quaternion.m_80150_() * quaternion.m_80150_() + quaternion.m_80153_() * quaternion.m_80153_();
        if (magnitudeSquared == 0.0f) {
            throw new ArithmeticException("Cannot calculate inverse of a zero quaternion.");
        }
        float inverseMagnitudeSquared = 1.0f / magnitudeSquared;
        return new Quaternion(-quaternion.m_80140_() * inverseMagnitudeSquared, -quaternion.m_80150_() * inverseMagnitudeSquared, -quaternion.m_80153_() * inverseMagnitudeSquared, quaternion.m_80156_() * inverseMagnitudeSquared);
    }

    static {
        show = false;
        counter = 0.0f;
        DAMAGE_INDICATOR = (gui, poseStack, partialTick, width, height) -> {
            if (!gui.getMinecraft().f_91066_.f_92062_ && gui.getMinecraft().f_91066_.m_92176_().m_90612_() && show) {
                int x = width / 2;
                int y = height;
                int posX = width / 2;
                int posY = height / 2;
                float deltaFrameTime = gui.getMinecraft().m_91297_();
                if ((counter += deltaFrameTime) >= (float)((Integer)DamageIndicatorClientConfig.INDICATE_TIME.get()).intValue()) {
                    show = false;
                }
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)INDICATOR);
                if (((Boolean)DamageIndicatorClientConfig.DIRECTIONAL_DAMAGE_TRACKING.get()).booleanValue()) {
                    finalAngle = IndicatorOverlay.calculateFinalAngle(Minecraft.m_91087_().f_91074_.m_20156_(), Minecraft.m_91087_().f_91074_.m_20182_(), Minecraft.m_91087_().f_91074_.m_20182_().m_82549_(damageVec));
                }
                float radians = (float)Math.toRadians(finalAngle);
                int imageWidth = 100;
                int centerX = posX;
                int centerY = posY;
                poseStack.m_85837_((double)centerX, (double)centerY, 0.0);
                Quaternion quaternion = new Quaternion(0.0f, 0.0f, (float)Math.sin(radians / 2.0f), (float)Math.cos(radians / 2.0f));
                poseStack.m_85845_(quaternion);
                poseStack.m_85837_((double)(-centerX), (double)(-centerY), 0.0);
                RenderSystem.m_157179_((int)0, (ResourceLocation)INDICATOR);
                GuiComponent.m_93133_((PoseStack)poseStack, (int)(posX - imageWidth / 2), (int)(posY - imageWidth / 2), (float)0.0f, (float)0.0f, (int)imageWidth, (int)imageWidth, (int)imageWidth, (int)imageWidth);
                poseStack.m_85837_((double)centerX, (double)centerY, 0.0);
                poseStack.m_85845_(IndicatorOverlay.inverse(quaternion));
                poseStack.m_85837_((double)(-centerX), (double)(-centerY), 0.0);
            } else {
                counter = 0.0f;
            }
        };
    }
}

