/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyseq.damageindicator.networking;

import com.jeremyseq.damageindicator.client.overlays.IndicatorOverlay;
import com.mojang.math.Vector3f;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class TookDamageS2CPacket {
    private final Vector3f pos;

    public TookDamageS2CPacket(Vec3 pos) {
        this.pos = new Vector3f((float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_);
    }

    public TookDamageS2CPacket(FriendlyByteBuf buf) {
        String string = buf.m_130277_();
        String[] strings = string.split(",");
        this.pos = new Vector3f(Float.parseFloat(strings[0]), Float.parseFloat(strings[1]), Float.parseFloat(strings[2]));
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.pos.m_122239_() + "," + this.pos.m_122260_() + "," + this.pos.m_122269_());
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Vec3 damagePos = new Vec3(this.pos);
            Vec3 playerForwardVec = Minecraft.m_91087_().f_91074_.m_20156_();
            double finalAngle = TookDamageS2CPacket.calculateFinalAngle(playerForwardVec, Minecraft.m_91087_().f_91074_.m_20182_(), damagePos);
            IndicatorOverlay.damageVec = damagePos.m_82546_(Minecraft.m_91087_().f_91074_.m_20182_());
            IndicatorOverlay.finalAngle = finalAngle;
            IndicatorOverlay.counter = 0.0f;
            IndicatorOverlay.show = true;
        });
        context.setPacketHandled(true);
        return true;
    }

    private static double calculateFinalAngle(Vec3 playerForward, Vec3 playerPosition, Vec3 damagePosition) {
        double playerAngle = Math.atan2(playerForward.f_82479_, playerForward.f_82481_) * 180.0 / Math.PI;
        Vec2 enemyVec = new Vec2((float)damagePosition.f_82479_, (float)damagePosition.f_82481_).m_165910_(new Vec2((float)playerPosition.f_82479_, (float)playerPosition.f_82481_).m_165913_());
        double enemyAngle = Math.atan2(enemyVec.f_82470_, enemyVec.f_82471_) * 180.0 / Math.PI;
        double finalAngle = enemyAngle - playerAngle;
        return -finalAngle;
    }
}

