/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.biome.builder;

import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.regions_unexplored.data.worldgen.RuBiomeDefaultFeatures;
import net.regions_unexplored.data.worldgen.placement.RuTreePlacements;
import net.regions_unexplored.data.worldgen.placement.RuVegetationPlacements;

public class AridBiomes {
    protected static final int NORMAL_WATER_COLOR = 4159204;
    protected static final int NORMAL_WATER_FOG_COLOR = 329011;
    private static final int OVERWORLD_FOG_COLOR = 12638463;

    protected static int calculateSkyColor(float color) {
        float $$1 = color / 3.0f;
        $$1 = Mth.m_14036_((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }

    private static MobSpawnSettings.Builder baseSavannaSpawning() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126800_((MobSpawnSettings.Builder)spawnBuilder);
        return spawnBuilder;
    }

    private static MobSpawnSettings.Builder baseDesertSpawning() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20457_, 1, 2, 6));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20560_, 1, 1, 2));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        return spawnBuilder;
    }

    private static BiomeGenerationSettings.Builder baseSavannaGeneration(boolean addGrass) {
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        RuBiomeDefaultFeatures.globalOverworldGeneration(biomeBuilder);
        if (addGrass) {
            BiomeDefaultFeatures.m_126698_((BiomeGenerationSettings.Builder)biomeBuilder);
        }
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addDefaultSoftDisks(biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return biomeBuilder;
    }

    private static BiomeGenerationSettings.Builder baseDesertGeneration(boolean denseCactus) {
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addDefaultSoftDisks(biomeBuilder);
        BiomeDefaultFeatures.m_126716_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195401_);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195450_);
        if (!denseCactus) {
            biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195470_);
        } else {
            biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.CACTUS_DENSE);
        }
        BiomeDefaultFeatures.m_126755_((BiomeGenerationSettings.Builder)biomeBuilder);
        return biomeBuilder;
    }

    public static Biome baobabSavanna() {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(AridBiomes.calculateSkyColor(2.0f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(-6636971).m_48045_(-4670891).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_11653_((SoundEvent)SoundEvents.f_215731_));
        BiomeGenerationSettings.Builder biomeBuilder = AridBiomes.baseSavannaGeneration(true);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.MEGA_BAOBAB_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.ULTRA_BAOBAB_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.ACACIA_TREE_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.OAK_BUSH_SPARSE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.STONE_BUD_DENSE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.BAOBAB_ACACIA_SHRUB_MIX);
        MobSpawnSettings.Builder spawnBuilder = AridBiomes.baseSavannaSpawning();
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(2.0f).m_47611_(0.35f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome dryBushland() {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(AridBiomes.calculateSkyColor(2.0f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(-5060484).m_48045_(-3552115).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_11653_((SoundEvent)SoundEvents.f_215731_));
        BiomeGenerationSettings.Builder biomeBuilder = AridBiomes.baseSavannaGeneration(false);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.LARGE_SOCOTRA_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.SMALL_SOCOTRA_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.ACACIA_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.OAK_TREE_SHRUB_SPARSE);
        RuBiomeDefaultFeatures.addMallow(biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.SOCOTRA_VEGETATION);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.SOCOTRA_SHRUB);
        MobSpawnSettings.Builder spawnBuilder = AridBiomes.baseSavannaSpawning();
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(1.5f).m_47611_(0.0f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome joshuaDesert() {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(AridBiomes.calculateSkyColor(2.0f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(-8409523).m_48045_(-5213).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_11653_((SoundEvent)SoundEvents.f_215731_));
        BiomeGenerationSettings.Builder biomeBuilder = AridBiomes.baseDesertGeneration(false);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.LARGE_JOSHUA_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.MEDIUM_JOSHUA_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.JOSHUA_TREE_SHRUB);
        RuBiomeDefaultFeatures.addMallow(biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.JOSHUA_VEGETATION);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.JOSHUA_SHRUB);
        MobSpawnSettings.Builder spawnBuilder = AridBiomes.baseDesertSpawning();
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(2.0f).m_47611_(0.0f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome outback() {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(AridBiomes.calculateSkyColor(2.0f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(-8016810).m_48045_(-4670891).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_11653_((SoundEvent)SoundEvents.f_215731_));
        BiomeGenerationSettings.Builder biomeBuilder = AridBiomes.baseDesertGeneration(true);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.ACACIA_TREE_SHRUB);
        RuBiomeDefaultFeatures.addMallow(biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.OUTBACK_VEGETATION);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.ACACIA_SHRUB);
        MobSpawnSettings.Builder spawnBuilder = AridBiomes.baseDesertSpawning();
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(2.0f).m_47611_(0.0f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome saguaroDesert() {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(AridBiomes.calculateSkyColor(2.0f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(-6836695).m_48045_(-4212907).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_11653_((SoundEvent)SoundEvents.f_215731_));
        BiomeGenerationSettings.Builder biomeBuilder = AridBiomes.baseDesertGeneration(true);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.SAGUARO_CACTUS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.BARREL_CACTUS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.SANDY_GRASS);
        MobSpawnSettings.Builder spawnBuilder = AridBiomes.baseDesertSpawning();
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(2.0f).m_47611_(0.0f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome steppe() {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(AridBiomes.calculateSkyColor(2.0f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(-5589135).m_48045_(-5067675).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_11653_((SoundEvent)SoundEvents.f_184226_));
        BiomeGenerationSettings.Builder biomeBuilder = AridBiomes.baseSavannaGeneration(false);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.STEPPE_VEGETATION);
        MobSpawnSettings.Builder spawnBuilder = AridBiomes.baseSavannaSpawning();
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(1.5f).m_47611_(0.15f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }
}

