/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.biome.builder;

import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.regions_unexplored.data.worldgen.RuBiomeDefaultFeatures;
import net.regions_unexplored.data.worldgen.placement.RuTreePlacements;
import net.regions_unexplored.data.worldgen.placement.RuVegetationPlacements;

public class CoastalBiomes {
    protected static final int NORMAL_WATER_COLOR = 4159204;
    protected static final int NORMAL_WATER_FOG_COLOR = 329011;
    private static final int OVERWORLD_FOG_COLOR = 12638463;

    protected static int calculateSkyColor(float color) {
        float $$1 = color / 3.0f;
        $$1 = Mth.m_14036_((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }

    private static MobSpawnSettings.Builder baseCoastSpawning(boolean hasTurtle) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20520_, 12, 4, 4));
        if (hasTurtle) {
            spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20490_, 5, 2, 5));
        }
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        return spawnBuilder;
    }

    private static BiomeGenerationSettings.Builder baseCoastGeneration() {
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        RuBiomeDefaultFeatures.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addDefaultSoftDisks(biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return biomeBuilder;
    }

    public static Biome chalkCliffs() {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(CoastalBiomes.calculateSkyColor(0.8f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(-8414642).m_48045_(-6044317).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_11653_((SoundEvent)SoundEvents.f_215731_));
        BiomeGenerationSettings.Builder biomeBuilder = CoastalBiomes.baseCoastGeneration();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.OAK_BUSH_SPARSE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.DAISY);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TASSEL_SPARSE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.FLOWERING_SHRUB);
        MobSpawnSettings.Builder spawnBuilder = CoastalBiomes.baseCoastSpawning(false);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.775f).m_47611_(0.7f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome grassyBeach() {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(CoastalBiomes.calculateSkyColor(0.8f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(-8933043).m_48045_(-2697863).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_11653_((SoundEvent)SoundEvents.f_215731_));
        BiomeGenerationSettings.Builder biomeBuilder = CoastalBiomes.baseCoastGeneration();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.SANDY_GRASS_VEGETATION);
        MobSpawnSettings.Builder spawnBuilder = CoastalBiomes.baseCoastSpawning(true);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.85f).m_47611_(0.75f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome gravelBeach() {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(CoastalBiomes.calculateSkyColor(0.8f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(-8673714).m_48045_(-7819420).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_11653_((SoundEvent)SoundEvents.f_215731_));
        BiomeGenerationSettings.Builder biomeBuilder = CoastalBiomes.baseCoastGeneration();
        MobSpawnSettings.Builder spawnBuilder = CoastalBiomes.baseCoastSpawning(false);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.6f).m_47611_(0.6f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }
}

