/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.biome.builder;

import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.regions_unexplored.data.worldgen.RuBiomeDefaultFeatures;
import net.regions_unexplored.data.worldgen.placement.RuMiscOverworldPlacements;
import net.regions_unexplored.data.worldgen.placement.RuTreePlacements;
import net.regions_unexplored.data.worldgen.placement.RuVegetationPlacements;

public class ForestBiomes {
    protected static final int NORMAL_WATER_COLOR = 4159204;
    protected static final int NORMAL_WATER_FOG_COLOR = 329011;
    private static final int OVERWORLD_FOG_COLOR = 12638463;

    protected static int calculateSkyColor(float color) {
        float $$1 = color / 3.0f;
        $$1 = Mth.m_14036_((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }

    private static MobSpawnSettings.Builder baseForestSpawning() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        return spawnBuilder;
    }

    private static BiomeGenerationSettings.Builder baseForestGeneration(boolean addDefaultFlowers) {
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        RuBiomeDefaultFeatures.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        if (addDefaultFlowers) {
            BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)biomeBuilder);
        }
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addDefaultSoftDisks(biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return biomeBuilder;
    }

    public static Biome autumnalMapleForest() {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(ForestBiomes.calculateSkyColor(0.5f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(9877306).m_48045_(12896058).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_11653_((SoundEvent)SoundEvents.f_215731_));
        BiomeGenerationSettings.Builder biomeBuilder = ForestBiomes.baseForestGeneration(true);
        RuBiomeDefaultFeatures.autumnalTrees(biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.GRASS);
        RuBiomeDefaultFeatures.addTrillium(biomeBuilder);
        RuBiomeDefaultFeatures.addMapleGroundcover(biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.AUTUMNAL_SHRUB_MIX);
        MobSpawnSettings.Builder spawnBuilder = ForestBiomes.baseForestSpawning();
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.25f).m_47611_(0.35f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome bambooForest() {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(10666421).m_48019_(11652277).m_48034_(4159204).m_48037_(329011).m_48043_(11140963).m_48045_(11853428).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_11653_((SoundEvent)SoundEvents.f_215731_));
        BiomeGenerationSettings.Builder biomeBuilder = ForestBiomes.baseForestGeneration(true);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.BAMBOO_TREE);
        RuBiomeDefaultFeatures.addPinkFlowers(biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.FERNS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.CHERRY_SHRUB);
        RuBiomeDefaultFeatures.addBamboo(biomeBuilder);
        MobSpawnSettings.Builder spawnBuilder = ForestBiomes.baseForestSpawning();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20507_, 80, 1, 2));
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.875f).m_47611_(0.8f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome magnoliaHighlands() {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(ForestBiomes.calculateSkyColor(0.75f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(8437033).m_48045_(10406459).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_11653_((SoundEvent)SoundEvents.f_215731_));
        BiomeGenerationSettings.Builder biomeBuilder = ForestBiomes.baseForestGeneration(false);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.MAGNOLIA_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.PINK_MAGNOLIA_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.WHITE_MAGNOLIA_TREE);
        RuBiomeDefaultFeatures.addTsubaki(biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.DAY_LILY);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.MAGNOLIA_SHRUB_MIX);
        MobSpawnSettings.Builder spawnBuilder = ForestBiomes.baseForestSpawning();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 8, 2, 4));
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.95f).m_47611_(0.8f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome deciduousForest() {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(ForestBiomes.calculateSkyColor(0.7f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(7578936).m_48045_(8700997).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_11653_((SoundEvent)SoundEvents.f_215731_));
        BiomeGenerationSettings.Builder biomeBuilder = ForestBiomes.baseForestGeneration(true);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.BIG_OAK_TREE_DENSE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.SMALL_OAK_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.OAK_TREE_TALL);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.OAK_BUSH_SPARSE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.FALLEN_OAK_TREE_DENSE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.DECIDUOUS_VEGETATION);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.OAK_SHRUB);
        MobSpawnSettings.Builder spawnBuilder = ForestBiomes.baseForestSpawning();
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.75f).m_47611_(0.8f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome mapleForest() {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(ForestBiomes.calculateSkyColor(0.6f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(6462505).m_48045_(9550928).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_11653_((SoundEvent)SoundEvents.f_215731_));
        BiomeGenerationSettings.Builder biomeBuilder = ForestBiomes.baseForestGeneration(true);
        RuBiomeDefaultFeatures.mapleForestTrees(biomeBuilder);
        RuBiomeDefaultFeatures.mapleForestVegetation(biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.FALLEN_MAPLE_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.MAPLE_SHRUB_MIX);
        MobSpawnSettings.Builder spawnBuilder = ForestBiomes.baseForestSpawning();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 5, 4, 4));
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.6f).m_47611_(0.5f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome mauveHills() {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(ForestBiomes.calculateSkyColor(1.0f)).m_48019_(12638463).m_48034_(5546361).m_48037_(329011).m_48043_(3966928).m_48045_(7518100).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_11653_((SoundEvent)SoundEvents.f_215731_));
        BiomeGenerationSettings.Builder biomeBuilder = ForestBiomes.baseForestGeneration(true);
        RuBiomeDefaultFeatures.mauveTrees(biomeBuilder);
        RuBiomeDefaultFeatures.addAster(biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TASSEL_DENSE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.ENCHANTED_BIRCH_LEAF_PILE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.MAUVE_ENCHANTED_SHRUB_MIX);
        MobSpawnSettings.Builder spawnBuilder = ForestBiomes.baseForestSpawning();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20555_, 10, 4, 4));
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(1.1f).m_47611_(0.85f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome orchard() {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(ForestBiomes.calculateSkyColor(0.7f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(10669160).m_48045_(11717735).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_11653_((SoundEvent)SoundEvents.f_215731_));
        BiomeGenerationSettings.Builder biomeBuilder = ForestBiomes.baseForestGeneration(true);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.APPLE_OAK_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.BIG_APPLE_OAK_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.BIG_OAK_TREE_SPARSE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TASSEL_SPARSE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.OAK_SHRUB);
        MobSpawnSettings.Builder spawnBuilder = ForestBiomes.baseForestSpawning();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 8, 4, 4));
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.7f).m_47611_(0.4f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome silverBirchForest() {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(ForestBiomes.calculateSkyColor(0.5f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(8960834).m_48045_(11585338).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_11653_((SoundEvent)SoundEvents.f_215731_));
        BiomeGenerationSettings.Builder biomeBuilder = ForestBiomes.baseForestGeneration(false);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.SILVER_BIRCH_TALL);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.SILVER_BIRCH_DENSE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.FALLEN_SILVER_BIRCH_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TASSEL_SPARSE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.SILVER_BIRCH_LEAF_PILE_DENSE);
        RuBiomeDefaultFeatures.addOrangeCornflower(biomeBuilder);
        MobSpawnSettings.Builder spawnBuilder = ForestBiomes.baseForestSpawning();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 5, 4, 4));
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.5f).m_47611_(0.6f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome temperateGrove() {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(ForestBiomes.calculateSkyColor(0.8f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(7054415).m_48045_(8432236).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_11653_((SoundEvent)SoundEvents.f_215731_));
        BiomeGenerationSettings.Builder biomeBuilder = ForestBiomes.baseForestGeneration(true);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.OAK_TREE_WITH_BRANCH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.MAPLE_TREE_SPARSE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.BIRCH_TREE_ASPEN);
        RuBiomeDefaultFeatures.addMeadowRocks(biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.FALLEN_OAK_TREE_SPARSE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.GRASS);
        RuBiomeDefaultFeatures.addPurpleCornflower(biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.OAK_SHRUB);
        MobSpawnSettings.Builder spawnBuilder = ForestBiomes.baseForestSpawning();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 5, 4, 4));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 15, 3, 4));
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.725f).m_47611_(0.6f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome willowForest() {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(ForestBiomes.calculateSkyColor(0.7f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(7778144).m_48045_(8037223).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_11653_((SoundEvent)SoundEvents.f_215731_));
        BiomeGenerationSettings.Builder biomeBuilder = ForestBiomes.baseForestGeneration(true);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.BIG_WILLOW_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.WILLOW_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.SMALL_OAK_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.OAK_BUSH_SINGLE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.BLUE_MAGNOLIA_TREE);
        RuBiomeDefaultFeatures.addWillowFlowers(biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.FERNS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.WILLOW_MAGNOLIA_SHRUB_MIX);
        MobSpawnSettings.Builder spawnBuilder = ForestBiomes.baseForestSpawning();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 10, 3, 4));
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.6f).m_47611_(0.5f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }
}

