/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.biome.builder;

import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.regions_unexplored.data.worldgen.RuBiomeDefaultFeatures;
import net.regions_unexplored.data.worldgen.placement.RuMiscOverworldPlacements;
import net.regions_unexplored.data.worldgen.placement.RuTreePlacements;
import net.regions_unexplored.data.worldgen.placement.RuVegetationPlacements;

public class MountainBiomes {
    protected static final int NORMAL_WATER_COLOR = 4159204;
    protected static final int NORMAL_WATER_FOG_COLOR = 329011;
    private static final int OVERWORLD_FOG_COLOR = 12638463;

    protected static int calculateSkyColor(float color) {
        float $$1 = color / 3.0f;
        $$1 = Mth.m_14036_((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }

    private static MobSpawnSettings.Builder baseMountainSpawning() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_147035_, 5, 1, 3));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        return spawnBuilder;
    }

    private static MobSpawnSettings.Builder baseSlopeSpawning() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 4, 2, 3));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_147035_, 5, 1, 3));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        return spawnBuilder;
    }

    private static MobSpawnSettings.Builder baseExtremeHillsSpawning() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 4, 2, 3));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20466_, 5, 4, 6));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        return spawnBuilder;
    }

    private static BiomeGenerationSettings.Builder baseMountainGeneration() {
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        RuBiomeDefaultFeatures.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addDefaultSoftDisks(biomeBuilder);
        BiomeDefaultFeatures.m_126818_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126820_((BiomeGenerationSettings.Builder)biomeBuilder);
        return biomeBuilder;
    }

    private static BiomeGenerationSettings.Builder baseSlopeGeneration() {
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        RuBiomeDefaultFeatures.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addDefaultSoftDisks(biomeBuilder);
        BiomeDefaultFeatures.m_126818_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126820_((BiomeGenerationSettings.Builder)biomeBuilder);
        return biomeBuilder;
    }

    private static BiomeGenerationSettings.Builder baseExtremeHillsGeneration() {
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        RuBiomeDefaultFeatures.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addDefaultSoftDisks(biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126818_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126820_((BiomeGenerationSettings.Builder)biomeBuilder);
        return biomeBuilder;
    }

    public static Biome aridMountains() {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(MountainBiomes.calculateSkyColor(1.5f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(-6773446).m_48045_(-4279222).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_11653_((SoundEvent)SoundEvents.f_184226_));
        BiomeGenerationSettings.Builder biomeBuilder = MountainBiomes.baseMountainGeneration();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.OAK_TREE_SHRUB_ON_STONE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.STONE_BUD_SPARSE);
        MobSpawnSettings.Builder spawnBuilder = MountainBiomes.baseExtremeHillsSpawning();
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(2.0f).m_47611_(0.0f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome highlandFields() {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(MountainBiomes.calculateSkyColor(2.0f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(-8275350).m_48045_(-9782677).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_11653_((SoundEvent)SoundEvents.f_184223_));
        BiomeGenerationSettings.Builder biomeBuilder = MountainBiomes.baseSlopeGeneration();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.ROCK);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.NOISE_ROCKS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.NOISE_BUSH);
        RuBiomeDefaultFeatures.addDaisies(biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.GRASS);
        MobSpawnSettings.Builder spawnBuilder = MountainBiomes.baseSlopeSpawning();
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.65f).m_47611_(0.6f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome mountains() {
        boolean b = false;
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(MountainBiomes.calculateSkyColor(0.4f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(-9075130).m_48045_(-8083622).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_11653_((SoundEvent)SoundEvents.f_184221_));
        BiomeGenerationSettings.Builder biomeBuilder = MountainBiomes.baseMountainGeneration();
        if (!b) {
            biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.PINE_TREE_ON_DIRT);
        } else {
            biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.SCOTTS_PINE_TREE_ON_DIRT);
        }
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.FALLEN_PINE_TREE_ON_DIRT);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.MOUNTAIN_VEGETATION);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.PINE_SHRUB);
        MobSpawnSettings.Builder spawnBuilder = MountainBiomes.baseMountainSpawning();
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.28f).m_47611_(0.6f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome slopes() {
        boolean b = true;
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(MountainBiomes.calculateSkyColor(0.4f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(-9075130).m_48045_(-8083622).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_11653_((SoundEvent)SoundEvents.f_184221_));
        BiomeGenerationSettings.Builder biomeBuilder = MountainBiomes.baseMountainGeneration();
        if (!b) {
            biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.PINE_TREE_ON_DIRT);
        } else {
            biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.SCOTTS_PINE_TREE_ON_DIRT);
        }
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.FALLEN_PINE_TREE_ON_DIRT);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.MOUNTAIN_VEGETATION);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.PINE_SHRUB);
        MobSpawnSettings.Builder spawnBuilder = MountainBiomes.baseMountainSpawning();
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.28f).m_47611_(0.6f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome toweringCliffs() {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(MountainBiomes.calculateSkyColor(0.7f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(-7362208).m_48045_(-8482734).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_11653_((SoundEvent)SoundEvents.f_184226_));
        BiomeGenerationSettings.Builder biomeBuilder = MountainBiomes.baseExtremeHillsGeneration();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.SCOTTS_PINE_TREE_MOUNTAIN);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.DEAD_SCOTTS_PINE_TREE_MOUNTAIN);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.FALLEN_PINE_TREE);
        RuBiomeDefaultFeatures.addHyssop(biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.FERNS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.PINE_DEAD_SHRUB_MIX);
        MobSpawnSettings.Builder spawnBuilder = MountainBiomes.baseExtremeHillsSpawning();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_147035_, 5, 1, 3));
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.75f).m_47611_(0.8f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }
}

