/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.datagen.provider;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.worldgen.biome.RuBiomes;
import net.regions_unexplored.item.RuItems;
import org.slf4j.Logger;

public class RuAdvancementProvider
extends AdvancementProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final DataGenerator.PathProvider pathProvider;
    private final List<Consumer<Consumer<Advancement>>> tabs = ImmutableList.of((Object)new AdvancementBuilder());

    public RuAdvancementProvider(DataGenerator generatorIn, ExistingFileHelper fileHelperIn) {
        super(generatorIn, fileHelperIn);
        this.pathProvider = generatorIn.m_236036_(DataGenerator.Target.DATA_PACK, "advancements");
    }

    public void m_213708_(CachedOutput p_236158_) {
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = p_236162_ -> {
            if (!set.add(p_236162_.m_138327_())) {
                throw new IllegalStateException("Duplicate advancement " + p_236162_.m_138327_());
            }
            Path path = this.pathProvider.m_236048_(p_236162_.m_138327_());
            try {
                DataProvider.m_236072_((CachedOutput)p_236158_, (JsonElement)p_236162_.m_138313_().m_138400_(), (Path)path);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)path, (Object)ioexception);
            }
        };
        this.registerAdvancements(consumer, this.fileHelper);
    }

    protected void registerAdvancements(Consumer<Advancement> consumer, ExistingFileHelper fileHelper) {
        for (Consumer<Consumer<Advancement>> consumer1 : this.tabs) {
            consumer1.accept(consumer);
        }
    }

    private static class AdvancementBuilder
    implements Consumer<Consumer<Advancement>> {
        private AdvancementBuilder() {
        }

        @Override
        public void accept(Consumer<Advancement> saver) {
            Advancement PARENT = Advancement.Builder.m_138353_().m_138371_((ItemLike)RuBlocks.EUCALYPTUS_SAPLING.get(), (Component)Component.m_237115_((String)"advancements.regions_unexplored.title"), (Component)Component.m_237115_((String)"advancements.regions_unexplored.description"), new ResourceLocation("regions_unexplored:textures/gui/advancements/backgrounds/argillite.png"), FrameType.TASK, true, false, false).m_138386_("load_in_world", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52638_((ResourceKey)Level.f_46428_))).m_138389_(saver, "regions_unexplored:parent");
            Advancement PIONEER = Advancement.Builder.m_138353_().m_138398_(PARENT).m_138371_((ItemLike)RuBlocks.HIBISCUS.get(), (Component)Component.m_237115_((String)"advancements.regions_unexplored.pioneer.title"), (Component)Component.m_237115_((String)"advancements.regions_unexplored.pioneer.description"), new ResourceLocation("regions_unexplored:textures/gui/advancements/backgrounds/argillite.png"), FrameType.TASK, true, true, false).m_138386_("alpha_grove", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.ALPHA_GROVE))).m_138386_("arid_mountains", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.ARID_MOUNTAINS))).m_138386_("ashen_woodland", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.ASHEN_WOODLAND))).m_138386_("autumnal_maple_forest", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.AUTUMNAL_MAPLE_FOREST))).m_138386_("bayou", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.BAYOU))).m_138386_("bamboo_forest", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.BAMBOO_FOREST))).m_138386_("baobab_savanna", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.BAOBAB_SAVANNA))).m_138386_("barley_fields", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.BARLEY_FIELDS))).m_138386_("blackwood_taiga", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.BLACKWOOD_TAIGA))).m_138386_("boreal_forest", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.BOREAL_TAIGA))).m_138386_("chalk_cliffs", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.CHALK_CLIFFS))).m_138386_("cold_boreal_taiga", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.COLD_BOREAL_TAIGA))).m_138386_("cold_deciduous_forest", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.COLD_DECIDUOUS_FOREST))).m_138386_("cold_river", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.COLD_RIVER))).m_138386_("deciduous_forest", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.DECIDUOUS_FOREST))).m_138386_("dry_bushland", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.DRY_BUSHLAND))).m_138386_("eucalyptus_forest", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.EUCALYPTUS_FOREST))).m_138386_("fen", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.FEN))).m_138386_("flower_fields", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.FLOWER_FIELDS))).m_138386_("frozen_pine_taiga", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.FROZEN_PINE_TAIGA))).m_138386_("frozen_tundra", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.FROZEN_TUNDRA))).m_138386_("fungal_fen", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.FUNGAL_FEN))).m_138386_("golden_boreal_taiga", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.GOLDEN_BOREAL_TAIGA))).m_138386_("grassland", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.GRASSLAND))).m_138386_("grassy_beach", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.GRASSY_BEACH))).m_138386_("gravel_beach", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.GRAVEL_BEACH))).m_138386_("highland_fields", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.HIGHLAND_FIELDS))).m_138386_("hyacinth_deeps", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.HYACINTH_DEEPS))).m_138386_("icy_heights", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.ICY_HEIGHTS))).m_138386_("joshua_desert", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.JOSHUA_DESERT))).m_138386_("lupine_plains", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.CLOVER_PLAINS))).m_138386_("magnolia_highlands", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.MAGNOLIA_WOODLAND))).m_138386_("maple_forest", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.MAPLE_FOREST))).m_138386_("marsh", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.MARSH))).m_138386_("mauve_hills", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.MAUVE_HILLS))).m_138386_("mountains", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.MOUNTAINS))).m_138386_("muddy_river", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.MUDDY_RIVER))).m_138386_("old_growth_bayou", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.OLD_GROWTH_BAYOU))).m_138386_("ochard", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.ORCHARD))).m_138386_("outback", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.OUTBACK))).m_138386_("pine_slopes", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.PINE_SLOPES))).m_138386_("pine_taiga", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.PINE_TAIGA))).m_138386_("poppy_fields", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.POPPY_FIELDS))).m_138386_("prairie", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.PRAIRIE))).m_138386_("pumpkin_fields", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.PUMPKIN_FIELDS))).m_138386_("rainforest", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.RAINFOREST))).m_138386_("redwoods", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.REDWOODS))).m_138386_("rocky_meadow", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.ROCKY_MEADOW))).m_138386_("rocky_reef", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.ROCKY_REEF))).m_138386_("saguaro_desert", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.SAGUARO_DESERT))).m_138386_("shrubland", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.SHRUBLAND))).m_138386_("silver_birch_forest", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.SILVER_BIRCH_FOREST))).m_138386_("sparse_rainforest", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.SPARSE_RAINFOREST))).m_138386_("sparse_redwoods", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.SPARSE_REDWOODS))).m_138386_("spires", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.SPIRES))).m_138386_("steppe", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.STEPPE))).m_138386_("temperate_grove", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.TEMPERATE_GROVE))).m_138386_("towering_cliffs", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.TOWERING_CLIFFS))).m_138386_("tropical_river", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.TROPICAL_RIVER))).m_138386_("tropics", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.TROPICS))).m_138386_("willow_forest", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.WILLOW_FOREST))).m_138389_(saver, "regions_unexplored:pioneer");
            Advancement REGIONS_EXPLORED = Advancement.Builder.m_138353_().m_138398_(PIONEER).m_138371_((ItemLike)Items.f_42463_, (Component)Component.m_237115_((String)"advancements.regions_unexplored.regions_explored.title"), (Component)Component.m_237115_((String)"advancements.regions_unexplored.regions_explored.description"), new ResourceLocation("regions_unexplored:textures/gui/advancements/backgrounds/argillite.png"), FrameType.CHALLENGE, true, true, true).m_138386_("alpha_grove", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.ALPHA_GROVE))).m_138386_("ancient_delta", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.ANCIENT_DELTA))).m_138386_("arid_mountains", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.ARID_MOUNTAINS))).m_138386_("ashen_woodland", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.ASHEN_WOODLAND))).m_138386_("autumnal_maple_forest", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.AUTUMNAL_MAPLE_FOREST))).m_138386_("bayou", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.BAYOU))).m_138386_("bamboo_forest", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.BAMBOO_FOREST))).m_138386_("baobab_savanna", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.BAOBAB_SAVANNA))).m_138386_("barley_fields", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.BARLEY_FIELDS))).m_138386_("bioshroom_caves", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.BIOSHROOM_CAVES))).m_138386_("blackstone_basin", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.BLACKSTONE_BASIN))).m_138386_("blackwood_taiga", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.BLACKWOOD_TAIGA))).m_138386_("boreal_forest", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.BOREAL_TAIGA))).m_138386_("chalk_cliffs", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.CHALK_CLIFFS))).m_138386_("cold_boreal_taiga", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.COLD_BOREAL_TAIGA))).m_138386_("cold_deciduous_forest", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.COLD_DECIDUOUS_FOREST))).m_138386_("cold_river", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.COLD_RIVER))).m_138386_("deciduous_forest", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.DECIDUOUS_FOREST))).m_138386_("dry_bushland", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.DRY_BUSHLAND))).m_138386_("eucalyptus_forest", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.EUCALYPTUS_FOREST))).m_138386_("fen", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.FEN))).m_138386_("flower_fields", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.FLOWER_FIELDS))).m_138386_("frozen_pine_taiga", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.FROZEN_PINE_TAIGA))).m_138386_("frozen_tundra", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.FROZEN_TUNDRA))).m_138386_("fungal_fen", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.FUNGAL_FEN))).m_138386_("glistering_meadow", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.GLISTERING_MEADOW))).m_138386_("golden_boreal_taiga", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.GOLDEN_BOREAL_TAIGA))).m_138386_("grassland", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.GRASSLAND))).m_138386_("grassy_beach", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.GRASSY_BEACH))).m_138386_("gravel_beach", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.GRAVEL_BEACH))).m_138386_("highland_fields", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.HIGHLAND_FIELDS))).m_138386_("hyacinth_deeps", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.HYACINTH_DEEPS))).m_138386_("icy_heights", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.ICY_HEIGHTS))).m_138386_("infernal_holt", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.INFERNAL_HOLT))).m_138386_("joshua_desert", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.JOSHUA_DESERT))).m_138386_("lupine_plains", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.CLOVER_PLAINS))).m_138386_("magnolia_highlands", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.MAGNOLIA_WOODLAND))).m_138386_("maple_forest", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.MAPLE_FOREST))).m_138386_("marsh", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.MARSH))).m_138386_("mauve_hills", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.MAUVE_HILLS))).m_138386_("mountains", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.MOUNTAINS))).m_138386_("muddy_river", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.MUDDY_RIVER))).m_138386_("mycotoxic_undergrowth", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.MYCOTOXIC_UNDERGROWTH))).m_138386_("old_growth_bayou", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.OLD_GROWTH_BAYOU))).m_138386_("ochard", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.ORCHARD))).m_138386_("outback", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.OUTBACK))).m_138386_("pine_slopes", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.PINE_SLOPES))).m_138386_("pine_taiga", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.PINE_TAIGA))).m_138386_("poppy_fields", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.POPPY_FIELDS))).m_138386_("prairie", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.PRAIRIE))).m_138386_("prismachasm", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.PRISMACHASM))).m_138386_("pumpkin_fields", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.PUMPKIN_FIELDS))).m_138386_("rainforest", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.RAINFOREST))).m_138386_("redstone_abyss", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.REDSTONE_ABYSS))).m_138386_("redstone_caves", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.REDSTONE_CAVES))).m_138386_("redwoods", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.REDWOODS))).m_138386_("rocky_meadow", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.ROCKY_MEADOW))).m_138386_("rocky_reef", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.ROCKY_REEF))).m_138386_("saguaro_desert", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.SAGUARO_DESERT))).m_138386_("scorching_caves", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.SCORCHING_CAVES))).m_138386_("shrubland", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.SHRUBLAND))).m_138386_("silver_birch_forest", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.SILVER_BIRCH_FOREST))).m_138386_("sparse_rainforest", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.SPARSE_RAINFOREST))).m_138386_("sparse_redwoods", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.SPARSE_REDWOODS))).m_138386_("spires", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.SPIRES))).m_138386_("steppe", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.STEPPE))).m_138386_("temperate_grove", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.TEMPERATE_GROVE))).m_138386_("towering_cliffs", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.TOWERING_CLIFFS))).m_138386_("tropical_river", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.TROPICAL_RIVER))).m_138386_("tropics", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.TROPICS))).m_138386_("willow_forest", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.WILLOW_FOREST))).m_138389_(saver, "regions_unexplored:regions_explored");
            Advancement EVERY_BIT_OF_THE_RAINBOW = Advancement.Builder.m_138353_().m_138398_(PIONEER).m_138371_((ItemLike)RuBlocks.WHITE_SNOWBELLE.get(), (Component)Component.m_237115_((String)"advancements.regions_unexplored.every_bit_of_the_rainbow.title"), (Component)Component.m_237115_((String)"advancements.regions_unexplored.every_bit_of_the_rainbow.description"), new ResourceLocation("regions_unexplored:textures/gui/advancements/backgrounds/argillite.png"), FrameType.TASK, true, true, false).m_138386_("white_snowbelle", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.WHITE_SNOWBELLE.get()).m_5456_()})).m_138386_("black_snowbelle", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.BLACK_SNOWBELLE.get()).m_5456_()})).m_138386_("blue_snowbelle", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.BLUE_SNOWBELLE.get()).m_5456_()})).m_138386_("green_snowbelle", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.GREEN_SNOWBELLE.get()).m_5456_()})).m_138386_("pink_snowbelle", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.PINK_SNOWBELLE.get()).m_5456_()})).m_138386_("brown_snowbelle", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.BROWN_SNOWBELLE.get()).m_5456_()})).m_138386_("cyan_snowbelle", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.CYAN_SNOWBELLE.get()).m_5456_()})).m_138386_("gray_snowbelle", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.GRAY_SNOWBELLE.get()).m_5456_()})).m_138386_("magenta_snowbelle", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.MAGENTA_SNOWBELLE.get()).m_5456_()})).m_138386_("red_snowbelle", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.RED_SNOWBELLE.get()).m_5456_()})).m_138386_("orange_snowbelle", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.ORANGE_SNOWBELLE.get()).m_5456_()})).m_138386_("yellow_snowbelle", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.YELLOW_SNOWBELLE.get()).m_5456_()})).m_138386_("purple_snowbelle", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.PURPLE_SNOWBELLE.get()).m_5456_()})).m_138386_("lime_snowbelle", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.LIME_SNOWBELLE.get()).m_5456_()})).m_138386_("light_gray_snowbelle", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.LIGHT_GRAY_SNOWBELLE.get()).m_5456_()})).m_138386_("light_blue_snowbelle", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.LIGHT_BLUE_SNOWBELLE.get()).m_5456_()})).m_138389_(saver, "regions_unexplored:every_bit_of_the_rainbow");
            Advancement FROM_THE_TREE_TOPS = Advancement.Builder.m_138353_().m_138398_(PIONEER).m_138371_((ItemLike)RuBlocks.KAPOK_VINES.get(), (Component)Component.m_237115_((String)"advancements.regions_unexplored.from_the_tree_tops.title"), (Component)Component.m_237115_((String)"advancements.regions_unexplored.from_the_tree_tops.description"), new ResourceLocation("regions_unexplored:textures/gui/advancements/backgrounds/argillite.png"), FrameType.TASK, true, true, false).m_138386_("kapok_vines", (CriterionTriggerInstance)EnterBlockTrigger.TriggerInstance.m_31297_((Block)((Block)RuBlocks.KAPOK_VINES_PLANT.get()))).m_138389_(saver, "regions_unexplored:from_the_tree_tops");
            Advancement LIGHT_AS_A_FROG = Advancement.Builder.m_138353_().m_138398_(PIONEER).m_138371_((ItemLike)RuBlocks.FLOWERING_LILY_PAD.get(), (Component)Component.m_237115_((String)"advancements.regions_unexplored.light_as_a_frog.title"), (Component)Component.m_237115_((String)"advancements.regions_unexplored.light_as_a_frog.description"), new ResourceLocation("regions_unexplored:textures/gui/advancements/backgrounds/argillite.png"), FrameType.TASK, true, true, false).m_138386_("lily_pad", (CriterionTriggerInstance)EnterBlockTrigger.TriggerInstance.m_31297_((Block)((Block)RuBlocks.GIANT_LILY_PAD.get()))).m_138389_(saver, "regions_unexplored:light_as_a_frog");
            Advancement ETERNAL_EXPEDITION = Advancement.Builder.m_138353_().m_138398_(PARENT).m_138371_((ItemLike)RuBlocks.BRIMWOOD_SAPLING.get(), (Component)Component.m_237115_((String)"advancements.regions_unexplored.eternal_expedition.title"), (Component)Component.m_237115_((String)"advancements.regions_unexplored.eternal_expedition.description"), new ResourceLocation("regions_unexplored:textures/gui/advancements/backgrounds/argillite.png"), FrameType.TASK, true, true, false).m_138386_("blackstone_basin", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.BLACKSTONE_BASIN))).m_138386_("mycotoxic_undergrowth", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.MYCOTOXIC_UNDERGROWTH))).m_138386_("glistering_meadow", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.GLISTERING_MEADOW))).m_138386_("infernal_holt", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.INFERNAL_HOLT))).m_138386_("redstone_abyss", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.REDSTONE_ABYSS))).m_138389_(saver, "regions_unexplored:eternal_expedition");
            Advancement DOWNER = Advancement.Builder.m_138353_().m_138398_(ETERNAL_EXPEDITION).m_138371_((ItemLike)RuBlocks.DORCEL.get(), (Component)Component.m_237115_((String)"advancements.regions_unexplored.downer.title"), (Component)Component.m_237115_((String)"advancements.regions_unexplored.downer.description"), new ResourceLocation("regions_unexplored:textures/gui/advancements/backgrounds/argillite.png"), FrameType.TASK, true, true, false).m_138386_("dorcel", (CriterionTriggerInstance)EnterBlockTrigger.TriggerInstance.m_31297_((Block)((Block)RuBlocks.DORCEL.get()))).m_138389_(saver, "regions_unexplored:downer");
            Advancement LIGHT_SNACK = Advancement.Builder.m_138353_().m_138398_(ETERNAL_EXPEDITION).m_138371_((ItemLike)RuBlocks.HANGING_EARLIGHT.get(), (Component)Component.m_237115_((String)"advancements.regions_unexplored.light_snack.title"), (Component)Component.m_237115_((String)"advancements.regions_unexplored.light_snack.description"), new ResourceLocation("regions_unexplored:textures/gui/advancements/backgrounds/argillite.png"), FrameType.TASK, true, true, false).m_138386_("earlight", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)RuItems.HANGING_EARLIGHT_FRUIT.get()))).m_138389_(saver, "regions_unexplored:light_snack");
            Advancement SPELUNKER = Advancement.Builder.m_138353_().m_138398_(PARENT).m_138371_((ItemLike)RuBlocks.DROPLEAF.get(), (Component)Component.m_237115_((String)"advancements.regions_unexplored.spelunker.title"), (Component)Component.m_237115_((String)"advancements.regions_unexplored.spelunker.description"), new ResourceLocation("regions_unexplored:textures/gui/advancements/backgrounds/argillite.png"), FrameType.TASK, true, true, false).m_138386_("bioshroom_caves", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.BIOSHROOM_CAVES))).m_138386_("ancient_delta", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.ANCIENT_DELTA))).m_138386_("prismachasm", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.PRISMACHASM))).m_138386_("redstone_caves", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.REDSTONE_CAVES))).m_138386_("scorching_caves", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(RuBiomes.SCORCHING_CAVES))).m_138389_(saver, "regions_unexplored:spelunker");
            Advancement BLIND_AS_A_BAT = Advancement.Builder.m_138353_().m_138398_(SPELUNKER).m_138371_((ItemLike)RuBlocks.DUSKMELON.get(), (Component)Component.m_237115_((String)"advancements.regions_unexplored.blind_as_a_bat.title"), (Component)Component.m_237115_((String)"advancements.regions_unexplored.blind_as_a_bat.description"), new ResourceLocation("regions_unexplored:textures/gui/advancements/backgrounds/argillite.png"), FrameType.TASK, true, true, false).m_138386_("duskmelon", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)RuItems.DUSKMELON_SLICE.get()))).m_138389_(saver, "regions_unexplored:blind_as_a_bat");
            Advancement THIS_TREE_BLEEDS_RED = Advancement.Builder.m_138353_().m_138398_(PARENT).m_138371_((ItemLike)RuBlocks.SOCOTRA_LOG.get(), (Component)Component.m_237115_((String)"advancements.regions_unexplored.this_tree_bleeds_red.title"), (Component)Component.m_237115_((String)"advancements.regions_unexplored.this_tree_bleeds_red.description"), new ResourceLocation("regions_unexplored:textures/gui/advancements/backgrounds/argillite.png"), FrameType.TASK, true, true, false).m_138386_("socotra_log", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.SOCOTRA_LOG.get()})).m_138389_(saver, "regions_unexplored:this_tree_bleeds_red");
            Advancement GOT_WOOD = Advancement.Builder.m_138353_().m_138398_(THIS_TREE_BLEEDS_RED).m_138371_((ItemLike)RuBlocks.REDWOOD_LOG.get(), (Component)Component.m_237115_((String)"advancements.regions_unexplored.got_wood.title"), (Component)Component.m_237115_((String)"advancements.regions_unexplored.got_wood.description"), new ResourceLocation("regions_unexplored:textures/gui/advancements/backgrounds/argillite.png"), FrameType.CHALLENGE, true, true, false).m_138386_("bamboo_log", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.BAMBOO_LOG.get()).m_5456_()})).m_138386_("small_oak_log", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.SMALL_OAK_LOG.get()).m_5456_()})).m_138386_("ashen_log", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.ASHEN_LOG.get()).m_5456_()})).m_138386_("silver_birch_log", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.SILVER_BIRCH_LOG.get()).m_5456_()})).m_138386_("alpha_log", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.ALPHA_LOG.get()).m_5456_()})).m_138386_("baobab_log", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.BAOBAB_LOG.get()).m_5456_()})).m_138386_("blackwood_log", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.BLACKWOOD_LOG.get()).m_5456_()})).m_138386_("brimwood_log", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.BRIMWOOD_LOG.get()).m_5456_()})).m_138386_("cobalt_log", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.COBALT_LOG.get()).m_5456_()})).m_138386_("cypress_log", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.CYPRESS_LOG.get()).m_5456_()})).m_138386_("dead_log", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.DEAD_LOG.get()).m_5456_()})).m_138386_("eucalyptus_log", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.EUCALYPTUS_LOG.get()).m_5456_()})).m_138386_("joshua_log", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.JOSHUA_LOG.get()).m_5456_()})).m_138386_("kapok_log", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.KAPOK_LOG.get()).m_5456_()})).m_138386_("larch_log", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.LARCH_LOG.get()).m_5456_()})).m_138386_("magnolia_log", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.MAGNOLIA_LOG.get()).m_5456_()})).m_138386_("maple_log", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.MAPLE_LOG.get()).m_5456_()})).m_138386_("mauve_log", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.MAUVE_LOG.get()).m_5456_()})).m_138386_("palm_log", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.PALM_LOG.get()).m_5456_()})).m_138386_("pine_log", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.PINE_LOG.get()).m_5456_()})).m_138386_("redwood_log", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.REDWOOD_LOG.get()).m_5456_()})).m_138386_("socotra_log", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.SOCOTRA_LOG.get()).m_5456_()})).m_138386_("willow_log", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.WILLOW_LOG.get()).m_5456_()})).m_138386_("blue_bioshroom_stem", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.BLUE_BIOSHROOM_STEM.get()).m_5456_()})).m_138386_("green_bioshroom_stem", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.GREEN_BIOSHROOM_STEM.get()).m_5456_()})).m_138386_("pink_bioshroom_stem", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.PINK_BIOSHROOM_STEM.get()).m_5456_()})).m_138386_("yellow_bioshroom_stem", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.YELLOW_BIOSHROOM_STEM.get()).m_5456_()})).m_138389_(saver, "regions_unexplored:got_wood");
            Advancement MYCOLOGIST = Advancement.Builder.m_138353_().m_138398_(PARENT).m_138371_((ItemLike)RuBlocks.BLUE_BIOSHROOM.get(), (Component)Component.m_237115_((String)"advancements.regions_unexplored.mycologist.title"), (Component)Component.m_237115_((String)"advancements.regions_unexplored.mycologist.description"), new ResourceLocation("regions_unexplored:textures/gui/advancements/backgrounds/argillite.png"), FrameType.TASK, true, true, false).m_138386_("blue_bioshroom", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.BLUE_BIOSHROOM.get()).m_5456_()})).m_138386_("pink_bioshroom", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.PINK_BIOSHROOM.get()).m_5456_()})).m_138386_("yellow_bioshroom", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.YELLOW_BIOSHROOM.get()).m_5456_()})).m_138386_("green_bioshroom", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.GREEN_BIOSHROOM.get()).m_5456_()})).m_138389_(saver, "regions_unexplored:mycologist");
            Advancement ANCIENT_SPECIMENS = Advancement.Builder.m_138353_().m_138398_(MYCOLOGIST).m_138371_((ItemLike)RuBlocks.BLUE_BIOSHROOM_STEM.get(), (Component)Component.m_237115_((String)"advancements.regions_unexplored.ancient_specimens.title"), (Component)Component.m_237115_((String)"advancements.regions_unexplored.ancient_specimens.description"), new ResourceLocation("regions_unexplored:textures/gui/advancements/backgrounds/argillite.png"), FrameType.CHALLENGE, true, true, false).m_138386_("blue_bioshroom_stem", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.BLUE_BIOSHROOM_STEM.get()).m_5456_()})).m_138386_("pink_bioshroom_stem", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.PINK_BIOSHROOM_STEM.get()).m_5456_()})).m_138386_("yellow_bioshroom_stem", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.YELLOW_BIOSHROOM_STEM.get()).m_5456_()})).m_138386_("green_bioshroom_stem", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((Block)RuBlocks.GREEN_BIOSHROOM_STEM.get()).m_5456_()})).m_138389_(saver, "regions_unexplored:ancient_specimens");
        }
    }
}

