/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.registry;

import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraftforge.registries.RegistryObject;
import net.regions_unexplored.RegionsUnexploredMod;
import net.regions_unexplored.config.RuCommonConfig;
import net.regions_unexplored.data.worldgen.biome.RuBiomes;
import net.regions_unexplored.data.worldgen.biome.builder.AquaticBiomes;
import net.regions_unexplored.data.worldgen.biome.builder.AridBiomes;
import net.regions_unexplored.data.worldgen.biome.builder.CaveBiomes;
import net.regions_unexplored.data.worldgen.biome.builder.CoastalBiomes;
import net.regions_unexplored.data.worldgen.biome.builder.ForestBiomes;
import net.regions_unexplored.data.worldgen.biome.builder.FrozenBiomes;
import net.regions_unexplored.data.worldgen.biome.builder.MountainBiomes;
import net.regions_unexplored.data.worldgen.biome.builder.NetherBiomes;
import net.regions_unexplored.data.worldgen.biome.builder.PlainsBiomes;
import net.regions_unexplored.data.worldgen.biome.builder.TaigaBiomes;
import net.regions_unexplored.data.worldgen.biome.builder.WetBiomes;
import net.regions_unexplored.data.worldgen.biome.surface.RuNetherSurfaceBuilder;
import net.regions_unexplored.data.worldgen.biome.surface.RuOverworldSurfaceBuilders;
import net.regions_unexplored.world.level.region.RuRegionNether;
import net.regions_unexplored.world.level.region.RuRegionPrimary;
import net.regions_unexplored.world.level.region.RuRegionSecondary;
import terrablender.api.Region;
import terrablender.api.Regions;
import terrablender.api.SurfaceRuleManager;

public class BiomeRegistry {
    public static void addBiomes() {
        BiomeRegistry.registerBiomes();
        BiomeRegistry.registerVillagerTypes();
    }

    public static void setupTerrablender() {
        Regions.register((Region)new RuRegionPrimary((Integer)RuCommonConfig.REGION_PRIMARY_WEIGHT.get()));
        Regions.register((Region)new RuRegionSecondary((Integer)RuCommonConfig.REGION_SECONDARY_WEIGHT.get()));
        Regions.register((Region)new RuRegionNether((Integer)RuCommonConfig.REGION_NETHER_WEIGHT.get()));
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.NETHER, (String)"regions_unexplored", (SurfaceRules.RuleSource)RuNetherSurfaceBuilder.makeRules());
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)"regions_unexplored", (SurfaceRules.RuleSource)RuOverworldSurfaceBuilders.makeRules());
    }

    public static void registerBiomes() {
        BiomeRegistry.register(RuBiomes.AUTUMNAL_MAPLE_FOREST, ForestBiomes::autumnalMapleForest);
        BiomeRegistry.register(RuBiomes.BAMBOO_FOREST, ForestBiomes::bambooForest);
        BiomeRegistry.register(RuBiomes.MAGNOLIA_WOODLAND, ForestBiomes::magnoliaHighlands);
        BiomeRegistry.register(RuBiomes.DECIDUOUS_FOREST, ForestBiomes::deciduousForest);
        BiomeRegistry.register(RuBiomes.MAPLE_FOREST, ForestBiomes::mapleForest);
        BiomeRegistry.register(RuBiomes.MAUVE_HILLS, ForestBiomes::mauveHills);
        BiomeRegistry.register(RuBiomes.ORCHARD, ForestBiomes::orchard);
        BiomeRegistry.register(RuBiomes.SILVER_BIRCH_FOREST, ForestBiomes::silverBirchForest);
        BiomeRegistry.register(RuBiomes.TEMPERATE_GROVE, ForestBiomes::temperateGrove);
        BiomeRegistry.register(RuBiomes.WILLOW_FOREST, ForestBiomes::willowForest);
        BiomeRegistry.register(RuBiomes.BLACKWOOD_TAIGA, TaigaBiomes::blackwoodTaiga);
        BiomeRegistry.register(RuBiomes.BOREAL_TAIGA, TaigaBiomes::borealTaiga);
        BiomeRegistry.register(RuBiomes.GOLDEN_BOREAL_TAIGA, TaigaBiomes::goldenBorealTaiga);
        BiomeRegistry.register(RuBiomes.PINE_TAIGA, TaigaBiomes::pineTaiga);
        BiomeRegistry.register(RuBiomes.REDWOODS, TaigaBiomes::redwoods);
        BiomeRegistry.register(RuBiomes.SPARSE_REDWOODS, TaigaBiomes::sparseRedwoods);
        BiomeRegistry.register(RuBiomes.BARLEY_FIELDS, PlainsBiomes::barleyFields);
        BiomeRegistry.register(RuBiomes.FLOWER_FIELDS, PlainsBiomes::flowerFields);
        BiomeRegistry.register(RuBiomes.GRASSLAND, PlainsBiomes::grassland);
        BiomeRegistry.register(RuBiomes.CLOVER_PLAINS, PlainsBiomes::lupinePlains);
        BiomeRegistry.register(RuBiomes.ROCKY_MEADOW, PlainsBiomes::rockyMeadow);
        BiomeRegistry.register(RuBiomes.POPPY_FIELDS, PlainsBiomes::poppyFields);
        BiomeRegistry.register(RuBiomes.PRAIRIE, PlainsBiomes::prairie);
        BiomeRegistry.register(RuBiomes.PUMPKIN_FIELDS, PlainsBiomes::pumpkinFields);
        BiomeRegistry.register(RuBiomes.SHRUBLAND, PlainsBiomes::shrubland);
        BiomeRegistry.register(RuBiomes.BAYOU, WetBiomes::bayou);
        BiomeRegistry.register(RuBiomes.EUCALYPTUS_FOREST, WetBiomes::eucalyptusForest);
        BiomeRegistry.register(RuBiomes.FEN, WetBiomes::fen);
        BiomeRegistry.register(RuBiomes.MARSH, WetBiomes::marsh);
        BiomeRegistry.register(RuBiomes.FUNGAL_FEN, WetBiomes::fungalFen);
        BiomeRegistry.register(RuBiomes.OLD_GROWTH_BAYOU, WetBiomes::oldGrowthBayou);
        BiomeRegistry.register(RuBiomes.SPARSE_RAINFOREST, WetBiomes::sparseRainforest);
        BiomeRegistry.register(RuBiomes.RAINFOREST, WetBiomes::rainforest);
        BiomeRegistry.register(RuBiomes.BAOBAB_SAVANNA, AridBiomes::baobabSavanna);
        BiomeRegistry.register(RuBiomes.DRY_BUSHLAND, AridBiomes::dryBushland);
        BiomeRegistry.register(RuBiomes.JOSHUA_DESERT, AridBiomes::joshuaDesert);
        BiomeRegistry.register(RuBiomes.OUTBACK, AridBiomes::outback);
        BiomeRegistry.register(RuBiomes.SAGUARO_DESERT, AridBiomes::saguaroDesert);
        BiomeRegistry.register(RuBiomes.STEPPE, AridBiomes::steppe);
        BiomeRegistry.register(RuBiomes.ARID_MOUNTAINS, MountainBiomes::aridMountains);
        BiomeRegistry.register(RuBiomes.HIGHLAND_FIELDS, MountainBiomes::highlandFields);
        BiomeRegistry.register(RuBiomes.MOUNTAINS, MountainBiomes::mountains);
        BiomeRegistry.register(RuBiomes.PINE_SLOPES, MountainBiomes::slopes);
        BiomeRegistry.register(RuBiomes.TOWERING_CLIFFS, MountainBiomes::toweringCliffs);
        BiomeRegistry.register(RuBiomes.CHALK_CLIFFS, CoastalBiomes::chalkCliffs);
        BiomeRegistry.register(RuBiomes.GRASSY_BEACH, CoastalBiomes::grassyBeach);
        BiomeRegistry.register(RuBiomes.GRAVEL_BEACH, CoastalBiomes::gravelBeach);
        BiomeRegistry.register(RuBiomes.ALPHA_GROVE, AquaticBiomes::alphaGrove);
        BiomeRegistry.register(RuBiomes.COLD_RIVER, AquaticBiomes::coldRiver);
        BiomeRegistry.register(RuBiomes.HYACINTH_DEEPS, AquaticBiomes::hyacinthDeeps);
        BiomeRegistry.register(RuBiomes.MUDDY_RIVER, AquaticBiomes::muddyRiver);
        BiomeRegistry.register(RuBiomes.ROCKY_REEF, AquaticBiomes::rockyReef);
        BiomeRegistry.register(RuBiomes.ASHEN_WOODLAND, AquaticBiomes::ashenWoodland);
        BiomeRegistry.register(RuBiomes.TROPICAL_RIVER, AquaticBiomes::tropicalRiver);
        BiomeRegistry.register(RuBiomes.TROPICS, AquaticBiomes::tropics);
        BiomeRegistry.register(RuBiomes.COLD_BOREAL_TAIGA, FrozenBiomes::coldBorealTaiga);
        BiomeRegistry.register(RuBiomes.COLD_DECIDUOUS_FOREST, FrozenBiomes::coldDeciduousForest);
        BiomeRegistry.register(RuBiomes.FROZEN_PINE_TAIGA, FrozenBiomes::frozenPineTaiga);
        BiomeRegistry.register(RuBiomes.FROZEN_TUNDRA, FrozenBiomes::frozenTundra);
        BiomeRegistry.register(RuBiomes.ICY_HEIGHTS, FrozenBiomes::icyHeights);
        BiomeRegistry.register(RuBiomes.SPIRES, FrozenBiomes::spires);
        BiomeRegistry.register(RuBiomes.ANCIENT_DELTA, CaveBiomes::ancientDelta);
        BiomeRegistry.register(RuBiomes.BIOSHROOM_CAVES, CaveBiomes::bioshroomCaves);
        BiomeRegistry.register(RuBiomes.PRISMACHASM, CaveBiomes::prismachasm);
        BiomeRegistry.register(RuBiomes.REDSTONE_CAVES, CaveBiomes::redstoneCaves);
        BiomeRegistry.register(RuBiomes.SCORCHING_CAVES, CaveBiomes::scorchingCaves);
        BiomeRegistry.register(RuBiomes.BLACKSTONE_BASIN, NetherBiomes::blackstoneBasin);
        BiomeRegistry.register(RuBiomes.INFERNAL_HOLT, NetherBiomes::infernalHolt);
        BiomeRegistry.register(RuBiomes.GLISTERING_MEADOW, NetherBiomes::glisteringMeadow);
        BiomeRegistry.register(RuBiomes.MYCOTOXIC_UNDERGROWTH, NetherBiomes::mycotoxicUndergrowth);
        BiomeRegistry.register(RuBiomes.REDSTONE_ABYSS, NetherBiomes::redstoneAbyss);
    }

    private static void registerVillagerTypes() {
        BiomeRegistry.registerVillagers(RuBiomes.AUTUMNAL_MAPLE_FOREST, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.BAMBOO_FOREST, VillagerType.f_35820_);
        BiomeRegistry.registerVillagers(RuBiomes.MAGNOLIA_WOODLAND, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.DECIDUOUS_FOREST, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.MAPLE_FOREST, VillagerType.f_35825_);
        BiomeRegistry.registerVillagers(RuBiomes.MAUVE_HILLS, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.ORCHARD, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.SILVER_BIRCH_FOREST, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.TEMPERATE_GROVE, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.WILLOW_FOREST, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.BLACKWOOD_TAIGA, VillagerType.f_35825_);
        BiomeRegistry.registerVillagers(RuBiomes.BOREAL_TAIGA, VillagerType.f_35825_);
        BiomeRegistry.registerVillagers(RuBiomes.GOLDEN_BOREAL_TAIGA, VillagerType.f_35825_);
        BiomeRegistry.registerVillagers(RuBiomes.PINE_TAIGA, VillagerType.f_35825_);
        BiomeRegistry.registerVillagers(RuBiomes.REDWOODS, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.SPARSE_REDWOODS, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.BARLEY_FIELDS, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.FLOWER_FIELDS, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.GRASSLAND, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.CLOVER_PLAINS, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.ROCKY_MEADOW, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.POPPY_FIELDS, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.PRAIRIE, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.PUMPKIN_FIELDS, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.SHRUBLAND, VillagerType.f_35825_);
        BiomeRegistry.registerVillagers(RuBiomes.BAYOU, VillagerType.f_35824_);
        BiomeRegistry.registerVillagers(RuBiomes.EUCALYPTUS_FOREST, VillagerType.f_35820_);
        BiomeRegistry.registerVillagers(RuBiomes.FEN, VillagerType.f_35824_);
        BiomeRegistry.registerVillagers(RuBiomes.MARSH, VillagerType.f_35824_);
        BiomeRegistry.registerVillagers(RuBiomes.FUNGAL_FEN, VillagerType.f_35824_);
        BiomeRegistry.registerVillagers(RuBiomes.OLD_GROWTH_BAYOU, VillagerType.f_35824_);
        BiomeRegistry.registerVillagers(RuBiomes.SPARSE_RAINFOREST, VillagerType.f_35820_);
        BiomeRegistry.registerVillagers(RuBiomes.RAINFOREST, VillagerType.f_35820_);
        BiomeRegistry.registerVillagers(RuBiomes.BAOBAB_SAVANNA, VillagerType.f_35822_);
        BiomeRegistry.registerVillagers(RuBiomes.DRY_BUSHLAND, VillagerType.f_35822_);
        BiomeRegistry.registerVillagers(RuBiomes.JOSHUA_DESERT, VillagerType.f_35819_);
        BiomeRegistry.registerVillagers(RuBiomes.OUTBACK, VillagerType.f_35822_);
        BiomeRegistry.registerVillagers(RuBiomes.SAGUARO_DESERT, VillagerType.f_35819_);
        BiomeRegistry.registerVillagers(RuBiomes.STEPPE, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.ARID_MOUNTAINS, VillagerType.f_35822_);
        BiomeRegistry.registerVillagers(RuBiomes.HIGHLAND_FIELDS, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.MOUNTAINS, VillagerType.f_35825_);
        BiomeRegistry.registerVillagers(RuBiomes.PINE_SLOPES, VillagerType.f_35825_);
        BiomeRegistry.registerVillagers(RuBiomes.TOWERING_CLIFFS, VillagerType.f_35825_);
        BiomeRegistry.registerVillagers(RuBiomes.CHALK_CLIFFS, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.GRASSY_BEACH, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.GRAVEL_BEACH, VillagerType.f_35825_);
        BiomeRegistry.registerVillagers(RuBiomes.ALPHA_GROVE, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.COLD_RIVER, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.HYACINTH_DEEPS, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.MUDDY_RIVER, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.ROCKY_REEF, VillagerType.f_35820_);
        BiomeRegistry.registerVillagers(RuBiomes.ASHEN_WOODLAND, VillagerType.f_35825_);
        BiomeRegistry.registerVillagers(RuBiomes.TROPICAL_RIVER, VillagerType.f_35820_);
        BiomeRegistry.registerVillagers(RuBiomes.TROPICS, VillagerType.f_35820_);
        BiomeRegistry.registerVillagers(RuBiomes.COLD_BOREAL_TAIGA, VillagerType.f_35823_);
        BiomeRegistry.registerVillagers(RuBiomes.COLD_DECIDUOUS_FOREST, VillagerType.f_35823_);
        BiomeRegistry.registerVillagers(RuBiomes.FROZEN_PINE_TAIGA, VillagerType.f_35823_);
        BiomeRegistry.registerVillagers(RuBiomes.FROZEN_TUNDRA, VillagerType.f_35823_);
        BiomeRegistry.registerVillagers(RuBiomes.ICY_HEIGHTS, VillagerType.f_35823_);
        BiomeRegistry.registerVillagers(RuBiomes.SPIRES, VillagerType.f_35823_);
        BiomeRegistry.registerVillagers(RuBiomes.BIOSHROOM_CAVES, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.ANCIENT_DELTA, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.PRISMACHASM, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.REDSTONE_CAVES, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.SCORCHING_CAVES, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.BLACKSTONE_BASIN, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.INFERNAL_HOLT, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.GLISTERING_MEADOW, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.MYCOTOXIC_UNDERGROWTH, VillagerType.f_35821_);
        BiomeRegistry.registerVillagers(RuBiomes.REDSTONE_ABYSS, VillagerType.f_35821_);
    }

    public static RegistryObject<Biome> register(ResourceKey<Biome> key, Supplier<Biome> biomeSupplier) {
        return RegionsUnexploredMod.BIOME_REGISTRY.register(key.m_135782_().m_135815_(), biomeSupplier);
    }

    private static void registerVillagers(ResourceKey<Biome> key, VillagerType type) {
        VillagerType.f_35827_.put(key, type);
    }
}

