/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.features.treedecorators;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.treedecorators.TrunkVineDecorator;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;

public class WillowTrunkDecorator
extends TrunkVineDecorator {
    public static final WillowTrunkDecorator INSTANCE = new WillowTrunkDecorator();
    public static Codec<WillowTrunkDecorator> codec = Codec.unit(() -> INSTANCE);
    public static TreeDecoratorType<?> tdt = new TreeDecoratorType(codec);

    protected TreeDecoratorType<?> m_6663_() {
        return tdt;
    }

    public void m_214187_(TreeDecorator.Context context) {
        BlockPos newpos = (BlockPos)context.m_226068_().get(0);
        if (context.m_226058_().m_7433_(newpos, WillowTrunkDecorator::isGrass)) {
            newpos = newpos.m_7494_();
        }
        this.placeRoot(context, newpos.m_122012_());
        this.placeRoot(context, newpos.m_122029_());
        this.placeRoot(context, newpos.m_122019_());
        this.placeRoot(context, newpos.m_122024_());
        this.placeLog(context, newpos.m_122012_().m_7494_());
        this.placeLog(context, newpos.m_122029_().m_7494_());
        this.placeLog(context, newpos.m_122019_().m_7494_());
        this.placeLog(context, newpos.m_122024_().m_7494_());
        this.placeLog(context, newpos.m_122012_().m_6630_(2));
        this.placeLog(context, newpos.m_122029_().m_6630_(2));
        this.placeLog(context, newpos.m_122019_().m_6630_(2));
        this.placeLog(context, newpos.m_122024_().m_6630_(2));
    }

    public void placeRoot(TreeDecorator.Context context, BlockPos pos) {
        LevelSimulatedReader level = context.m_226058_();
        Random random = new Random();
        int rd = random.nextInt(2) + 4;
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        for (int i = 0; i <= rd; ++i) {
            if (WillowTrunkDecorator.isReplaceable(level, (BlockPos)placePos) && level.m_7433_(placePos.m_7494_(), WillowTrunkDecorator::isDirt)) {
                context.m_226061_((BlockPos)placePos, Blocks.f_152548_.m_49966_());
                break;
            }
            this.placeLog(context, (BlockPos)placePos);
            placePos.m_122173_(Direction.DOWN);
        }
    }

    public void placeLog(TreeDecorator.Context context, BlockPos pos) {
        LevelSimulatedReader level = context.m_226058_();
        if (level.m_7433_(pos, WillowTrunkDecorator::isForestGrass)) {
            context.m_226061_(pos, ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_());
        } else if (level.m_7433_(pos, WillowTrunkDecorator::isPlainsGrass)) {
            context.m_226061_(pos, ((Block)RuBlocks.SILT_DIRT.get()).m_49966_());
        } else if (level.m_7433_(pos, WillowTrunkDecorator::isGrass)) {
            context.m_226061_(pos, Blocks.f_50493_.m_49966_());
        } else if (WillowTrunkDecorator.isReplaceable(level, pos)) {
            context.m_226061_(pos, ((Block)RuBlocks.WILLOW_LOG.get()).m_49966_());
        } else {
            return;
        }
        if (level.m_7433_(pos, WillowTrunkDecorator::isForestGrass)) {
            context.m_226061_(pos.m_7495_(), ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_());
        } else if (level.m_7433_(pos, WillowTrunkDecorator::isPlainsGrass)) {
            context.m_226061_(pos.m_7495_(), ((Block)RuBlocks.SILT_DIRT.get()).m_49966_());
        } else if (level.m_7433_(pos, WillowTrunkDecorator::isGrass)) {
            context.m_226061_(pos.m_7495_(), Blocks.f_50493_.m_49966_());
        }
    }

    public static boolean isGrass(BlockState state) {
        return state.m_60713_(Blocks.f_50440_) || state.m_60713_(Blocks.f_50195_) || state.m_60713_(Blocks.f_50493_) || state.m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get());
    }

    public static boolean isForestGrass(BlockState state) {
        return state.m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get()) || state.m_60713_((Block)RuBlocks.PEAT_DIRT.get());
    }

    public static boolean isPlainsGrass(BlockState state) {
        return state.m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get()) || state.m_60713_((Block)RuBlocks.SILT_DIRT.get());
    }

    public static boolean isDirt(BlockState state) {
        return state.m_204336_(BlockTags.f_144274_);
    }

    public static boolean isAllGrass(BlockState state) {
        return state.m_60713_(Blocks.f_50440_) || state.m_60713_(Blocks.f_50195_) || state.m_60713_(Blocks.f_50493_) || state.m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get()) || state.m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get()) || state.m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get()) || state.m_60713_((Block)RuBlocks.PEAT_DIRT.get()) || state.m_60713_((Block)RuBlocks.SILT_DIRT.get());
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.m_204336_(RuTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, WillowTrunkDecorator::isReplaceableBlock);
    }
}

