/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.biome;

import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.regions_unexplored.config.RuCommonConfig;
import net.regions_unexplored.config.RuPrimaryRegionConfig;
import net.regions_unexplored.config.RuSecondaryRegionConfig;
import net.regions_unexplored.data.worldgen.biome.RuBiomes;

public class DefaultBiomes {
    public static ResourceKey<Biome>[][] PRIMARY_MIDDLE_BIOMES = new ResourceKey[][]{{RuBiomes.FROZEN_TUNDRA, RuBiomes.FROZEN_TUNDRA, RuBiomes.FROZEN_PINE_TAIGA, RuBiomes.COLD_BOREAL_TAIGA, RuBiomes.COLD_BOREAL_TAIGA}, {RuBiomes.PUMPKIN_FIELDS, RuBiomes.AUTUMNAL_MAPLE_FOREST, RuBiomes.MAPLE_FOREST, RuBiomes.BOREAL_TAIGA, RuBiomes.BOREAL_TAIGA}, {RuBiomes.ORCHARD, RuBiomes.SHRUBLAND, RuBiomes.TEMPERATE_GROVE, RuBiomes.PINE_TAIGA, RuBiomes.BLACKWOOD_TAIGA}, {RuBiomes.BARLEY_FIELDS, RuBiomes.PRAIRIE, RuBiomes.GRASSLAND, RuBiomes.REDWOODS, RuBiomes.REDWOODS}, {RuBiomes.BAOBAB_SAVANNA, RuBiomes.BAOBAB_SAVANNA, RuBiomes.SAGUARO_DESERT, RuBiomes.OUTBACK, RuBiomes.EUCALYPTUS_FOREST}};
    public static ResourceKey<Biome>[][] PRIMARY_MIDDLE_BIOMES_VARIANT = new ResourceKey[][]{{RuBiomes.FROZEN_PINE_TAIGA, RuBiomes.FROZEN_TUNDRA, RuBiomes.FROZEN_TUNDRA, RuBiomes.COLD_BOREAL_TAIGA, RuBiomes.SPIRES}, {RuBiomes.AUTUMNAL_MAPLE_FOREST, RuBiomes.AUTUMNAL_MAPLE_FOREST, RuBiomes.MAPLE_FOREST, RuBiomes.BOREAL_TAIGA, RuBiomes.GOLDEN_BOREAL_TAIGA}, {RuBiomes.ORCHARD, RuBiomes.SHRUBLAND, RuBiomes.TEMPERATE_GROVE, RuBiomes.PINE_TAIGA, RuBiomes.BLACKWOOD_TAIGA}, {RuBiomes.PRAIRIE, RuBiomes.DECIDUOUS_FOREST, RuBiomes.GRASSLAND, RuBiomes.REDWOODS, RuBiomes.SPARSE_REDWOODS}, {RuBiomes.BAOBAB_SAVANNA, RuBiomes.BAOBAB_SAVANNA, RuBiomes.SAGUARO_DESERT, RuBiomes.OUTBACK, RuBiomes.EUCALYPTUS_FOREST}};
    public static ResourceKey<Biome>[][] PRIMARY_PLATEAU_BIOMES = new ResourceKey[][]{{RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS, RuBiomes.COLD_BOREAL_TAIGA}, {RuBiomes.AUTUMNAL_MAPLE_FOREST, RuBiomes.AUTUMNAL_MAPLE_FOREST, RuBiomes.MAPLE_FOREST, RuBiomes.BOREAL_TAIGA, RuBiomes.BOREAL_TAIGA}, {RuBiomes.HIGHLAND_FIELDS, RuBiomes.HIGHLAND_FIELDS, RuBiomes.HIGHLAND_FIELDS, RuBiomes.HIGHLAND_FIELDS, RuBiomes.BLACKWOOD_TAIGA}, {RuBiomes.BARLEY_FIELDS, RuBiomes.DECIDUOUS_FOREST, RuBiomes.DECIDUOUS_FOREST, RuBiomes.REDWOODS, RuBiomes.REDWOODS}, {RuBiomes.STEPPE, RuBiomes.STEPPE, RuBiomes.SAGUARO_DESERT, RuBiomes.EUCALYPTUS_FOREST, RuBiomes.EUCALYPTUS_FOREST}};
    public static ResourceKey<Biome>[][] PRIMARY_PLATEAU_BIOMES_VARIANT = new ResourceKey[][]{{RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS, RuBiomes.SPIRES}, {RuBiomes.AUTUMNAL_MAPLE_FOREST, RuBiomes.AUTUMNAL_MAPLE_FOREST, RuBiomes.MAPLE_FOREST, RuBiomes.BOREAL_TAIGA, RuBiomes.GOLDEN_BOREAL_TAIGA}, {RuBiomes.ORCHARD, RuBiomes.HIGHLAND_FIELDS, RuBiomes.TEMPERATE_GROVE, RuBiomes.PINE_TAIGA, RuBiomes.BLACKWOOD_TAIGA}, {RuBiomes.DECIDUOUS_FOREST, RuBiomes.DECIDUOUS_FOREST, RuBiomes.DECIDUOUS_FOREST, RuBiomes.REDWOODS, RuBiomes.SPARSE_REDWOODS}, {RuBiomes.STEPPE, RuBiomes.STEPPE, RuBiomes.SAGUARO_DESERT, RuBiomes.EUCALYPTUS_FOREST, RuBiomes.EUCALYPTUS_FOREST}};
    public static ResourceKey<Biome>[][] PRIMARY_SHATTERED_BIOMES = new ResourceKey[][]{{RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS}, {RuBiomes.TOWERING_CLIFFS, RuBiomes.TOWERING_CLIFFS, RuBiomes.TOWERING_CLIFFS, RuBiomes.TOWERING_CLIFFS, RuBiomes.TOWERING_CLIFFS}, {RuBiomes.TOWERING_CLIFFS, RuBiomes.TOWERING_CLIFFS, RuBiomes.TOWERING_CLIFFS, RuBiomes.TOWERING_CLIFFS, RuBiomes.TOWERING_CLIFFS}, {RuBiomes.BARLEY_FIELDS, RuBiomes.DECIDUOUS_FOREST, RuBiomes.DECIDUOUS_FOREST, RuBiomes.SPARSE_REDWOODS, RuBiomes.SPARSE_REDWOODS}, {RuBiomes.STEPPE, RuBiomes.STEPPE, RuBiomes.SAGUARO_DESERT, RuBiomes.EUCALYPTUS_FOREST, RuBiomes.EUCALYPTUS_FOREST}};
    public static ResourceKey<Biome>[][] PRIMARY_RIVER_BIOMES = new ResourceKey[][]{{Biomes.f_48212_, Biomes.f_48212_, Biomes.f_48212_, Biomes.f_48212_, RuBiomes.COLD_RIVER}, {RuBiomes.COLD_RIVER, RuBiomes.COLD_RIVER, RuBiomes.MUDDY_RIVER, RuBiomes.MUDDY_RIVER, RuBiomes.MUDDY_RIVER}, {Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, RuBiomes.BLACKWOOD_TAIGA}, {Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_}, {Biomes.f_48208_, Biomes.f_48208_, RuBiomes.TROPICAL_RIVER, RuBiomes.TROPICAL_RIVER, RuBiomes.TROPICAL_RIVER}};
    public static ResourceKey<Biome>[][] PRIMARY_RIVER_BIOMES_VARIANT = new ResourceKey[][]{{Biomes.f_48212_, Biomes.f_48212_, Biomes.f_48212_, Biomes.f_48212_, RuBiomes.COLD_RIVER}, {RuBiomes.COLD_RIVER, RuBiomes.COLD_RIVER, RuBiomes.MUDDY_RIVER, RuBiomes.MUDDY_RIVER, RuBiomes.MUDDY_RIVER}, {Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, RuBiomes.BLACKWOOD_TAIGA}, {Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_}, {Biomes.f_48208_, Biomes.f_48208_, RuBiomes.TROPICAL_RIVER, RuBiomes.TROPICAL_RIVER, RuBiomes.TROPICAL_RIVER}};
    public static ResourceKey<Biome>[][] PRIMARY_SWAMP_BIOMES = new ResourceKey[][]{{RuBiomes.SPIRES, RuBiomes.SPIRES, RuBiomes.SPIRES, RuBiomes.SPIRES, RuBiomes.SPIRES}, {RuBiomes.FEN, RuBiomes.FEN, RuBiomes.FEN, RuBiomes.FEN, RuBiomes.FEN}, {RuBiomes.OLD_GROWTH_BAYOU, RuBiomes.BAYOU, RuBiomes.BAYOU, RuBiomes.BAYOU, RuBiomes.OLD_GROWTH_BAYOU}, {RuBiomes.MARSH, RuBiomes.MARSH, RuBiomes.MARSH, RuBiomes.MARSH, RuBiomes.MARSH}, {RuBiomes.FUNGAL_FEN, RuBiomes.FUNGAL_FEN, RuBiomes.FUNGAL_FEN, RuBiomes.FUNGAL_FEN, RuBiomes.FUNGAL_FEN}};
    public static ResourceKey<Biome>[][] PRIMARY_OCEAN_BIOMES = new ResourceKey[][]{{RuBiomes.HYACINTH_DEEPS, Biomes.f_48171_, Biomes.f_48225_, Biomes.f_48170_, Biomes.f_48166_}, {Biomes.f_48211_, Biomes.f_48168_, Biomes.f_48174_, Biomes.f_48167_, RuBiomes.ROCKY_REEF}};
    public static ResourceKey<Biome>[] PRIMARY_ISLAND_BIOMES = new ResourceKey[]{RuBiomes.ALPHA_GROVE, RuBiomes.ASHEN_WOODLAND, RuBiomes.ASHEN_WOODLAND, RuBiomes.TROPICS, RuBiomes.TROPICS};
    public static ResourceKey<Biome>[] PRIMARY_BEACH_BIOMES = new ResourceKey[]{Biomes.f_48148_, RuBiomes.GRAVEL_BEACH, RuBiomes.GRASSY_BEACH, RuBiomes.GRASSY_BEACH, Biomes.f_48217_};
    public static ResourceKey<Biome>[] PRIMARY_STONE_SHORE_BIOMES = new ResourceKey[]{Biomes.f_186760_, RuBiomes.CHALK_CLIFFS};
    public static ResourceKey<Biome> PRIMARY_SHATTERED_CLIFF_BIOME = RuBiomes.TOWERING_CLIFFS;
    public static ResourceKey<Biome>[] PRIMARY_CAVE_BIOMES = new ResourceKey[]{Biomes.f_151785_, Biomes.f_151784_, Biomes.f_220594_, RuBiomes.BIOSHROOM_CAVES, RuBiomes.ANCIENT_DELTA, RuBiomes.PRISMACHASM, RuBiomes.REDSTONE_CAVES, RuBiomes.SCORCHING_CAVES};
    public static ResourceKey<Biome>[] PRIMARY_PEAK_BIOMES = new ResourceKey[]{Biomes.f_186757_, Biomes.f_186758_, RuBiomes.MOUNTAINS, Biomes.f_186759_, RuBiomes.ARID_MOUNTAINS};
    public static ResourceKey<Biome>[] PRIMARY_PEAK_BIOMES_VARIANT = new ResourceKey[]{Biomes.f_186758_, RuBiomes.MOUNTAINS, RuBiomes.MOUNTAINS, Biomes.f_186759_, RuBiomes.ARID_MOUNTAINS};
    public static ResourceKey<Biome>[] PRIMARY_SLOPE_BIOMES = new ResourceKey[]{Biomes.f_186756_, Biomes.f_186755_, RuBiomes.PINE_SLOPES, RuBiomes.DECIDUOUS_FOREST, RuBiomes.EUCALYPTUS_FOREST};
    public static ResourceKey<Biome>[] PRIMARY_SLOPE_BIOMES_VARIANT = new ResourceKey[]{RuBiomes.COLD_DECIDUOUS_FOREST, RuBiomes.PINE_SLOPES, RuBiomes.PINE_SLOPES, RuBiomes.DECIDUOUS_FOREST, RuBiomes.EUCALYPTUS_FOREST};
    public static ResourceKey<Biome>[][] SECONDARY_MIDDLE_BIOMES = new ResourceKey[][]{{RuBiomes.FROZEN_TUNDRA, RuBiomes.FROZEN_TUNDRA, RuBiomes.FROZEN_PINE_TAIGA, RuBiomes.COLD_BOREAL_TAIGA, RuBiomes.COLD_BOREAL_TAIGA}, {RuBiomes.POPPY_FIELDS, RuBiomes.SILVER_BIRCH_FOREST, RuBiomes.MAPLE_FOREST, RuBiomes.BOREAL_TAIGA, RuBiomes.BOREAL_TAIGA}, {RuBiomes.FLOWER_FIELDS, RuBiomes.ROCKY_MEADOW, RuBiomes.WILLOW_FOREST, RuBiomes.CLOVER_PLAINS, RuBiomes.BLACKWOOD_TAIGA}, {RuBiomes.MAUVE_HILLS, RuBiomes.ROCKY_MEADOW, RuBiomes.BAMBOO_FOREST, RuBiomes.REDWOODS, RuBiomes.REDWOODS}, {RuBiomes.DRY_BUSHLAND, RuBiomes.DRY_BUSHLAND, RuBiomes.JOSHUA_DESERT, RuBiomes.RAINFOREST, RuBiomes.RAINFOREST}};
    public static ResourceKey<Biome>[][] SECONDARY_MIDDLE_BIOMES_VARIANT = new ResourceKey[][]{{RuBiomes.FROZEN_PINE_TAIGA, RuBiomes.FROZEN_TUNDRA, RuBiomes.FROZEN_TUNDRA, RuBiomes.COLD_BOREAL_TAIGA, RuBiomes.SPIRES}, {RuBiomes.POPPY_FIELDS, RuBiomes.SILVER_BIRCH_FOREST, RuBiomes.MAPLE_FOREST, RuBiomes.BOREAL_TAIGA, RuBiomes.GOLDEN_BOREAL_TAIGA}, {RuBiomes.FLOWER_FIELDS, RuBiomes.ROCKY_MEADOW, RuBiomes.MAGNOLIA_WOODLAND, RuBiomes.CLOVER_PLAINS, RuBiomes.BLACKWOOD_TAIGA}, {RuBiomes.MAUVE_HILLS, RuBiomes.ROCKY_MEADOW, RuBiomes.BAMBOO_FOREST, RuBiomes.REDWOODS, RuBiomes.SPARSE_REDWOODS}, {RuBiomes.DRY_BUSHLAND, RuBiomes.DRY_BUSHLAND, RuBiomes.JOSHUA_DESERT, RuBiomes.RAINFOREST, RuBiomes.SPARSE_RAINFOREST}};
    public static ResourceKey<Biome>[][] SECONDARY_PLATEAU_BIOMES = new ResourceKey[][]{{RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS, RuBiomes.COLD_BOREAL_TAIGA}, {RuBiomes.POPPY_FIELDS, RuBiomes.SILVER_BIRCH_FOREST, RuBiomes.MAPLE_FOREST, RuBiomes.BOREAL_TAIGA, RuBiomes.BOREAL_TAIGA}, {RuBiomes.HIGHLAND_FIELDS, RuBiomes.HIGHLAND_FIELDS, RuBiomes.HIGHLAND_FIELDS, RuBiomes.HIGHLAND_FIELDS, RuBiomes.BLACKWOOD_TAIGA}, {RuBiomes.MAUVE_HILLS, RuBiomes.MAGNOLIA_WOODLAND, RuBiomes.MAGNOLIA_WOODLAND, RuBiomes.MAGNOLIA_WOODLAND, RuBiomes.REDWOODS}, {RuBiomes.STEPPE, RuBiomes.STEPPE, RuBiomes.JOSHUA_DESERT, RuBiomes.RAINFOREST, RuBiomes.RAINFOREST}};
    public static ResourceKey<Biome>[][] SECONDARY_PLATEAU_BIOMES_VARIANT = new ResourceKey[][]{{RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS, RuBiomes.SPIRES}, {RuBiomes.POPPY_FIELDS, RuBiomes.SILVER_BIRCH_FOREST, RuBiomes.MAPLE_FOREST, RuBiomes.BOREAL_TAIGA, RuBiomes.GOLDEN_BOREAL_TAIGA}, {RuBiomes.HIGHLAND_FIELDS, RuBiomes.HIGHLAND_FIELDS, RuBiomes.MAGNOLIA_WOODLAND, RuBiomes.CLOVER_PLAINS, RuBiomes.BLACKWOOD_TAIGA}, {RuBiomes.MAUVE_HILLS, RuBiomes.MAGNOLIA_WOODLAND, RuBiomes.MAGNOLIA_WOODLAND, RuBiomes.MAGNOLIA_WOODLAND, RuBiomes.SPARSE_REDWOODS}, {RuBiomes.STEPPE, RuBiomes.STEPPE, RuBiomes.JOSHUA_DESERT, RuBiomes.RAINFOREST, RuBiomes.SPARSE_RAINFOREST}};
    public static ResourceKey<Biome>[][] SECONDARY_SHATTERED_BIOMES = new ResourceKey[][]{{RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS}, {RuBiomes.TOWERING_CLIFFS, RuBiomes.TOWERING_CLIFFS, RuBiomes.TOWERING_CLIFFS, RuBiomes.TOWERING_CLIFFS, RuBiomes.TOWERING_CLIFFS}, {RuBiomes.TOWERING_CLIFFS, RuBiomes.TOWERING_CLIFFS, RuBiomes.TOWERING_CLIFFS, RuBiomes.TOWERING_CLIFFS, RuBiomes.TOWERING_CLIFFS}, {RuBiomes.MAGNOLIA_WOODLAND, RuBiomes.MAGNOLIA_WOODLAND, RuBiomes.MAGNOLIA_WOODLAND, RuBiomes.MAGNOLIA_WOODLAND, RuBiomes.SPARSE_REDWOODS}, {RuBiomes.STEPPE, RuBiomes.STEPPE, RuBiomes.JOSHUA_DESERT, RuBiomes.SPARSE_RAINFOREST, RuBiomes.SPARSE_RAINFOREST}};
    public static ResourceKey<Biome>[][] SECONDARY_RIVER_BIOMES = new ResourceKey[][]{{Biomes.f_48212_, Biomes.f_48212_, Biomes.f_48212_, Biomes.f_48212_, Biomes.f_48212_}, {RuBiomes.COLD_RIVER, RuBiomes.COLD_RIVER, RuBiomes.COLD_RIVER, RuBiomes.MUDDY_RIVER, RuBiomes.MUDDY_RIVER}, {Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_}, {Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_}, {Biomes.f_48208_, Biomes.f_48208_, RuBiomes.TROPICAL_RIVER, RuBiomes.TROPICAL_RIVER, RuBiomes.TROPICAL_RIVER}};
    public static ResourceKey<Biome>[][] SECONDARY_RIVER_BIOMES_VARIANT = new ResourceKey[][]{{Biomes.f_48212_, Biomes.f_48212_, Biomes.f_48212_, Biomes.f_48212_, Biomes.f_48212_}, {RuBiomes.COLD_RIVER, RuBiomes.COLD_RIVER, RuBiomes.COLD_RIVER, RuBiomes.MUDDY_RIVER, RuBiomes.MUDDY_RIVER}, {Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_}, {Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_}, {Biomes.f_48208_, Biomes.f_48208_, RuBiomes.TROPICAL_RIVER, RuBiomes.TROPICAL_RIVER, RuBiomes.TROPICAL_RIVER}};
    public static ResourceKey<Biome>[][] SECONDARY_SWAMP_BIOMES = new ResourceKey[][]{{RuBiomes.SPIRES, RuBiomes.SPIRES, RuBiomes.SPIRES, RuBiomes.SPIRES, RuBiomes.SPIRES}, {RuBiomes.FEN, RuBiomes.FEN, RuBiomes.FEN, RuBiomes.FEN, RuBiomes.FEN}, {RuBiomes.OLD_GROWTH_BAYOU, RuBiomes.BAYOU, RuBiomes.BAYOU, RuBiomes.BAYOU, RuBiomes.OLD_GROWTH_BAYOU}, {RuBiomes.MARSH, RuBiomes.MARSH, RuBiomes.MARSH, RuBiomes.MARSH, RuBiomes.MARSH}, {RuBiomes.FUNGAL_FEN, RuBiomes.FUNGAL_FEN, RuBiomes.FUNGAL_FEN, RuBiomes.FUNGAL_FEN, RuBiomes.FUNGAL_FEN}};
    public static ResourceKey<Biome>[][] SECONDARY_OCEAN_BIOMES = new ResourceKey[][]{{RuBiomes.HYACINTH_DEEPS, Biomes.f_48171_, Biomes.f_48225_, Biomes.f_48170_, Biomes.f_48166_}, {Biomes.f_48211_, Biomes.f_48168_, Biomes.f_48174_, Biomes.f_48167_, RuBiomes.ROCKY_REEF}};
    public static ResourceKey<Biome>[] SECONDARY_ISLAND_BIOMES = new ResourceKey[]{RuBiomes.ALPHA_GROVE, RuBiomes.ASHEN_WOODLAND, RuBiomes.ASHEN_WOODLAND, RuBiomes.TROPICS, RuBiomes.TROPICS};
    public static ResourceKey<Biome>[] SECONDARY_BEACH_BIOMES = new ResourceKey[]{Biomes.f_48148_, RuBiomes.GRAVEL_BEACH, RuBiomes.GRASSY_BEACH, RuBiomes.GRASSY_BEACH, Biomes.f_48217_};
    public static ResourceKey<Biome>[] SECONDARY_STONE_SHORE_BIOMES = new ResourceKey[]{Biomes.f_186760_, RuBiomes.CHALK_CLIFFS};
    public static ResourceKey<Biome> SECONDARY_SHATTERED_CLIFF_BIOME = RuBiomes.TOWERING_CLIFFS;
    public static ResourceKey<Biome>[] SECONDARY_CAVE_BIOMES = new ResourceKey[]{Biomes.f_151785_, Biomes.f_151784_, Biomes.f_220594_, RuBiomes.BIOSHROOM_CAVES, RuBiomes.ANCIENT_DELTA, RuBiomes.PRISMACHASM, RuBiomes.REDSTONE_CAVES, RuBiomes.SCORCHING_CAVES};
    public static ResourceKey<Biome>[] SECONDARY_PEAK_BIOMES = new ResourceKey[]{Biomes.f_186757_, Biomes.f_186758_, RuBiomes.MOUNTAINS, Biomes.f_186759_, RuBiomes.ARID_MOUNTAINS};
    public static ResourceKey<Biome>[] SECONDARY_PEAK_BIOMES_VARIANT = new ResourceKey[]{Biomes.f_186758_, RuBiomes.MOUNTAINS, RuBiomes.MOUNTAINS, Biomes.f_186759_, RuBiomes.ARID_MOUNTAINS};
    public static ResourceKey<Biome>[] SECONDARY_SLOPE_BIOMES = new ResourceKey[]{Biomes.f_186756_, Biomes.f_186755_, RuBiomes.PINE_SLOPES, RuBiomes.MAGNOLIA_WOODLAND, RuBiomes.RAINFOREST};
    public static ResourceKey<Biome>[] SECONDARY_SLOPE_BIOMES_VARIANT = new ResourceKey[]{RuBiomes.COLD_DECIDUOUS_FOREST, RuBiomes.PINE_SLOPES, RuBiomes.PINE_SLOPES, RuBiomes.MAGNOLIA_WOODLAND, RuBiomes.RAINFOREST};

    public static ResourceKey<Biome>[][] getPrimaryMiddleBiome() {
        ResourceKey[][] PRIMARY_MIDDLE_BIOMES_CUSTOM = new ResourceKey[][]{{DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_ICY_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_ICY_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_ICY_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_ICY_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_ICY_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_COOL_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_COOL_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_COOL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_COOL_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_COOL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_NEUTRAL_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_NEUTRAL_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_NEUTRAL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_NEUTRAL_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_NEUTRAL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_WARM_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_WARM_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_WARM_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_WARM_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_WARM_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_HOT_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_HOT_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_HOT_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_HOT_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_HOT_HUMID.get())}};
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return PRIMARY_MIDDLE_BIOMES_CUSTOM;
        }
        return PRIMARY_MIDDLE_BIOMES;
    }

    public static ResourceKey<Biome>[][] getPrimaryMiddleBiomeVariant() {
        ResourceKey[][] PRIMARY_MIDDLE_BIOMES_VARIANT_CUSTOM = new ResourceKey[][]{{DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_VAR_ICY_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_VAR_ICY_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_VAR_ICY_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_VAR_ICY_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_VAR_ICY_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_VAR_COOL_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_VAR_COOL_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_VAR_COOL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_VAR_COOL_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_VAR_COOL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_VAR_NEUTRAL_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_VAR_NEUTRAL_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_VAR_NEUTRAL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_VAR_NEUTRAL_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_VAR_NEUTRAL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_VAR_WARM_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_VAR_WARM_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_VAR_WARM_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_VAR_WARM_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_VAR_WARM_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_VAR_HOT_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_VAR_HOT_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_VAR_HOT_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_VAR_HOT_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.MID_VAR_HOT_HUMID.get())}};
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return PRIMARY_MIDDLE_BIOMES_VARIANT_CUSTOM;
        }
        return PRIMARY_MIDDLE_BIOMES_VARIANT;
    }

    public static ResourceKey<Biome>[][] getPrimaryPlateauBiome() {
        ResourceKey[][] PRIMARY_PLATEAU_BIOMES_CUSTOM = new ResourceKey[][]{{DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_ICY_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_ICY_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_ICY_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_ICY_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_ICY_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_COOL_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_COOL_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_COOL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_COOL_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_COOL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_NEUTRAL_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_NEUTRAL_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_NEUTRAL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_NEUTRAL_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_NEUTRAL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_WARM_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_WARM_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_WARM_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_WARM_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_WARM_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_HOT_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_HOT_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_HOT_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_HOT_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_HOT_HUMID.get())}};
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return PRIMARY_PLATEAU_BIOMES_CUSTOM;
        }
        return PRIMARY_PLATEAU_BIOMES;
    }

    public static ResourceKey<Biome>[][] getPrimaryPlateauBiomeVariant() {
        ResourceKey[][] PRIMARY_PLATEAU_BIOMES_VARIANT_CUSTOM = new ResourceKey[][]{{DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_VAR_ICY_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_VAR_ICY_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_VAR_ICY_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_VAR_ICY_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_VAR_ICY_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_VAR_COOL_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_VAR_COOL_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_VAR_COOL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_VAR_COOL_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_VAR_COOL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_VAR_NEUTRAL_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_VAR_NEUTRAL_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_VAR_NEUTRAL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_VAR_NEUTRAL_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_VAR_NEUTRAL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_VAR_WARM_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_VAR_WARM_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_VAR_WARM_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_VAR_WARM_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_VAR_WARM_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_VAR_HOT_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_VAR_HOT_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_VAR_HOT_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_VAR_HOT_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.PLT_VAR_HOT_HUMID.get())}};
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return PRIMARY_PLATEAU_BIOMES_VARIANT_CUSTOM;
        }
        return PRIMARY_PLATEAU_BIOMES_VARIANT;
    }

    public static ResourceKey<Biome>[][] getPrimaryShatteredBiome() {
        ResourceKey[][] PRIMARY_SHATTERED_BIOMES_CUSTOM = new ResourceKey[][]{{DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SHT_ICY_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SHT_ICY_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SHT_ICY_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SHT_ICY_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SHT_ICY_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SHT_COOL_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SHT_COOL_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SHT_COOL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SHT_COOL_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SHT_COOL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SHT_NEUTRAL_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SHT_NEUTRAL_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SHT_NEUTRAL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SHT_NEUTRAL_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SHT_NEUTRAL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SHT_WARM_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SHT_WARM_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SHT_WARM_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SHT_WARM_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SHT_WARM_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SHT_HOT_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SHT_HOT_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SHT_HOT_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SHT_HOT_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SHT_HOT_HUMID.get())}};
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return PRIMARY_SHATTERED_BIOMES_CUSTOM;
        }
        return PRIMARY_SHATTERED_BIOMES;
    }

    public static ResourceKey<Biome>[][] getPrimaryRiverBiome() {
        ResourceKey[][] PRIMARY_RIVER_BIOMES_CUSTOM = new ResourceKey[][]{{DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_ICY_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_ICY_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_ICY_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_ICY_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_ICY_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_COOL_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_COOL_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_COOL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_COOL_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_COOL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_NEUTRAL_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_NEUTRAL_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_NEUTRAL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_NEUTRAL_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_NEUTRAL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_WARM_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_WARM_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_WARM_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_WARM_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_WARM_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_HOT_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_HOT_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_HOT_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_HOT_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_HOT_HUMID.get())}};
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return PRIMARY_RIVER_BIOMES_CUSTOM;
        }
        return PRIMARY_RIVER_BIOMES;
    }

    public static ResourceKey<Biome>[][] getPrimaryRiverBiomeVariant() {
        ResourceKey[][] PRIMARY_RIVER_BIOMES_VARIANT_CUSTOM = new ResourceKey[][]{{DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_ICY_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_ICY_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_ICY_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_ICY_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_ICY_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_COOL_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_COOL_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_COOL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_COOL_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_COOL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_NEUTRAL_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_NEUTRAL_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_NEUTRAL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_NEUTRAL_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_NEUTRAL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_WARM_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_WARM_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_WARM_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_WARM_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_WARM_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_HOT_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_HOT_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_HOT_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_HOT_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.RVR_HOT_HUMID.get())}};
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return PRIMARY_RIVER_BIOMES_VARIANT_CUSTOM;
        }
        return PRIMARY_RIVER_BIOMES_VARIANT;
    }

    public static ResourceKey<Biome>[][] getPrimarySwampBiome() {
        ResourceKey[][] PRIMARY_SWAMP_BIOMES_CUSTOM = new ResourceKey[][]{{DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SMP_ICY_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SMP_ICY_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SMP_ICY_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SMP_ICY_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SMP_ICY_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SMP_COOL_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SMP_COOL_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SMP_COOL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SMP_COOL_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SMP_COOL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SMP_NEUTRAL_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SMP_NEUTRAL_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SMP_NEUTRAL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SMP_NEUTRAL_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SMP_NEUTRAL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SMP_WARM_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SMP_WARM_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SMP_WARM_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SMP_WARM_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SMP_WARM_HUMID.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SMP_HOT_ARID.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SMP_HOT_DRY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SMP_HOT_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SMP_HOT_WET.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SMP_HOT_HUMID.get())}};
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return PRIMARY_SWAMP_BIOMES_CUSTOM;
        }
        return PRIMARY_SWAMP_BIOMES;
    }

    public static ResourceKey<Biome>[][] getPrimaryOceanBiome() {
        ResourceKey[][] PRIMARY_OCEAN_BIOMES_CUSTOM = new ResourceKey[][]{{DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.OCA_DEP_ICY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.OCA_DEP_COOL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.OCA_DEP_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.OCA_DEP_WARM.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.OCA_DEP_HOT.get())}, {DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.OCA_ICY.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.OCA_COOL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.OCA_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.OCA_WARM.get()), DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.OCA_HOT.get())}};
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return PRIMARY_OCEAN_BIOMES_CUSTOM;
        }
        return PRIMARY_OCEAN_BIOMES;
    }

    public static ResourceKey<Biome> getPrimaryIslandBiome(int temperature) {
        if (temperature == 0) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.ICY_ISLAND.get());
            }
            return PRIMARY_ISLAND_BIOMES[0];
        }
        if (temperature == 1) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.COOL_ISLAND.get());
            }
            return PRIMARY_ISLAND_BIOMES[1];
        }
        if (temperature == 2) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.NEUTRAL_ISLAND.get());
            }
            return PRIMARY_ISLAND_BIOMES[2];
        }
        if (temperature == 3) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.WARM_ISLAND.get());
            }
            return PRIMARY_ISLAND_BIOMES[3];
        }
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.HOT_ISLAND.get());
        }
        return PRIMARY_ISLAND_BIOMES[4];
    }

    public static ResourceKey<Biome> getPrimaryBeachBiome(int temperature) {
        if (temperature == 0) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.ICY_BEACH.get());
            }
            return PRIMARY_BEACH_BIOMES[0];
        }
        if (temperature == 1) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.COOL_BEACH.get());
            }
            return PRIMARY_BEACH_BIOMES[1];
        }
        if (temperature == 2) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.NEUTRAL_BEACH.get());
            }
            return PRIMARY_BEACH_BIOMES[2];
        }
        if (temperature == 3) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.WARM_BEACH.get());
            }
            return PRIMARY_BEACH_BIOMES[3];
        }
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.HOT_BEACH.get());
        }
        return PRIMARY_BEACH_BIOMES[4];
    }

    public static ResourceKey<Biome> getPrimaryStoneShoreBiome(boolean isCold) {
        if (isCold) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.COLD_STONE_BEACH.get());
            }
            return PRIMARY_STONE_SHORE_BIOMES[0];
        }
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.HOT_STONE_BEACH.get());
        }
        return PRIMARY_STONE_SHORE_BIOMES[1];
    }

    public static ResourceKey<Biome> getPrimaryShatteredCliffBiome() {
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.SHA_CLI.get());
        }
        return PRIMARY_SHATTERED_CLIFF_BIOME;
    }

    public static ResourceKey<Biome> getPrimaryCaveBiome(int type) {
        if (type == 1) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.CAVE_1.get());
            }
            return PRIMARY_CAVE_BIOMES[0];
        }
        if (type == 2) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.CAVE_2.get());
            }
            return PRIMARY_CAVE_BIOMES[1];
        }
        if (type == 3) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.CAVE_3.get());
            }
            return PRIMARY_CAVE_BIOMES[2];
        }
        if (type == 4) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.CAVE_4.get());
            }
            return PRIMARY_CAVE_BIOMES[3];
        }
        if (type == 5) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.CAVE_5.get());
            }
            return PRIMARY_CAVE_BIOMES[4];
        }
        if (type == 6) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.CAVE_6.get());
            }
            return PRIMARY_CAVE_BIOMES[5];
        }
        if (type == 7) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.CAVE_7.get());
            }
            return PRIMARY_CAVE_BIOMES[6];
        }
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.CAVE_8.get());
        }
        return PRIMARY_CAVE_BIOMES[7];
    }

    public static ResourceKey<Biome> getPrimaryPeakBiome(int temperature) {
        if (temperature == 0) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.ICY_PEAK.get());
            }
            return PRIMARY_PEAK_BIOMES[0];
        }
        if (temperature == 1) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.COOL_PEAK.get());
            }
            return PRIMARY_PEAK_BIOMES[1];
        }
        if (temperature == 2) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.NEUTRAL_PEAK.get());
            }
            return PRIMARY_PEAK_BIOMES[2];
        }
        if (temperature == 3) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.WARM_PEAK.get());
            }
            return PRIMARY_PEAK_BIOMES[3];
        }
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.HOT_PEAK.get());
        }
        return PRIMARY_PEAK_BIOMES[4];
    }

    public static ResourceKey<Biome> getPrimaryPeakBiomeVariant(int temperature) {
        if (temperature == 0) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.ICY_PEAK_VAR.get());
            }
            return PRIMARY_PEAK_BIOMES_VARIANT[0];
        }
        if (temperature == 1) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.COOL_PEAK_VAR.get());
            }
            return PRIMARY_PEAK_BIOMES_VARIANT[1];
        }
        if (temperature == 2) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.NEUTRAL_PEAK_VAR.get());
            }
            return PRIMARY_PEAK_BIOMES_VARIANT[2];
        }
        if (temperature == 3) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.WARM_PEAK_VAR.get());
            }
            return PRIMARY_PEAK_BIOMES_VARIANT[3];
        }
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.HOT_PEAK_VAR.get());
        }
        return PRIMARY_PEAK_BIOMES_VARIANT[4];
    }

    public static ResourceKey<Biome> getPrimarySlopeBiome(int temperature) {
        if (temperature == 0) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.ICY_SLOPE.get());
            }
            return PRIMARY_SLOPE_BIOMES[0];
        }
        if (temperature == 1) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.COOL_SLOPE.get());
            }
            return PRIMARY_SLOPE_BIOMES[1];
        }
        if (temperature == 2) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.NEUTRAL_SLOPE.get());
            }
            return PRIMARY_SLOPE_BIOMES[2];
        }
        if (temperature == 3) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.WARM_SLOPE.get());
            }
            return PRIMARY_SLOPE_BIOMES[3];
        }
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.HOT_SLOPE.get());
        }
        return PRIMARY_SLOPE_BIOMES[4];
    }

    public static ResourceKey<Biome> getPrimarySlopeBiomeVariant(int temperature) {
        if (temperature == 0) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.ICY_SLOPE_VAR.get());
            }
            return PRIMARY_SLOPE_BIOMES_VARIANT[0];
        }
        if (temperature == 1) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.COOL_SLOPE_VAR.get());
            }
            return PRIMARY_SLOPE_BIOMES_VARIANT[1];
        }
        if (temperature == 2) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.NEUTRAL_SLOPE_VAR.get());
            }
            return PRIMARY_SLOPE_BIOMES_VARIANT[2];
        }
        if (temperature == 3) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.WARM_SLOPE_VAR.get());
            }
            return PRIMARY_SLOPE_BIOMES_VARIANT[3];
        }
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return DefaultBiomes.getBiome((String)RuPrimaryRegionConfig.HOT_SLOPE_VAR.get());
        }
        return PRIMARY_SLOPE_BIOMES_VARIANT[4];
    }

    public static ResourceKey<Biome>[][] getSecondaryMiddleBiome() {
        ResourceKey[][] SECONDARY_MIDDLE_BIOMES_CUSTOM = new ResourceKey[][]{{DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_ICY_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_ICY_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_ICY_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_ICY_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_ICY_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_COOL_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_COOL_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_COOL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_COOL_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_COOL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_NEUTRAL_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_NEUTRAL_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_NEUTRAL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_NEUTRAL_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_NEUTRAL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_WARM_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_WARM_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_WARM_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_WARM_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_WARM_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_HOT_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_HOT_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_HOT_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_HOT_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_HOT_HUMID.get())}};
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return SECONDARY_MIDDLE_BIOMES_CUSTOM;
        }
        return SECONDARY_MIDDLE_BIOMES;
    }

    public static ResourceKey<Biome>[][] getSecondaryMiddleBiomeVariant() {
        ResourceKey[][] SECONDARY_MIDDLE_BIOMES_VARIANT_CUSTOM = new ResourceKey[][]{{DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_VAR_ICY_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_VAR_ICY_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_VAR_ICY_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_VAR_ICY_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_VAR_ICY_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_VAR_COOL_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_VAR_COOL_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_VAR_COOL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_VAR_COOL_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_VAR_COOL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_VAR_NEUTRAL_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_VAR_NEUTRAL_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_VAR_NEUTRAL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_VAR_NEUTRAL_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_VAR_NEUTRAL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_VAR_WARM_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_VAR_WARM_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_VAR_WARM_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_VAR_WARM_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_VAR_WARM_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_VAR_HOT_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_VAR_HOT_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_VAR_HOT_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_VAR_HOT_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.MID_VAR_HOT_HUMID.get())}};
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return SECONDARY_MIDDLE_BIOMES_VARIANT_CUSTOM;
        }
        return SECONDARY_MIDDLE_BIOMES_VARIANT;
    }

    public static ResourceKey<Biome>[][] getSecondaryPlateauBiome() {
        ResourceKey[][] SECONDARY_PLATEAU_BIOMES_CUSTOM = new ResourceKey[][]{{DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_ICY_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_ICY_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_ICY_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_ICY_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_ICY_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_COOL_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_COOL_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_COOL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_COOL_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_COOL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_NEUTRAL_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_NEUTRAL_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_NEUTRAL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_NEUTRAL_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_NEUTRAL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_WARM_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_WARM_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_WARM_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_WARM_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_WARM_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_HOT_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_HOT_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_HOT_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_HOT_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_HOT_HUMID.get())}};
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return SECONDARY_PLATEAU_BIOMES_CUSTOM;
        }
        return SECONDARY_PLATEAU_BIOMES;
    }

    public static ResourceKey<Biome>[][] getSecondaryPlateauBiomeVariant() {
        ResourceKey[][] SECONDARY_PLATEAU_BIOMES_VARIANT_CUSTOM = new ResourceKey[][]{{DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_VAR_ICY_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_VAR_ICY_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_VAR_ICY_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_VAR_ICY_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_VAR_ICY_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_VAR_COOL_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_VAR_COOL_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_VAR_COOL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_VAR_COOL_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_VAR_COOL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_VAR_NEUTRAL_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_VAR_NEUTRAL_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_VAR_NEUTRAL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_VAR_NEUTRAL_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_VAR_NEUTRAL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_VAR_WARM_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_VAR_WARM_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_VAR_WARM_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_VAR_WARM_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_VAR_WARM_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_VAR_HOT_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_VAR_HOT_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_VAR_HOT_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_VAR_HOT_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.PLT_VAR_HOT_HUMID.get())}};
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return SECONDARY_PLATEAU_BIOMES_VARIANT_CUSTOM;
        }
        return SECONDARY_PLATEAU_BIOMES_VARIANT;
    }

    public static ResourceKey<Biome>[][] getSecondaryShatteredBiome() {
        ResourceKey[][] SECONDARY_SHATTERED_BIOMES_CUSTOM = new ResourceKey[][]{{DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SHT_ICY_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SHT_ICY_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SHT_ICY_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SHT_ICY_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SHT_ICY_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SHT_COOL_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SHT_COOL_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SHT_COOL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SHT_COOL_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SHT_COOL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SHT_NEUTRAL_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SHT_NEUTRAL_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SHT_NEUTRAL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SHT_NEUTRAL_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SHT_NEUTRAL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SHT_WARM_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SHT_WARM_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SHT_WARM_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SHT_WARM_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SHT_WARM_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SHT_HOT_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SHT_HOT_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SHT_HOT_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SHT_HOT_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SHT_HOT_HUMID.get())}};
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return SECONDARY_SHATTERED_BIOMES_CUSTOM;
        }
        return SECONDARY_SHATTERED_BIOMES;
    }

    public static ResourceKey<Biome>[][] getSecondaryRiverBiome() {
        ResourceKey[][] SECONDARY_RIVER_BIOMES_CUSTOM = new ResourceKey[][]{{DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_ICY_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_ICY_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_ICY_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_ICY_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_ICY_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_COOL_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_COOL_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_COOL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_COOL_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_COOL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_NEUTRAL_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_NEUTRAL_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_NEUTRAL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_NEUTRAL_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_NEUTRAL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_WARM_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_WARM_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_WARM_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_WARM_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_WARM_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_HOT_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_HOT_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_HOT_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_HOT_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_HOT_HUMID.get())}};
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return SECONDARY_RIVER_BIOMES_CUSTOM;
        }
        return SECONDARY_RIVER_BIOMES;
    }

    public static ResourceKey<Biome>[][] getSecondaryRiverBiomeVariant() {
        ResourceKey[][] SECONDARY_RIVER_BIOMES_VARIANT_CUSTOM = new ResourceKey[][]{{DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_ICY_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_ICY_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_ICY_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_ICY_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_ICY_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_COOL_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_COOL_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_COOL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_COOL_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_COOL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_NEUTRAL_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_NEUTRAL_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_NEUTRAL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_NEUTRAL_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_NEUTRAL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_WARM_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_WARM_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_WARM_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_WARM_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_WARM_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_HOT_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_HOT_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_HOT_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_HOT_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.RVR_HOT_HUMID.get())}};
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return SECONDARY_RIVER_BIOMES_VARIANT_CUSTOM;
        }
        return SECONDARY_RIVER_BIOMES_VARIANT;
    }

    public static ResourceKey<Biome>[][] getSecondarySwampBiome() {
        ResourceKey[][] SECONDARY_SWAMP_BIOMES_CUSTOM = new ResourceKey[][]{{DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SMP_ICY_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SMP_ICY_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SMP_ICY_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SMP_ICY_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SMP_ICY_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SMP_COOL_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SMP_COOL_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SMP_COOL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SMP_COOL_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SMP_COOL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SMP_NEUTRAL_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SMP_NEUTRAL_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SMP_NEUTRAL_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SMP_NEUTRAL_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SMP_NEUTRAL_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SMP_WARM_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SMP_WARM_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SMP_WARM_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SMP_WARM_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SMP_WARM_HUMID.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SMP_HOT_ARID.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SMP_HOT_DRY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SMP_HOT_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SMP_HOT_WET.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SMP_HOT_HUMID.get())}};
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return SECONDARY_SWAMP_BIOMES_CUSTOM;
        }
        return SECONDARY_SWAMP_BIOMES;
    }

    public static ResourceKey<Biome>[][] getSecondaryOceanBiome() {
        ResourceKey[][] SECONDARY_OCEAN_BIOMES_CUSTOM = new ResourceKey[][]{{DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.OCA_DEP_ICY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.OCA_DEP_COOL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.OCA_DEP_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.OCA_DEP_WARM.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.OCA_DEP_HOT.get())}, {DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.OCA_ICY.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.OCA_COOL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.OCA_NEUTRAL.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.OCA_WARM.get()), DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.OCA_HOT.get())}};
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return SECONDARY_OCEAN_BIOMES_CUSTOM;
        }
        return SECONDARY_OCEAN_BIOMES;
    }

    public static ResourceKey<Biome> getSecondaryIslandBiome(int temperature) {
        if (temperature == 0) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.ICY_ISLAND.get());
            }
            return SECONDARY_ISLAND_BIOMES[0];
        }
        if (temperature == 1) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.COOL_ISLAND.get());
            }
            return SECONDARY_ISLAND_BIOMES[1];
        }
        if (temperature == 2) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.NEUTRAL_ISLAND.get());
            }
            return SECONDARY_ISLAND_BIOMES[2];
        }
        if (temperature == 3) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.WARM_ISLAND.get());
            }
            return SECONDARY_ISLAND_BIOMES[3];
        }
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.HOT_ISLAND.get());
        }
        return SECONDARY_ISLAND_BIOMES[4];
    }

    public static ResourceKey<Biome> getSecondaryBeachBiome(int temperature) {
        if (temperature == 0) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.ICY_BEACH.get());
            }
            return SECONDARY_BEACH_BIOMES[0];
        }
        if (temperature == 1) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.COOL_BEACH.get());
            }
            return SECONDARY_BEACH_BIOMES[1];
        }
        if (temperature == 2) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.NEUTRAL_BEACH.get());
            }
            return SECONDARY_BEACH_BIOMES[2];
        }
        if (temperature == 3) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.WARM_BEACH.get());
            }
            return SECONDARY_BEACH_BIOMES[3];
        }
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.HOT_BEACH.get());
        }
        return SECONDARY_BEACH_BIOMES[4];
    }

    public static ResourceKey<Biome> getSecondaryStoneShoreBiome(boolean isCold) {
        if (isCold) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.COLD_STONE_BEACH.get());
            }
            return SECONDARY_STONE_SHORE_BIOMES[0];
        }
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.HOT_STONE_BEACH.get());
        }
        return SECONDARY_STONE_SHORE_BIOMES[1];
    }

    public static ResourceKey<Biome> getSecondaryShatteredCliffBiome() {
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.SHA_CLI.get());
        }
        return SECONDARY_SHATTERED_CLIFF_BIOME;
    }

    public static ResourceKey<Biome> getSecondaryCaveBiome(int type) {
        if (type == 1) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.CAVE_1.get());
            }
            return SECONDARY_CAVE_BIOMES[0];
        }
        if (type == 2) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.CAVE_2.get());
            }
            return SECONDARY_CAVE_BIOMES[1];
        }
        if (type == 3) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.CAVE_3.get());
            }
            return SECONDARY_CAVE_BIOMES[2];
        }
        if (type == 4) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.CAVE_4.get());
            }
            return SECONDARY_CAVE_BIOMES[3];
        }
        if (type == 5) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.CAVE_5.get());
            }
            return SECONDARY_CAVE_BIOMES[4];
        }
        if (type == 6) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.CAVE_6.get());
            }
            return SECONDARY_CAVE_BIOMES[5];
        }
        if (type == 7) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.CAVE_7.get());
            }
            return SECONDARY_CAVE_BIOMES[6];
        }
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.CAVE_8.get());
        }
        return SECONDARY_CAVE_BIOMES[7];
    }

    public static ResourceKey<Biome> getSecondaryPeakBiome(int temperature) {
        if (temperature == 0) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.ICY_PEAK.get());
            }
            return SECONDARY_PEAK_BIOMES[0];
        }
        if (temperature == 1) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.COOL_PEAK.get());
            }
            return SECONDARY_PEAK_BIOMES[1];
        }
        if (temperature == 2) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.NEUTRAL_PEAK.get());
            }
            return SECONDARY_PEAK_BIOMES[2];
        }
        if (temperature == 3) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.WARM_PEAK.get());
            }
            return SECONDARY_PEAK_BIOMES[3];
        }
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.HOT_PEAK.get());
        }
        return SECONDARY_PEAK_BIOMES[4];
    }

    public static ResourceKey<Biome> getSecondaryPeakBiomeVariant(int temperature) {
        if (temperature == 0) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.ICY_PEAK_VAR.get());
            }
            return SECONDARY_PEAK_BIOMES_VARIANT[0];
        }
        if (temperature == 1) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.COOL_PEAK_VAR.get());
            }
            return SECONDARY_PEAK_BIOMES_VARIANT[1];
        }
        if (temperature == 2) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.NEUTRAL_PEAK_VAR.get());
            }
            return SECONDARY_PEAK_BIOMES_VARIANT[2];
        }
        if (temperature == 3) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.WARM_PEAK_VAR.get());
            }
            return SECONDARY_PEAK_BIOMES_VARIANT[3];
        }
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.HOT_PEAK_VAR.get());
        }
        return SECONDARY_PEAK_BIOMES_VARIANT[4];
    }

    public static ResourceKey<Biome> getSecondarySlopeBiome(int temperature) {
        if (temperature == 0) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.ICY_SLOPE.get());
            }
            return SECONDARY_SLOPE_BIOMES[0];
        }
        if (temperature == 1) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.COOL_SLOPE.get());
            }
            return SECONDARY_SLOPE_BIOMES[1];
        }
        if (temperature == 2) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.NEUTRAL_SLOPE.get());
            }
            return SECONDARY_SLOPE_BIOMES[2];
        }
        if (temperature == 3) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.WARM_SLOPE.get());
            }
            return SECONDARY_SLOPE_BIOMES[3];
        }
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.HOT_SLOPE.get());
        }
        return SECONDARY_SLOPE_BIOMES[4];
    }

    public static ResourceKey<Biome> getSecondarySlopeBiomeVariant(int temperature) {
        if (temperature == 0) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.ICY_SLOPE_VAR.get());
            }
            return SECONDARY_SLOPE_BIOMES_VARIANT[0];
        }
        if (temperature == 1) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.COOL_SLOPE_VAR.get());
            }
            return SECONDARY_SLOPE_BIOMES_VARIANT[1];
        }
        if (temperature == 2) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.NEUTRAL_SLOPE_VAR.get());
            }
            return SECONDARY_SLOPE_BIOMES_VARIANT[2];
        }
        if (temperature == 3) {
            if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
                return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.WARM_SLOPE_VAR.get());
            }
            return SECONDARY_SLOPE_BIOMES_VARIANT[3];
        }
        if (((Boolean)RuCommonConfig.TOGGLE_CUSTOM_REGIONS.get()).booleanValue()) {
            return DefaultBiomes.getBiome((String)RuSecondaryRegionConfig.HOT_SLOPE_VAR.get());
        }
        return SECONDARY_SLOPE_BIOMES_VARIANT[4];
    }

    public static boolean isBiomeEnabled(ResourceKey<Biome> biome) {
        if (biome == RuBiomes.ALPHA_GROVE) {
            return (Boolean)RuCommonConfig.TOGGLE_ALPHA_GROVE.get();
        }
        if (biome == RuBiomes.ARID_MOUNTAINS) {
            return (Boolean)RuCommonConfig.TOGGLE_ARID_MOUNTAINS.get();
        }
        if (biome == RuBiomes.AUTUMNAL_MAPLE_FOREST) {
            return (Boolean)RuCommonConfig.TOGGLE_AUTUMNAL_MAPLE_FOREST.get();
        }
        if (biome == RuBiomes.BAMBOO_FOREST) {
            return (Boolean)RuCommonConfig.TOGGLE_BAMBOO_FOREST.get();
        }
        if (biome == RuBiomes.BAOBAB_SAVANNA) {
            return (Boolean)RuCommonConfig.TOGGLE_BAOBAB_SAVANNA.get();
        }
        if (biome == RuBiomes.BARLEY_FIELDS) {
            return (Boolean)RuCommonConfig.TOGGLE_BARLEY_FIELDS.get();
        }
        if (biome == RuBiomes.BAYOU) {
            return (Boolean)RuCommonConfig.TOGGLE_BAYOU.get();
        }
        if (biome == RuBiomes.BLACKSTONE_BASIN) {
            return (Boolean)RuCommonConfig.TOGGLE_BLACKSTONE_BASIN.get();
        }
        if (biome == RuBiomes.BLACKWOOD_TAIGA) {
            return (Boolean)RuCommonConfig.TOGGLE_BLACKWOOD_TAIGA.get();
        }
        if (biome == RuBiomes.MAGNOLIA_WOODLAND) {
            return (Boolean)RuCommonConfig.TOGGLE_MAGNOLIA_WOODLAND.get();
        }
        if (biome == RuBiomes.BOREAL_TAIGA) {
            return (Boolean)RuCommonConfig.TOGGLE_BOREAL_TAIGA.get();
        }
        if (biome == RuBiomes.CHALK_CLIFFS) {
            return (Boolean)RuCommonConfig.TOGGLE_CHALK_CLIFFS.get();
        }
        if (biome == RuBiomes.COLD_BOREAL_TAIGA) {
            return (Boolean)RuCommonConfig.TOGGLE_COLD_BOREAL_TAIGA.get();
        }
        if (biome == RuBiomes.COLD_DECIDUOUS_FOREST) {
            return (Boolean)RuCommonConfig.TOGGLE_COLD_DECIDUOUS_FOREST.get();
        }
        if (biome == RuBiomes.COLD_RIVER) {
            return (Boolean)RuCommonConfig.TOGGLE_COLD_RIVER.get();
        }
        if (biome == RuBiomes.DECIDUOUS_FOREST) {
            return (Boolean)RuCommonConfig.TOGGLE_DECIDUOUS_FOREST.get();
        }
        if (biome == RuBiomes.DRY_BUSHLAND) {
            return (Boolean)RuCommonConfig.TOGGLE_DRY_BUSHLAND.get();
        }
        if (biome == RuBiomes.EUCALYPTUS_FOREST) {
            return (Boolean)RuCommonConfig.TOGGLE_EUCALYPTUS_FOREST.get();
        }
        if (biome == RuBiomes.FEN) {
            return (Boolean)RuCommonConfig.TOGGLE_FEN.get();
        }
        if (biome == RuBiomes.MARSH) {
            return (Boolean)RuCommonConfig.TOGGLE_MARSH.get();
        }
        if (biome == RuBiomes.FLOWER_FIELDS) {
            return (Boolean)RuCommonConfig.TOGGLE_FLOWER_FIELDS.get();
        }
        if (biome == RuBiomes.FROZEN_PINE_TAIGA) {
            return (Boolean)RuCommonConfig.TOGGLE_FROZEN_PINE_TAIGA.get();
        }
        if (biome == RuBiomes.FROZEN_TUNDRA) {
            return (Boolean)RuCommonConfig.TOGGLE_FROZEN_TUNDRA.get();
        }
        if (biome == RuBiomes.FUNGAL_FEN) {
            return (Boolean)RuCommonConfig.TOGGLE_FUNGAL_FEN.get();
        }
        if (biome == RuBiomes.OLD_GROWTH_BAYOU) {
            return (Boolean)RuCommonConfig.TOGGLE_OLD_GROWTH_BAYOU.get();
        }
        if (biome == RuBiomes.GOLDEN_BOREAL_TAIGA) {
            return (Boolean)RuCommonConfig.TOGGLE_GOLDEN_BOREAL_TAIGA.get();
        }
        if (biome == RuBiomes.GRASSLAND) {
            return (Boolean)RuCommonConfig.TOGGLE_GRASSLAND.get();
        }
        if (biome == RuBiomes.GRASSY_BEACH) {
            return (Boolean)RuCommonConfig.TOGGLE_GRASSY_BEACH.get();
        }
        if (biome == RuBiomes.GRAVEL_BEACH) {
            return (Boolean)RuCommonConfig.TOGGLE_GRAVEL_BEACH.get();
        }
        if (biome == RuBiomes.HIGHLAND_FIELDS) {
            return (Boolean)RuCommonConfig.TOGGLE_HIGHLAND_FIELDS.get();
        }
        if (biome == RuBiomes.HYACINTH_DEEPS) {
            return (Boolean)RuCommonConfig.TOGGLE_HYACINTH_DEEPS.get();
        }
        if (biome == RuBiomes.ICY_HEIGHTS) {
            return (Boolean)RuCommonConfig.TOGGLE_ICY_HEIGHTS.get();
        }
        if (biome == RuBiomes.JOSHUA_DESERT) {
            return (Boolean)RuCommonConfig.TOGGLE_JOSHUA_DESERT.get();
        }
        if (biome == RuBiomes.CLOVER_PLAINS) {
            return (Boolean)RuCommonConfig.TOGGLE_CLOVER_PLAINS.get();
        }
        if (biome == RuBiomes.MAPLE_FOREST) {
            return (Boolean)RuCommonConfig.TOGGLE_MAPLE_FOREST.get();
        }
        if (biome == RuBiomes.MAUVE_HILLS) {
            return (Boolean)RuCommonConfig.TOGGLE_MAUVE_HILLS.get();
        }
        if (biome == RuBiomes.ROCKY_MEADOW) {
            return (Boolean)RuCommonConfig.TOGGLE_MEADOW.get();
        }
        if (biome == RuBiomes.MOUNTAINS) {
            return (Boolean)RuCommonConfig.TOGGLE_MOUNTAINS.get();
        }
        if (biome == RuBiomes.MUDDY_RIVER) {
            return (Boolean)RuCommonConfig.TOGGLE_MUDDY_RIVER.get();
        }
        if (biome == RuBiomes.SPARSE_RAINFOREST) {
            return (Boolean)RuCommonConfig.TOGGLE_SPARSE_RAINFOREST.get();
        }
        if (biome == RuBiomes.ORCHARD) {
            return (Boolean)RuCommonConfig.TOGGLE_ORCHARD.get();
        }
        if (biome == RuBiomes.OUTBACK) {
            return (Boolean)RuCommonConfig.TOGGLE_OUTBACK.get();
        }
        if (biome == RuBiomes.PINE_TAIGA) {
            return (Boolean)RuCommonConfig.TOGGLE_PINE_TAIGA.get();
        }
        if (biome == RuBiomes.PINE_SLOPES) {
            return (Boolean)RuCommonConfig.TOGGLE_PINE_SLOPES.get();
        }
        if (biome == RuBiomes.POPPY_FIELDS) {
            return (Boolean)RuCommonConfig.TOGGLE_POPPY_FIELDS.get();
        }
        if (biome == RuBiomes.PRAIRIE) {
            return (Boolean)RuCommonConfig.TOGGLE_PRAIRIE.get();
        }
        if (biome == RuBiomes.PUMPKIN_FIELDS) {
            return (Boolean)RuCommonConfig.TOGGLE_PUMPKIN_FIELDS.get();
        }
        if (biome == RuBiomes.RAINFOREST) {
            return (Boolean)RuCommonConfig.TOGGLE_RAINFOREST.get();
        }
        if (biome == RuBiomes.REDWOODS) {
            return (Boolean)RuCommonConfig.TOGGLE_REDWOODS.get();
        }
        if (biome == RuBiomes.ROCKY_REEF) {
            return (Boolean)RuCommonConfig.TOGGLE_ROCKY_REEF.get();
        }
        if (biome == RuBiomes.SAGUARO_DESERT) {
            return (Boolean)RuCommonConfig.TOGGLE_SAGUARO_DESERT.get();
        }
        if (biome == RuBiomes.SHRUBLAND) {
            return (Boolean)RuCommonConfig.TOGGLE_SHRUBLAND.get();
        }
        if (biome == RuBiomes.SILVER_BIRCH_FOREST) {
            return (Boolean)RuCommonConfig.TOGGLE_SILVER_BIRCH_FOREST.get();
        }
        if (biome == RuBiomes.ASHEN_WOODLAND) {
            return (Boolean)RuCommonConfig.TOGGLE_ASHEN_WOODLAND.get();
        }
        if (biome == RuBiomes.SPARSE_REDWOODS) {
            return (Boolean)RuCommonConfig.TOGGLE_SPARSE_REDWOODS.get();
        }
        if (biome == RuBiomes.SPIRES) {
            return (Boolean)RuCommonConfig.TOGGLE_SPIRES.get();
        }
        if (biome == RuBiomes.STEPPE) {
            return (Boolean)RuCommonConfig.TOGGLE_STEPPE.get();
        }
        if (biome == RuBiomes.TEMPERATE_GROVE) {
            return (Boolean)RuCommonConfig.TOGGLE_TEMPERATE_GROVE.get();
        }
        if (biome == RuBiomes.TOWERING_CLIFFS) {
            return (Boolean)RuCommonConfig.TOGGLE_TOWERING_CLIFFS.get();
        }
        if (biome == RuBiomes.TROPICS) {
            return (Boolean)RuCommonConfig.TOGGLE_TROPICS.get();
        }
        if (biome == RuBiomes.TROPICAL_RIVER) {
            return (Boolean)RuCommonConfig.TOGGLE_TROPICAL_RIVER.get();
        }
        if (biome == RuBiomes.WILLOW_FOREST) {
            return (Boolean)RuCommonConfig.TOGGLE_WILLOW_FOREST.get();
        }
        if (biome == RuBiomes.BLACKSTONE_BASIN) {
            return (Boolean)RuCommonConfig.TOGGLE_BLACKSTONE_BASIN.get();
        }
        if (biome == RuBiomes.INFERNAL_HOLT) {
            return (Boolean)RuCommonConfig.TOGGLE_INFERNAL_HOLT.get();
        }
        if (biome == RuBiomes.GLISTERING_MEADOW) {
            return (Boolean)RuCommonConfig.TOGGLE_GLISTERING_MEADOW.get();
        }
        if (biome == RuBiomes.MYCOTOXIC_UNDERGROWTH) {
            return (Boolean)RuCommonConfig.TOGGLE_MYCOTOXIC_UNDERGROWTH.get();
        }
        if (biome == RuBiomes.REDSTONE_ABYSS) {
            return (Boolean)RuCommonConfig.TOGGLE_REDSTONE_ABYSS.get();
        }
        if (biome == RuBiomes.ANCIENT_DELTA) {
            return (Boolean)RuCommonConfig.TOGGLE_ANCIENT_DELTA.get();
        }
        if (biome == RuBiomes.BIOSHROOM_CAVES) {
            return (Boolean)RuCommonConfig.TOGGLE_BIOSHROOM_CAVES.get();
        }
        if (biome == RuBiomes.PRISMACHASM) {
            return (Boolean)RuCommonConfig.TOGGLE_PRISMACHASM.get();
        }
        if (biome == RuBiomes.REDSTONE_CAVES) {
            return (Boolean)RuCommonConfig.TOGGLE_REDSTONE_CAVES.get();
        }
        if (biome == RuBiomes.SCORCHING_CAVES) {
            return (Boolean)RuCommonConfig.TOGGLE_SCORCHING_CAVES.get();
        }
        return true;
    }

    public static ResourceKey<Biome> getBiome(String id) {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(id));
    }
}

