/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.block.plant.dusktrap;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.regions_unexplored.entity.RuDamageTypes;

public abstract class BaseDuskTrapBlock
extends DoublePlantBlock {
    protected static final VoxelShape CLOSED_AABB = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    protected static final AABB TOUCH_AABB = new AABB(0.3, 0.0, 0.3, 0.7, 16.0, 0.7);

    protected BaseDuskTrapBlock(BlockBehaviour.Properties p_273450_) {
        super(p_273450_);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_49342_, BlockPos p_49343_, CollisionContext p_49344_) {
        return this.getSignalForState(state) > 0 ? CLOSED_AABB : AABB;
    }

    protected int getClosedTime() {
        return 5;
    }

    public boolean isPossibleToRespawnInThis(BlockState p_279155_) {
        return true;
    }

    public void m_213897_(BlockState p_220768_, ServerLevel p_220769_, BlockPos p_220770_, RandomSource p_220771_) {
        int i = this.getSignalForState(p_220768_);
        if (i > 0) {
            this.checkClosed(null, (Level)p_220769_, p_220770_, p_220768_, i);
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        Vec3 entityPos = entity.m_20182_();
        Vec3 inPos = new Vec3((double)pos.m_123341_() + 0.002, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.002);
        Vec3 outPos = new Vec3((double)pos.m_123341_() + 0.998, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.998);
        boolean isInside = entityPos.f_82479_ > inPos.f_82479_ && entityPos.f_82481_ > inPos.f_82481_ && entityPos.f_82479_ < outPos.f_82479_ && entityPos.f_82481_ < outPos.f_82481_;
        boolean isItem = entity instanceof ItemEntity;
        if (!isItem && isInside) {
            entity.m_7601_(state, new Vec3(0.4, 0.1, 0.4));
        }
        if (!level.f_46443_) {
            if (entity.m_6084_() && isInside) {
                entity.m_6469_(RuDamageTypes.DUSK_TRAP, 3.0f);
            }
            entity.m_7601_(state, new Vec3(0.4, 0.1, 0.4));
            int i = this.getSignalForState(state);
            if (i == 0) {
                this.checkClosed(entity, level, pos, state, i);
            }
        }
    }

    private void checkClosed(@Nullable Entity entity, Level level, BlockPos pos, BlockState state, int power) {
        boolean flag1;
        int i = this.getSignalStrength(level, pos);
        boolean flag = power > 0;
        boolean bl = flag1 = i > 0;
        if (power != i) {
            BlockState blockstate = this.setSignalForState(state, i);
            if (blockstate.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER) {
                BlockPos blockpos = pos.m_7494_();
                level.m_7731_(blockpos, (BlockState)blockstate.m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.UPPER), 2);
            } else if (blockstate.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER) {
                BlockPos blockpos = pos.m_7495_();
                level.m_7731_(blockpos, (BlockState)blockstate.m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.LOWER), 2);
            }
            level.m_7731_(pos, blockstate, 2);
            this.updateNeighbours(level, pos);
            level.m_6550_(pos, state, blockstate);
        }
        if (!flag1 && flag) {
            level.m_5594_((Player)null, pos, SoundType.f_56715_.m_56775_(), SoundSource.BLOCKS, 0.3f, 0.6f);
            level.m_142346_(entity, GameEvent.f_223703_, pos);
        } else if (flag1 && !flag) {
            level.m_5594_((Player)null, pos, SoundType.f_56715_.m_56777_(), SoundSource.BLOCKS, 0.3f, 0.6f);
            level.m_142346_(entity, GameEvent.f_223702_, pos);
        }
        if (flag1) {
            level.m_186460_(new BlockPos((Vec3i)pos), (Block)this, this.getClosedTime());
        }
    }

    public void m_6810_(BlockState p_49319_, Level p_49320_, BlockPos p_49321_, BlockState p_49322_, boolean p_49323_) {
        if (!p_49323_ && !p_49319_.m_60713_(p_49322_.m_60734_())) {
            if (this.getSignalForState(p_49319_) > 0) {
                this.updateNeighbours(p_49320_, p_49321_);
            }
            super.m_6810_(p_49319_, p_49320_, p_49321_, p_49322_, p_49323_);
        }
    }

    protected void updateNeighbours(Level p_49292_, BlockPos p_49293_) {
        p_49292_.m_46672_(p_49293_, (Block)this);
        p_49292_.m_46672_(p_49293_.m_7495_(), (Block)this);
    }

    public int m_6378_(BlockState p_49309_, BlockGetter p_49310_, BlockPos p_49311_, Direction p_49312_) {
        return this.getSignalForState(p_49309_);
    }

    public int m_6376_(BlockState p_49346_, BlockGetter p_49347_, BlockPos p_49348_, Direction p_49349_) {
        return p_49349_ == Direction.UP ? this.getSignalForState(p_49346_) : 0;
    }

    public boolean m_7899_(BlockState p_49351_) {
        return true;
    }

    protected static int getEntityCount(Level p_289656_, AABB p_289647_, Class<? extends Entity> p_289686_) {
        return p_289656_.m_6443_(p_289686_, p_289647_, EntitySelector.f_20408_.and(p_289691_ -> !p_289691_.m_6090_())).size();
    }

    protected abstract int getSignalStrength(Level var1, BlockPos var2);

    protected abstract int getSignalForState(BlockState var1);

    protected abstract BlockState setSignalForState(BlockState var1, int var2);
}

