/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.block.saplinggrowers;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.Event;

public abstract class AbstractSuperTreeGrower
extends AbstractTreeGrower {
    public boolean m_213817_(ServerLevel level, ChunkGenerator generator, BlockPos pos, BlockState state, RandomSource random) {
        for (int i = 1; i >= -1; --i) {
            for (int j = 1; j >= -1; --j) {
                if (!AbstractSuperTreeGrower.isStarBlockSapling(state, (BlockGetter)level, pos, i, j)) continue;
                return this.placeSuper(level, generator, pos, state, random, i, j);
            }
        }
        return super.m_213817_(level, generator, pos, state, random);
    }

    @Nullable
    protected Holder<? extends ConfiguredFeature<?, ?>> getConfiguredSuperFeature(ServerLevel level, ChunkGenerator chunkGenerator, BlockPos pos, BlockState state, RandomSource random) {
        return this.getConfiguredSuperFeature(random);
    }

    @Nullable
    protected abstract Holder<? extends ConfiguredFeature<?, ?>> getConfiguredSuperFeature(RandomSource var1);

    public boolean placeSuper(ServerLevel level, ChunkGenerator generator, BlockPos pos, BlockState state, RandomSource random, int X, int Z) {
        Holder<? extends ConfiguredFeature<?, ?>> holder = this.getConfiguredSuperFeature(level, generator, pos, state, random);
        SaplingGrowTreeEvent event = ForgeEventFactory.blockGrowFeature((LevelAccessor)level, (RandomSource)random, (BlockPos)pos, holder);
        if (event.getResult().equals((Object)Event.Result.DENY) || event.getFeature() == null) {
            return false;
        }
        ConfiguredFeature configuredfeature = (ConfiguredFeature)event.getFeature().m_203334_();
        BlockState setAir = Blocks.f_50016_.m_49966_();
        level.m_7731_(pos.m_7918_(X, 0, Z), setAir, 4);
        level.m_7731_(pos.m_7918_(X, 0, Z + 1), setAir, 4);
        level.m_7731_(pos.m_7918_(X, 0, Z - 1), setAir, 4);
        level.m_7731_(pos.m_7918_(X + 1, 0, Z), setAir, 4);
        level.m_7731_(pos.m_7918_(X - 1, 0, Z), setAir, 4);
        if (configuredfeature.m_224953_((WorldGenLevel)level, generator, random, pos.m_7918_(X, 0, Z))) {
            return true;
        }
        level.m_7731_(pos.m_7918_(X, 0, Z), state, 4);
        level.m_7731_(pos.m_7918_(X, 0, Z + 1), state, 4);
        level.m_7731_(pos.m_7918_(X, 0, Z - 1), state, 4);
        level.m_7731_(pos.m_7918_(X + 1, 0, Z), state, 4);
        level.m_7731_(pos.m_7918_(X - 1, 0, Z), state, 4);
        return false;
    }

    public static boolean isStarBlockSapling(BlockState state, BlockGetter getter, BlockPos pos, int X, int Z) {
        Block block = state.m_60734_();
        return getter.m_8055_(pos.m_7918_(X, 0, Z)).m_60713_(block) && getter.m_8055_(pos.m_7918_(X, 0, Z + 1)).m_60713_(block) && getter.m_8055_(pos.m_7918_(X, 0, Z - 1)).m_60713_(block) && getter.m_8055_(pos.m_7918_(X + 1, 0, Z)).m_60713_(block) && getter.m_8055_(pos.m_7918_(X - 1, 0, Z)).m_60713_(block);
    }
}

