/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;
import net.regions_unexplored.world.level.feature.configuration.RuTreeConfiguration;

public class IceSpireFeature
extends Feature<RuTreeConfiguration> {
    public IceSpireFeature(Codec<RuTreeConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<RuTreeConfiguration> context) {
        RuTreeConfiguration treeConfiguration = (RuTreeConfiguration)context.m_159778_();
        BlockPos pos = context.m_159777_();
        RandomSource randomSource = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        int height_main = context.m_225041_().m_188503_(treeConfiguration.sizeVariation) + treeConfiguration.minimumSize;
        int height_2n = height_main > 10 ? height_main / 2 + randomSource.m_188503_(3) : height_main / 2;
        int height_2s = height_main > 10 ? height_main / 2 + randomSource.m_188503_(3) : height_main / 2;
        int height_2e = height_main > 10 ? height_main / 2 + randomSource.m_188503_(3) : height_main / 2;
        int height_2w = height_main > 10 ? height_main / 2 + randomSource.m_188503_(3) : height_main / 2;
        int height_ne = randomSource.m_188503_(5);
        int height_nw = randomSource.m_188503_(5);
        int height_se = randomSource.m_188503_(5);
        int height_sw = randomSource.m_188503_(5);
        BlockPos.MutableBlockPos checkPos = pos.m_122032_();
        for (int check = 0; check <= height_main; ++check) {
            if (!this.checkReplaceable((LevelAccessor)level, (BlockPos)checkPos)) {
                return false;
            }
            checkPos.m_122173_(Direction.UP);
        }
        if (randomSource.m_188503_(2) == 0) {
            this.generateSmallSpire((LevelAccessor)level, pos, randomSource, treeConfiguration);
            return true;
        }
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        for (int placeCheck = 0; placeCheck <= height_main; ++placeCheck) {
            this.placeLog((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            if (placeCheck <= height_ne) {
                if (placeCheck == height_ne) {
                    this.placeLeavesBlob((LevelAccessor)level, placePos.m_122012_().m_122029_(), randomSource, treeConfiguration);
                }
                this.placeLog((LevelAccessor)level, placePos.m_122012_().m_122029_(), randomSource, treeConfiguration);
            }
            if (placeCheck <= height_nw) {
                if (placeCheck == height_nw) {
                    this.placeLeavesBlob((LevelAccessor)level, placePos.m_122012_().m_122024_(), randomSource, treeConfiguration);
                }
                this.placeLog((LevelAccessor)level, placePos.m_122012_().m_122024_(), randomSource, treeConfiguration);
            }
            if (placeCheck <= height_se) {
                if (placeCheck == height_se) {
                    this.placeLeavesBlob((LevelAccessor)level, placePos.m_122019_().m_122029_(), randomSource, treeConfiguration);
                }
                this.placeLog((LevelAccessor)level, placePos.m_122019_().m_122029_(), randomSource, treeConfiguration);
            }
            if (placeCheck <= height_sw) {
                if (placeCheck == height_sw) {
                    this.placeLeavesBlob((LevelAccessor)level, placePos.m_122019_().m_122024_(), randomSource, treeConfiguration);
                }
                this.placeLog((LevelAccessor)level, placePos.m_122019_().m_122024_(), randomSource, treeConfiguration);
            }
            if (placeCheck <= height_2n) {
                if (placeCheck == height_2n) {
                    this.placeLeavesBlob((LevelAccessor)level, placePos.m_122012_(), randomSource, treeConfiguration);
                }
                this.placeLog((LevelAccessor)level, placePos.m_122012_(), randomSource, treeConfiguration);
            }
            if (placeCheck <= height_2s) {
                if (placeCheck == height_2s) {
                    this.placeLeavesBlob((LevelAccessor)level, placePos.m_122019_(), randomSource, treeConfiguration);
                }
                this.placeLog((LevelAccessor)level, placePos.m_122019_(), randomSource, treeConfiguration);
            }
            if (placeCheck <= height_2e) {
                if (placeCheck == height_2e) {
                    this.placeLeavesBlob((LevelAccessor)level, placePos.m_122029_(), randomSource, treeConfiguration);
                }
                this.placeLog((LevelAccessor)level, placePos.m_122029_(), randomSource, treeConfiguration);
            }
            if (placeCheck <= height_2w) {
                if (placeCheck == height_2w) {
                    this.placeLeavesBlob((LevelAccessor)level, placePos.m_122024_(), randomSource, treeConfiguration);
                }
                this.placeLog((LevelAccessor)level, placePos.m_122024_(), randomSource, treeConfiguration);
            }
            if (placeCheck == 0) {
                this.placeRoot((LevelAccessor)level, placePos.m_7495_(), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_7495_().m_122012_(), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_7495_().m_122012_().m_122029_(), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_7495_().m_122012_().m_122024_(), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_7495_().m_122019_(), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_7495_().m_122019_().m_122029_(), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_7495_().m_122019_().m_122024_(), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_7495_().m_122029_(), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_7495_().m_122024_(), randomSource, treeConfiguration);
                if (randomSource.m_188503_(2) == 0) {
                    this.placeLeavesBlob((LevelAccessor)level, placePos.m_122012_().m_122012_(), randomSource, treeConfiguration);
                    this.placeRoot((LevelAccessor)level, placePos.m_122012_().m_122012_(), randomSource, treeConfiguration);
                }
                if (randomSource.m_188503_(2) == 0) {
                    this.placeLeavesBlob((LevelAccessor)level, placePos.m_122019_().m_122019_(), randomSource, treeConfiguration);
                    this.placeRoot((LevelAccessor)level, placePos.m_122019_().m_122019_(), randomSource, treeConfiguration);
                }
                if (randomSource.m_188503_(2) == 0) {
                    this.placeLeavesBlob((LevelAccessor)level, placePos.m_122029_().m_122029_(), randomSource, treeConfiguration);
                    this.placeRoot((LevelAccessor)level, placePos.m_122029_().m_122029_(), randomSource, treeConfiguration);
                }
                if (randomSource.m_188503_(2) == 0) {
                    this.placeLeavesBlob((LevelAccessor)level, placePos.m_122024_().m_122024_(), randomSource, treeConfiguration);
                    this.placeRoot((LevelAccessor)level, placePos.m_122024_().m_122024_(), randomSource, treeConfiguration);
                }
            }
            if (placeCheck == height_main) {
                this.placeLeavesBlob((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            placePos.m_122173_(Direction.UP);
        }
        return true;
    }

    public void generateSmallSpire(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        int size = randomSource.m_188503_(3) + 5;
        for (int i = 0; i <= size; ++i) {
            if (i == 0) {
                this.placeRoot(level, pos, randomSource, treeConfiguration);
                this.placeRoot(level, pos.m_122012_(), randomSource, treeConfiguration);
                this.placeRoot(level, pos.m_122019_(), randomSource, treeConfiguration);
                this.placeRoot(level, pos.m_122029_(), randomSource, treeConfiguration);
                this.placeRoot(level, pos.m_122024_(), randomSource, treeConfiguration);
            }
            this.placeLog(level, (BlockPos)placePos, randomSource, treeConfiguration);
            if (i == size) {
                this.placeLeavesBlob(level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            placePos.m_122173_(Direction.UP);
        }
        this.placeLog(level, pos.m_122012_(), randomSource, treeConfiguration);
        this.placeLog(level, pos.m_122012_().m_7494_(), randomSource, treeConfiguration);
        this.placeLeavesBlob(level, pos.m_122012_().m_7494_(), randomSource, treeConfiguration);
        this.placeLog(level, pos.m_122019_(), randomSource, treeConfiguration);
        this.placeLog(level, pos.m_122019_().m_7494_(), randomSource, treeConfiguration);
        this.placeLeavesBlob(level, pos.m_122019_().m_7494_(), randomSource, treeConfiguration);
        this.placeLog(level, pos.m_122029_(), randomSource, treeConfiguration);
        this.placeLog(level, pos.m_122029_().m_7494_(), randomSource, treeConfiguration);
        this.placeLeavesBlob(level, pos.m_122029_().m_7494_(), randomSource, treeConfiguration);
        this.placeLog(level, pos.m_122024_(), randomSource, treeConfiguration);
        this.placeLog(level, pos.m_122024_().m_7494_(), randomSource, treeConfiguration);
        this.placeLeavesBlob(level, pos.m_122024_().m_7494_(), randomSource, treeConfiguration);
    }

    public boolean placeLog(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return true;
        }
        if (level.m_8055_(pos).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (IceSpireFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.m_7731_(pos, treeConfiguration.trunkProvider.m_213972_(randomSource, pos), 2);
        } else {
            return true;
        }
        if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        }
        return true;
    }

    public void placeRoot(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        int rd = random.nextInt(2) + 4;
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        for (int i = 0; !(i > rd || level.m_8055_((BlockPos)placePos).m_60767_().m_76336_() && level.m_8055_(placePos.m_7494_()).m_204336_(BlockTags.f_144274_)); ++i) {
            this.placeLog(level, (BlockPos)placePos, randomSource, treeConfiguration);
            placePos.m_122173_(Direction.DOWN);
        }
    }

    public boolean placeLeavesBlob(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        int n = random.nextInt(3);
        this.placeLeavesBlock(level, pos.m_7494_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_6630_(2), randomSource, treeConfiguration);
        if (randomSource.m_188499_()) {
            this.placeLeavesBlock(level, pos.m_6630_(3), randomSource, treeConfiguration);
        }
        return true;
    }

    public boolean placeLeavesBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return true;
        }
        if (level.m_8055_(pos).m_60767_().m_76336_()) {
            level.m_7731_(pos, treeConfiguration.foliageProvider.m_213972_(randomSource, pos), 2);
        }
        return true;
    }

    public boolean checkReplaceable(LevelAccessor level, BlockPos pos) {
        if (level.m_151570_(pos)) {
            return false;
        }
        return IceSpireFeature.isReplaceable((LevelSimulatedReader)level, pos);
    }

    public static boolean isReplaceableDirtBlock(BlockState state) {
        return state.m_204336_(RuTags.TREE_GRASS_REPLACEABLES);
    }

    public static boolean isReplaceableDirt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, IceSpireFeature::isReplaceableDirtBlock);
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.m_204336_(RuTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, IceSpireFeature::isReplaceableBlock);
    }
}

