/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;
import net.regions_unexplored.world.level.block.plant.other.BranchBlock;
import net.regions_unexplored.world.level.feature.configuration.RuTreeConfiguration;

public class MapleTreeFeature
extends Feature<RuTreeConfiguration> {
    public MapleTreeFeature(Codec<RuTreeConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<RuTreeConfiguration> context) {
        RuTreeConfiguration treeConfiguration = (RuTreeConfiguration)context.m_159778_();
        BlockPos pos = context.m_159777_();
        RandomSource randomSource = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        int height_main = context.m_225041_().m_188503_(treeConfiguration.sizeVariation) + treeConfiguration.minimumSize;
        BlockPos.MutableBlockPos checkPos = pos.m_122032_();
        for (int check = 0; check <= height_main; ++check) {
            if (!this.checkReplaceable((LevelAccessor)level, (BlockPos)checkPos)) {
                return false;
            }
            checkPos.m_122173_(Direction.UP);
        }
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        for (int placeCheck = 0; placeCheck <= height_main; ++placeCheck) {
            this.placeLog((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            if (placeCheck == 0) {
                this.placeRoot((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            if (placeCheck == height_main) {
                this.placeLeavesBlob((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            placePos.m_122173_(Direction.UP);
        }
        return true;
    }

    public boolean placeLog(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return true;
        }
        if (level.m_8055_(pos).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (MapleTreeFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.m_7731_(pos, treeConfiguration.trunkProvider.m_213972_(randomSource, pos), 2);
        } else {
            return true;
        }
        if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        }
        return true;
    }

    public boolean placeBranches(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        if (MapleTreeFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122012_()) && !level.m_151570_(pos.m_122012_())) {
            level.m_7731_(pos.m_122012_(), (BlockState)treeConfiguration.branchProvider.m_213972_(randomSource, pos).m_61124_((Property)BranchBlock.FACING, (Comparable)Direction.NORTH), 2);
        }
        if (MapleTreeFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122019_()) && !level.m_151570_(pos.m_122019_())) {
            level.m_7731_(pos.m_122019_(), (BlockState)treeConfiguration.branchProvider.m_213972_(randomSource, pos).m_61124_((Property)BranchBlock.FACING, (Comparable)Direction.SOUTH), 2);
        }
        if (MapleTreeFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122029_()) && !level.m_151570_(pos.m_122029_())) {
            level.m_7731_(pos.m_122029_(), (BlockState)treeConfiguration.branchProvider.m_213972_(randomSource, pos).m_61124_((Property)BranchBlock.FACING, (Comparable)Direction.EAST), 2);
        }
        if (MapleTreeFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122024_()) && !level.m_151570_(pos.m_122024_())) {
            level.m_7731_(pos.m_122024_(), (BlockState)treeConfiguration.branchProvider.m_213972_(randomSource, pos).m_61124_((Property)BranchBlock.FACING, (Comparable)Direction.WEST), 2);
        }
        return true;
    }

    public void placeRoot(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        int rd = random.nextInt(2) + 4;
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        for (int i = 0; i <= rd; ++i) {
            if (level.m_8055_((BlockPos)placePos).m_60767_().m_76336_() && level.m_8055_(placePos.m_7494_()).m_204336_(BlockTags.f_144274_)) {
                level.m_7731_((BlockPos)placePos, Blocks.f_152548_.m_49966_(), 2);
                break;
            }
            if (!level.m_8055_((BlockPos)placePos).m_204336_(BlockTags.f_144274_) && !level.m_8055_((BlockPos)placePos).m_204336_(RuTags.REPLACEABLE_BLOCKS) && !level.m_46859_((BlockPos)placePos)) break;
            this.placeLog(level, (BlockPos)placePos, randomSource, treeConfiguration);
            placePos.m_122173_(Direction.DOWN);
        }
    }

    public boolean placeLeavesBlobLayer(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        int i = random.nextInt(3);
        int j = random.nextInt(3);
        int k = random.nextInt(3);
        int l = random.nextInt(3);
        this.placeLeavesBlock(level, pos, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_().m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_().m_122029_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_().m_122012_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_().m_122024_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_().m_122012_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_().m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_().m_122029_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_().m_122019_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_().m_122024_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_().m_122019_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122029_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122024_().m_122024_(), randomSource, treeConfiguration);
        if (i == 0) {
            this.placeLeavesBlock(level, pos.m_122012_().m_122012_().m_122029_().m_122029_(), randomSource, treeConfiguration);
        }
        if (j == 0) {
            this.placeLeavesBlock(level, pos.m_122012_().m_122012_().m_122024_().m_122024_(), randomSource, treeConfiguration);
        }
        if (k == 0) {
            this.placeLeavesBlock(level, pos.m_122019_().m_122019_().m_122029_().m_122029_(), randomSource, treeConfiguration);
        }
        if (l == 0) {
            this.placeLeavesBlock(level, pos.m_122019_().m_122019_().m_122024_().m_122024_(), randomSource, treeConfiguration);
        }
        return true;
    }

    public boolean placeLeavesBlob(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        int n = random.nextInt(3);
        if (n == 0) {
            this.placeLeavesBlock(level, pos.m_122012_().m_122029_(), randomSource, treeConfiguration);
        } else if (n == 1) {
            this.placeLeavesBlock(level, pos.m_122012_().m_122029_().m_7494_(), randomSource, treeConfiguration);
        } else {
            this.placeLeavesBlock(level, pos.m_7495_().m_122012_().m_122012_(), randomSource, treeConfiguration);
        }
        int s = random.nextInt(3);
        if (s == 0) {
            this.placeLeavesBlock(level, pos.m_122012_().m_122024_(), randomSource, treeConfiguration);
        } else if (s == 1) {
            this.placeLeavesBlock(level, pos.m_122012_().m_122024_().m_7494_(), randomSource, treeConfiguration);
        } else {
            this.placeLeavesBlock(level, pos.m_7495_().m_122019_().m_122019_(), randomSource, treeConfiguration);
        }
        int e = random.nextInt(3);
        if (e == 0) {
            this.placeLeavesBlock(level, pos.m_122019_().m_122029_(), randomSource, treeConfiguration);
        } else if (e == 1) {
            this.placeLeavesBlock(level, pos.m_122019_().m_122029_().m_7494_(), randomSource, treeConfiguration);
        } else {
            this.placeLeavesBlock(level, pos.m_7495_().m_122029_().m_122029_(), randomSource, treeConfiguration);
        }
        int w = random.nextInt(3);
        if (w == 0) {
            this.placeLeavesBlock(level, pos.m_122019_().m_122024_(), randomSource, treeConfiguration);
        } else if (w == 1) {
            this.placeLeavesBlock(level, pos.m_122019_().m_122024_().m_7494_(), randomSource, treeConfiguration);
        } else {
            this.placeLeavesBlock(level, pos.m_7495_().m_122024_().m_122024_(), randomSource, treeConfiguration);
        }
        this.placeBranches(level, pos.m_7495_().m_7495_().m_7495_(), randomSource, treeConfiguration);
        this.placeBeehiveOrLeaves(level, pos.m_7495_().m_7495_().m_7495_().m_7495_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_7494_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7495_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7495_().m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7495_().m_122012_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7495_().m_122012_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7495_().m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7495_().m_122019_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7495_().m_122019_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7495_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7495_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlobLayer(level, pos.m_7495_().m_7495_(), randomSource, treeConfiguration);
        this.placeLeavesBlobLayer(level, pos.m_7495_().m_7495_().m_7495_(), randomSource, treeConfiguration);
        return true;
    }

    public boolean placeLeavesBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return true;
        }
        if (level.m_8055_(pos).m_60767_().m_76336_()) {
            level.m_7731_(pos, (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        return true;
    }

    public boolean checkReplaceable(LevelAccessor level, BlockPos pos) {
        if (level.m_151570_(pos)) {
            return false;
        }
        return MapleTreeFeature.isReplaceable((LevelSimulatedReader)level, pos);
    }

    public boolean placeBeehiveOrLeaves(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        int chance = random.nextInt(500);
        if (level.m_8055_(pos.m_122012_()).m_60795_()) {
            if (chance == 0) {
                this.placeLeavesBlock(level, pos.m_122012_().m_7494_(), randomSource, treeConfiguration);
                level.m_7731_(pos.m_122012_(), (BlockState)Blocks.f_50717_.m_49966_().m_61124_((Property)BeehiveBlock.f_49563_, (Comparable)Direction.NORTH), 2);
                level.m_141902_(pos.m_122012_(), BlockEntityType.f_58912_).ifPresent(addBee -> {
                    int j = 2 + random.nextInt(2);
                    for (int k = 0; k < j; ++k) {
                        CompoundTag compoundtag = new CompoundTag();
                        compoundtag.m_128359_("id", Registry.f_122826_.m_7981_((Object)EntityType.f_20550_).toString());
                        addBee.m_155157_(compoundtag, random.nextInt(599), false);
                    }
                });
            } else {
                this.placeLeavesBlock(level, pos.m_122012_(), randomSource, treeConfiguration);
            }
        }
        if (level.m_8055_(pos.m_122019_()).m_60795_()) {
            if (chance == 1) {
                this.placeLeavesBlock(level, pos.m_122019_().m_7494_(), randomSource, treeConfiguration);
                level.m_7731_(pos.m_122019_(), (BlockState)Blocks.f_50717_.m_49966_().m_61124_((Property)BeehiveBlock.f_49563_, (Comparable)Direction.SOUTH), 2);
                level.m_141902_(pos.m_122019_(), BlockEntityType.f_58912_).ifPresent(addBee -> {
                    int j = 2 + random.nextInt(2);
                    for (int k = 0; k < j; ++k) {
                        CompoundTag compoundtag = new CompoundTag();
                        compoundtag.m_128359_("id", Registry.f_122826_.m_7981_((Object)EntityType.f_20550_).toString());
                        addBee.m_155157_(compoundtag, random.nextInt(599), false);
                    }
                });
            } else {
                this.placeLeavesBlock(level, pos.m_122019_(), randomSource, treeConfiguration);
            }
        }
        if (level.m_8055_(pos.m_122029_()).m_60795_()) {
            if (chance == 2) {
                this.placeLeavesBlock(level, pos.m_122029_().m_7494_(), randomSource, treeConfiguration);
                level.m_7731_(pos.m_122029_(), (BlockState)Blocks.f_50717_.m_49966_().m_61124_((Property)BeehiveBlock.f_49563_, (Comparable)Direction.EAST), 2);
                level.m_141902_(pos.m_122029_(), BlockEntityType.f_58912_).ifPresent(addBee -> {
                    int j = 2 + random.nextInt(2);
                    for (int k = 0; k < j; ++k) {
                        CompoundTag compoundtag = new CompoundTag();
                        compoundtag.m_128359_("id", Registry.f_122826_.m_7981_((Object)EntityType.f_20550_).toString());
                        addBee.m_155157_(compoundtag, random.nextInt(599), false);
                    }
                });
            } else {
                this.placeLeavesBlock(level, pos.m_122029_(), randomSource, treeConfiguration);
            }
        }
        if (level.m_8055_(pos.m_122024_()).m_60795_()) {
            if (chance == 3) {
                this.placeLeavesBlock(level, pos.m_122024_().m_7494_(), randomSource, treeConfiguration);
                level.m_7731_(pos.m_122024_(), (BlockState)Blocks.f_50717_.m_49966_().m_61124_((Property)BeehiveBlock.f_49563_, (Comparable)Direction.WEST), 2);
                level.m_141902_(pos.m_122024_(), BlockEntityType.f_58912_).ifPresent(addBee -> {
                    int j = 2 + random.nextInt(2);
                    for (int k = 0; k < j; ++k) {
                        CompoundTag compoundtag = new CompoundTag();
                        compoundtag.m_128359_("id", Registry.f_122826_.m_7981_((Object)EntityType.f_20550_).toString());
                        addBee.m_155157_(compoundtag, random.nextInt(599), false);
                    }
                });
            } else {
                this.placeLeavesBlock(level, pos.m_122024_(), randomSource, treeConfiguration);
            }
        }
        return true;
    }

    public static boolean isReplaceableDirtBlock(BlockState state) {
        return state.m_204336_(RuTags.TREE_GRASS_REPLACEABLES);
    }

    public static boolean isReplaceableDirt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, MapleTreeFeature::isReplaceableDirtBlock);
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.m_204336_(RuTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, MapleTreeFeature::isReplaceableBlock);
    }
}

