/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;

public class SmallSocotraTreeFeature
extends Feature<NoneFeatureConfiguration> {
    public SmallSocotraTreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos = context.m_159777_();
        RandomSource randomSource = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        if (!this.checkReplaceable((LevelAccessor)level, pos)) {
            return false;
        }
        this.placeShrub((LevelAccessor)level, pos, randomSource);
        return true;
    }

    public void placeShrub(LevelAccessor level, BlockPos pos, RandomSource randomSource) {
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        if (randomSource.m_188503_(3) == 0) {
            this.placeLogBlock(level, (BlockPos)placePos, randomSource, Direction.Axis.Y);
            placePos.m_122173_(Direction.UP);
        }
        this.placeLogBlock(level, (BlockPos)placePos, randomSource, Direction.Axis.Y);
        placePos.m_122173_(Direction.UP);
        this.placeLogBlock(level, (BlockPos)placePos, randomSource, Direction.Axis.Y);
        placePos.m_122173_(Direction.UP);
        this.placeLogBlock(level, (BlockPos)placePos, randomSource, Direction.Axis.Y);
        this.placeLogBlock(level, placePos.m_122012_(), randomSource, Direction.Axis.Z);
        this.placeTop(level, placePos.m_122012_(), randomSource);
        this.placeLogBlock(level, placePos.m_122019_(), randomSource, Direction.Axis.Z);
        this.placeTop(level, placePos.m_122019_(), randomSource);
        this.placeLogBlock(level, placePos.m_122029_(), randomSource, Direction.Axis.X);
        this.placeTop(level, placePos.m_122029_(), randomSource);
        this.placeLogBlock(level, placePos.m_122024_(), randomSource, Direction.Axis.X);
        this.placeTop(level, placePos.m_122024_(), randomSource);
        placePos.m_122173_(Direction.UP);
        this.placeLogBlock(level, (BlockPos)placePos, randomSource, Direction.Axis.Y);
        this.placeTop(level, (BlockPos)placePos, randomSource);
        placePos.m_122173_(Direction.UP);
    }

    public void placeTop(LevelAccessor level, BlockPos pos, RandomSource randomSource) {
        this.placeLeavesBlock(level, pos.m_122012_(), randomSource);
        this.placeLeavesBlock(level, pos.m_122019_(), randomSource);
        this.placeLeavesBlock(level, pos.m_122029_(), randomSource);
        this.placeLeavesBlock(level, pos.m_122024_(), randomSource);
        this.placeLeavesBlock(level, pos.m_122012_().m_122029_(), randomSource);
        this.placeLeavesBlock(level, pos.m_122012_().m_122024_(), randomSource);
        this.placeLeavesBlock(level, pos.m_122019_().m_122029_(), randomSource);
        this.placeLeavesBlock(level, pos.m_122019_().m_122024_(), randomSource);
        this.placeLeavesBlock(level, pos.m_7494_(), randomSource);
        this.placeLeavesBlock(level, pos.m_122012_().m_7494_(), randomSource);
        this.placeLeavesBlock(level, pos.m_122019_().m_7494_(), randomSource);
        this.placeLeavesBlock(level, pos.m_122029_().m_7494_(), randomSource);
        this.placeLeavesBlock(level, pos.m_122024_().m_7494_(), randomSource);
        if (randomSource.m_188503_(4) == 0) {
            this.placeLeavesBlock(level, pos.m_7494_().m_122012_().m_122029_(), randomSource);
        }
        if (randomSource.m_188503_(4) == 0) {
            this.placeLeavesBlock(level, pos.m_7494_().m_122012_().m_122024_(), randomSource);
        }
        if (randomSource.m_188503_(4) == 0) {
            this.placeLeavesBlock(level, pos.m_7494_().m_122019_().m_122029_(), randomSource);
        }
        if (randomSource.m_188503_(4) == 0) {
            this.placeLeavesBlock(level, pos.m_7494_().m_122019_().m_122024_(), randomSource);
        }
    }

    public void placeLogBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource, Direction.Axis axis) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return;
        }
        if (level.m_8055_(pos).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (SmallSocotraTreeFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.m_7731_(pos, (BlockState)((Block)RuBlocks.SOCOTRA_LOG.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)axis), 2);
        } else {
            return;
        }
        if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        }
    }

    public void placeLeavesBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return;
        }
        if (level.m_8055_(pos).m_60767_().m_76336_()) {
            level.m_7731_(pos, (BlockState)((Block)RuBlocks.SOCOTRA_LEAVES.get()).m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    public boolean checkReplaceable(LevelAccessor level, BlockPos pos) {
        if (level.m_151570_(pos)) {
            return false;
        }
        return SmallSocotraTreeFeature.isReplaceable((LevelSimulatedReader)level, pos);
    }

    public static boolean isReplaceableDirtBlock(BlockState state) {
        return state.m_204336_(RuTags.TREE_GRASS_REPLACEABLES);
    }

    public static boolean isReplaceableDirt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, SmallSocotraTreeFeature::isReplaceableDirtBlock);
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.m_204336_(RuTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, SmallSocotraTreeFeature::isReplaceableBlock);
    }
}

