/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.harvest_with_ease.api.event;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface HarvestEvent<P extends Player, L extends Level> {
    public P getEntity();

    public L getLevel();

    public BlockState getCrop();

    public BlockPos getPos();

    public Direction getFace();

    @Nullable
    public BlockHitResult getHitResult();

    public InteractionHand getHand();

    default public boolean isFirst() {
        return this.getHitResult() != null;
    }

    public static interface AfterHarvestEvent
    extends HarvestEvent<ServerPlayer, ServerLevel> {
    }

    public static interface HarvestDropsEvent
    extends HarvestEvent<ServerPlayer, ServerLevel> {
        public List<ItemStack> getDefaultDrops();

        public List<ItemStack> getDrops();

        @ApiStatus.Internal
        public void setDrops(List<ItemStack> var1);

        @ApiStatus.Internal
        public void seedsIncluded();

        @ApiStatus.Internal
        public boolean areSeedsIncluded();

        public void cancel();

        default public boolean didDropsChange() {
            List<ItemStack> defaultDrops = this.getDefaultDrops();
            List<ItemStack> drops = this.getDrops();
            if (defaultDrops.size() == drops.size()) {
                for (int c = 0; c < defaultDrops.size(); ++c) {
                    if (ItemStack.m_41728_((ItemStack)defaultDrops.get(c), (ItemStack)drops.get(c))) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        @ApiStatus.Internal
        default public List<ItemStack> initDefaultDrops(ServerLevel level, BlockState crop, BlockPos pos, InteractionHand hand) {
            List drops = Block.m_49874_((BlockState)crop, (ServerLevel)level, (BlockPos)pos, (BlockEntity)(crop.m_155947_() ? level.m_7702_(pos) : null), this.getEntity(), (ItemStack)((ServerPlayer)this.getEntity()).m_21120_(hand));
            for (ItemStack stack : drops) {
                if (!stack.m_150930_(crop.m_60734_().m_7397_((BlockGetter)level, pos, crop).m_41720_())) continue;
                this.seedsIncluded();
                stack.m_41774_(1);
                break;
            }
            return drops;
        }
    }

    public static interface BeforeHarvestEvent
    extends HarvestEvent<ServerPlayer, ServerLevel> {
    }

    public static interface HarvestCheckEvent
    extends HarvestEvent<Player, Level> {
        @ApiStatus.Internal
        public boolean canHarvest();

        public void preventHarvest();
    }
}

