/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.harvest_with_ease.api.event;

import it.crystalnest.harvest_with_ease.api.event.HarvestEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Cancelable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class HarvestEvents {
    private HarvestEvents() {
    }

    public static class AfterHarvestEvent
    extends ForgeHarvestEvent<ServerPlayer, ServerLevel>
    implements HarvestEvent.AfterHarvestEvent {
        AfterHarvestEvent(ServerLevel level, BlockState crop, BlockPos pos, Direction face, @Nullable BlockHitResult hitResult, ServerPlayer entity, InteractionHand hand) {
            super(level, crop, pos, face, hitResult, entity, hand);
        }
    }

    @Cancelable
    public static class HarvestDropsEvent
    extends ForgeHarvestEvent<ServerPlayer, ServerLevel>
    implements HarvestEvent.HarvestDropsEvent {
        private final List<ItemStack> defaultDrops;
        private List<ItemStack> drops;
        private boolean seedsIncluded = false;

        HarvestDropsEvent(ServerLevel level, BlockState crop, BlockPos pos, Direction face, @Nullable BlockHitResult hitResult, ServerPlayer entity, InteractionHand hand) {
            super(level, crop, pos, face, hitResult, entity, hand);
            this.defaultDrops = this.initDefaultDrops(level, crop, pos, hand);
            this.drops = new ArrayList<ItemStack>(this.defaultDrops.stream().map(ItemStack::m_41777_).toList());
        }

        @Override
        public List<ItemStack> getDefaultDrops() {
            return this.defaultDrops;
        }

        @Override
        public List<ItemStack> getDrops() {
            return this.drops;
        }

        @Override
        @ApiStatus.Internal
        public void setDrops(List<ItemStack> drops) {
            this.drops = drops;
        }

        @Override
        @ApiStatus.Internal
        public void seedsIncluded() {
            this.seedsIncluded = true;
        }

        @Override
        @ApiStatus.Internal
        public boolean areSeedsIncluded() {
            return this.seedsIncluded;
        }

        @Override
        public void cancel() {
            this.setCanceled(true);
        }
    }

    public static class BeforeHarvestEvent
    extends ForgeHarvestEvent<ServerPlayer, ServerLevel>
    implements HarvestEvent.BeforeHarvestEvent {
        BeforeHarvestEvent(ServerLevel level, BlockState crop, BlockPos pos, Direction face, @Nullable BlockHitResult hitResult, ServerPlayer entity, InteractionHand hand) {
            super(level, crop, pos, face, hitResult, entity, hand);
        }
    }

    @Cancelable
    public static class HarvestCheckEvent
    extends ForgeHarvestEvent<Player, Level>
    implements HarvestEvent.HarvestCheckEvent {
        private boolean canHarvest = true;

        HarvestCheckEvent(Level level, BlockState crop, BlockPos pos, Direction face, @Nullable BlockHitResult hitResult, Player entity, InteractionHand hand) {
            super(level, crop, pos, face, hitResult, entity, hand);
        }

        @Override
        @ApiStatus.Internal
        public boolean canHarvest() {
            return this.canHarvest;
        }

        @Override
        public void preventHarvest() {
            this.canHarvest = false;
            this.setCanceled(true);
        }
    }

    public static abstract class ForgeHarvestEvent<P extends Player, L extends Level>
    extends PlayerInteractEvent
    implements HarvestEvent<P, L> {
        protected final L level;
        protected final BlockState crop;
        @Nullable
        protected final BlockHitResult hitResult;

        protected ForgeHarvestEvent(L level, BlockState crop, BlockPos pos, Direction face, @Nullable BlockHitResult hitResult, P player, InteractionHand hand) {
            super(player, hand, pos, face);
            this.level = level;
            this.crop = crop;
            this.hitResult = hitResult;
        }

        @Override
        public P getEntity() {
            return (P)super.getEntity();
        }

        @Override
        public L getLevel() {
            return this.level;
        }

        @Override
        public BlockState getCrop() {
            return this.crop;
        }

        @Override
        @Nullable
        public BlockHitResult getHitResult() {
            return this.hitResult;
        }
    }
}

