/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class ReplaceItemLootModifier
extends LootModifier {
    public static final Supplier<Codec<ReplaceItemLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> ReplaceItemLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ForgeRegistries.ITEMS.getCodec().fieldOf("target").forGetter(m -> m.target), (App)ForgeRegistries.ITEMS.getCodec().fieldOf("replacement").forGetter(m -> m.replacement), (App)Codec.STRING.fieldOf("mod_dependency").forGetter(m -> m.modDependency))).apply((Applicative)inst, ReplaceItemLootModifier::new)));
    private final Item target;
    private final Item replacement;
    private final String modDependency;
    private final UnaryOperator<ItemStack> conversion;

    protected ReplaceItemLootModifier(LootItemCondition[] conditions, Item target, Item replacement, String modDependency) {
        super(conditions);
        this.target = target;
        this.replacement = replacement;
        this.modDependency = modDependency;
        this.conversion = itemStack -> itemStack.m_41720_() == target ? new ItemStack((ItemLike)this.replacement, itemStack.m_41613_()) : itemStack;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (ModList.get().isLoaded(this.modDependency)) {
            generatedLoot.replaceAll(this.conversion);
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

